

CREATE TABLE `wp_burst_browser_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_burst_browser_versions` VALUES("1","122.0");
INSERT INTO `wp_burst_browser_versions` VALUES("2","120.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("3","121.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("4","122.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("5","109.0");
INSERT INTO `wp_burst_browser_versions` VALUES("6","23.0");
INSERT INTO `wp_burst_browser_versions` VALUES("7","109.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("8","60.0.3112.90");
INSERT INTO `wp_burst_browser_versions` VALUES("9","16.1");
INSERT INTO `wp_burst_browser_versions` VALUES("10","17.2");
INSERT INTO `wp_burst_browser_versions` VALUES("11","87.0.4280.144");
INSERT INTO `wp_burst_browser_versions` VALUES("12","56.0.2924.75");
INSERT INTO `wp_burst_browser_versions` VALUES("13","116.0.5845.140");
INSERT INTO `wp_burst_browser_versions` VALUES("14","99.0.4844.47");
INSERT INTO `wp_burst_browser_versions` VALUES("15","80.0.3987.163");
INSERT INTO `wp_burst_browser_versions` VALUES("16","80.0.3987.132");
INSERT INTO `wp_burst_browser_versions` VALUES("17","69.0.3497.128");
INSERT INTO `wp_burst_browser_versions` VALUES("18","119.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("19","117.0.5938.132");
INSERT INTO `wp_burst_browser_versions` VALUES("20","79.0.3945.79");
INSERT INTO `wp_burst_browser_versions` VALUES("21","110.0.5478.0");
INSERT INTO `wp_burst_browser_versions` VALUES("22","104.0.5112.101");
INSERT INTO `wp_burst_browser_versions` VALUES("23","87.0.4280.88");
INSERT INTO `wp_burst_browser_versions` VALUES("24","119.0.6045.105");
INSERT INTO `wp_burst_browser_versions` VALUES("25","21.0");
INSERT INTO `wp_burst_browser_versions` VALUES("26","13.1.2");
INSERT INTO `wp_burst_browser_versions` VALUES("27","104.0.5112.79");
INSERT INTO `wp_burst_browser_versions` VALUES("28","123.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("29","120.0");
INSERT INTO `wp_burst_browser_versions` VALUES("30","110.0.5481.100");
INSERT INTO `wp_burst_browser_versions` VALUES("31","123.0");
INSERT INTO `wp_burst_browser_versions` VALUES("32","16.6");
INSERT INTO `wp_burst_browser_versions` VALUES("33","605.1.15");
INSERT INTO `wp_burst_browser_versions` VALUES("34","122.0.6261.54");
INSERT INTO `wp_burst_browser_versions` VALUES("35","116.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("36","17.3.1");
INSERT INTO `wp_burst_browser_versions` VALUES("37","111.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("38","24.0");
INSERT INTO `wp_burst_browser_versions` VALUES("39","17.4");
INSERT INTO `wp_burst_browser_versions` VALUES("40","17.4.1");
INSERT INTO `wp_burst_browser_versions` VALUES("41","123.0.6312.52");
INSERT INTO `wp_burst_browser_versions` VALUES("42","604.1");
INSERT INTO `wp_burst_browser_versions` VALUES("43","122.1.63");
INSERT INTO `wp_burst_browser_versions` VALUES("44","124.0");
INSERT INTO `wp_burst_browser_versions` VALUES("45","107.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("46","122.0.6261.120");
INSERT INTO `wp_burst_browser_versions` VALUES("47","15.6.6");
INSERT INTO `wp_burst_browser_versions` VALUES("48","124.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("49","125.0");
INSERT INTO `wp_burst_browser_versions` VALUES("50","16.3");
INSERT INTO `wp_burst_browser_versions` VALUES("51","74.0.3729.131");
INSERT INTO `wp_burst_browser_versions` VALUES("52","125.0.0.0");
INSERT INTO `wp_burst_browser_versions` VALUES("53","130.0.0.0");


CREATE TABLE `wp_burst_browsers` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_burst_browsers` VALUES("1","Firefox");
INSERT INTO `wp_burst_browsers` VALUES("2","Chrome");
INSERT INTO `wp_burst_browsers` VALUES("3","Edge");
INSERT INTO `wp_burst_browsers` VALUES("4","SamsungBrowser");
INSERT INTO `wp_burst_browsers` VALUES("5","Safari");
INSERT INTO `wp_burst_browsers` VALUES("6","HeadlessChrome");
INSERT INTO `wp_burst_browsers` VALUES("7","AppleWebKit");
INSERT INTO `wp_burst_browsers` VALUES("8","Silk");


CREATE TABLE `wp_burst_devices` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_burst_devices` VALUES("1","desktop");
INSERT INTO `wp_burst_devices` VALUES("2","mobile");
INSERT INTO `wp_burst_devices` VALUES("3","other");
INSERT INTO `wp_burst_devices` VALUES("4","tablet");


CREATE TABLE `wp_burst_platforms` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_burst_platforms` VALUES("1","Windows");
INSERT INTO `wp_burst_platforms` VALUES("2","Android");
INSERT INTO `wp_burst_platforms` VALUES("3","iPhone");
INSERT INTO `wp_burst_platforms` VALUES("4","Linux");
INSERT INTO `wp_burst_platforms` VALUES("5","Macintosh");
INSERT INTO `wp_burst_platforms` VALUES("6","iPad");
INSERT INTO `wp_burst_platforms` VALUES("7","Chrome OS");
INSERT INTO `wp_burst_platforms` VALUES("8","Kindle Fire");


CREATE TABLE `wp_cmplz_cookiebanners` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `banner_version` int(11) NOT NULL,
  `default` int(11) NOT NULL,
  `archived` int(11) NOT NULL,
  `title` text NOT NULL,
  `position` text NOT NULL,
  `theme` text NOT NULL,
  `checkbox_style` text NOT NULL,
  `use_logo` text NOT NULL,
  `logo_attachment_id` text NOT NULL,
  `close_button` text NOT NULL,
  `revoke` text NOT NULL,
  `manage_consent_options` text NOT NULL,
  `header` text NOT NULL,
  `dismiss` text NOT NULL,
  `save_preferences` text NOT NULL,
  `view_preferences` text NOT NULL,
  `category_functional` text NOT NULL,
  `category_all` text NOT NULL,
  `category_stats` text NOT NULL,
  `category_prefs` text NOT NULL,
  `accept` text NOT NULL,
  `message_optin` text NOT NULL,
  `use_categories` text NOT NULL,
  `disable_cookiebanner` int(11) NOT NULL,
  `banner_width` int(11) NOT NULL,
  `soft_cookiewall` int(11) NOT NULL,
  `dismiss_on_scroll` int(11) NOT NULL,
  `dismiss_on_timeout` int(11) NOT NULL,
  `dismiss_timeout` text NOT NULL,
  `accept_informational` text NOT NULL,
  `message_optout` text NOT NULL,
  `use_custom_cookie_css` text NOT NULL,
  `custom_css` text NOT NULL,
  `statistics` text NOT NULL,
  `functional_text` text NOT NULL,
  `statistics_text` text NOT NULL,
  `statistics_text_anonymous` text NOT NULL,
  `preferences_text` text NOT NULL,
  `marketing_text` text NOT NULL,
  `colorpalette_background` text NOT NULL,
  `colorpalette_text` text NOT NULL,
  `colorpalette_toggles` text NOT NULL,
  `colorpalette_border_radius` text NOT NULL,
  `border_width` text NOT NULL,
  `font_size` text NOT NULL,
  `colorpalette_button_accept` text NOT NULL,
  `colorpalette_button_deny` text NOT NULL,
  `colorpalette_button_settings` text NOT NULL,
  `buttons_border_radius` text NOT NULL,
  `animation` text NOT NULL,
  `use_box_shadow` int(11) NOT NULL,
  `header_footer_shadow` int(11) NOT NULL,
  `hide_preview` int(11) NOT NULL,
  `disable_width_correction` int(11) NOT NULL,
  `legal_documents` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_cmplz_cookiebanners` VALUES("1","16","1","0","bottom-right view-preferences","bottom","","slider","site","0","1","Manage consent","hover-hide-mobile","a:2:{s:4:\"text\";s:21:\"Manage Cookie Consent\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:4:\"Deny\";s:4:\"show\";i:1;}","Save preferences","View preferences","Functional","a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:10:\"Statistics\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:11:\"Preferences\";s:4:\"show\";i:1;}","Accept","To provide the best experiences, we use technologies like cookies to store and/or access device information. Consenting to these technologies will allow us to process data such as browsing behaviour or unique IDs on this site. Not consenting or withdrawing consent, may adversely affect certain features and functions.","view-preferences","0","526","0","0","0","10","a:2:{s:4:\"text\";s:6:\"Accept\";s:4:\"show\";i:1;}","To provide the best experiences, we use technologies like cookies to store and/or access device information. Consenting to these technologies will allow us to process data such as browsing behaviour or unique IDs on this site. Not consenting or withdrawing consent, may adversely affect certain features and functions.","0","/* Container */\r\n.cmplz-cookiebanner{}\r\n\r\n/* Logo */\r\n.cmplz-cookiebanner .cmplz-logo{}\r\n/* Title */\r\n.cmplz-cookiebanner .cmplz-title{}\r\n/* Close icon */\r\n.cmplz-cookiebanner .cmplz-close{}\r\n\r\n/* Message */\r\n.cmplz-cookiebanner .cmplz-message{}\r\n\r\n /* All buttons */\r\n.cmplz-buttons .cmplz-btn{}\r\n/* Accept button */\r\n.cmplz-btn .cmplz-accept{} \r\n /* Deny button */\r\n.cmplz-btn .cmplz-deny{}\r\n /* Save preferences button */\r\n.cmplz-btn .cmplz-deny{}\r\n /* View preferences button */\r\n.cmplz-btn .cmplz-deny{}\r\n\r\n /* Document hyperlinks */\r\n.cmplz-links .cmplz-documents{}\r\n\r\n /* Categories */\r\n.cmplz-cookiebanner .cmplz-category{}\r\n.cmplz-cookiebanner .cmplz-category-title{} \r\n\r\n/* Manage consent tab */\r\n#cmplz-manage-consent .cmplz-manage-consent{} \r\n\r\n/* Soft cookie wall */\r\n.cmplz-soft-cookiewall{}\r\n\r\n/* Placeholder button - Per category */\r\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\r\n\r\n/* Placeholder button & message - Per service */\r\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\r\n.cmplz-blocked-content-notice{}\r\nbutton.cmplz-accept-service{}\r\n\r\n/* Styles for the AMP notice */\r\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\r\n/* Message */\r\n#cmplz-consent-ui .cmplz-consent-message {}\r\n/* Buttons */\r\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}","a:0:{}","a:2:{s:4:\"text\";s:289:\"The technical storage or access is strictly necessary for the legitimate purpose of enabling the use of a specific service explicitly requested by the subscriber or user, or for the sole purpose of carrying out the transmission of a communication over an electronic communications network.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:82:\"The technical storage or access that is used exclusively for statistical purposes.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:317:\"The technical storage or access that is used exclusively for anonymous statistical purposes. Without a subpoena, voluntary compliance on the part of your Internet Service Provider, or additional records from a third party, information stored or retrieved for this purpose alone cannot usually be used to identify you.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:144:\"The technical storage or access is necessary for the legitimate purpose of storing preferences that are not requested by the subscriber or user.\";s:4:\"show\";i:1;}","a:2:{s:4:\"text\";s:181:\"The technical storage or access is required to create user profiles to send advertising, or to track the user on a website or across several websites for similar marketing purposes.\";s:4:\"show\";i:1;}","a:2:{s:5:\"color\";s:7:\"#ffffff\";s:6:\"border\";s:7:\"#f2f2f2\";}","a:2:{s:5:\"color\";s:7:\"#222222\";s:9:\"hyperlink\";s:7:\"#1E73BE\";}","a:3:{s:10:\"background\";s:7:\"#1e73be\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#F56E28\";}","a:5:{s:3:\"top\";i:12;s:5:\"right\";i:12;s:6:\"bottom\";i:12;s:4:\"left\";i:12;s:4:\"type\";s:2:\"px\";}","a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}","12","a:3:{s:10:\"background\";s:7:\"#1E73BE\";s:6:\"border\";s:7:\"#1E73BE\";s:4:\"text\";s:7:\"#ffffff\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#222222\";}","a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#333333\";}","a:5:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;s:4:\"type\";s:2:\"px\";}","fade","1","0","1","0","1");


CREATE TABLE `wp_cmplz_cookies` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `sync` int(11) NOT NULL,
  `ignored` int(11) NOT NULL,
  `retention` text NOT NULL,
  `type` text NOT NULL,
  `serviceID` int(11) NOT NULL,
  `cookieFunction` text NOT NULL,
  `collectedPersonalData` text NOT NULL,
  `purpose` text NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `isPersonalData` int(11) NOT NULL,
  `isOwnDomainCookie` int(11) NOT NULL,
  `domain` text NOT NULL,
  `deleted` int(11) NOT NULL,
  `isMembersOnly` int(11) NOT NULL,
  `showOnPolicy` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  `lastAddDate` int(11) NOT NULL,
  `firstAddDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_cmplz_cookies` VALUES("1","Google Fonts API","tcb_google_fonts","1","0","expires immediately","API","1","read user IP address","IP address","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("2","rc::c","rcc","1","0","session","","2","read and filter requests from bots","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("3","rc::b","rcb","1","0","session","","2","read and filter requests from bots","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("4","rc::a","rca","1","0","persistent","","2","read and filter requests from bots","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("5","Google Maps API","google-maps-api","1","0","expires immediately","API","3","read user IP address","IP address","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("6","GPS","gps","1","0","session","","4","store location data","location data","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("7","VISITOR_INFO1_LIVE","visitor_info1_live","1","0","6 months","Cookie","4","provide ad delivery or retargeting","browsing behaviour","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("8","YSC","ysc","1","0","session","Cookie","4","Store and track interaction","user ID","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("9","PREF","pref","1","0","8 months","Cookie","4","store user preferences","browsing behaviour","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("10","UIDR","uidr","1","0","","","5","","","","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("11","_stgmap","_stgmap","1","0","1 week","","5","store and track audience reach","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("12","_stamap","_stamap","1","0","1 week","","5","store and track audience reach","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("13","stacxiommap","stacxiommap","1","0","1 week","","5","store and track audience reach","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("14","stdlxmap","stdlxmap","1","0","1 week","","5","store and track audience reach","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("15","__uset","__uset","1","0","","","5","","","","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("16","uset","uset","1","0","","","5","","","","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("17","__stid","__stid","1","0","1 week","","5","store and track audience reach","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("18","_js_datr","_js_datr","1","1","2 years","","6","store user preferences","","Preferences","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("19","_fbc","_fbc","1","0","2 years","","6","store last visit","browsing device information","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("20","fbm*","fbm_","1","0","1 year","","6","store account details","social media account details","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("21","xs","xs","1","0","3 months","","6","store a unique session ID","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("22","wd","wd","1","0","1 week","","6","read screen resolution","","Functional","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("23","fr","fr","1","0","3 months","","6","provide ad delivery or retargeting","social media account details","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("24","act","act","1","0","90 days","","6","Store logged in users","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("25","_fbp","_fbp","1","0","3 months","","6","store and track visits across websites","","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("26","datr","datr","1","0","2 years","","6","provide fraud prevention","browsing device information","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("27","c_user","c_user","1","0","30 days","","6","store a unique user ID","user ID","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("28","csm","csm","1","0","90 days","","6","provide fraud prevention","","Functional","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("29","sb","sb","1","0","2 years","","6","store browser details","browsing device information","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("30","actppresence","actppresence","1","0","session","Cookie","6","store and track if the browser tab is active","","Functional","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("31","*_fbm_","_fbm_","1","0","1 year","","6","store account details","social media account details","Marketing","en","0","1","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("32","local_storage_support_test","local_storage_support_test","1","0","persistent","","7","provide load balancing functionality","","Functional","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("33","metrics_token","metrics_token","1","0","persistent","","7","store if the user has seen embedded content","browsing device information","Marketing","en","0","0","0","thirdparty","0","0","1","1708611237","1708611234","1708611234");
INSERT INTO `wp_cmplz_cookies` VALUES("34","WP_DATA_USER_2","","1","0","","localstorage","0","","","","en","0","0","0","self","0","0","1","0","1712383688","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("35","WP_PREFERENCES_USER_2","","1","0","","localstorage","0","","","","en","0","0","0","self","0","0","1","0","1712383688","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("36","wpEmojiSettingsSupports","","1","0","","localstorage","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("37","wp-settings-2","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1712383688","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("38","wp-settings-time-2","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1712383688","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("39","wordpress_test_cookie","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("40","wordpress_logged_in_431e66c259d1cfcfd06e7ad00a84bc04","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("41","burst_uid","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1709750263");
INSERT INTO `wp_cmplz_cookies` VALUES("42","cmplz_consented_services","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("43","cmplz_policy_id","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("44","cmplz_marketing","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("45","cmplz_statistics","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("46","cmplz_preferences","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("47","cmplz_functional","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("48","cmplz_banner-status","","1","0","365 days","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1712383635");
INSERT INTO `wp_cmplz_cookies` VALUES("49","wp-settings-1","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1714996119");
INSERT INTO `wp_cmplz_cookies` VALUES("50","wp-settings-time-1","","1","0","","cookie","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1714996119");
INSERT INTO `wp_cmplz_cookies` VALUES("51","jetpack-boost-guide","","1","0","","localstorage","0","","","","en","0","0","0","self","0","0","1","0","1714996363","1714996363");


CREATE TABLE `wp_cmplz_dnsmpd` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `region` text NOT NULL,
  `global_optout` int(11) NOT NULL,
  `cross_context` int(11) NOT NULL,
  `limit_sensitive` int(11) NOT NULL,
  `request_date` int(11) NOT NULL,
  `resolved` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_cmplz_services` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `serviceType` varchar(250) NOT NULL,
  `category` varchar(250) NOT NULL,
  `thirdParty` int(11) NOT NULL,
  `sharesData` int(11) NOT NULL,
  `secondParty` int(11) NOT NULL,
  `privacyStatementURL` varchar(250) NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `sync` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_cmplz_services` VALUES("1","Google Fonts","google-fonts","display of webfonts","service","1","1","0","https://policies.google.com/privacy","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("2","Google reCAPTCHA","google-recaptcha","spam prevention","service","1","1","0","https://policies.google.com/privacy","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("3","Google Maps","google-maps","maps display","service","1","1","0","https://policies.google.com/privacy","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("4","YouTube","youtube","video display","service","1","1","0","https://policies.google.com/privacy","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("5","ShareThis","sharethis","display of recent social posts and/or social share buttons","service","1","1","0","https://sharethis.com/privacy/","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("6","Facebook","facebook","display of recent social posts and/or social share buttons","social","1","1","0","https://www.facebook.com/policy/cookies","en","0","1","1708611234");
INSERT INTO `wp_cmplz_services` VALUES("7","Twitter","twitter","display of recent social posts and/or social share buttons","social","1","1","0","https://twitter.com/en/privacy","en","0","1","1708611234");


CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_index_now_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `level` enum('emergency','alert','critical','error','warning','notice','info','debug') NOT NULL DEFAULT 'debug',
  `search_engine` enum('index-now','yandex-index-now','yandex-webmaster','bing-index-now','bing-webmaster','site','google-webmaster','seznam-index-now','naver-index-now') NOT NULL DEFAULT 'site',
  `direction` enum('incoming','outgoing','internal') NOT NULL DEFAULT 'incoming',
  `status_code` int(11) unsigned NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_indexnow_failed_submissions` (
  `id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `submission_date` bigint(20) NOT NULL,
  `submission_type` tinytext NOT NULL,
  `type` tinytext NOT NULL,
  `error` text NOT NULL,
  `url` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_indexnow_passed_submissions` (
  `id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `submission_date` bigint(20) NOT NULL,
  `submission_type` tinytext NOT NULL,
  `type` tinytext NOT NULL,
  `error` text NOT NULL,
  `url` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_indexnow_passed_submissions` VALUES("1","1757485324","1","add","Success","https://www.southlancsarc.co.uk");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("2","1757485387","1","add","Success","https://www.southlancsarc.co.uk/beacon-country-park-ardf-event/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("3","1757485481","1","add","Success","https://www.southlancsarc.co.uk/welcome/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("4","1757485502","1","add","Success","https://www.southlancsarc.co.uk/about/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("5","1757485523","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("6","1757485543","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("7","1757485577","1","add","Success","https://www.southlancsarc.co.uk/blog/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("8","1757485597","1","add","Success","https://www.southlancsarc.co.uk/training/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("9","1757485618","1","add","Success","https://www.southlancsarc.co.uk/club-media/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("10","1757485647","1","add","Success","https://www.southlancsarc.co.uk/links/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("11","1757485671","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("12","1757485717","1","add","Success","https://www.southlancsarc.co.uk/club-members-pota-parks-on-the-air-activation-gb-1281-beacon-country-park/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("13","1757766185","1","add","Success","https://www.southlancsarc.co.uk/sitemap.xml");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("14","1757958660","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("15","1757958962","1","add","Success","https://www.southlancsarc.co.uk/?p=2092");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("16","1757959005","1","add","Success","https://www.southlancsarc.co.uk/?p=2093");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("17","1757959410","1","add","Success","https://www.southlancsarc.co.uk/?p=2094");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("18","1757959516","1","add","Success","https://www.southlancsarc.co.uk/?p=2096");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("19","1757960239","1","add","Success","https://www.southlancsarc.co.uk/about/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("20","1757960372","1","add","Success","https://www.southlancsarc.co.uk/about/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("21","1757960491","1","add","Success","https://www.southlancsarc.co.uk/about/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("22","1757960574","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("23","1757960947","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("24","1757961120","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("25","1757961222","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("26","1757961349","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("27","1757961712","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("28","1757961839","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("29","1757962005","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("30","1757962215","1","add","Success","https://www.southlancsarc.co.uk/meet-the-team/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("31","1757963203","1","add","Success","https://www.southlancsarc.co.uk/?p=2125");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("32","1757963484","1","add","Success","https://www.southlancsarc.co.uk/?p=2127");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("33","1757963587","1","add","Success","https://www.southlancsarc.co.uk/?p=2129");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("34","1757963735","1","add","Success","https://www.southlancsarc.co.uk/?p=2131");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("35","1757963801","1","add","Success","https://www.southlancsarc.co.uk/?p=2133");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("36","1757963870","1","add","Success","https://www.southlancsarc.co.uk/?p=2135");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("37","1757964113","1","add","Success","https://www.southlancsarc.co.uk/?p=2137");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("38","1757964281","1","add","Success","https://www.southlancsarc.co.uk/?p=2139");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("39","1758299147","1","add","Success","https://www.southlancsarc.co.uk/?p=2154");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("40","1758299264","1","add","Success","https://www.southlancsarc.co.uk/?p=2156");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("41","1758299384","1","add","Success","https://www.southlancsarc.co.uk/?p=2158");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("42","1758299473","1","add","Success","https://www.southlancsarc.co.uk/?p=2160");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("43","1758299539","1","add","Success","https://www.southlancsarc.co.uk/?p=2162");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("44","1758299811","1","add","Success","https://www.southlancsarc.co.uk/?p=2164");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("45","1758360941","1","add","Success","https://www.southlancsarc.co.uk/?p=2168");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("46","1758360994","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=1444");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("47","1758360994","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=1104");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("48","1758360995","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=1097");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("49","1758360996","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=1068");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("50","1758360996","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=967");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("51","1758360997","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=954");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("52","1758360998","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=872");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("53","1758360998","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=862");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("54","1758360999","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=854");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("55","1758360999","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=714");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("56","1758361002","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=684");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("57","1758361003","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=666");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("58","1758361004","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=663");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("59","1758361004","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=662");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("60","1758361005","1","add","Success","https://www.southlancsarc.co.uk/?post_type=flamingo_inbound&p=617");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("61","1758458109","1","add","Success","https://www.southlancsarc.co.uk/?p=2178");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("62","1758459370","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("63","1758459550","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("64","1758459761","1","add","Success","https://www.southlancsarc.co.uk/privacy-policy/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("65","1758975124","1","add","Success","https://www.southlancsarc.co.uk/?p=2194");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("66","1758975333","1","add","Success","https://www.southlancsarc.co.uk/?p=2196");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("67","1758975378","1","add","Success","https://www.southlancsarc.co.uk/?p=2198");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("68","1758975491","1","add","Success","https://www.southlancsarc.co.uk/?p=2200");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("69","1758976238","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("70","1758976664","1","add","Success","https://www.southlancsarc.co.uk/proud-supporters-of-fat-monkey-wigan-and-leigh-hospice/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("71","1759663049","1","add","Success","https://www.southlancsarc.co.uk/meshcore-slideshow/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("72","1759663109","1","add","Success","https://www.southlancsarc.co.uk/meshcore-slideshow/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("73","1759663216","1","add","Success","https://www.southlancsarc.co.uk/meshcore-slideshow/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("74","1759663337","1","add","Success","https://www.southlancsarc.co.uk/?page_id=2209");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("75","1761822866","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("76","1761823183","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("77","1761823244","1","add","Success","https://www.southlancsarc.co.uk/contact-us/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("78","1761839473","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("79","1761839647","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("80","1761839875","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("81","1761840232","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("82","1761840376","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("83","1761840553","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("84","1761840959","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("85","1761841050","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("86","1761841333","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("87","1761841567","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("88","1761841681","1","add","Success","https://www.southlancsarc.co.uk/activities/");
INSERT INTO `wp_indexnow_passed_submissions` VALUES("89","1761999256","1","add","Success","https://www.southlancsarc.co.uk/about/");


CREATE TABLE `wp_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) NOT NULL,
  `event_id` varchar(100) NOT NULL,
  `event_payload` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=8960 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_jetpack_waf_blocklog` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `rule_id` bigint(20) NOT NULL,
  `reason` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=388853 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_options` VALUES("1","siteurl","https://www.southlancsarc.co.uk","yes");
INSERT INTO `wp_options` VALUES("2","home","https://www.southlancsarc.co.uk","yes");
INSERT INTO `wp_options` VALUES("3","blogname","South Lancs Amateur Radio Club","yes");
INSERT INTO `wp_options` VALUES("4","blogdescription","Furthering The Interest Of All Aspects Of Amateur Radio","yes");
INSERT INTO `wp_options` VALUES("5","users_can_register","0","auto");
INSERT INTO `wp_options` VALUES("6","admin_email","cwoodalluk@yahoo.co.uk","yes");
INSERT INTO `wp_options` VALUES("7","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("8","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("9","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("10","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("11","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("12","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("17","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("18","default_category","1","yes");
INSERT INTO `wp_options` VALUES("19","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("21","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("22","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("23","date_format","j F Y","yes");
INSERT INTO `wp_options` VALUES("24","time_format","H:i","yes");
INSERT INTO `wp_options` VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `wp_options` VALUES("26","comment_moderation","","yes");
INSERT INTO `wp_options` VALUES("27","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("28","permalink_structure","/{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}postname{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}/","yes");
INSERT INTO `wp_options` VALUES("29","rewrite_rules","a:95:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO `wp_options` VALUES("30","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("32","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("33","active_plugins","a:17:{i:0;s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";i:1;s:19:\"akismet/akismet.php\";i:3;s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";i:6;s:36:\"indexnow/indexnow-url-submission.php\";i:7;s:31:\"jetpack-boost/jetpack-boost.php\";i:8;s:35:\"jetpack-protect/jetpack-protect.php\";i:9;s:33:\"jetpack-search/jetpack-search.php\";i:10;s:33:\"jetpack-social/jetpack-social.php\";i:11;s:19:\"jetpack/jetpack.php\";i:12;s:41:\"last-login-display/last-login-display.php\";i:13;s:33:\"nimble-builder/nimble-builder.php\";i:14;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:15;s:27:\"redis-cache/redis-cache.php\";i:16;s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";i:17;s:45:\"simple-local-avatars/simple-local-avatars.php\";i:18;s:53:\"smart-auto-upload-images/smart-auto-upload-images.php\";i:19;s:41:\"wp-database-backup/wp-database-backup.php\";}","yes");
INSERT INTO `wp_options` VALUES("34","category_base","","yes");
INSERT INTO `wp_options` VALUES("35","ping_sites","https://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("36","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("37","gmt_offset","","yes");
INSERT INTO `wp_options` VALUES("38","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("39","recently_edited","a:2:{i:0;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/style.css\";i:1;s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("40","template","customizr","yes");
INSERT INTO `wp_options` VALUES("41","stylesheet","customizr","yes");
INSERT INTO `wp_options` VALUES("42","comment_registration","1","yes");
INSERT INTO `wp_options` VALUES("43","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("44","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("45","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("46","db_version","60421","yes");
INSERT INTO `wp_options` VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("48","upload_path","","yes");
INSERT INTO `wp_options` VALUES("49","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("50","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("51","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("52","tag_base","","yes");
INSERT INTO `wp_options` VALUES("53","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("54","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("55","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES("58","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("59","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("60","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("61","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("62","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES("63","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES("64","image_default_link_type","none","yes");
INSERT INTO `wp_options` VALUES("65","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("66","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("67","close_comments_for_old_posts","","yes");
INSERT INTO `wp_options` VALUES("68","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("69","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("70","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("71","page_comments","","yes");
INSERT INTO `wp_options` VALUES("72","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("73","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("74","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("75","sticky_posts","a:18:{i:0;i:277;i:1;i:201;i:2;i:446;i:3;i:793;i:4;i:1045;i:5;i:1089;i:6;i:1225;i:7;i:1297;i:8;i:1332;i:9;i:1408;i:10;i:1515;i:11;i:1520;i:12;i:1584;i:13;i:1808;i:14;i:1955;i:15;i:1986;i:16;i:2004;i:17;i:2048;}","yes");
INSERT INTO `wp_options` VALUES("76","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("79","uninstall_plugins","a:6:{s:31:\"jetpack-boost/jetpack-boost.php\";s:48:\"Automattic\\Jetpack_Boost\\jetpack_boost_uninstall\";s:55:\"social-media-auto-publish/social-media-auto-publish.php\";s:25:\"smap_free_network_destroy\";s:47:\"facebook-auto-publish/facebook-auto-publish.php\";s:25:\"fbap_free_network_destroy\";s:45:\"simple-local-avatars/simple-local-avatars.php\";s:30:\"simple_local_avatars_uninstall\";s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";a:2:{i:0;s:24:\"ADBC_Advanced_DB_Cleaner\";i:1;s:14:\"aDBc_uninstall\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:56:\"ReallySimplePlugins\\RSS\\Core\\Bootstrap\\Plugin::uninstall\";}","no");
INSERT INTO `wp_options` VALUES("80","timezone_string","Europe/London","yes");
INSERT INTO `wp_options` VALUES("81","page_for_posts","13","yes");
INSERT INTO `wp_options` VALUES("82","page_on_front","12","yes");
INSERT INTO `wp_options` VALUES("83","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("84","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO `wp_options` VALUES("86","site_icon","71","yes");
INSERT INTO `wp_options` VALUES("87","medium_large_size_w","768","yes");
INSERT INTO `wp_options` VALUES("88","medium_large_size_h","0","yes");
INSERT INTO `wp_options` VALUES("89","wp_page_for_privacy_policy","365","yes");
INSERT INTO `wp_options` VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO `wp_options` VALUES("91","admin_email_lifespan","1769618946","yes");
INSERT INTO `wp_options` VALUES("92","disallowed_keys","","no");
INSERT INTO `wp_options` VALUES("93","comment_previously_approved","1","yes");
INSERT INTO `wp_options` VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO `wp_options` VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO `wp_options` VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO `wp_options` VALUES("97","auto_update_core_major","enabled","no");
INSERT INTO `wp_options` VALUES("98","wp_force_deactivated_plugins","a:0:{}","off");
INSERT INTO `wp_options` VALUES("99","wp_attachment_pages_enabled","0","yes");
INSERT INTO `wp_options` VALUES("100","initial_db_version","56657","yes");
INSERT INTO `wp_options` VALUES("101","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_security\";b:1;s:14:\"manage_privacy\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_kubio-globals\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("102","fresh_site","0","off");
INSERT INTO `wp_options` VALUES("103","user_count","3","off");
INSERT INTO `wp_options` VALUES("104","widget_block","a:14:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:7;a:1:{s:7:\"content\";s:232:\"<!-- wp:separator {\"color\":\"kubio-color-1\",\"className\":\"is-style-wide\"} --><hr class=\"wp-block-separator has-text-color has-background has-kubio-color-1-background-color has-kubio-color-1-color is-style-wide\"/><!-- /wp:separator -->\";}i:9;a:1:{s:7:\"content\";s:58:\"<!-- wp:rss {\"feedURL\":\"https://rsgb.org/main/feed/\"} /-->\";}i:11;a:1:{s:7:\"content\";s:329:\"<!-- wp:image {\"id\":136,\"width\":\"159px\",\"height\":\"auto\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://www.southlancsarc.co.uk/wp-content/uploads/2024/02/logo.gif\" alt=\"slarc\" class=\"wp-image-136\" style=\"width:159px;height:auto\"/></figure>\n<!-- /wp:image -->\";}i:12;a:1:{s:7:\"content\";s:175:\"<center>\n<a href=\"https://www.hamqsl.com/solar.html\" title=\"Click to add Solar-Terrestrial Data to your website!\"><img src=\"https://www.hamqsl.com/solarvhf.php\"></a>\n</center>\";}i:15;a:1:{s:7:\"content\";s:161:\"<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Domain and Email by <a href=\"http://ipage.com\">iPage.com</a></p>\n<!-- /wp:paragraph -->\";}i:19;a:1:{s:7:\"content\";s:471:\"<!-- wp:gallery {\"linkTo\":\"none\",\"sizeSlug\":\"full\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped\"><!-- wp:image {\"id\":443,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://www.southlancsarc.co.uk/wp-content/uploads/2024/02/newslarc_png-1.jpg\" alt=\"\" class=\"wp-image-443\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\";}i:22;a:1:{s:7:\"content\";s:260:\"<!-- wp:image {\"id\":591,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://www.southlancsarc.co.uk/wp-content/uploads/2024/05/newslarc_png-1.webp\" alt=\"\" class=\"wp-image-591\"/></figure>\n<!-- /wp:image -->\";}i:25;a:1:{s:7:\"content\";s:417:\"<!-- wp:widget-group {\"title\":\"RSGB Updates\"} -->\n<h2 class=\"widget-title\">RSGB Updates</h2><div class=\"wp-widget-group__inner-blocks\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:100{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"><!-- wp:rss {\"feedURL\":\"https://rsgb.org/main/feed/\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:widget-group -->\";}}","on");
INSERT INTO `wp_options` VALUES("105","sidebars_widgets","a:19:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:7:\"block-9\";i:1;s:8:\"block-11\";i:2;s:8:\"block-19\";i:3;s:7:\"block-7\";}s:20:\"nimble-widget-area-1\";a:0:{}s:20:\"nimble-widget-area-2\";a:0:{}s:20:\"nimble-widget-area-3\";a:0:{}s:20:\"nimble-widget-area-4\";a:0:{}s:20:\"nimble-widget-area-5\";a:0:{}s:20:\"nimble-widget-area-6\";a:0:{}s:20:\"nimble-widget-area-7\";a:0:{}s:20:\"nimble-widget-area-8\";a:0:{}s:20:\"nimble-widget-area-9\";a:0:{}s:21:\"nimble-widget-area-10\";a:0:{}s:4:\"left\";a:0:{}s:5:\"right\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"footer_horizontal\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:10:\"footer_one\";a:2:{i:0;s:8:\"block-22\";i:1;s:8:\"block-15\";}s:10:\"footer_two\";a:1:{i:0;s:8:\"block-12\";}s:12:\"footer_three\";a:1:{i:0;s:8:\"block-25\";}s:9:\"site-info\";a:0:{}s:13:\"array_version\";i:3;}","on");
INSERT INTO `wp_options` VALUES("106","cron","a:30:{i:1762124375;a:1:{s:26:\"rediscache_discard_metrics\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762124396;a:1:{s:29:\"rsssl_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"rsssl_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1762124409;a:2:{s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1762124569;a:1:{s:33:\"jetpack_boost_preload_cornerstone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"twicehourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1800;}}}i:1762124818;a:1:{s:21:\"backup_files_cron_new\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"ten_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1762124964;a:1:{s:38:\"jetpack_boost_cache_garbage_collection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762125229;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762125847;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762126195;a:1:{s:27:\"mihdan-index-now__clear-log\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1762132196;a:1:{s:28:\"rsssl_every_three_hours_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:23:\"rsssl_every_three_hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1762135615;a:1:{s:29:\"jetpack_waf_rules_update_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762151715;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762161229;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762162170;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762163008;a:1:{s:32:\"Kubio\\NotificationsManager::init\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1762167733;a:3:{s:29:\"jetpack_boost_404_tester_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:39:\"jetpack_boost_minify_cron_cache_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:46:\"jetpack_boost_minify_cron_cleanup_concat_paths\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762178878;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762184760;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762191380;a:1:{s:20:\"rsssl_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"rsssl_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762199400;a:1:{s:20:\"aDBc_clean_scheduler\";a:1:{s:32:\"3da684f71cbffda6ffbf128968c0ca47\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:1:{i:0;s:6:\"weekly\";}s:8:\"interval\";i:604800;}}}i:1762204429;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762205403;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762205404;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1762537475;a:1:{s:18:\"wp_db_backup_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762551177;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762636429;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762709780;a:1:{s:21:\"rsssl_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"rsssl_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1762729140;a:1:{s:24:\"wpdbkup_event_fullbackup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763586958;a:1:{s:22:\"rsssl_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"rsssl_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on");
INSERT INTO `wp_options` VALUES("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.4.3\";s:5:\"files\";a:500:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:20:\"block/editor-rtl.css\";i:29;s:24:\"block/editor-rtl.min.css\";i:30;s:16:\"block/editor.css\";i:31;s:20:\"block/editor.min.css\";i:32;s:21:\"button/editor-rtl.css\";i:33;s:25:\"button/editor-rtl.min.css\";i:34;s:17:\"button/editor.css\";i:35;s:21:\"button/editor.min.css\";i:36;s:20:\"button/style-rtl.css\";i:37;s:24:\"button/style-rtl.min.css\";i:38;s:16:\"button/style.css\";i:39;s:20:\"button/style.min.css\";i:40;s:22:\"buttons/editor-rtl.css\";i:41;s:26:\"buttons/editor-rtl.min.css\";i:42;s:18:\"buttons/editor.css\";i:43;s:22:\"buttons/editor.min.css\";i:44;s:21:\"buttons/style-rtl.css\";i:45;s:25:\"buttons/style-rtl.min.css\";i:46;s:17:\"buttons/style.css\";i:47;s:21:\"buttons/style.min.css\";i:48;s:22:\"calendar/style-rtl.css\";i:49;s:26:\"calendar/style-rtl.min.css\";i:50;s:18:\"calendar/style.css\";i:51;s:22:\"calendar/style.min.css\";i:52;s:25:\"categories/editor-rtl.css\";i:53;s:29:\"categories/editor-rtl.min.css\";i:54;s:21:\"categories/editor.css\";i:55;s:25:\"categories/editor.min.css\";i:56;s:24:\"categories/style-rtl.css\";i:57;s:28:\"categories/style-rtl.min.css\";i:58;s:20:\"categories/style.css\";i:59;s:24:\"categories/style.min.css\";i:60;s:19:\"code/editor-rtl.css\";i:61;s:23:\"code/editor-rtl.min.css\";i:62;s:15:\"code/editor.css\";i:63;s:19:\"code/editor.min.css\";i:64;s:18:\"code/style-rtl.css\";i:65;s:22:\"code/style-rtl.min.css\";i:66;s:14:\"code/style.css\";i:67;s:18:\"code/style.min.css\";i:68;s:18:\"code/theme-rtl.css\";i:69;s:22:\"code/theme-rtl.min.css\";i:70;s:14:\"code/theme.css\";i:71;s:18:\"code/theme.min.css\";i:72;s:22:\"columns/editor-rtl.css\";i:73;s:26:\"columns/editor-rtl.min.css\";i:74;s:18:\"columns/editor.css\";i:75;s:22:\"columns/editor.min.css\";i:76;s:21:\"columns/style-rtl.css\";i:77;s:25:\"columns/style-rtl.min.css\";i:78;s:17:\"columns/style.css\";i:79;s:21:\"columns/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:30:\"comment-template/style-rtl.css\";i:85;s:34:\"comment-template/style-rtl.min.css\";i:86;s:26:\"comment-template/style.css\";i:87;s:30:\"comment-template/style.min.css\";i:88;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:89;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:90;s:38:\"comments-pagination-numbers/editor.css\";i:91;s:42:\"comments-pagination-numbers/editor.min.css\";i:92;s:34:\"comments-pagination/editor-rtl.css\";i:93;s:38:\"comments-pagination/editor-rtl.min.css\";i:94;s:30:\"comments-pagination/editor.css\";i:95;s:34:\"comments-pagination/editor.min.css\";i:96;s:33:\"comments-pagination/style-rtl.css\";i:97;s:37:\"comments-pagination/style-rtl.min.css\";i:98;s:29:\"comments-pagination/style.css\";i:99;s:33:\"comments-pagination/style.min.css\";i:100;s:29:\"comments-title/editor-rtl.css\";i:101;s:33:\"comments-title/editor-rtl.min.css\";i:102;s:25:\"comments-title/editor.css\";i:103;s:29:\"comments-title/editor.min.css\";i:104;s:23:\"comments/editor-rtl.css\";i:105;s:27:\"comments/editor-rtl.min.css\";i:106;s:19:\"comments/editor.css\";i:107;s:23:\"comments/editor.min.css\";i:108;s:22:\"comments/style-rtl.css\";i:109;s:26:\"comments/style-rtl.min.css\";i:110;s:18:\"comments/style.css\";i:111;s:22:\"comments/style.min.css\";i:112;s:20:\"cover/editor-rtl.css\";i:113;s:24:\"cover/editor-rtl.min.css\";i:114;s:16:\"cover/editor.css\";i:115;s:20:\"cover/editor.min.css\";i:116;s:19:\"cover/style-rtl.css\";i:117;s:23:\"cover/style-rtl.min.css\";i:118;s:15:\"cover/style.css\";i:119;s:19:\"cover/style.min.css\";i:120;s:22:\"details/editor-rtl.css\";i:121;s:26:\"details/editor-rtl.min.css\";i:122;s:18:\"details/editor.css\";i:123;s:22:\"details/editor.min.css\";i:124;s:21:\"details/style-rtl.css\";i:125;s:25:\"details/style-rtl.min.css\";i:126;s:17:\"details/style.css\";i:127;s:21:\"details/style.min.css\";i:128;s:20:\"embed/editor-rtl.css\";i:129;s:24:\"embed/editor-rtl.min.css\";i:130;s:16:\"embed/editor.css\";i:131;s:20:\"embed/editor.min.css\";i:132;s:19:\"embed/style-rtl.css\";i:133;s:23:\"embed/style-rtl.min.css\";i:134;s:15:\"embed/style.css\";i:135;s:19:\"embed/style.min.css\";i:136;s:19:\"embed/theme-rtl.css\";i:137;s:23:\"embed/theme-rtl.min.css\";i:138;s:15:\"embed/theme.css\";i:139;s:19:\"embed/theme.min.css\";i:140;s:19:\"file/editor-rtl.css\";i:141;s:23:\"file/editor-rtl.min.css\";i:142;s:15:\"file/editor.css\";i:143;s:19:\"file/editor.min.css\";i:144;s:18:\"file/style-rtl.css\";i:145;s:22:\"file/style-rtl.min.css\";i:146;s:14:\"file/style.css\";i:147;s:18:\"file/style.min.css\";i:148;s:23:\"footnotes/style-rtl.css\";i:149;s:27:\"footnotes/style-rtl.min.css\";i:150;s:19:\"footnotes/style.css\";i:151;s:23:\"footnotes/style.min.css\";i:152;s:23:\"freeform/editor-rtl.css\";i:153;s:27:\"freeform/editor-rtl.min.css\";i:154;s:19:\"freeform/editor.css\";i:155;s:23:\"freeform/editor.min.css\";i:156;s:22:\"gallery/editor-rtl.css\";i:157;s:26:\"gallery/editor-rtl.min.css\";i:158;s:18:\"gallery/editor.css\";i:159;s:22:\"gallery/editor.min.css\";i:160;s:21:\"gallery/style-rtl.css\";i:161;s:25:\"gallery/style-rtl.min.css\";i:162;s:17:\"gallery/style.css\";i:163;s:21:\"gallery/style.min.css\";i:164;s:21:\"gallery/theme-rtl.css\";i:165;s:25:\"gallery/theme-rtl.min.css\";i:166;s:17:\"gallery/theme.css\";i:167;s:21:\"gallery/theme.min.css\";i:168;s:20:\"group/editor-rtl.css\";i:169;s:24:\"group/editor-rtl.min.css\";i:170;s:16:\"group/editor.css\";i:171;s:20:\"group/editor.min.css\";i:172;s:19:\"group/style-rtl.css\";i:173;s:23:\"group/style-rtl.min.css\";i:174;s:15:\"group/style.css\";i:175;s:19:\"group/style.min.css\";i:176;s:19:\"group/theme-rtl.css\";i:177;s:23:\"group/theme-rtl.min.css\";i:178;s:15:\"group/theme.css\";i:179;s:19:\"group/theme.min.css\";i:180;s:21:\"heading/style-rtl.css\";i:181;s:25:\"heading/style-rtl.min.css\";i:182;s:17:\"heading/style.css\";i:183;s:21:\"heading/style.min.css\";i:184;s:19:\"html/editor-rtl.css\";i:185;s:23:\"html/editor-rtl.min.css\";i:186;s:15:\"html/editor.css\";i:187;s:19:\"html/editor.min.css\";i:188;s:20:\"image/editor-rtl.css\";i:189;s:24:\"image/editor-rtl.min.css\";i:190;s:16:\"image/editor.css\";i:191;s:20:\"image/editor.min.css\";i:192;s:19:\"image/style-rtl.css\";i:193;s:23:\"image/style-rtl.min.css\";i:194;s:15:\"image/style.css\";i:195;s:19:\"image/style.min.css\";i:196;s:19:\"image/theme-rtl.css\";i:197;s:23:\"image/theme-rtl.min.css\";i:198;s:15:\"image/theme.css\";i:199;s:19:\"image/theme.min.css\";i:200;s:29:\"latest-comments/style-rtl.css\";i:201;s:33:\"latest-comments/style-rtl.min.css\";i:202;s:25:\"latest-comments/style.css\";i:203;s:29:\"latest-comments/style.min.css\";i:204;s:27:\"latest-posts/editor-rtl.css\";i:205;s:31:\"latest-posts/editor-rtl.min.css\";i:206;s:23:\"latest-posts/editor.css\";i:207;s:27:\"latest-posts/editor.min.css\";i:208;s:26:\"latest-posts/style-rtl.css\";i:209;s:30:\"latest-posts/style-rtl.min.css\";i:210;s:22:\"latest-posts/style.css\";i:211;s:26:\"latest-posts/style.min.css\";i:212;s:18:\"list/style-rtl.css\";i:213;s:22:\"list/style-rtl.min.css\";i:214;s:14:\"list/style.css\";i:215;s:18:\"list/style.min.css\";i:216;s:25:\"media-text/editor-rtl.css\";i:217;s:29:\"media-text/editor-rtl.min.css\";i:218;s:21:\"media-text/editor.css\";i:219;s:25:\"media-text/editor.min.css\";i:220;s:24:\"media-text/style-rtl.css\";i:221;s:28:\"media-text/style-rtl.min.css\";i:222;s:20:\"media-text/style.css\";i:223;s:24:\"media-text/style.min.css\";i:224;s:19:\"more/editor-rtl.css\";i:225;s:23:\"more/editor-rtl.min.css\";i:226;s:15:\"more/editor.css\";i:227;s:19:\"more/editor.min.css\";i:228;s:30:\"navigation-link/editor-rtl.css\";i:229;s:34:\"navigation-link/editor-rtl.min.css\";i:230;s:26:\"navigation-link/editor.css\";i:231;s:30:\"navigation-link/editor.min.css\";i:232;s:29:\"navigation-link/style-rtl.css\";i:233;s:33:\"navigation-link/style-rtl.min.css\";i:234;s:25:\"navigation-link/style.css\";i:235;s:29:\"navigation-link/style.min.css\";i:236;s:33:\"navigation-submenu/editor-rtl.css\";i:237;s:37:\"navigation-submenu/editor-rtl.min.css\";i:238;s:29:\"navigation-submenu/editor.css\";i:239;s:33:\"navigation-submenu/editor.min.css\";i:240;s:25:\"navigation/editor-rtl.css\";i:241;s:29:\"navigation/editor-rtl.min.css\";i:242;s:21:\"navigation/editor.css\";i:243;s:25:\"navigation/editor.min.css\";i:244;s:24:\"navigation/style-rtl.css\";i:245;s:28:\"navigation/style-rtl.min.css\";i:246;s:20:\"navigation/style.css\";i:247;s:24:\"navigation/style.min.css\";i:248;s:23:\"nextpage/editor-rtl.css\";i:249;s:27:\"nextpage/editor-rtl.min.css\";i:250;s:19:\"nextpage/editor.css\";i:251;s:23:\"nextpage/editor.min.css\";i:252;s:24:\"page-list/editor-rtl.css\";i:253;s:28:\"page-list/editor-rtl.min.css\";i:254;s:20:\"page-list/editor.css\";i:255;s:24:\"page-list/editor.min.css\";i:256;s:23:\"page-list/style-rtl.css\";i:257;s:27:\"page-list/style-rtl.min.css\";i:258;s:19:\"page-list/style.css\";i:259;s:23:\"page-list/style.min.css\";i:260;s:24:\"paragraph/editor-rtl.css\";i:261;s:28:\"paragraph/editor-rtl.min.css\";i:262;s:20:\"paragraph/editor.css\";i:263;s:24:\"paragraph/editor.min.css\";i:264;s:23:\"paragraph/style-rtl.css\";i:265;s:27:\"paragraph/style-rtl.min.css\";i:266;s:19:\"paragraph/style.css\";i:267;s:23:\"paragraph/style.min.css\";i:268;s:25:\"post-author/style-rtl.css\";i:269;s:29:\"post-author/style-rtl.min.css\";i:270;s:21:\"post-author/style.css\";i:271;s:25:\"post-author/style.min.css\";i:272;s:33:\"post-comments-form/editor-rtl.css\";i:273;s:37:\"post-comments-form/editor-rtl.min.css\";i:274;s:29:\"post-comments-form/editor.css\";i:275;s:33:\"post-comments-form/editor.min.css\";i:276;s:32:\"post-comments-form/style-rtl.css\";i:277;s:36:\"post-comments-form/style-rtl.min.css\";i:278;s:28:\"post-comments-form/style.css\";i:279;s:32:\"post-comments-form/style.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"query/style-rtl.css\";i:357;s:23:\"query/style-rtl.min.css\";i:358;s:15:\"query/style.css\";i:359;s:19:\"query/style.min.css\";i:360;s:19:\"quote/style-rtl.css\";i:361;s:23:\"quote/style-rtl.min.css\";i:362;s:15:\"quote/style.css\";i:363;s:19:\"quote/style.min.css\";i:364;s:19:\"quote/theme-rtl.css\";i:365;s:23:\"quote/theme-rtl.min.css\";i:366;s:15:\"quote/theme.css\";i:367;s:19:\"quote/theme.min.css\";i:368;s:23:\"read-more/style-rtl.css\";i:369;s:27:\"read-more/style-rtl.min.css\";i:370;s:19:\"read-more/style.css\";i:371;s:23:\"read-more/style.min.css\";i:372;s:18:\"rss/editor-rtl.css\";i:373;s:22:\"rss/editor-rtl.min.css\";i:374;s:14:\"rss/editor.css\";i:375;s:18:\"rss/editor.min.css\";i:376;s:17:\"rss/style-rtl.css\";i:377;s:21:\"rss/style-rtl.min.css\";i:378;s:13:\"rss/style.css\";i:379;s:17:\"rss/style.min.css\";i:380;s:21:\"search/editor-rtl.css\";i:381;s:25:\"search/editor-rtl.min.css\";i:382;s:17:\"search/editor.css\";i:383;s:21:\"search/editor.min.css\";i:384;s:20:\"search/style-rtl.css\";i:385;s:24:\"search/style-rtl.min.css\";i:386;s:16:\"search/style.css\";i:387;s:20:\"search/style.min.css\";i:388;s:20:\"search/theme-rtl.css\";i:389;s:24:\"search/theme-rtl.min.css\";i:390;s:16:\"search/theme.css\";i:391;s:20:\"search/theme.min.css\";i:392;s:24:\"separator/editor-rtl.css\";i:393;s:28:\"separator/editor-rtl.min.css\";i:394;s:20:\"separator/editor.css\";i:395;s:24:\"separator/editor.min.css\";i:396;s:23:\"separator/style-rtl.css\";i:397;s:27:\"separator/style-rtl.min.css\";i:398;s:19:\"separator/style.css\";i:399;s:23:\"separator/style.min.css\";i:400;s:23:\"separator/theme-rtl.css\";i:401;s:27:\"separator/theme-rtl.min.css\";i:402;s:19:\"separator/theme.css\";i:403;s:23:\"separator/theme.min.css\";i:404;s:24:\"shortcode/editor-rtl.css\";i:405;s:28:\"shortcode/editor-rtl.min.css\";i:406;s:20:\"shortcode/editor.css\";i:407;s:24:\"shortcode/editor.min.css\";i:408;s:24:\"site-logo/editor-rtl.css\";i:409;s:28:\"site-logo/editor-rtl.min.css\";i:410;s:20:\"site-logo/editor.css\";i:411;s:24:\"site-logo/editor.min.css\";i:412;s:23:\"site-logo/style-rtl.css\";i:413;s:27:\"site-logo/style-rtl.min.css\";i:414;s:19:\"site-logo/style.css\";i:415;s:23:\"site-logo/style.min.css\";i:416;s:27:\"site-tagline/editor-rtl.css\";i:417;s:31:\"site-tagline/editor-rtl.min.css\";i:418;s:23:\"site-tagline/editor.css\";i:419;s:27:\"site-tagline/editor.min.css\";i:420;s:25:\"site-title/editor-rtl.css\";i:421;s:29:\"site-title/editor-rtl.min.css\";i:422;s:21:\"site-title/editor.css\";i:423;s:25:\"site-title/editor.min.css\";i:424;s:24:\"site-title/style-rtl.css\";i:425;s:28:\"site-title/style-rtl.min.css\";i:426;s:20:\"site-title/style.css\";i:427;s:24:\"site-title/style.min.css\";i:428;s:26:\"social-link/editor-rtl.css\";i:429;s:30:\"social-link/editor-rtl.min.css\";i:430;s:22:\"social-link/editor.css\";i:431;s:26:\"social-link/editor.min.css\";i:432;s:27:\"social-links/editor-rtl.css\";i:433;s:31:\"social-links/editor-rtl.min.css\";i:434;s:23:\"social-links/editor.css\";i:435;s:27:\"social-links/editor.min.css\";i:436;s:26:\"social-links/style-rtl.css\";i:437;s:30:\"social-links/style-rtl.min.css\";i:438;s:22:\"social-links/style.css\";i:439;s:26:\"social-links/style.min.css\";i:440;s:21:\"spacer/editor-rtl.css\";i:441;s:25:\"spacer/editor-rtl.min.css\";i:442;s:17:\"spacer/editor.css\";i:443;s:21:\"spacer/editor.min.css\";i:444;s:20:\"spacer/style-rtl.css\";i:445;s:24:\"spacer/style-rtl.min.css\";i:446;s:16:\"spacer/style.css\";i:447;s:20:\"spacer/style.min.css\";i:448;s:20:\"table/editor-rtl.css\";i:449;s:24:\"table/editor-rtl.min.css\";i:450;s:16:\"table/editor.css\";i:451;s:20:\"table/editor.min.css\";i:452;s:19:\"table/style-rtl.css\";i:453;s:23:\"table/style-rtl.min.css\";i:454;s:15:\"table/style.css\";i:455;s:19:\"table/style.min.css\";i:456;s:19:\"table/theme-rtl.css\";i:457;s:23:\"table/theme-rtl.min.css\";i:458;s:15:\"table/theme.css\";i:459;s:19:\"table/theme.min.css\";i:460;s:23:\"tag-cloud/style-rtl.css\";i:461;s:27:\"tag-cloud/style-rtl.min.css\";i:462;s:19:\"tag-cloud/style.css\";i:463;s:23:\"tag-cloud/style.min.css\";i:464;s:28:\"template-part/editor-rtl.css\";i:465;s:32:\"template-part/editor-rtl.min.css\";i:466;s:24:\"template-part/editor.css\";i:467;s:28:\"template-part/editor.min.css\";i:468;s:27:\"template-part/theme-rtl.css\";i:469;s:31:\"template-part/theme-rtl.min.css\";i:470;s:23:\"template-part/theme.css\";i:471;s:27:\"template-part/theme.min.css\";i:472;s:30:\"term-description/style-rtl.css\";i:473;s:34:\"term-description/style-rtl.min.css\";i:474;s:26:\"term-description/style.css\";i:475;s:30:\"term-description/style.min.css\";i:476;s:27:\"text-columns/editor-rtl.css\";i:477;s:31:\"text-columns/editor-rtl.min.css\";i:478;s:23:\"text-columns/editor.css\";i:479;s:27:\"text-columns/editor.min.css\";i:480;s:26:\"text-columns/style-rtl.css\";i:481;s:30:\"text-columns/style-rtl.min.css\";i:482;s:22:\"text-columns/style.css\";i:483;s:26:\"text-columns/style.min.css\";i:484;s:19:\"verse/style-rtl.css\";i:485;s:23:\"verse/style-rtl.min.css\";i:486;s:15:\"verse/style.css\";i:487;s:19:\"verse/style.min.css\";i:488;s:20:\"video/editor-rtl.css\";i:489;s:24:\"video/editor-rtl.min.css\";i:490;s:16:\"video/editor.css\";i:491;s:20:\"video/editor.min.css\";i:492;s:19:\"video/style-rtl.css\";i:493;s:23:\"video/style-rtl.min.css\";i:494;s:15:\"video/style.css\";i:495;s:19:\"video/style.min.css\";i:496;s:19:\"video/theme-rtl.css\";i:497;s:23:\"video/theme-rtl.min.css\";i:498;s:15:\"video/theme.css\";i:499;s:19:\"video/theme.min.css\";}}","yes");
INSERT INTO `wp_options` VALUES("123","recovery_keys","a:0:{}","off");
INSERT INTO `wp_options` VALUES("127","theme_mods_twentytwentyfour","a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1708596476;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-7\";i:1;s:8:\"block-11\";i:2;s:8:\"block-15\";i:3;s:8:\"block-12\";i:4;s:7:\"block-9\";}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}}","no");
INSERT INTO `wp_options` VALUES("131","current_theme","Customizr","yes");
INSERT INTO `wp_options` VALUES("132","theme_mods_bright-mode","a:4:{s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1706910197;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}","no");
INSERT INTO `wp_options` VALUES("133","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("157","finished_updating_comment_type","1","yes");
INSERT INTO `wp_options` VALUES("161","WPLANG","en_GB","yes");
INSERT INTO `wp_options` VALUES("182","theme_mods_vertice","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:11:\"header-menu\";i:4;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1706910332;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:17:\"kubio-woocommerce\";a:6:{i:0;s:25:\"woocommerce_widget_cart-2\";i:1;s:7:\"block-7\";i:2;s:26:\"woocommerce_price_filter-2\";i:3;s:38:\"woocommerce_recently_viewed_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";i:5;s:33:\"woocommerce_layered_nav_filters-2\";}}}}","no");
INSERT INTO `wp_options` VALUES("183","__kubio_instance_flags","a:8:{s:13:\"import_design\";b:1;s:9:\"_settings\";a:6:{s:11:\"googleFonts\";a:1:{s:12:\"serveLocally\";b:0;}s:15:\"editorUIVersion\";i:2;s:10:\"editorMode\";s:6:\"simple\";s:17:\"activatedOnStage2\";b:1;s:8:\"aiStage2\";b:0;s:23:\"deactivation_backup_key\";a:1:{s:9:\"customizr\";s:30:\"bkp-deactivation-65bd633a3de88\";}}s:21:\"kubio_activation_time\";i:1706910208;s:10:\"stylesheet\";s:7:\"vertice\";s:24:\"kubio_templates_imported\";i:1706910333;s:29:\"kubio_template_parts_imported\";i:1706910333;s:12:\"start_source\";s:15:\"notice-homepage\";s:20:\"wc_sidebar_populated\";b:1;}","no");
INSERT INTO `wp_options` VALUES("185","kubio_instance_data","a:4:{s:23:\"license_active_endpoint\";s:51:\"https://cloud.kubiobuilder.com/api/license/activate\";s:22:\"license_check_endpoint\";s:48:\"https://cloud.kubiobuilder.com/api/license/check\";s:23:\"product_update_endpoint\";s:49:\"https://cloud.kubiobuilder.com/api/product/update\";s:13:\"dashboard_url\";s:31:\"https://cloud.kubiobuilder.com/\";}","yes");
INSERT INTO `wp_options` VALUES("186","_kubio_backup_unique_key_id","65bd6200ebb31","no");
INSERT INTO `wp_options` VALUES("187","kubio_is_fresh_site","1","yes");
INSERT INTO `wp_options` VALUES("190","widget_woocommerce_widget_cart","a:1:{i:2;a:2:{s:5:\"title\";s:4:\"Cart\";s:13:\"hide_if_empty\";i:1;}}","yes");
INSERT INTO `wp_options` VALUES("191","widget_woocommerce_price_filter","a:1:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}}","yes");
INSERT INTO `wp_options` VALUES("192","widget_woocommerce_recently_viewed_products","a:1:{i:2;a:2:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";i:10;}}","yes");
INSERT INTO `wp_options` VALUES("193","widget_woocommerce_top_rated_products","a:1:{i:2;a:2:{s:5:\"title\";s:18:\"Top rated products\";s:6:\"number\";i:5;}}","yes");
INSERT INTO `wp_options` VALUES("194","widget_woocommerce_layered_nav_filters","a:1:{i:2;a:1:{s:5:\"title\";s:14:\"Active filters\";}}","yes");
INSERT INTO `wp_options` VALUES("204","theme_mods_customizr","a:6:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:6:\"topbar\";i:9;s:4:\"main\";i:0;s:9:\"secondary\";i:0;s:6:\"mobile\";i:9;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:1226;s:27:\"remove_powered_by_wordpress\";b:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1708596427;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";i:5;s:7:\"block-7\";}s:4:\"left\";a:0:{}s:5:\"right\";a:0:{}s:17:\"footer_horizontal\";a:0:{}s:10:\"footer_one\";a:2:{i:0;s:8:\"block-11\";i:1;s:8:\"block-15\";}s:10:\"footer_two\";a:1:{i:0;s:8:\"block-12\";}s:12:\"footer_three\";a:1:{i:0;s:7:\"block-9\";}}}}","yes");
INSERT INTO `wp_options` VALUES("205","tc_theme_options","a:23:{s:23:\"started_using_customizr\";s:11:\"with|4.4.21\";s:15:\"tc_social_links\";a:4:{i:0;a:3:{s:10:\"is_mod_opt\";b:1;s:9:\"module_id\";s:26:\"tc_social_links_czr_module\";s:11:\"social-size\";s:2:\"14\";}i:1;a:6:{s:2:\"id\";s:19:\"czr_social_module_0\";s:5:\"title\";s:24:\"Subscribe to my RSS Feed\";s:11:\"social-icon\";s:6:\"fa-rss\";s:11:\"social-link\";s:51:\"https://www.southlancsarc.co.uk/index.php/feed/rss/\";s:12:\"social-color\";s:13:\"rgb(90,90,90)\";s:13:\"social-target\";i:1;}i:2;a:6:{s:2:\"id\";s:19:\"czr_social_module_1\";s:5:\"title\";s:31:\"Follow us on Facebook-f (alias)\";s:11:\"social-icon\";s:21:\"fa-facebook-f (alias)\";s:11:\"social-link\";s:37:\"https://www.facebook.com/groups/SLARC\";s:12:\"social-color\";s:13:\"rgb(90,90,90)\";s:13:\"social-target\";i:1;}i:3;a:6:{s:2:\"id\";s:19:\"czr_social_module_2\";s:5:\"title\";s:20:\"Follow us on Youtube\";s:11:\"social-icon\";s:10:\"fa-youtube\";s:11:\"social-link\";s:55:\"https://www.youtube.com/@southlancsamateurradioclub9743\";s:12:\"social-color\";s:13:\"rgb(90,90,90)\";s:13:\"social-target\";i:1;}}s:12:\"__moved_opts\";a:9:{i:0;s:11:\"old_socials\";i:1;s:10:\"custom_css\";i:2;s:12:\"classic_skin\";i:3;s:21:\"classic_sticky_header\";i:4;s:21:\"classic_header_wccart\";i:5;s:22:\"classic_header_tagline\";i:6;s:20:\"header_mobile_search\";i:7;s:13:\"header_topbar\";i:8;s:14:\"header_socials\";}s:8:\"defaults\";a:163:{s:18:\"tc_title_next_logo\";b:1;s:14:\"tc_logo_resize\";b:1;s:14:\"tc_site_layout\";s:4:\"wide\";s:23:\"tc_header_topbar_layout\";s:5:\"boxed\";s:23:\"tc_header_navbar_layout\";s:5:\"boxed\";s:25:\"tc_footer_colophon_layout\";s:5:\"boxed\";s:13:\"tc_skin_color\";s:7:\"#5a5a5a\";s:23:\"tc_disable_google_fonts\";b:0;s:8:\"tc_fonts\";s:16:\"_g_sourcesanspro\";s:17:\"tc_body_font_size\";i:15;s:15:\"tc_social_links\";a:0:{}s:14:\"tc_link_scroll\";b:0;s:20:\"tc_link_hover_effect\";b:1;s:17:\"tc_link_underline\";b:1;s:11:\"tc_fancybox\";b:1;s:17:\"tc_retina_support\";b:0;s:20:\"tc_center_slider_img\";b:1;s:13:\"tc_center_img\";b:1;s:18:\"tc_resp_thumbs_img\";b:1;s:18:\"tc_slider_parallax\";b:1;s:19:\"tc_show_author_info\";b:1;s:15:\"tc_smoothscroll\";b:1;s:14:\"tc_header_skin\";s:5:\"light\";s:25:\"tc_header_custom_bg_color\";s:7:\"#ffffff\";s:25:\"tc_header_custom_fg_color\";s:7:\"#313131\";s:43:\"tc_highlight_contextually_active_menu_items\";b:0;s:26:\"tc_header_transparent_home\";b:0;s:19:\"tc_home_header_skin\";s:4:\"dark\";s:20:\"tc_header_no_borders\";b:1;s:21:\"tc_header_show_topbar\";s:4:\"none\";s:22:\"tc_header_show_socials\";s:7:\"desktop\";s:13:\"tc_top_border\";b:1;s:25:\"tc_header_title_underline\";b:1;s:31:\"tc_sticky_transparent_on_scroll\";b:1;s:17:\"tc_sticky_z_index\";i:100;s:16:\"tc_header_layout\";s:4:\"left\";s:25:\"tc_header_desktop_tagline\";s:11:\"brand_below\";s:24:\"tc_header_desktop_search\";s:6:\"navbar\";s:27:\"tc_header_search_full_width\";b:0;s:25:\"tc_header_desktop_wc_cart\";s:6:\"topbar\";s:24:\"tc_header_desktop_sticky\";s:8:\"stick_up\";s:26:\"tc_header_desktop_to_stick\";s:7:\"primary\";s:27:\"tc_sticky_shrink_title_logo\";b:1;s:28:\"tc_header_mobile_menu_layout\";s:11:\"mobile_menu\";s:39:\"tc_header_mobile_menu_dropdown_on_click\";b:1;s:24:\"tc_header_mobile_tagline\";b:0;s:24:\"tc_header_mobile_wc_cart\";b:1;s:23:\"tc_header_mobile_sticky\";s:8:\"stick_up\";s:23:\"tc_header_mobile_search\";s:6:\"navbar\";s:22:\"tc_display_second_menu\";b:0;s:13:\"tc_menu_style\";s:6:\"navbar\";s:30:\"tc_side_menu_dropdown_on_click\";b:0;s:16:\"tc_menu_position\";s:15:\"pull-menu-right\";s:23:\"tc_second_menu_position\";s:14:\"pull-menu-left\";s:12:\"tc_menu_type\";s:5:\"hover\";s:27:\"tc_menu_submenu_fade_effect\";b:1;s:32:\"tc_menu_submenu_item_move_effect\";b:1;s:17:\"tc_hide_all_menus\";b:0;s:28:\"tc_show_post_navigation_home\";b:0;s:23:\"tc_blog_restrict_by_cat\";a:0:{}s:15:\"tc_front_layout\";s:1:\"f\";s:15:\"tc_front_slider\";s:1:\"0\";s:22:\"tc_posts_slider_number\";i:4;s:24:\"tc_posts_slider_stickies\";b:0;s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:3:\"cta\";s:27:\"tc_posts_slider_button_text\";s:17:\"Read more &raquo;\";s:15:\"tc_slider_width\";b:1;s:15:\"tc_slider_delay\";i:5000;s:22:\"tc_home_slider_overlay\";s:2:\"on\";s:19:\"tc_home_slider_dots\";s:2:\"on\";s:24:\"tc_slider_default_height\";i:500;s:34:\"tc_slider_default_height_apply_all\";b:1;s:33:\"tc_slider_change_default_img_size\";b:0;s:22:\"tc_show_featured_pages\";i:0;s:26:\"tc_show_featured_pages_img\";b:1;s:28:\"tc_featured_page_button_text\";s:17:\"Read more &raquo;\";s:20:\"tc_featured_page_one\";i:0;s:20:\"tc_featured_page_two\";i:0;s:22:\"tc_featured_page_three\";i:0;s:20:\"tc_featured_text_one\";N;s:20:\"tc_featured_text_two\";N;s:22:\"tc_featured_text_three\";N;s:24:\"tc_sidebar_global_layout\";s:1:\"f\";s:23:\"tc_sidebar_force_layout\";b:0;s:22:\"tc_sidebar_post_layout\";s:1:\"f\";s:22:\"tc_sidebar_page_layout\";s:1:\"f\";s:31:\"tc_single_author_block_location\";s:18:\"below_post_content\";s:38:\"tc_single_related_posts_block_location\";s:18:\"below_post_content\";s:35:\"tc_singular_comments_block_location\";s:18:\"below_post_content\";s:22:\"tc_comment_show_bubble\";b:1;s:16:\"tc_page_comments\";b:0;s:16:\"tc_post_comments\";b:1;s:20:\"tc_show_comment_list\";b:1;s:13:\"tc_breadcrumb\";b:1;s:23:\"tc_show_breadcrumb_home\";b:0;s:27:\"tc_show_breadcrumb_in_pages\";b:1;s:34:\"tc_show_breadcrumb_in_single_posts\";b:1;s:32:\"tc_show_breadcrumb_in_post_lists\";b:1;s:19:\"tc_breadcrumb_yoast\";b:1;s:18:\"tc_show_post_metas\";b:1;s:23:\"tc_show_post_metas_home\";b:0;s:30:\"tc_show_post_metas_single_post\";b:1;s:29:\"tc_show_post_metas_post_lists\";b:1;s:29:\"tc_show_post_metas_categories\";b:1;s:23:\"tc_show_post_metas_tags\";b:1;s:25:\"tc_show_post_metas_author\";b:1;s:35:\"tc_show_post_metas_publication_date\";b:1;s:30:\"tc_show_post_metas_update_date\";b:0;s:27:\"tc_post_list_excerpt_length\";i:50;s:23:\"tc_post_list_show_thumb\";b:1;s:36:\"tc_post_list_use_attachment_as_thumb\";b:1;s:24:\"tc_post_list_thumb_shape\";s:7:\"rounded\";s:27:\"tc_post_list_thumb_position\";s:5:\"right\";s:28:\"tc_post_list_thumb_alternate\";b:1;s:12:\"tc_cat_title\";s:0:\"\";s:12:\"tc_tag_title\";s:0:\"\";s:15:\"tc_author_title\";s:0:\"\";s:15:\"tc_search_title\";s:19:\"Search results for:\";s:17:\"tc_post_list_grid\";s:4:\"grid\";s:15:\"tc_grid_columns\";s:1:\"3\";s:23:\"tc_grid_expand_featured\";b:1;s:14:\"tc_grid_shadow\";b:1;s:21:\"tc_grid_bottom_border\";b:1;s:17:\"tc_grid_num_words\";i:10;s:30:\"tc_post_list_thumb_placeholder\";b:1;s:29:\"tc_single_post_thumb_location\";s:4:\"hide\";s:28:\"tc_single_post_thumb_natural\";b:0;s:27:\"tc_single_post_thumb_height\";i:250;s:38:\"tc_single_post_thumb_smartphone_height\";i:200;s:16:\"tc_related_posts\";s:10:\"categories\";s:29:\"tc_single_page_thumb_location\";s:4:\"hide\";s:28:\"tc_single_page_thumb_natural\";b:0;s:27:\"tc_single_page_thumb_height\";i:250;s:38:\"tc_single_page_thumb_smartphone_height\";i:200;s:17:\"tc_enable_gallery\";b:1;s:19:\"tc_gallery_fancybox\";b:1;s:16:\"tc_gallery_style\";b:1;s:23:\"tc_show_post_navigation\";b:1;s:28:\"tc_show_post_navigation_page\";b:0;s:30:\"tc_show_post_navigation_single\";b:1;s:31:\"tc_show_post_navigation_archive\";b:1;s:25:\"tc_social_in_left-sidebar\";b:0;s:26:\"tc_social_in_right-sidebar\";b:0;s:14:\"tc_footer_skin\";s:4:\"dark\";s:28:\"tc_footer_horizontal_widgets\";s:4:\"none\";s:19:\"tc_social_in_footer\";b:1;s:16:\"tc_sticky_footer\";b:1;s:19:\"tc_show_back_to_top\";b:1;s:23:\"tc_back_to_top_position\";s:5:\"right\";s:16:\"tc_minified_skin\";b:1;s:17:\"tc_img_smart_load\";b:0;s:24:\"tc_slider_img_smart_load\";b:1;s:21:\"tc_defer_front_script\";b:0;s:21:\"tc_defer_font_awesome\";b:1;s:17:\"tc_preload_gfonts\";b:1;s:21:\"tc_display_front_help\";b:1;s:21:\"tc_font_awesome_icons\";b:1;s:17:\"tc_ms_respond_css\";b:0;s:8:\"tc_style\";s:6:\"modern\";s:46:\"tc_woocommerce_display_product_thumb_before_mw\";b:0;s:3:\"ver\";s:6:\"4.4.24\";}s:18:\"last_update_notice\";a:2:{s:7:\"version\";s:6:\"4.4.24\";s:13:\"display_count\";i:0;}s:23:\"tc_header_topbar_layout\";s:4:\"wide\";s:25:\"tc_footer_colophon_layout\";s:4:\"wide\";s:28:\"tc_show_post_navigation_home\";b:1;s:15:\"tc_front_slider\";s:15:\"tc_posts_slider\";s:21:\"tc_header_show_topbar\";s:14:\"desktop_mobile\";s:13:\"tc_skin_color\";s:7:\"#dd3333\";s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:9:\"slide_cta\";s:22:\"tc_posts_slider_number\";s:3:\"100\";s:14:\"tc_footer_skin\";s:4:\"dark\";s:24:\"tc_posts_slider_stickies\";b:1;s:22:\"tc_home_slider_overlay\";s:2:\"on\";s:24:\"tc_slider_default_height\";i:600;s:27:\"tc_post_list_excerpt_length\";i:60;s:15:\"tc_slider_delay\";i:10000;s:24:\"tc_header_desktop_sticky\";s:12:\"stick_always\";s:27:\"tc_sticky_shrink_title_logo\";b:1;}","on");
INSERT INTO `wp_options` VALUES("209","recently_activated","a:2:{s:21:\"flamingo/flamingo.php\";i:1758361084;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1758361069;}","off");
INSERT INTO `wp_options` VALUES("210","nimble_version","3.3.8","yes");
INSERT INTO `wp_options` VALUES("211","nimble_start_date","2024-02-02 21:45:53","yes");
INSERT INTO `wp_options` VALUES("212","nb_backward_fixes","a:5:{s:20:\"optimize_opts_0321_2\";s:4:\"done\";s:18:\"optimize_opts_0321\";s:4:\"done\";s:23:\"move_in_post_index_0321\";s:4:\"done\";s:27:\"fix_skope_opt_autoload_0321\";s:4:\"done\";s:35:\"clean_section_params_transient_0720\";s:4:\"done\";}","yes");
INSERT INTO `wp_options` VALUES("213","nimble_posts_index","a:2:{s:26:\"nimble___skp__post_page_12\";i:90;s:27:\"nimble___skp__post_page_267\";i:373;}","no");
INSERT INTO `wp_options` VALUES("214","nimble_started_with_version","3.3.4","yes");
INSERT INTO `wp_options` VALUES("215","nimble_global_css","","no");
INSERT INTO `wp_options` VALUES("223","_kubio_bkp_65bd6200ebb31_customizr","a:3:{s:9:\"templates\";a:3:{s:28:\"kubio-page-with-left-sidebar\";a:3:{s:7:\"content\";s:1606:\"<!-- wp:kubio/header {\"slug\":\"kubio-header\",\"theme\":\"customizr\",\"kubio\":{\"id\":\"kd_9rxsmg\",\"styleRef\":\"OwgZj2bCI3\",\"hash\":\"fd9ae78c\"}} /-->\n\n<!-- wp:kubio/section {\"kubio\":{\"id\":\"vpWQFI4LvE\",\"styleRef\":\"eZOO6_njVX\",\"props\":{\"width\":\"boxed\"},\"hash\":\"6e1ec96a\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"id\":\"AWplIaV7Hl\",\"styleRef\":\"nS68_tL1If\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"equalWidth\":false,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"hash\":\"4b5c43d2\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"id\":\"mGbJuhBISd\",\"styleRef\":\"CLNXRJv2N\",\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":300,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"order\":2}}}}},\"hash\":\"61bec024\"}} -->\n<!-- wp:kubio/sidebar {\"slug\":\"kubio-page-sidebar\",\"theme\":\"customizr\",\"kubio\":{\"styleRef\":\"yOiyDDwB4\",\"id\":\"XowSB9lCPe\",\"hash\":\"Y9ypErBRvS\"},\"anchor\":\"sidebar\"} /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"id\":\"2oTZ1_fZBV\",\"styleRef\":\"yxi-Yg7NV8\",\"style\":{\"descendants\":{\"container\":{\"textAlign\":\"left\"},\"inner\":{\"textAlign\":\"left\"}}},\"hash\":\"4b348df8\",\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":50,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"tablet\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"order\":1}}}}}}} -->\n<!-- wp:post-content /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/section -->\n\n<!-- wp:kubio/footer {\"slug\":\"kubio-footer\",\"theme\":\"customizr\",\"kubio\":{\"styleRef\":\"7VAKvEKq60\",\"id\":\"3QnQoo6Sik\"}} /-->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:11:\"wp_template\";}s:29:\"kubio-page-with-right-sidebar\";a:3:{s:7:\"content\";s:1565:\"<!-- wp:kubio/header {\"slug\":\"kubio-header\",\"theme\":\"customizr\",\"kubio\":{\"id\":\"kd_9rxsmg\",\"styleRef\":\"OwgZj2bCI3\",\"hash\":\"fd9ae78c\"}} /-->\n\n<!-- wp:kubio/section {\"kubio\":{\"id\":\"vpWQFI4LvE\",\"styleRef\":\"eZOO6_njVX\",\"props\":{\"width\":\"boxed\"},\"hash\":\"6e1ec96a\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"id\":\"AWplIaV7Hl\",\"styleRef\":\"nS68_tL1If\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"equalWidth\":false,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"hash\":\"4b5c43d2\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"id\":\"2oTZ1_fZBV\",\"styleRef\":\"yxi-Yg7NV8\",\"style\":{\"descendants\":{\"container\":{\"textAlign\":\"left\"},\"inner\":{\"textAlign\":\"left\"}}},\"hash\":\"92309a80\",\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":50,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"tablet\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}} -->\n<!-- wp:post-content /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"id\":\"mGbJuhBISd\",\"styleRef\":\"CLNXRJv2N\",\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":300,\"unit\":\"px\"}}}}},\"hash\":\"b928ce80\"}} -->\n<!-- wp:kubio/sidebar {\"slug\":\"kubio-page-sidebar\",\"theme\":\"customizr\",\"kubio\":{\"styleRef\":\"yOiyDDwB4\",\"id\":\"XowSB9lCPe\",\"hash\":\"Y9ypErBRvS\"},\"anchor\":\"sidebar\"} /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/section -->\n\n<!-- wp:kubio/footer {\"slug\":\"kubio-footer\",\"theme\":\"customizr\",\"kubio\":{\"styleRef\":\"7VAKvEKq60\",\"id\":\"3QnQoo6Sik\"}} /-->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:11:\"wp_template\";}s:16:\"kubio-full-width\";a:3:{s:7:\"content\";s:271:\"<!-- wp:kubio/header {\"slug\":\"kubio-header\",\"theme\":\"customizr\",\"kubio\":{\"id\":\"q52gx7xBLN\",\"styleRef\":\"RW_QAhu4iL\",\"hash\":\"j44lfkmuCu\"}} /-->\n<!-- wp:post-content /-->\n<!-- wp:kubio/footer {\"slug\":\"kubio-footer\",\"theme\":\"customizr\",\"kubio\":{\"styleRef\":\"qPjFIdF0Y\"}} /-->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:11:\"wp_template\";}}s:5:\"parts\";a:4:{s:12:\"kubio-footer\";a:3:{s:7:\"content\";s:2290:\"<!-- wp:kubio/section {\"kubio\":{\"styleRef\":\"vP0mYzy99sE\",\"hash\":\"3ebe1eaa53bf4b88\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"value\":35,\"unit\":\"px\"},\"bottom\":{\"value\":35,\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(var(--kubio-color-6),1)\"},\"typography\":{\"holders\":{\"a\":{\"color\":\"rgba(var(--kubio-color-1-variant-2),1)\",\"states\":{\"hover\":{\"color\":\"rgba(var(--kubio-color-1-variant-1),1)\"}}},\"p\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h1\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h2\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h3\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h4\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h5\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h6\":{\"color\":\"rgba(var(--kubio-color-4),1)\"}}}}}}},\"attrs\":{\"name\":\"Footer\"},\"anchor\":\"footer\"} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"e6PC03TfkKI\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"equalWidth\":false,\"equalHeight\":true,\"verticalGap\":0}},\"hash\":\"392c37e6\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"nJpox2eRXHV\",\"style\":{\"descendants\":{\"container\":{\"textAlign\":\"center\"},\"inner\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h2\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h3\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h4\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h5\":{\"color\":\"rgba(var(--kubio-color-4),1)\"},\"h6\":{\"color\":\"rgba(var(--kubio-color-4),1)\"}}}}}},\"hash\":\"3f2399bd59322f29\",\"props\":{\"layout\":{\"verticalInnerGap\":0}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}} -->\n<!-- wp:kubio/copyright {\"kubio\":{\"styleRef\":\"tF8kitdcL\",\"hash\":\"0f43fb585c5b0527\",\"style\":{\"descendants\":{\"container\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),0.8)\",\"family\":\"Urbanist\",\"weight\":400}}}}}} -->\n© {year} {site-name}. Created with <img class=\"emoji\" role=\"img\" draggable=\"false\" src=\"https://s.w.org/images/core/emoji/14.0.0/svg/2764.svg\" alt=\"❤\"> using WordPress and <a href=\"https://kubiobuilder.com\" target=\"_blank\" rel=\"noopener\">Kubio</a>\n<!-- /wp:kubio/copyright -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/section -->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:16:\"wp_template_part\";}s:18:\"kubio-front-header\";a:3:{s:7:\"content\";s:22901:\"<!-- wp:kubio/navigation {\"kubio\":{\"styleRef\":\"Gp3qTlxXlu\",\"props\":{\"width\":\"boxed\",\"showHeader\":false,\"overlap\":true,\"sticky\":false,\"stickyStartAt\":\"immediately\",\"showTopBar\":false,\"animation\":{\"name\":\"slideDown\"}},\"style\":{\"descendants\":{\"section\":{\"animation\":{\"duration\":{\"unit\":\"s\",\"value\":0.5}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":20,\"unit\":\"px\"},\"bottom\":{\"value\":20,\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(var(--kubio-color-6),0)\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"section\":{\"background\":{\"color\":\"#ffffff\"},\"padding\":{\"top\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"10\",\"color\":\"rgba(23, 25, 39, 0.1)\"}]}}}}}},\"hash\":\"2a1479b2\"},\"anchor\":\"navigation\",\"attrs\":{\"id\":\"navigation\",\"name\":\"Navigation\"}} -->\n<!-- wp:kubio/navigation-section {\"kubio\":{\"styleRef\":\"xLwdIMLPC_l\",\"hash\":\"7slsXb9M8Nf\"}} -->\n<!-- wp:kubio/navigation-items {\"kubio\":{\"styleRef\":\"DqcL_YF9LKJ\",\"hash\":\"4slf86H8Rco\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"MqErEXZ17Jm\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":1,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":2,\"outerGapLinked\":false,\"verticalGap\":0}},\"tablet\":{\"layout\":{\"horizontalGap\":0}}},\"containerWidth\":\"boxed\"},\"hash\":\"4276e14a\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"SFXC9Ze09eu\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":0,\"horizontalInnerGap\":0},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":0}},\"mobile\":{\"layout\":{\"verticalInnerGap\":2,\"horizontalInnerGap\":2}}},\"internal\":{\"heroSection\":{\"type\":null},\"navContent\":{\"type\":\"logo\"},\"mirror\":\"navigation-logo\"}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"mobile\":{\"textAlign\":\"left\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"container\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}},\"hash\":\"564d6cdc\"}} -->\n<!-- wp:kubio/logo {\"kubio\":{\"styleRef\":\"0xSC3AT64\",\"hash\":\"1dc11785\",\"props\":{\"layoutType\":\"text\"},\"style\":{\"descendants\":{\"text\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":36,\"unit\":\"px\"},\"weight\":800,\"family\":\"Urbanist\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}}},\"container\":{\"media\":{\"mobile\":{\"justifyContent\":\"flex-start\",\"alignItems\":\"flex-start\"}}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"DJ3dK9XoVZ\",\"props\":{\"layout\":{\"verticalAlign\":\"center\"},\"internal\":{\"navContent\":{\"type\":\"spacing\"}},\"media\":{\"mobile\":{\"isHidden\":true}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\"}}}}}},\"hash\":\"0ad949ac\"}} -->\n<!-- wp:kubio/spacer {\"kubio\":{\"styleRef\":\"mRmagmI3LJv\"}} /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"ZEkYpBrx7RA\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":0,\"horizontalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},\"internal\":{\"heroSection\":{\"type\":null},\"navContent\":{\"type\":\"menu\"},\"mirror\":\"navigation-menu\"}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"right\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"container\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"right\",\"media\":{\"mobile\":{\"textAlign\":\"right\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"86.16\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"86.16\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}},\"hash\":\"79ffa156\"}} -->\n<!-- wp:kubio/dropdown-menu {\"kubio\":{\"styleRef\":\"c6BbujDIAOY\",\"props\":{\"menu\":null,\"horizontalAlign\":\"start\",\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"background\":{\"effect\":\"solid-active-item effect-pull-down\"},\"border\":{\"effect\":\"effect-borders-grow grow-from-left\"}}},\"style\":{\"descendants\":{\"hover-effect-border\":{\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"height\":{\"value\":2,\"unit\":\"px\"}},\"hover-effect-background\":{\"background\":{\"color\":\"white\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"}}}}},\"main-menu-ul\":{\"justifyContent\":\"flex-end\",\"gap\":{\"value\":30,\"unit\":\"px\"},\"media\":{\"mobile\":{\"justifyContent\":\"flex-end\"}}},\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":16,\"unit\":\"px\"},\"weight\":400,\"transform\":\"uppercase\",\"family\":\"Urbanist\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":1}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"main-menu-icon\":{\"padding\":{\"left\":{\"value\":5,\"unit\":\"px\"},\"right\":{\"value\":5,\"unit\":\"px\"}}},\"sub-menu-ul\":{\"background\":{\"color\":\"#ffffff\"},\"margin\":{\"left\":{\"value\":5,\"unit\":\"px\"},\"right\":{\"value\":5,\"unit\":\"px\"}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"sub-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6-variant-3),1)\",\"size\":{\"value\":14,\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"border\":{\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"rgba(128,128,128,.2)\"}},\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"},\"color\":\"rgba(var(--kubio-color-5),1)\"},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"},\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"color\":\"rgba(var(--kubio-color-6),1)\"},\"first-sub-menu-ul\":{\"margin\":{\"top\":{\"value\":10,\"unit\":\"px\"}}},\"first-sub-menu-ul-before\":{\"height\":{\"value\":10,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}}}},\"hover-effect-border\":{\"background\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"main-menu-ul\":{\"justifyContent\":\"flex-end\",\"media\":{\"mobile\":{\"justifyContent\":\"flex-end\"}}}}}}},\"hash\":\"3d27b036\"},\"showOffscreenMenuOn\":\"has-offcanvas-tablet\"} -->\n<!-- wp:kubio/menu-items {\"location\":\"header-menu\",\"kubio\":{\"styleRef\":\"K5qy1wT2BoI\",\"hash\":\"7773c488\"}} /-->\n\n<!-- wp:kubio/menu-offscreen {\"kubio\":{\"styleRef\":\"r1Ph182_RWJ\",\"props\":{\"showPanelInCustomizer\":false},\"style\":{\"descendants\":{\"offscreen\":{\"width\":{\"value\":300,\"unit\":\"px\",\"important\":true},\"background\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"offscreenOverlay\":{\"background\":{\"color\":\"rgba(0,0,0,0.5)\"}},\"icon\":{\"background\":{\"color\":\"rgba(0, 0, 0, 0.1)\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0}},\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0}},\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"}},\"fill\":\"white\",\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"5\"},\"bottom\":{\"unit\":\"px\",\"value\":\"5\"},\"left\":{\"unit\":\"px\",\"value\":\"5\"},\"right\":{\"unit\":\"px\",\"value\":\"5\"}},\"size\":{\"unit\":\"px\",\"value\":\"24\"},\"media\":{\"mobile\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}}}}}},\"sub-menu-icon\":{\"margin\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"hash\":\"f9a41d40f33e4388\"},\"icon\":\"icons8-line-awesome/bars\"} -->\n<!-- wp:kubio/menu-offscreen-content {\"kubio\":{\"styleRef\":\"4fttDua62gk\",\"hash\":\"28cc6078\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"oEwMj8zqLa0\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":2,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":1,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":2,\"outerGapLinked\":false}},\"tablet\":{\"layout\":{\"horizontalGap\":2}}}},\"hash\":\"297ef51259322f29\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"dySu33XviAE\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"start\",\"verticalInnerGap\":\"inherit\",\"horizontalInnerGap\":\"inherit\"},\"internal\":{\"heroSection\":{\"type\":null}}},\"style\":{\"descendants\":{\"inner\":{\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"textAlign\":\"center\"}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}}}}}}},\"hash\":\"1326e3f9\"}} -->\n<!-- wp:kubio/logo {\"kubio\":{\"styleRef\":\"afIZ7lcsb\",\"hash\":\"02c95fae\",\"props\":{\"layoutType\":\"text\"},\"style\":{\"descendants\":{\"text\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":30,\"unit\":\"px\"},\"family\":\"Urbanist\",\"weight\":800,\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}}},\"container\":{\"justifyContent\":\"flex-start\",\"alignItems\":\"flex-start\",\"padding\":{\"top\":{\"value\":20,\"unit\":\"px\"},\"bottom\":{\"value\":20,\"unit\":\"px\"},\"left\":{\"value\":20,\"unit\":\"px\"},\"right\":{\"value\":20,\"unit\":\"px\"}}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n\n<!-- wp:kubio/accordion-menu {\"kubio\":{\"styleRef\":\"RfKm7zJUMjR\",\"style\":{\"descendants\":{\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"}}},\"border\":{\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),0.2)\"}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":20},\"bottom\":{\"unit\":\"px\",\"value\":20}}},\"sub-menu-a\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),0.8)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),0.8)\"}}},\"border\":{\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),0.2)\"}}}}},\"hash\":\"0dbd2eae\"}} -->\n<!-- wp:kubio/menu-items {\"location\":\"header-menu\",\"kubio\":{\"styleRef\":\"7riXk8OqsUS\",\"hash\":\"37b03aac\"}} /-->\n<!-- /wp:kubio/accordion-menu -->\n\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"ridFgk2UVqX\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":2,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":0,\"outerGapLinked\":false}}}},\"hash\":\"3d92dd71\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"7AuOkWajPWG\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":\"inherit\",\"horizontalInnerGap\":\"inherit\"},\"internal\":{\"heroSection\":{\"type\":null}}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"center\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}},\"hash\":\"7d0be2f8\"}} -->\n<!-- wp:kubio/copyright {\"kubio\":{\"styleRef\":\"nicBEJtZM\",\"hash\":\"daa2df84\",\"style\":{\"descendants\":{\"container\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),0.4)\"}}}}}} -->\n© {year} {site-name}\n<!-- /wp:kubio/copyright -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/menu-offscreen-content -->\n<!-- /wp:kubio/menu-offscreen -->\n<!-- /wp:kubio/dropdown-menu -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/navigation-items -->\n<!-- /wp:kubio/navigation-section -->\n<!-- /wp:kubio/navigation -->\n\n<!-- wp:kubio/hero {\"kubio\":{\"styleRef\":\"J6FPNZyUrn\",\"hash\":\"5c782241\",\"style\":{\"descendants\":{\"outer\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https://static-assets.kubiobuilder.com/themes/kubio/assets/hero-new3.jpg\"},\"position\":{\"x\":49,\"y\":0}}],\"overlay\":{\"enabled\":true,\"color\":{\"opacity\":\"0.50\",\"value\":\"#000000\"}},\"slideshow\":{\"slides\":[{\"id\":1,\"url\":\"https://static-assets.kubiobuilder.com/themes/kubio/assets/hero-new3.jpg\"},{\"id\":2,\"url\":\"https://wps.iconvert.pro/wp/alexandra-nicolae/almighty-new-1/wp-content/uploads/2023/03/hero-new2.jpg\"},{\"id\":3,\"url\":\"https://wps.iconvert.pro/wp/alexandra-nicolae/almighty-new-1/wp-content/uploads/2023/03/hero-new1.jpg\"}]}},\"padding\":{\"top\":{\"value\":150,\"unit\":\"px\"},\"bottom\":{\"value\":250,\"unit\":\"px\"}},\"typography\":{\"holders\":{\"h1\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h2\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h3\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h4\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h5\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h6\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"p\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":90,\"unit\":\"px\"},\"bottom\":{\"value\":150,\"unit\":\"px\"}}},\"tablet\":{\"background\":{\"image\":[{\"source\":{\"url\":\"https://static-assets.kubiobuilder.com/themes/kubio/assets/hero-new3.jpg\"},\"position\":{\"x\":50,\"y\":100}}]}}},\"customHeight\":{\"type\":\"fit-to-content\"}}}},\"props\":{\"width\":\"boxed\"}},\"attrs\":{\"name\":\"Hero\"},\"anchor\":\"hero\"} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"bgnhUSaQMl\",\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":3}}}},\"hash\":\"68cbe73a\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"9IGHpldIpw\",\"props\":{\"internal\":{\"heroSection\":{\"type\":\"text\"}},\"layout\":{\"vSpace\":{\"value\":10,\"unit\":\"px\"}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":85,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}},\"hash\":\"52c244b1\",\"style\":{\"descendants\":{\"inner\":{\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}}}}}}} -->\n<!-- wp:kubio/heading {\"kubio\":{\"styleRef\":\"ukjZtaF3MN\",\"props\":{\"level\":1},\"hash\":\"64dea320\",\"style\":{\"descendants\":{\"text\":{\"media\":{\"mobile\":{\"typography\":{\"size\":{\"value\":3,\"unit\":\"em\"}}},\"tablet\":{\"typography\":{\"size\":{\"value\":3.5,\"unit\":\"em\"},\"family\":\"Urbanist\"}}},\"typography\":{\"size\":{\"value\":5,\"unit\":\"em\"},\"weight\":700}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} -->\nImagine. Create. Adapt.\n<!-- /wp:kubio/heading -->\n\n<!-- wp:kubio/text {\"kubio\":{\"styleRef\":\"ZFE6-785z\",\"hash\":\"33fe1f9c\",\"props\":{\"isLead\":true},\"style\":{\"descendants\":{\"text\":{\"typography\":{\"size\":{\"value\":2.5,\"unit\":\"em\"},\"lineHeight\":{\"value\":1.2,\"unit\":\"\"}},\"padding\":{\"bottom\":{\"value\":60,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"typography\":{\"weight\":400,\"family\":\"Urbanist\",\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":1.6,\"unit\":\"em\"},\"lineHeight\":{\"value\":1.2,\"unit\":\"\"},\"letterSpacing\":{\"value\":0,\"unit\":\"px\"}}},\"tablet\":{\"typography\":{\"size\":{\"value\":2.2,\"unit\":\"em\"}}}}}}}},\"anchor\":\"paragraph\"} -->\nContinuous learning is the minimum requirement for success in any given field\n<!-- /wp:kubio/text -->\n\n<!-- wp:kubio/buttongroup {\"kubio\":{\"styleRef\":\"9uoTT9gnxCy\",\"hash\":\"DND1AG4nPk6\"}} -->\n<!-- wp:kubio/button {\"kubio\":{\"styleRef\":\"krjLr6qWdH7\",\"props\":{\"buttonWidth\":\"fitToContent\",\"iconPosition\":\"after\",\"showIcon\":false,\"buttonSize\":\"large\",\"horizontalAlign\":\"center\"},\"style\":{\"descendants\":{\"link\":{\"textAlign\":\"center\",\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"},\"border\":{\"top\":{\"color\":\"rgba(var(--kubio-color-1),1)\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"rgba(var(--kubio-color-1),1)\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"right\":{\"color\":\"rgba(var(--kubio-color-1),1)\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"rgba(var(--kubio-color-1),1)\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"15\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":35},\"right\":{\"unit\":\"px\",\"value\":35}},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"right\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"left\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-1),0)\"}}},\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"},\"family\":\"Urbanist\",\"weight\":600}},\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"margin\":{\"left\":{\"value\":10,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}}},\"hash\":\"51e246f6\"},\"link\":{\"value\":\"#\",\"typeOpenLink\":\"sameWindow\",\"noFollow\":false,\"lightboxMedia\":\"\"},\"preserveSpace\":{\"text\":false},\"icon\":{\"name\":\"font-awesome/arrow-right\"}} -->\nBegin now\n<!-- /wp:kubio/button -->\n\n<!-- wp:kubio/button {\"kubio\":{\"styleRef\":\"Dud6AOZG0Hc\",\"props\":{\"buttonWidth\":\"fitToContent\",\"iconPosition\":\"after\",\"showIcon\":false,\"buttonSize\":\"large\",\"horizontalAlign\":\"center\"},\"style\":{\"descendants\":{\"link\":{\"textAlign\":\"center\",\"border\":{\"top\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":2,\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":2,\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"right\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":2,\"unit\":\"px\"}},\"left\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":2,\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"15\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":35},\"right\":{\"unit\":\"px\",\"value\":35}},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"right\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"left\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-5),0)\"}}},\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"},\"family\":\"Urbanist\",\"weight\":600},\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"margin\":{\"left\":{\"value\":10,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}}},\"hash\":\"c854e430\"},\"link\":{\"value\":\"\",\"typeOpenLink\":\"sameWindow\",\"noFollow\":false,\"lightboxMedia\":\"\"},\"preserveSpace\":{\"text\":false},\"icon\":{\"name\":\"font-awesome/arrow-right\"}} -->\nLearn more\n<!-- /wp:kubio/button -->\n<!-- /wp:kubio/buttongroup -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/hero -->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:16:\"wp_template_part\";}s:12:\"kubio-header\";a:3:{s:7:\"content\";s:19783:\"<!-- wp:kubio/navigation {\"kubio\":{\"styleRef\":\"hsxwExJqns\",\"props\":{\"width\":\"boxed\",\"showHeader\":false,\"overlap\":true,\"sticky\":false,\"stickyStartAt\":\"immediately\",\"showTopBar\":false,\"animation\":{\"name\":\"slideDown\"}},\"style\":{\"descendants\":{\"section\":{\"animation\":{\"duration\":{\"unit\":\"s\",\"value\":0.5}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":20,\"unit\":\"px\"},\"bottom\":{\"value\":20,\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(var(--kubio-color-6),0)\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"section\":{\"background\":{\"color\":\"#ffffff\"},\"padding\":{\"top\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"10\",\"color\":\"rgba(23, 25, 39, 0.1)\"}]}}}}}},\"hash\":\"FIizMiSzvM\"},\"anchor\":\"navigation\",\"attrs\":{\"id\":\"navigation\",\"name\":\"Navigation\"}} -->\n<!-- wp:kubio/navigation-section {\"kubio\":{\"styleRef\":\"cXwt7oABaX\",\"hash\":\"1hdAfx9T0_\"}} -->\n<!-- wp:kubio/navigation-items {\"kubio\":{\"styleRef\":\"qdM3juY_kx\",\"hash\":\"zlQuALDIy-\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"s0iK5DNR-t\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":1,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":2,\"outerGapLinked\":false,\"verticalGap\":0}},\"tablet\":{\"layout\":{\"horizontalGap\":0}}},\"containerWidth\":\"boxed\"},\"hash\":\"oHw1CcYFRw\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"o4mv064M8s\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":0,\"horizontalInnerGap\":0},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":0}},\"mobile\":{\"layout\":{\"verticalInnerGap\":2,\"horizontalInnerGap\":2}}},\"internal\":{\"heroSection\":{\"type\":null},\"navContent\":{\"type\":\"logo\"},\"mirror\":\"navigation-logo\"}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"mobile\":{\"textAlign\":\"left\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"container\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"flexgrow\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}},\"hash\":\"zbCh-s7byI\"}} -->\n<!-- wp:kubio/logo {\"kubio\":{\"styleRef\":\"vhWuku20W6U\",\"hash\":\"eJllnN0TTpp\",\"props\":{\"layoutType\":\"text\"},\"style\":{\"descendants\":{\"text\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":36,\"unit\":\"px\"},\"weight\":800,\"family\":\"Urbanist\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}}},\"container\":{\"media\":{\"mobile\":{\"justifyContent\":\"flex-start\",\"alignItems\":\"flex-start\"}}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"MS5a_tntu-J\",\"props\":{\"layout\":{\"verticalAlign\":\"center\"},\"internal\":{\"navContent\":{\"type\":\"spacing\"}},\"media\":{\"mobile\":{\"isHidden\":true}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"flexgrow\"}}}}}},\"hash\":\"oIAAf2xUR-c\"}} -->\n<!-- wp:kubio/spacer {\"kubio\":{\"styleRef\":\"7xBWCLvq6c7\",\"hash\":\"bxti3NYPVoM\"}} /-->\n<!-- /wp:kubio/column -->\n\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"MPMgZVvSoKO\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":0,\"horizontalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},\"internal\":{\"heroSection\":{\"type\":null},\"navContent\":{\"type\":\"menu\"},\"mirror\":\"navigation-menu\"}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"right\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"container\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"right\",\"media\":{\"mobile\":{\"textAlign\":\"right\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"86.16\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"86.16\"}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"fitToContent\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}},\"hash\":\"FEVZTIHzQ-g\"}} -->\n<!-- wp:kubio/dropdown-menu {\"kubio\":{\"styleRef\":\"U_lCw1BkhH4\",\"props\":{\"menu\":null,\"horizontalAlign\":\"start\",\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"background\":{\"effect\":\"solid-active-item effect-pull-down\"},\"border\":{\"effect\":\"effect-borders-grow grow-from-left\"}}},\"style\":{\"descendants\":{\"hover-effect-border\":{\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"height\":{\"value\":2,\"unit\":\"px\"}},\"hover-effect-background\":{\"background\":{\"color\":\"white\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":\"0\"}}}}},\"main-menu-ul\":{\"justifyContent\":\"flex-end\",\"gap\":{\"value\":30,\"unit\":\"px\"},\"media\":{\"mobile\":{\"justifyContent\":\"flex-end\"}}},\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":16,\"unit\":\"px\"},\"weight\":400,\"transform\":\"uppercase\",\"family\":\"Urbanist\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":1}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"main-menu-icon\":{\"padding\":{\"left\":{\"value\":5,\"unit\":\"px\"},\"right\":{\"value\":5,\"unit\":\"px\"}}},\"sub-menu-ul\":{\"background\":{\"color\":\"#ffffff\"},\"margin\":{\"left\":{\"value\":5,\"unit\":\"px\"},\"right\":{\"value\":5,\"unit\":\"px\"}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"sub-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6-variant-3),1)\",\"size\":{\"value\":14,\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"border\":{\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"rgba(128,128,128,.2)\"}},\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"},\"color\":\"rgba(var(--kubio-color-5),1)\"},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"},\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"},\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"color\":\"rgba(var(--kubio-color-6),1)\"},\"first-sub-menu-ul\":{\"margin\":{\"top\":{\"value\":10,\"unit\":\"px\"}}},\"first-sub-menu-ul-before\":{\"height\":{\"value\":10,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}}}},\"hover-effect-border\":{\"background\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"main-menu-ul\":{\"justifyContent\":\"flex-end\",\"media\":{\"mobile\":{\"justifyContent\":\"flex-end\"}}}}}}},\"hash\":\"t1FxEnJkchA\"},\"showOffscreenMenuOn\":\"has-offcanvas-tablet\"} -->\n<!-- wp:kubio/menu-items {\"location\":\"header-menu\",\"kubio\":{\"styleRef\":\"B49zmhoXxCc\",\"hash\":\"xTM9-SdmhJR\"}} /-->\n\n<!-- wp:kubio/menu-offscreen {\"kubio\":{\"styleRef\":\"3e_T6gQCqu0\",\"props\":{\"showPanelInCustomizer\":false},\"style\":{\"descendants\":{\"offscreen\":{\"width\":{\"value\":300,\"unit\":\"px\",\"important\":true},\"background\":{\"color\":\"rgba(var(--kubio-color-6),1)\"}},\"offscreenOverlay\":{\"background\":{\"color\":\"rgba(0,0,0,0.5)\"}},\"icon\":{\"background\":{\"color\":\"rgba(0, 0, 0, 0.1)\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0}},\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0},\"right\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":0}},\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"solid\",\"color\":\"black\"}},\"fill\":\"white\",\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"5\"},\"bottom\":{\"unit\":\"px\",\"value\":\"5\"},\"left\":{\"unit\":\"px\",\"value\":\"5\"},\"right\":{\"unit\":\"px\",\"value\":\"5\"}},\"size\":{\"unit\":\"px\",\"value\":\"24\"},\"media\":{\"mobile\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}}}}}},\"sub-menu-icon\":{\"margin\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"hash\":\"xfT_kq2Pyqr\"},\"icon\":\"icons8-line-awesome/bars\"} -->\n<!-- wp:kubio/menu-offscreen-content {\"kubio\":{\"styleRef\":\"NZQOTG6-YBk\",\"hash\":\"CpR-b78fd1l\"}} -->\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"lqEv4MWKLAt\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":2,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":1,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":2,\"outerGapLinked\":false}},\"tablet\":{\"layout\":{\"horizontalGap\":2}}}},\"hash\":\"d1t4QJogJiu\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"PVOKbkvoDfE\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"start\",\"verticalInnerGap\":\"inherit\",\"horizontalInnerGap\":\"inherit\"},\"internal\":{\"heroSection\":{\"type\":null}}},\"style\":{\"descendants\":{\"inner\":{\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"textAlign\":\"center\"}},\"ancestor\":{\"sticky\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}}}}}}},\"hash\":\"Jzj-URo7ECp\"}} -->\n<!-- wp:kubio/logo {\"kubio\":{\"styleRef\":\"JcpslOq1A6j\",\"hash\":\"IGZCwoVPXHj\",\"props\":{\"layoutType\":\"text\"},\"style\":{\"descendants\":{\"text\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"size\":{\"value\":30,\"unit\":\"px\"},\"family\":\"Urbanist\",\"weight\":800,\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}}},\"container\":{\"justifyContent\":\"flex-start\",\"alignItems\":\"flex-start\",\"padding\":{\"top\":{\"value\":20,\"unit\":\"px\"},\"bottom\":{\"value\":20,\"unit\":\"px\"},\"left\":{\"value\":20,\"unit\":\"px\"},\"right\":{\"value\":20,\"unit\":\"px\"}}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n\n<!-- wp:kubio/accordion-menu {\"kubio\":{\"styleRef\":\"MNlnbVj2wdt\",\"style\":{\"descendants\":{\"main-menu-a\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":1,\"unit\":\"px\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),1)\"}}},\"border\":{\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),0.2)\"}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":20},\"bottom\":{\"unit\":\"px\",\"value\":20}}},\"sub-menu-a\":{\"color\":\"rgba(var(--kubio-color-5),1)\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),0.8)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(var(--kubio-color-1),0.8)\"}}},\"border\":{\"bottom\":{\"color\":\"rgba(var(--kubio-color-5),0.2)\"}}}}},\"hash\":\"k_OC6yl1eU7\"}} -->\n<!-- wp:kubio/menu-items {\"location\":\"header-menu\",\"kubio\":{\"styleRef\":\"zKM-HtZUnDE\",\"hash\":\"_DPggutSFMP\"}} /-->\n<!-- /wp:kubio/accordion-menu -->\n\n<!-- wp:kubio/row {\"kubio\":{\"styleRef\":\"LlK-SSnUr24\",\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":2,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":0,\"outerGapLinked\":false}}}},\"hash\":\"YgcW8ZrzXuC\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"styleRef\":\"x6acY_w1zcs\",\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":\"inherit\",\"horizontalInnerGap\":\"inherit\"},\"internal\":{\"heroSection\":{\"type\":null}}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"center\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":100}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}},\"hash\":\"OJvtLR8vm9E\"}} -->\n<!-- wp:kubio/copyright {\"kubio\":{\"styleRef\":\"yR5c6g_x49j\",\"hash\":\"iIw2_o2QYof\",\"style\":{\"descendants\":{\"container\":{\"typography\":{\"color\":\"rgba(var(--kubio-color-5),0.4)\"}}}}}} -->\n© {year} {site-name}\n<!-- /wp:kubio/copyright -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/menu-offscreen-content -->\n<!-- /wp:kubio/menu-offscreen -->\n<!-- /wp:kubio/dropdown-menu -->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/navigation-items -->\n<!-- /wp:kubio/navigation-section -->\n<!-- /wp:kubio/navigation -->\n\n<!-- wp:kubio/hero {\"kubio\":{\"styleRef\":\"KFTMhA6WOVh\",\"props\":{\"width\":\"boxed\",\"verticalAlign\":\"center\",\"showHeader\":false,\"overlapSection\":false,\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"downArrow\":{\"enabled\":false},\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"}},\"style\":{\"descendants\":{\"outer\":{\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"typography\":{\"holders\":{\"h1\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h2\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h3\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h4\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h5\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"h6\":{\"color\":\"rgba(var(--kubio-color-5),1)\"},\"p\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}}},\"background\":{\"type\":\"image\",\"overlay\":{\"enabled\":true,\"type\":\"color\",\"gradient\":\"linear-gradient(-20deg, rgba(183, 33, 255, 0.8) 0{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301},rgba(33, 212, 253, 0.8) 100{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301})\",\"shape\":{\"value\":\"none\",\"isTile\":false},\"color\":{\"opacity\":\"0.70\",\"value\":\"#000000\"}},\"image\":[{\"source\":{\"url\":\"https://static-assets.kubiobuilder.com/themes/kubio/assets/hero-new3.jpg\"},\"position\":{\"x\":53,\"y\":43}}]},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":90},\"bottom\":{\"unit\":\"px\",\"value\":160}},\"separators\":{\"bottom\":{\"color\":\"white\"},\"top\":{\"color\":\"white\"}}}}},\"hash\":\"2264a78f\"},\"attrs\":{\"name\":\"Hero\"},\"anchor\":\"hero\"} -->\n<!-- wp:kubio/row {\"kubio\":{\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":false,\"equalHeight\":true,\"itemsPerRow\":2,\"verticalAlign\":\"center\",\"horizontalAlign\":\"center\",\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":0,\"outerGapLinked\":false}}}},\"styleRef\":\"vv0pRzL5YoZ\",\"hash\":\"612fc898\"}} -->\n<!-- wp:kubio/column {\"kubio\":{\"props\":{\"overlapOptions\":false,\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"verticalAlign\":\"center\",\"verticalInnerGap\":2,\"horizontalInnerGap\":2},\"internal\":{\"heroSection\":{\"type\":\"text\"}}},\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"center\",\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\"},\"tablet\":{\"textAlign\":\"center\"}},\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\",\"value\":80}},\"media\":{\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"tablet\":{\"columnWidth\":{\"custom\":{\"value\":80,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}},\"styleRef\":\"vPVKm6K-swr\",\"hash\":\"1babb0ac\"}} -->\n<!-- wp:kubio/page-title {\"kubio\":{\"styleRef\":\"SzZXH7PdCL\",\"props\":{\"level\":\"h2\"},\"hash\":\"6b79eb7402319a5c\",\"style\":{\"descendants\":{\"container\":{\"typography\":{\"family\":\"Inter\",\"weight\":600}}}}},\"templates\":{\"normalPage\":\"{TITLE}\",\"normalResultsPage\":\"Search results for: {TITLE}\",\"errorPage\":\"Sorry! Page Not Found!\",\"singlePost\":\"{TITLE}\",\"categoryArchive\":\"Posts in {TITLE}\",\"authorArchive\":\"Posts by {TITLE}\",\"tagArchive\":\"Posts about {TITLE}\",\"yearArchive\":\"Posts from {TITLE}\",\"monthArchive\":\"Posts from {TITLE}\",\"dayArchive\":\"Posts from {TITLE}\"}} /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n<!-- /wp:kubio/hero -->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:16:\"wp_template_part\";}s:18:\"kubio-page-sidebar\";a:3:{s:7:\"content\";s:3369:\"<!-- wp:kubio/row {\"kubio\":{\"id\":\"8dCsSrjMsp\",\"styleRef\":\"theme-t1RcpSwTMC\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"equalWidth\":false,\"equalHeight\":true,\"horizontalGap\":3,\"verticalGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":3}}}},\"hash\":\"ee488ef8\",\"style\":{\"descendants\":{\"container\":{\"background\":{\"color\":\"#f4f4f7\"}}}}}} -->\n<!-- wp:kubio/column {\"kubio\":{\"id\":\"EYHaORziZs\",\"styleRef\":\"theme-HE2LPNtfKX\",\"style\":{\"descendants\":{\"inner\":{\"textAlign\":\"left\"}}},\"hash\":\"52b9563f\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"_style\":{\"descendants\":{\"container\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}},\"media\":{\"tablet\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}},\"mobile\":{\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}\"}}}}}}}}} -->\n<!-- wp:kubio/search-form {\"kubio\":{\"id\":\"_2zeyugI0\",\"styleRef\":\"theme-ciaK61IeR\",\"style\":{\"descendants\":{\"input\":{\"border\":{\"top\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"left\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\"},\"right\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"width\":{\"value\":0,\"unit\":\"px\"}}}},\"button\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}},\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"style\":\"solid\",\"width\":{\"value\":1,\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}},\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"style\":\"solid\",\"width\":{\"value\":1,\"unit\":\"px\"}},\"left\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"style\":\"solid\",\"width\":{\"value\":0,\"unit\":\"px\"}},\"right\":{\"color\":\"rgba(var(--kubio-color-6),0.1)\",\"style\":\"solid\",\"width\":{\"value\":1,\"unit\":\"px\"}}},\"background\":{\"color\":\"rgba(var(--kubio-color-5),1)\"}},\"icon\":{\"fill\":\"rgba(var(--kubio-color-1),1)\",\"states\":{\"hover\":{\"fill\":\"rgba(var(--kubio-color-1-variant-4),1)\"}}}}},\"hash\":\"20202892\"}} /-->\n\n<!-- wp:kubio/heading {\"kubio\":{\"id\":\"oT_xHtkfdV8\",\"styleRef\":\"theme-R9xOJzpKQW0\",\"props\":{\"level\":4},\"hash\":\"791eec86\",\"style\":{\"descendants\":{\"text\":{\"margin\":{\"bottom\":{\"value\":10,\"unit\":\"px\"}}}}}},\"link\":{\"typeOpenLink\":\"sameWindow\"}} -->\nLatest Comments\n<!-- /wp:kubio/heading -->\n\n<!-- wp:latest-comments {\"displayAvatar\":false,\"displayExcerpt\":false,\"kubio\":{\"id\":\"Qv78Ez7ps\",\"styleRef\":\"dAlw2G59Yo\",\"style\":{\"descendants\":{\"widget-box\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\"}}]},\"typography\":{\"size\":{\"value\":14,\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"widget-link\":{\"typography\":{\"size\":{\"value\":14,\"unit\":\"px\"},\"color\":\"rgba(var(--kubio-color-1),1)\"}},\"widget-excerpt\":{\"typography\":{\"size\":{\"value\":16,\"unit\":\"px\"},\"family\":\"Open Sans\",\"weight\":400}},\"widget-date\":{\"typography\":{\"size\":{\"value\":14,\"unit\":\"px\"}},\"margin\":{\"bottom\":{\"value\":20,\"unit\":\"px\"},\"top\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"hash\":\"72bbe0a2\"},\"align\":\"center\"} /-->\n<!-- /wp:kubio/column -->\n<!-- /wp:kubio/row -->\n\";s:6:\"source\";s:5:\"kubio\";s:4:\"type\";s:16:\"wp_template_part\";}}s:6:\"global\";a:7:{s:5:\"fonts\";a:2:{s:6:\"google\";a:5:{i:0;a:3:{s:6:\"family\";s:9:\"Open Sans\";s:8:\"variants\";a:11:{i:0;i:400;i:1;s:3:\"300\";i:2;s:9:\"300italic\";i:3;s:3:\"400\";i:4;s:9:\"400italic\";i:5;s:3:\"600\";i:6;s:9:\"600italic\";i:7;s:3:\"700\";i:8;s:9:\"700italic\";i:9;s:3:\"800\";i:10;s:9:\"800italic\";}s:8:\"category\";s:10:\"sans-serif\";}i:1;a:2:{s:6:\"family\";s:6:\"Mulish\";s:8:\"variants\";a:1:{i:0;i:400;}}i:2;a:2:{s:6:\"family\";s:6:\"Roboto\";s:8:\"variants\";a:13:{i:0;i:400;i:1;s:3:\"100\";i:2;s:9:\"100italic\";i:3;s:3:\"300\";i:4;s:9:\"300italic\";i:5;s:7:\"regular\";i:6;s:6:\"italic\";i:7;s:3:\"500\";i:8;s:9:\"500italic\";i:9;s:3:\"700\";i:10;s:9:\"700italic\";i:11;s:3:\"900\";i:12;s:9:\"900italic\";}}i:3;a:2:{s:6:\"family\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;i:400;}}i:4;a:2:{s:6:\"family\";s:7:\"Poppins\";s:8:\"variants\";a:3:{i:0;i:300;i:1;i:600;i:2;i:600;}}}s:6:\"native\";a:0:{}}s:6:\"medias\";a:3:{s:7:\"desktop\";a:6:{s:2:\"id\";s:7:\"desktop\";s:5:\"label\";s:7:\"desktop\";s:4:\"icon\";s:15:\"desktop_windows\";s:4:\"show\";b:1;s:4:\"main\";b:1;s:10:\"gridPrefix\";s:2:\"lg\";}s:6:\"tablet\";a:7:{s:2:\"id\";s:6:\"tablet\";s:5:\"label\";s:6:\"tablet\";s:4:\"icon\";s:14:\"tablet_android\";s:4:\"show\";b:0;s:5:\"width\";i:1024;s:10:\"gridPrefix\";s:2:\"md\";s:5:\"query\";s:49:\"@media (min-width: 768px) and (max-width: 1023px)\";}s:6:\"mobile\";a:6:{s:2:\"id\";s:6:\"mobile\";s:5:\"label\";s:6:\"mobile\";s:4:\"icon\";s:13:\"phone_android\";s:4:\"show\";b:0;s:5:\"width\";i:480;s:5:\"query\";s:25:\"@media (max-width: 767px)\";}}s:6:\"colors\";a:6:{i:0;a:2:{s:4:\"slug\";s:13:\"kubio-color-1\";s:5:\"color\";a:3:{i:0;i:66;i:1;i:99;i:2;i:190;}}i:1;a:2:{s:4:\"slug\";s:13:\"kubio-color-2\";s:5:\"color\";a:3:{i:0;i:234;i:1;i:147;i:2;i:116;}}i:2;a:2:{s:4:\"slug\";s:13:\"kubio-color-3\";s:5:\"color\";a:3:{i:0;i:128;i:1;i:136;i:2;i:144;}}i:3;a:2:{s:4:\"slug\";s:13:\"kubio-color-4\";s:5:\"color\";a:3:{i:0;i:43;i:1;i:66;i:2;i:123;}}i:4;a:2:{s:4:\"slug\";s:13:\"kubio-color-5\";s:5:\"color\";a:3:{i:0;i:255;i:1;i:255;i:2;i:255;}}i:5;a:2:{s:4:\"slug\";s:13:\"kubio-color-6\";s:5:\"color\";a:3:{i:0;i:18;i:1;i:19;i:2;i:21;}}}s:13:\"colorVariants\";a:30:{i:0;a:3:{s:4:\"slug\";s:23:\"kubio-color-1-variant-1\";s:5:\"color\";a:3:{i:0;i:129;i:1;i:145;i:2;i:189;}s:6:\"parent\";s:13:\"kubio-color-1\";}i:1;a:3:{s:4:\"slug\";s:23:\"kubio-color-1-variant-2\";s:5:\"color\";a:3:{i:0;i:66;i:1;i:99;i:2;i:190;}s:6:\"parent\";s:13:\"kubio-color-1\";}i:2;a:3:{s:4:\"slug\";s:23:\"kubio-color-1-variant-3\";s:5:\"color\";a:3:{i:0;i:2;i:1;i:52;i:2;i:189;}s:6:\"parent\";s:13:\"kubio-color-1\";}i:3;a:3:{s:4:\"slug\";s:23:\"kubio-color-1-variant-4\";s:5:\"color\";a:3:{i:0;i:36;i:1;i:54;i:2;i:104;}s:6:\"parent\";s:13:\"kubio-color-1\";}i:4;a:3:{s:4:\"slug\";s:23:\"kubio-color-1-variant-5\";s:5:\"color\";a:3:{i:0;i:6;i:1;i:10;i:2;i:19;}s:6:\"parent\";s:13:\"kubio-color-1\";}i:5;a:3:{s:4:\"slug\";s:23:\"kubio-color-2-variant-1\";s:5:\"color\";a:3:{i:0;i:233;i:1;i:204;i:2;i:193;}s:6:\"parent\";s:13:\"kubio-color-2\";}i:6;a:3:{s:4:\"slug\";s:23:\"kubio-color-2-variant-2\";s:5:\"color\";a:3:{i:0;i:234;i:1;i:147;i:2;i:116;}s:6:\"parent\";s:13:\"kubio-color-2\";}i:7;a:3:{s:4:\"slug\";s:23:\"kubio-color-2-variant-3\";s:5:\"color\";a:3:{i:0;i:233;i:1;i:89;i:2;i:37;}s:6:\"parent\";s:13:\"kubio-color-2\";}i:8;a:3:{s:4:\"slug\";s:23:\"kubio-color-2-variant-4\";s:5:\"color\";a:3:{i:0;i:148;i:1;i:93;i:2;i:73;}s:6:\"parent\";s:13:\"kubio-color-2\";}i:9;a:3:{s:4:\"slug\";s:23:\"kubio-color-2-variant-5\";s:5:\"color\";a:3:{i:0;i:63;i:1;i:40;i:2;i:31;}s:6:\"parent\";s:13:\"kubio-color-2\";}i:10;a:3:{s:4:\"slug\";s:23:\"kubio-color-3-variant-1\";s:5:\"color\";a:3:{i:0;i:203;i:1;i:216;i:2;i:228;}s:6:\"parent\";s:13:\"kubio-color-3\";}i:11;a:3:{s:4:\"slug\";s:23:\"kubio-color-3-variant-2\";s:5:\"color\";a:3:{i:0;i:128;i:1;i:136;i:2;i:144;}s:6:\"parent\";s:13:\"kubio-color-3\";}i:12;a:3:{s:4:\"slug\";s:23:\"kubio-color-3-variant-3\";s:5:\"color\";a:3:{i:0;i:80;i:1;i:112;i:2;i:143;}s:6:\"parent\";s:13:\"kubio-color-3\";}i:13;a:3:{s:4:\"slug\";s:23:\"kubio-color-3-variant-4\";s:5:\"color\";a:3:{i:0;i:32;i:1;i:88;i:2;i:143;}s:6:\"parent\";s:13:\"kubio-color-3\";}i:14;a:3:{s:4:\"slug\";s:23:\"kubio-color-3-variant-5\";s:5:\"color\";a:3:{i:0;i:52;i:1;i:55;i:2;i:58;}s:6:\"parent\";s:13:\"kubio-color-3\";}i:15;a:3:{s:4:\"slug\";s:23:\"kubio-color-4-variant-1\";s:5:\"color\";a:3:{i:0;i:72;i:1;i:111;i:2;i:207;}s:6:\"parent\";s:13:\"kubio-color-4\";}i:16;a:3:{s:4:\"slug\";s:23:\"kubio-color-4-variant-2\";s:5:\"color\";a:3:{i:0;i:83;i:1;i:95;i:2;i:122;}s:6:\"parent\";s:13:\"kubio-color-4\";}i:17;a:3:{s:4:\"slug\";s:23:\"kubio-color-4-variant-3\";s:5:\"color\";a:3:{i:0;i:43;i:1;i:66;i:2;i:123;}s:6:\"parent\";s:13:\"kubio-color-4\";}i:18;a:3:{s:4:\"slug\";s:23:\"kubio-color-4-variant-4\";s:5:\"color\";a:3:{i:0;i:2;i:1;i:36;i:2;i:122;}s:6:\"parent\";s:13:\"kubio-color-4\";}i:19;a:3:{s:4:\"slug\";s:23:\"kubio-color-4-variant-5\";s:5:\"color\";a:3:{i:0;i:13;i:1;i:20;i:2;i:37;}s:6:\"parent\";s:13:\"kubio-color-4\";}i:20;a:3:{s:4:\"slug\";s:23:\"kubio-color-5-variant-1\";s:5:\"color\";a:3:{i:0;i:255;i:1;i:255;i:2;i:255;}s:6:\"parent\";s:13:\"kubio-color-5\";}i:21;a:3:{s:4:\"slug\";s:23:\"kubio-color-5-variant-2\";s:5:\"color\";a:3:{i:0;i:204;i:1;i:204;i:2;i:204;}s:6:\"parent\";s:13:\"kubio-color-5\";}i:22;a:3:{s:4:\"slug\";s:23:\"kubio-color-5-variant-3\";s:5:\"color\";a:3:{i:0;i:153;i:1;i:153;i:2;i:153;}s:6:\"parent\";s:13:\"kubio-color-5\";}i:23;a:3:{s:4:\"slug\";s:23:\"kubio-color-5-variant-4\";s:5:\"color\";a:3:{i:0;i:101;i:1;i:101;i:2;i:101;}s:6:\"parent\";s:13:\"kubio-color-5\";}i:24;a:3:{s:4:\"slug\";s:23:\"kubio-color-5-variant-5\";s:5:\"color\";a:3:{i:0;i:50;i:1;i:50;i:2;i:50;}s:6:\"parent\";s:13:\"kubio-color-5\";}i:25;a:3:{s:4:\"slug\";s:23:\"kubio-color-6-variant-1\";s:5:\"color\";a:3:{i:0;i:163;i:1;i:172;i:2;i:190;}s:6:\"parent\";s:13:\"kubio-color-6\";}i:26;a:3:{s:4:\"slug\";s:23:\"kubio-color-6-variant-2\";s:5:\"color\";a:3:{i:0;i:90;i:1;i:95;i:2;i:105;}s:6:\"parent\";s:13:\"kubio-color-6\";}i:27;a:3:{s:4:\"slug\";s:23:\"kubio-color-6-variant-3\";s:5:\"color\";a:3:{i:0;i:18;i:1;i:19;i:2;i:21;}s:6:\"parent\";s:13:\"kubio-color-6\";}i:28;a:3:{s:4:\"slug\";s:23:\"kubio-color-6-variant-4\";s:5:\"color\";a:3:{i:0;i:10;i:1;i:14;i:2;i:20;}s:6:\"parent\";s:13:\"kubio-color-6\";}i:29;a:3:{s:4:\"slug\";s:23:\"kubio-color-6-variant-5\";s:5:\"color\";a:3:{i:0;i:3;i:1;i:9;i:2;i:20;}s:6:\"parent\";s:13:\"kubio-color-6\";}}s:11:\"globalStyle\";a:5:{s:8:\"styleRef\";s:10:\"p97jxneH0J\";s:2:\"id\";s:9:\"IONWT30iJ\";s:5:\"style\";a:1:{s:11:\"descendants\";a:10:{s:4:\"body\";a:2:{s:10:\"typography\";a:1:{s:7:\"holders\";a:10:{s:1:\"a\";a:7:{s:6:\"family\";s:7:\"Poppins\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";i:1;}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.5;s:4:\"unit\";s:0:\"\";}s:6:\"weight\";s:3:\"400\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:10:\"decoration\";s:4:\"none\";s:6:\"states\";a:2:{s:5:\"hover\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:7:\"visited\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}}}s:2:\"h1\";a:6:{s:6:\"weight\";i:700;s:9:\"transform\";s:4:\"none\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";i:4;}s:6:\"family\";s:7:\"Poppins\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.26;s:4:\"unit\";s:0:\"\";}}s:2:\"h2\";a:6:{s:6:\"weight\";i:600;s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:6:\"family\";s:7:\"Poppins\";s:4:\"size\";a:2:{s:5:\"value\";i:3;s:4:\"unit\";s:2:\"em\";}s:9:\"transform\";s:4:\"none\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.143;s:4:\"unit\";s:0:\"\";}}s:2:\"h3\";a:6:{s:6:\"weight\";i:500;s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:4:\"size\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"em\";}s:9:\"transform\";s:4:\"none\";s:6:\"family\";s:7:\"Poppins\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.25;s:4:\"unit\";s:0:\"\";}}s:2:\"h4\";a:6:{s:6:\"weight\";i:600;s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:6:\"family\";s:7:\"Poppins\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";d:1.25;}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.6;s:4:\"unit\";s:0:\"\";}s:9:\"transform\";s:4:\"none\";}s:2:\"h5\";a:6:{s:6:\"weight\";i:600;s:5:\"color\";s:7:\"#000000\";s:4:\"size\";a:2:{s:5:\"value\";d:1.125;s:4:\"unit\";s:2:\"em\";}s:9:\"transform\";s:4:\"none\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.55;s:4:\"unit\";s:0:\"\";}s:6:\"family\";s:7:\"Poppins\";}s:2:\"h6\";a:7:{s:9:\"transform\";s:9:\"uppercase\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";d:0.8;}s:13:\"letterSpacing\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:1;}s:6:\"weight\";s:3:\"600\";s:6:\"family\";s:7:\"Poppins\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.6;s:4:\"unit\";s:0:\"\";}s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";}s:1:\"p\";a:7:{s:4:\"size\";a:2:{s:5:\"value\";i:18;s:4:\"unit\";s:2:\"px\";}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.6;s:4:\"unit\";s:0:\"\";}s:6:\"family\";s:6:\"Roboto\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-4),1)\";s:9:\"transform\";s:4:\"none\";s:6:\"weight\";i:300;s:6:\"margin\";a:1:{s:6:\"bottom\";a:2:{s:5:\"value\";i:16;s:4:\"unit\";s:2:\"px\";}}}s:4:\"lead\";a:7:{s:4:\"size\";a:2:{s:5:\"value\";d:1.25;s:4:\"unit\";s:2:\"em\";}s:6:\"family\";s:6:\"Roboto\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-4),1)\";s:9:\"transform\";s:4:\"none\";s:6:\"weight\";s:3:\"300\";s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.5;s:4:\"unit\";s:0:\"\";}s:6:\"margin\";a:1:{s:6:\"bottom\";a:2:{s:5:\"value\";i:16;s:4:\"unit\";s:2:\"px\";}}}s:5:\"input\";a:6:{s:5:\"color\";s:15:\"rgb(73, 80, 87)\";s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"states\";a:1:{s:5:\"focus\";a:3:{s:5:\"color\";s:15:\"rgb(73, 80, 87)\";s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:3:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:3:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:3:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:2:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";}}}}s:6:\"border\";a:4:{s:3:\"top\";a:3:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:2:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";}s:6:\"bottom\";a:3:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:2:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";}}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:12;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:12;s:4:\"unit\";s:2:\"px\";}}s:6:\"margin\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:0;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:0;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:0;s:4:\"unit\";s:2:\"px\";}}}}}s:5:\"media\";a:1:{s:6:\"mobile\";a:1:{s:10:\"typography\";a:1:{s:7:\"holders\";a:1:{s:2:\"h1\";a:1:{s:4:\"size\";a:2:{s:5:\"value\";i:3;s:4:\"unit\";s:2:\"em\";}}}}}}}s:14:\"sectionSpacing\";a:2:{s:7:\"padding\";a:2:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:90;}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:90;}}s:5:\"media\";a:2:{s:6:\"tablet\";a:1:{s:7:\"padding\";a:2:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:60;}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:60;}}}s:6:\"mobile\";a:1:{s:7:\"padding\";a:2:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:30;}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:30;}}}}}s:10:\"transition\";a:2:{s:10:\"transition\";a:1:{s:8:\"duration\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:1:\"s\";}}s:8:\"duration\";a:2:{s:5:\"value\";d:0.5;s:4:\"unit\";s:1:\"s\";}}s:11:\"form-fields\";a:6:{s:10:\"typography\";a:5:{s:4:\"size\";a:2:{s:5:\"value\";i:16;s:4:\"unit\";s:2:\"px\";}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.6;s:4:\"unit\";s:0:\"\";}s:6:\"family\";s:9:\"Open Sans\";s:9:\"transform\";s:4:\"none\";s:6:\"weight\";s:3:\"400\";}s:6:\"states\";a:2:{s:5:\"hover\";a:3:{s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-1),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-1),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-1),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-1),1)\";}}}s:5:\"focus\";a:3:{s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}}}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:1;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}}s:6:\"margin\";a:1:{s:6:\"bottom\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}}}s:18:\"form-submit-button\";a:5:{s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"states\";a:2:{s:5:\"hover\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}}s:8:\"disabled\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-3),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}}}}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:24;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:25;s:4:\"unit\";s:2:\"px\";}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}}s:11:\"form-button\";a:5:{s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:6:\"states\";a:2:{s:5:\"hover\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}}s:8:\"disabled\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-3),1)\";}}}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:24;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:25;s:4:\"unit\";s:2:\"px\";}}}s:17:\"form-reset-button\";a:5:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-1),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-2),1)\";}s:6:\"states\";a:2:{s:5:\"hover\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-2),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-6-variant-2),1)\";}}s:8:\"disabled\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-3),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}}}}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:24;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:8;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:25;s:4:\"unit\";s:2:\"px\";}}}s:9:\"wc-button\";a:4:{s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:10:\"typography\";a:6:{s:4:\"size\";a:2:{s:5:\"value\";i:14;s:4:\"unit\";s:2:\"px\";}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.2;s:4:\"unit\";s:0:\"\";}s:6:\"family\";s:9:\"Open Sans\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:9:\"transform\";s:4:\"none\";s:6:\"weight\";s:3:\"400\";}s:6:\"states\";a:2:{s:5:\"hover\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-2-variant-4),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-2-variant-4),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-2-variant-4),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-2-variant-4),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-2-variant-4),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}}s:8:\"disabled\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-4),1)\";}}}}s:13:\"wc-alt-button\";a:5:{s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:4;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:4:{s:5:\"width\";a:2:{s:5:\"value\";i:2;s:4:\"unit\";s:2:\"px\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}}s:10:\"typography\";a:6:{s:4:\"size\";a:2:{s:5:\"value\";i:14;s:4:\"unit\";s:2:\"px\";}s:10:\"lineHeight\";a:2:{s:5:\"value\";d:1.2;s:4:\"unit\";s:0:\"\";}s:6:\"family\";s:9:\"Open Sans\";s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:9:\"transform\";s:4:\"none\";s:6:\"weight\";s:3:\"400\";}s:6:\"states\";a:2:{s:5:\"hover\";a:2:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-1-variant-4),1)\";}}}s:8:\"disabled\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-2),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-5-variant-4),1)\";}}}s:9:\"boxShadow\";a:2:{s:7:\"enabled\";b:1;s:6:\"layers\";a:1:{i:0;a:4:{s:4:\"blur\";s:2:\"15\";s:6:\"spread\";s:3:\"-24\";s:1:\"x\";s:1:\"0\";s:1:\"y\";s:2:\"27\";}}}}s:10:\"wc-on-sale\";a:4:{s:10:\"background\";a:1:{s:5:\"color\";s:38:\"rgba(var(--kubio-color-3-variant-2),1)\";}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:5:\"value\";i:5;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:6:\"bottom\";a:2:{s:5:\"value\";i:5;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}}}s:5:\"right\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}s:6:\"bottom\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}}}s:4:\"left\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:1:{s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:1:{s:4:\"unit\";s:2:\"px\";}}}}}}}s:5:\"props\";a:2:{s:6:\"hSpace\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:20;}s:6:\"vSpace\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:20;}}s:4:\"hash\";s:9:\"kRvOc8KJm\";}s:14:\"additional_css\";s:0:\"\";s:10:\"migrations\";a:1:{s:36:\"1-kubio_themes_add_pls_prs_templates\";b:1;}}}","no");
INSERT INTO `wp_options` VALUES("224","site_logo","1226","yes");
INSERT INTO `wp_options` VALUES("225","_transient_timeout_tc_widget_placehold_footer","2337631674","no");
INSERT INTO `wp_options` VALUES("226","_transient_tc_widget_placehold_footer","disabled","no");
INSERT INTO `wp_options` VALUES("229","_transient_timeout_tc_thumbnail_help","2337631856","no");
INSERT INTO `wp_options` VALUES("230","_transient_tc_thumbnail_help","disabled","no");
INSERT INTO `wp_options` VALUES("234","nav_menu_options","a:1:{s:8:\"auto_add\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("242","_transient_timeout_tc_img_smartload_help","2337634359","no");
INSERT INTO `wp_options` VALUES("243","_transient_tc_img_smartload_help","disabled","no");
INSERT INTO `wp_options` VALUES("268","nimble_module_css_read_status","OK","yes");
INSERT INTO `wp_options` VALUES("290","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("338","wp_calendar_block_has_published_posts","1","yes");
INSERT INTO `wp_options` VALUES("423","_transient_health-check-site-status-result","{\"good\":\"39\",\"recommended\":\"4\",\"critical\":\"1\"}","yes");
INSERT INTO `wp_options` VALUES("500","auto_update_plugins","a:17:{i:0;s:19:\"akismet/akismet.php\";i:2;s:33:\"nimble-builder/nimble-builder.php\";i:5;s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:8;s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";i:9;s:31:\"jetpack-boost/jetpack-boost.php\";i:13;s:33:\"jetpack-social/jetpack-social.php\";i:15;s:35:\"jetpack-protect/jetpack-protect.php\";i:17;s:19:\"jetpack/jetpack.php\";i:18;s:41:\"wp-database-backup/wp-database-backup.php\";i:20;s:33:\"jetpack-search/jetpack-search.php\";i:21;s:41:\"last-login-display/last-login-display.php\";i:22;s:45:\"simple-local-avatars/simple-local-avatars.php\";i:23;s:53:\"smart-auto-upload-images/smart-auto-upload-images.php\";i:24;s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";i:25;s:36:\"indexnow/indexnow-url-submission.php\";i:26;s:27:\"redis-cache/redis-cache.php\";}","off");
INSERT INTO `wp_options` VALUES("501","jabrfc_text","a:4:{s:4:\"find\";a:1:{i:0;s:389:\"<span class=\"czr-wp-powered-text\">Powered by&nbsp;</span><a class=\"czr-wp-powered-link\" title=\"Powered by WordPress\" href=\"https://en-gb.wordpress.org/\" target=\"_blank\" rel=\"noopener noreferrer\">WP</a></span><span class=\"czr-designer-text\">&nbsp;–&nbsp;Designed with the <a class=\"czr-designer-link\" href=\"https://presscustomizr.com/customizr\" title=\"Customizr Theme\">Customizr Theme</a>\";}s:7:\"replace\";a:1:{i:0;s:0:\"\";}s:12:\"willLinkback\";s:2:\"no\";s:14:\"linkbackPostId\";s:3:\"241\";}","yes");
INSERT INTO `wp_options` VALUES("546","rsssl_show_onboarding","1","no");
INSERT INTO `wp_options` VALUES("551","rsssl_options","a:39:{s:12:\"site_has_ssl\";s:1:\"1\";s:8:\"redirect\";s:8:\"htaccess\";s:19:\"mixed_content_fixer\";i:1;s:11:\"ssl_enabled\";s:1:\"1\";s:29:\"enable_limited_login_attempts\";i:1;s:27:\"limit_login_attempts_amount\";s:1:\"5\";s:29:\"limit_login_attempts_duration\";s:2:\"15\";s:40:\"limit_login_attempts_locked_out_duration\";s:2:\"30\";s:16:\"x_xss_protection\";s:4:\"zero\";s:15:\"x_frame_options\";s:0:\"\";s:15:\"referrer_policy\";s:31:\"strict-origin-when-cross-origin\";s:12:\"hsts_max_age\";s:8:\"63072000\";s:26:\"cross_origin_opener_policy\";s:8:\"disabled\";s:28:\"cross_origin_resource_policy\";s:8:\"disabled\";s:28:\"cross_origin_embedder_policy\";s:8:\"disabled\";s:27:\"disable_anyone_can_register\";i:1;s:20:\"disable_file_editing\";i:1;s:28:\"block_code_execution_uploads\";i:1;s:22:\"hide_wordpress_version\";i:1;s:22:\"disable_login_feedback\";i:1;s:16:\"disable_indexing\";i:1;s:24:\"disable_user_enumeration\";i:1;s:14:\"two_fa_enabled\";i:1;s:19:\"csp_frame_ancestors\";s:8:\"disabled\";s:28:\"enable_vulnerability_scanner\";i:1;s:36:\"vulnerability_notification_dashboard\";s:1:\"l\";s:35:\"vulnerability_notification_sitewide\";s:1:\"h\";s:38:\"vulnerability_notification_email_admin\";s:1:\"*\";s:25:\"password_change_frequency\";s:2:\"12\";s:27:\"notifications_email_address\";s:18:\"stuart@m7spi.co.uk\";s:24:\"send_notifications_email\";i:0;s:17:\"rename_admin_user\";i:1;s:23:\"login_cookie_expiration\";s:2:\"48\";s:19:\"review_notice_shown\";s:1:\"1\";s:24:\"enabled_captcha_provider\";s:4:\"none\";s:22:\"404_blocking_threshold\";s:3:\"lax\";s:29:\"404_blocking_lockout_duration\";s:0:\"\";s:27:\"disable_x_powered_by_header\";i:1;s:19:\"two_fa_grace_period\";s:2:\"10\";}","yes");
INSERT INTO `wp_options` VALUES("556","rsssl_current_version","9.5.3","off");
INSERT INTO `wp_options` VALUES("568","rsssl_6_notice_dismissed","1","no");
INSERT INTO `wp_options` VALUES("570","rsssl_port_check_2082","success","no");
INSERT INTO `wp_options` VALUES("573","rsssl_last_tested_http_method","19","no");
INSERT INTO `wp_options` VALUES("574","rsssl_http_methods_allowed","a:2:{s:11:\"not-allowed\";a:0:{}s:7:\"allowed\";a:18:{i:0;s:3:\"GET\";i:1;s:4:\"POST\";i:2;s:3:\"PUT\";i:3;s:6:\"DELETE\";i:4;s:4:\"HEAD\";i:5;s:7:\"OPTIONS\";i:6;s:7:\"CONNECT\";i:7;s:5:\"TRACE\";i:8;s:5:\"TRACK\";i:9;s:5:\"PATCH\";i:10;s:4:\"COPY\";i:11;s:4:\"LINK\";i:12;s:6:\"UNLINK\";i:13;s:5:\"PURGE\";i:14;s:4:\"LOCK\";i:15;s:6:\"UNLOCK\";i:16;s:8:\"PROPFIND\";i:17;s:4:\"VIEW\";}}","no");
INSERT INTO `wp_options` VALUES("579","rsssl_activation_timestamp","1709750306","no");
INSERT INTO `wp_options` VALUES("584","rsssl_wp_version_token","8067010732","yes");
INSERT INTO `wp_options` VALUES("589","rsssl_wp_version_detected","not-found","no");
INSERT INTO `wp_options` VALUES("594","rsssl_email_verification_status","started","no");
INSERT INTO `wp_options` VALUES("602","rsssl_ssl_labs_data","a:14:{s:6:\"action\";s:14:\"store_ssl_labs\";s:7:\"_locale\";s:4:\"user\";s:4:\"host\";s:23:\"www.southlancsarc.co.uk\";s:4:\"port\";i:443;s:8:\"protocol\";s:4:\"http\";s:8:\"isPublic\";b:0;s:6:\"status\";s:5:\"READY\";s:9:\"startTime\";i:1757487087902;s:8:\"testTime\";i:1757487140779;s:13:\"engineVersion\";s:5:\"2.4.1\";s:15:\"criteriaVersion\";s:5:\"2009q\";s:9:\"endpoints\";a:1:{i:0;a:10:{s:9:\"ipAddress\";s:12:\"104.36.87.91\";s:10:\"serverName\";s:18:\"server.m7spi.co.uk\";s:13:\"statusMessage\";s:5:\"Ready\";s:5:\"grade\";s:2:\"A-\";s:17:\"gradeTrustIgnored\";s:2:\"A-\";s:11:\"hasWarnings\";b:1;s:13:\"isExceptional\";b:0;s:8:\"progress\";i:100;s:8:\"duration\";i:52521;s:10:\"delegation\";i:2;}}s:12:\"endpointData\";a:1:{i:0;a:11:{s:9:\"ipAddress\";s:12:\"104.36.87.91\";s:10:\"serverName\";s:18:\"server.m7spi.co.uk\";s:13:\"statusMessage\";s:5:\"Ready\";s:5:\"grade\";s:2:\"A-\";s:17:\"gradeTrustIgnored\";s:2:\"A-\";s:11:\"hasWarnings\";b:1;s:13:\"isExceptional\";b:0;s:8:\"progress\";i:100;s:8:\"duration\";i:52521;s:10:\"delegation\";i:2;s:7:\"details\";a:51:{s:13:\"hostStartTime\";i:1757487087902;s:10:\"certChains\";a:2:{i:0;a:5:{s:2:\"id\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:7:\"certIds\";a:2:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";}s:10:\"trustPaths\";a:5:{i:0;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:2:{s:9:\"rootStore\";s:7:\"Mozilla\";s:9:\"isTrusted\";b:1;}}}i:1;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:2:{s:9:\"rootStore\";s:5:\"Apple\";s:9:\"isTrusted\";b:1;}}}i:2;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:2:{s:9:\"rootStore\";s:7:\"Android\";s:9:\"isTrusted\";b:1;}}}i:3;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:2:{s:9:\"rootStore\";s:4:\"Java\";s:9:\"isTrusted\";b:1;}}}i:4;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"b1bcf55c68de3ee0efb50b24155a5bd0743bb38627dc1d056d0eb76dd3c00a0e\";i:1;s:64:\"aeb1fd7410e83bc96f5da3c6a7c2c1bb836d1fa5cb86e708515890e428a8770b\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:2:{s:9:\"rootStore\";s:7:\"Windows\";s:9:\"isTrusted\";b:1;}}}}s:6:\"issues\";i:0;s:5:\"noSni\";b:0;}i:1;a:5:{s:2:\"id\";s:64:\"3f4356f278c923c685cca3c5f3ab1d8c56ed58e9c2a36df937fb5bb468e05efc\";s:7:\"certIds\";a:2:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";}s:10:\"trustPaths\";a:5:{i:0;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:3:{s:9:\"rootStore\";s:7:\"Mozilla\";s:9:\"isTrusted\";b:0;s:17:\"trustErrorMessage\";s:106:\"invalid certificate [Fingerprint SHA256: ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591]\";}}}i:1;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:3:{s:9:\"rootStore\";s:5:\"Apple\";s:9:\"isTrusted\";b:0;s:17:\"trustErrorMessage\";s:106:\"invalid certificate [Fingerprint SHA256: ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591]\";}}}i:2;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:3:{s:9:\"rootStore\";s:7:\"Android\";s:9:\"isTrusted\";b:0;s:17:\"trustErrorMessage\";s:106:\"invalid certificate [Fingerprint SHA256: ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591]\";}}}i:3;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:3:{s:9:\"rootStore\";s:4:\"Java\";s:9:\"isTrusted\";b:0;s:17:\"trustErrorMessage\";s:106:\"invalid certificate [Fingerprint SHA256: ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591]\";}}}i:4;a:2:{s:7:\"certIds\";a:3:{i:0;s:64:\"ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591\";i:1;s:64:\"9d7c3f1aa6ad2b2ec0d5cf1e246f8d9ae6cbc9fd0755ad37bb974b1f2fb603f3\";i:2;s:64:\"96bcec06264976f37460779acf28c5a7cfe8a3c0aae11a8ffcee05c0bddf08c6\";}s:5:\"trust\";a:1:{i:0;a:3:{s:9:\"rootStore\";s:7:\"Windows\";s:9:\"isTrusted\";b:0;s:17:\"trustErrorMessage\";s:106:\"invalid certificate [Fingerprint SHA256: ce6059ec46823b2e91cd729c4c116b987bcd6e9cfb37ceec781bf250840ee591]\";}}}}s:6:\"issues\";i:0;s:5:\"noSni\";b:1;}}s:9:\"protocols\";a:1:{i:0;a:3:{s:2:\"id\";i:771;s:4:\"name\";s:3:\"TLS\";s:7:\"version\";s:3:\"1.2\";}}s:6:\"suites\";a:1:{i:0;a:3:{s:8:\"protocol\";i:771;s:4:\"list\";a:6:{i:0;a:8:{s:2:\"id\";i:49196;s:4:\"name\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:14:\"cipherStrength\";i:256;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";}i:1;a:8:{s:2:\"id\";i:49195;s:4:\"name\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\";s:14:\"cipherStrength\";i:128;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";}i:2;a:9:{s:2:\"id\";i:49188;s:4:\"name\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:14:\"cipherStrength\";i:256;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:1:\"q\";i:1;}i:3;a:9:{s:2:\"id\";i:49187;s:4:\"name\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256\";s:14:\"cipherStrength\";i:128;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:1:\"q\";i:1;}i:4;a:9:{s:2:\"id\";i:49162;s:4:\"name\";s:36:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA\";s:14:\"cipherStrength\";i:256;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:1:\"q\";i:1;}i:5;a:9:{s:2:\"id\";i:49161;s:4:\"name\";s:36:\"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA\";s:14:\"cipherStrength\";i:128;s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:1:\"q\";i:1;}}s:10:\"preference\";b:1;}}s:11:\"namedGroups\";a:1:{s:4:\"list\";a:1:{i:0;a:4:{s:2:\"id\";i:23;s:4:\"name\";s:9:\"secp256r1\";s:4:\"bits\";i:256;s:14:\"namedGroupType\";s:2:\"EC\";}}}s:15:\"serverSignature\";s:12:\"nginx/1.26.1\";s:16:\"prefixDelegation\";b:1;s:19:\"nonPrefixDelegation\";b:0;s:9:\"vulnBeast\";b:0;s:12:\"renegSupport\";i:2;s:17:\"sessionResumption\";i:2;s:18:\"compressionMethods\";i:0;s:11:\"supportsNpn\";b:0;s:12:\"supportsAlpn\";b:1;s:13:\"alpnProtocols\";s:8:\"http/1.1\";s:14:\"sessionTickets\";i:1;s:12:\"ocspStapling\";b:0;s:11:\"sniRequired\";b:1;s:14:\"httpStatusCode\";i:200;s:11:\"supportsRc4\";b:0;s:13:\"rc4WithModern\";b:0;s:7:\"rc4Only\";b:0;s:14:\"forwardSecrecy\";i:4;s:12:\"supportsAead\";b:1;s:19:\"protocolIntolerance\";i:0;s:15:\"miscIntolerance\";i:0;s:4:\"sims\";a:1:{s:7:\"results\";a:64:{i:0;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:56;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"2.3.7\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:1;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:58;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"4.0.4\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:2;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:59;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"4.1.1\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:3;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:60;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"4.2.2\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:4;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:61;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"4.3\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:5;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:62;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"4.4.2\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:6;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:88;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:5:\"5.0.0\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49195;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:7;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:129;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"6.0\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49195;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:8;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:167;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"7.0\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:9;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:168;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"8.0\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:10;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:157;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"8.1\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:11;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:158;s:4:\"name\";s:7:\"Android\";s:7:\"version\";s:3:\"9.0\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:12;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:94;s:4:\"name\";s:5:\"Baidu\";s:7:\"version\";s:8:\"Jan 2015\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:13;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:91;s:4:\"name\";s:11:\"BingPreview\";s:7:\"version\";s:8:\"Jan 2015\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:14;a:6:{s:6:\"client\";a:5:{s:2:\"id\";i:136;s:4:\"name\";s:6:\"Chrome\";s:8:\"platform\";s:6:\"XP SP3\";s:7:\"version\";s:2:\"49\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:42:\"Server sent fatal alert: handshake_failure\";s:8:\"attempts\";i:1;s:9:\"alertType\";i:2;s:9:\"alertCode\";i:40;}i:15;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:152;s:4:\"name\";s:6:\"Chrome\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:2:\"69\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:16;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:153;s:4:\"name\";s:6:\"Chrome\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"70\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:17;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:170;s:4:\"name\";s:6:\"Chrome\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"80\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:18;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:84;s:4:\"name\";s:7:\"Firefox\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:10:\"31.3.0 ESR\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49195;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:19;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:132;s:4:\"name\";s:7:\"Firefox\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:2:\"47\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49195;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:20;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:137;s:4:\"name\";s:7:\"Firefox\";s:8:\"platform\";s:6:\"XP SP3\";s:7:\"version\";s:2:\"49\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:21;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:151;s:4:\"name\";s:7:\"Firefox\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:2:\"62\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:22;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:171;s:4:\"name\";s:7:\"Firefox\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"73\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:23;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:145;s:4:\"name\";s:9:\"Googlebot\";s:7:\"version\";s:8:\"Feb 2018\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:24;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:100;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:2:\"XP\";s:7:\"version\";s:1:\"6\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:25;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:19;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:5:\"Vista\";s:7:\"version\";s:1:\"7\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:26;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:101;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:2:\"XP\";s:7:\"version\";s:1:\"8\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:27;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:113;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:4:\"8-10\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:28;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:143;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:5:\"Win 7\";s:7:\"version\";s:2:\"11\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:29;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:134;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:7:\"Win 8.1\";s:7:\"version\";s:2:\"11\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:30;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:64;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:13:\"Win Phone 8.0\";s:7:\"version\";s:2:\"10\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:31;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:65;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:13:\"Win Phone 8.1\";s:7:\"version\";s:2:\"11\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:32;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:106;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:20:\"Win Phone 8.1 Update\";s:7:\"version\";s:2:\"11\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:33;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:131;s:4:\"name\";s:2:\"IE\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"11\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:34;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:144;s:4:\"name\";s:4:\"Edge\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"15\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:35;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:159;s:4:\"name\";s:4:\"Edge\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"16\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:36;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:160;s:4:\"name\";s:4:\"Edge\";s:8:\"platform\";s:6:\"Win 10\";s:7:\"version\";s:2:\"18\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:37;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:120;s:4:\"name\";s:4:\"Edge\";s:8:\"platform\";s:12:\"Win Phone 10\";s:7:\"version\";s:2:\"13\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:38;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:25;s:4:\"name\";s:4:\"Java\";s:7:\"version\";s:4:\"6u45\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:39;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:26;s:4:\"name\";s:4:\"Java\";s:7:\"version\";s:4:\"7u25\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:40;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:147;s:4:\"name\";s:4:\"Java\";s:7:\"version\";s:5:\"8u161\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:41;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:162;s:4:\"name\";s:4:\"Java\";s:7:\"version\";s:6:\"11.0.3\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:42;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:163;s:4:\"name\";s:4:\"Java\";s:7:\"version\";s:6:\"12.0.1\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:43;a:4:{s:6:\"client\";a:4:{s:2:\"id\";i:27;s:4:\"name\";s:7:\"OpenSSL\";s:7:\"version\";s:6:\"0.9.8y\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:44;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:99;s:4:\"name\";s:7:\"OpenSSL\";s:7:\"version\";s:6:\"1.0.1l\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:45;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:164;s:4:\"name\";s:7:\"OpenSSL\";s:7:\"version\";s:6:\"1.0.2s\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:46;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:169;s:4:\"name\";s:7:\"OpenSSL\";s:7:\"version\";s:6:\"1.1.0k\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:47;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:165;s:4:\"name\";s:7:\"OpenSSL\";s:7:\"version\";s:6:\"1.1.1c\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:48;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:32;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:11:\"OS X 10.6.8\";s:7:\"version\";s:5:\"5.1.9\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:49;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:33;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:9:\"iOS 6.0.1\";s:7:\"version\";s:1:\"6\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49188;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:50;a:4:{s:6:\"client\";a:5:{s:2:\"id\";i:34;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:11:\"OS X 10.8.4\";s:7:\"version\";s:5:\"6.0.4\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:1;s:12:\"errorMessage\";s:33:\"Protocol mismatch (not simulated)\";s:8:\"attempts\";i:0;}i:51;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:63;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:7:\"iOS 7.1\";s:7:\"version\";s:1:\"7\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49188;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:52;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:35;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:9:\"OS X 10.9\";s:7:\"version\";s:1:\"7\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49188;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:53;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:85;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:7:\"iOS 8.4\";s:7:\"version\";s:1:\"8\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49188;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:54;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:87;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:10:\"OS X 10.10\";s:7:\"version\";s:1:\"8\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49188;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:55;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:114;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:5:\"iOS 9\";s:7:\"version\";s:1:\"9\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:56;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:111;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:10:\"OS X 10.11\";s:7:\"version\";s:1:\"9\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:57;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:140;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:6:\"iOS 10\";s:7:\"version\";s:2:\"10\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:58;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:138;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:10:\"OS X 10.12\";s:7:\"version\";s:2:\"10\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:59;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:161;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:18:\"MacOS 10.14.6 Beta\";s:7:\"version\";s:6:\"12.1.2\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:60;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:166;s:4:\"name\";s:6:\"Safari\";s:8:\"platform\";s:10:\"iOS 12.3.1\";s:7:\"version\";s:6:\"12.1.1\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:61;a:15:{s:6:\"client\";a:5:{s:2:\"id\";i:112;s:4:\"name\";s:9:\"Apple ATS\";s:8:\"platform\";s:5:\"iOS 9\";s:7:\"version\";s:1:\"9\";s:11:\"isReference\";b:1;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:62;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:92;s:4:\"name\";s:11:\"Yahoo Slurp\";s:7:\"version\";s:8:\"Jan 2015\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}i:63;a:15:{s:6:\"client\";a:4:{s:2:\"id\";i:93;s:4:\"name\";s:9:\"YandexBot\";s:7:\"version\";s:8:\"Jan 2015\";s:11:\"isReference\";b:0;}s:9:\"errorCode\";i:0;s:8:\"attempts\";i:1;s:11:\"certChainId\";s:64:\"880c24e6f457077ef9eeb4f09c31cdbed796c98cdd0c674c424328365fc3064b\";s:10:\"protocolId\";i:771;s:7:\"suiteId\";i:49196;s:9:\"suiteName\";s:39:\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\";s:6:\"kxType\";s:4:\"ECDH\";s:10:\"kxStrength\";i:3072;s:14:\"namedGroupBits\";i:256;s:12:\"namedGroupId\";i:23;s:14:\"namedGroupName\";s:9:\"secp256r1\";s:6:\"keyAlg\";s:2:\"EC\";s:7:\"keySize\";i:256;s:6:\"sigAlg\";s:15:\"SHA384withECDSA\";}}}s:10:\"heartbleed\";b:0;s:9:\"heartbeat\";b:1;s:10:\"openSslCcs\";i:1;s:19:\"openSSLLuckyMinus20\";i:1;s:11:\"ticketbleed\";i:1;s:14:\"bleichenbacher\";i:1;s:6:\"poodle\";b:0;s:9:\"poodleTls\";i:1;s:5:\"freak\";b:0;s:6:\"hasSct\";i:1;s:18:\"ecdhParameterReuse\";b:0;s:6:\"logjam\";b:0;s:10:\"hstsPolicy\";a:5:{s:12:\"LONG_MAX_AGE\";i:15552000;s:6:\"header\";s:16:\"max-age=31536000\";s:6:\"status\";s:7:\"present\";s:6:\"maxAge\";i:31536000;s:10:\"directives\";a:1:{s:7:\"max-age\";s:8:\"31536000\";}}s:12:\"hstsPreloads\";a:4:{i:0;a:4:{s:6:\"source\";s:6:\"Chrome\";s:8:\"hostname\";s:23:\"www.southlancsarc.co.uk\";s:6:\"status\";s:6:\"absent\";s:10:\"sourceTime\";i:1757485682457;}i:1;a:4:{s:6:\"source\";s:4:\"Edge\";s:8:\"hostname\";s:23:\"www.southlancsarc.co.uk\";s:6:\"status\";s:6:\"absent\";s:10:\"sourceTime\";i:1757486402190;}i:2;a:4:{s:6:\"source\";s:7:\"Firefox\";s:8:\"hostname\";s:23:\"www.southlancsarc.co.uk\";s:6:\"status\";s:6:\"absent\";s:10:\"sourceTime\";i:1757486402190;}i:3;a:4:{s:6:\"source\";s:2:\"IE\";s:8:\"hostname\";s:23:\"www.southlancsarc.co.uk\";s:6:\"status\";s:6:\"absent\";s:10:\"sourceTime\";i:1757486402190;}}s:10:\"hpkpPolicy\";a:4:{s:6:\"status\";s:6:\"absent\";s:4:\"pins\";a:0:{}s:11:\"matchedPins\";a:0:{}s:10:\"directives\";a:0:{}}s:12:\"hpkpRoPolicy\";a:4:{s:6:\"status\";s:6:\"absent\";s:4:\"pins\";a:0:{}s:11:\"matchedPins\";a:0:{}s:10:\"directives\";a:0:{}}s:15:\"staticPkpPolicy\";a:5:{s:6:\"status\";s:6:\"absent\";s:4:\"pins\";a:0:{}s:11:\"matchedPins\";a:0:{}s:13:\"forbiddenPins\";a:0:{}s:20:\"matchedForbiddenPins\";a:0:{}}s:16:\"httpTransactions\";a:1:{i:0;a:8:{s:10:\"requestUrl\";s:32:\"https://www.southlancsarc.co.uk/\";s:10:\"statusCode\";i:200;s:11:\"requestLine\";s:14:\"GET / HTTP/1.1\";s:14:\"requestHeaders\";a:4:{i:0;s:29:\"Host: www.southlancsarc.co.uk\";i:1;s:98:\"User-Agent: SSL Labs (https://www.ssllabs.com/about/assessment.html); on behalf of XXX.XXX.XXX.XXX\";i:2;s:11:\"Accept: */*\";i:3;s:17:\"Connection: Close\";}s:12:\"responseLine\";s:15:\"HTTP/1.1 200 OK\";s:18:\"responseHeadersRaw\";a:11:{i:0;s:20:\"Server: nginx/1.26.1\";i:1;s:35:\"Date: Wed, 10 Sep 2025 06:51:38 GMT\";i:2;s:38:\"Content-Type: text/html; charset=UTF-8\";i:3;s:26:\"Transfer-Encoding: chunked\";i:4;s:17:\"Connection: close\";i:5;s:21:\"Vary: Accept-Encoding\";i:6;s:26:\"X-Jetpack-Boost-Cache: hit\";i:7;s:25:\"X-Cache: HIT from Backend\";i:8;s:43:\"Strict-Transport-Security: max-age=31536000\";i:9;s:31:\"X-XSS-Protection: 1; mode=block\";i:10;s:31:\"X-Content-Type-Options: nosniff\";}s:15:\"responseHeaders\";a:11:{i:0;a:2:{s:4:\"name\";s:6:\"Server\";s:5:\"value\";s:12:\"nginx/1.26.1\";}i:1;a:2:{s:4:\"name\";s:4:\"Date\";s:5:\"value\";s:29:\"Wed, 10 Sep 2025 06:51:38 GMT\";}i:2;a:2:{s:4:\"name\";s:12:\"Content-Type\";s:5:\"value\";s:24:\"text/html; charset=UTF-8\";}i:3;a:2:{s:4:\"name\";s:17:\"Transfer-Encoding\";s:5:\"value\";s:7:\"chunked\";}i:4;a:2:{s:4:\"name\";s:10:\"Connection\";s:5:\"value\";s:5:\"close\";}i:5;a:2:{s:4:\"name\";s:4:\"Vary\";s:5:\"value\";s:15:\"Accept-Encoding\";}i:6;a:2:{s:4:\"name\";s:21:\"X-Jetpack-Boost-Cache\";s:5:\"value\";s:3:\"hit\";}i:7;a:2:{s:4:\"name\";s:7:\"X-Cache\";s:5:\"value\";s:16:\"HIT from Backend\";}i:8;a:2:{s:4:\"name\";s:25:\"Strict-Transport-Security\";s:5:\"value\";s:16:\"max-age=31536000\";}i:9;a:2:{s:4:\"name\";s:16:\"X-XSS-Protection\";s:5:\"value\";s:13:\"1; mode=block\";}i:10;a:2:{s:4:\"name\";s:22:\"X-Content-Type-Options\";s:5:\"value\";s:7:\"nosniff\";}}s:13:\"fragileServer\";b:0;}}s:14:\"zeroRTTEnabled\";i:-1;s:12:\"zombiePoodle\";i:1;s:12:\"goldenDoodle\";i:1;s:11:\"supportsCBC\";b:1;s:23:\"zeroLengthPaddingOracle\";i:1;s:14:\"sleepingPoodle\";i:1;}}}s:5:\"nonce\";s:10:\"5687ac0886\";}","off");
INSERT INTO `wp_options` VALUES("603","rsssl_l_notification_dismissed_for","a:0:{}","no");
INSERT INTO `wp_options` VALUES("604","rsssl_m_notification_dismissed_for","a:0:{}","off");
INSERT INTO `wp_options` VALUES("605","rsssl_h_notification_dismissed_for","a:0:{}","no");
INSERT INTO `wp_options` VALUES("606","rsssl_c_notification_dismissed_for","a:0:{}","off");
INSERT INTO `wp_options` VALUES("609","burst_rest_api_optimizer_not_writable","1","no");
INSERT INTO `wp_options` VALUES("623","rsssl_onboarding_dismissed","1","no");
INSERT INTO `wp_options` VALUES("628","cmplz_show_terms_conditions_notice","1707068220","yes");
INSERT INTO `wp_options` VALUES("629","cmplz_tour_started","","no");
INSERT INTO `wp_options` VALUES("630","cmplz_tour_shown_once","1","no");
INSERT INTO `wp_options` VALUES("633","_transient_cmplz_cookie_table_exists","1","yes");
INSERT INTO `wp_options` VALUES("634","cmplz_cookietable_version","7.0.5","yes");
INSERT INTO `wp_options` VALUES("635","cmplz_active_integrations","2","yes");
INSERT INTO `wp_options` VALUES("636","cmplz_integrations_changed","1","yes");
INSERT INTO `wp_options` VALUES("637","cmplz_cbdb_version","7.0.5","yes");
INSERT INTO `wp_options` VALUES("639","cmplz_first_version","6.5.6","no");
INSERT INTO `wp_options` VALUES("640","cmplz_generate_new_cookiepolicy_snapshot","","no");
INSERT INTO `wp_options` VALUES("641","cmplz-current-version","7.0.5","no");
INSERT INTO `wp_options` VALUES("649","cmplz_generate_pdf_languages","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("652","cmplz_tc_tour_shown_once","1","no");
INSERT INTO `wp_options` VALUES("653","rsssl_mixed_content_scan_dismissed","1","off");
INSERT INTO `wp_options` VALUES("654","cmplz_activation_time","1708523877","no");
INSERT INTO `wp_options` VALUES("655","cmplz_tc_activation_time","1707068245","yes");
INSERT INTO `wp_options` VALUES("661","cmplz-tc-current-version","1.2.8","yes");
INSERT INTO `wp_options` VALUES("677","cmplz_synced_cookiedatabase_once","1","yes");
INSERT INTO `wp_options` VALUES("678","cmplz_last_cookie_scan","1714996371","yes");
INSERT INTO `wp_options` VALUES("679","complianz_scan_token","1708610565","no");
INSERT INTO `wp_options` VALUES("682","cmplz_detected_social_media","a:2:{i:0;s:9:\"pinterest\";i:1;s:9:\"instagram\";}","yes");
INSERT INTO `wp_options` VALUES("683","cmplz_detected_thirdparty_services","a:1:{i:0;s:7:\"youtube\";}","yes");
INSERT INTO `wp_options` VALUES("684","cmplz_detected_stats","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("737","rsssl_application-passwords_dismissed","1","no");
INSERT INTO `wp_options` VALUES("738","rsssl_db-prefix-notice_dismissed","1","no");
INSERT INTO `wp_options` VALUES("754","secret_key","AsN7;Dyn]91D#sa>;*MOc{{j#GV+Wol1eiG4weGw?R,h7O*-zk:.m)t^F(7vmNeC","no");
INSERT INTO `wp_options` VALUES("758","burst_new_delete_old_data_dismissed","1","no");
INSERT INTO `wp_options` VALUES("773","test_vulnerability_tester","a9c340f76e0a9a82f53f51f64a4706ae","no");
INSERT INTO `wp_options` VALUES("777","rsssl_test_vulnerability_sitewide_a9c340f76e0a9a82f53f51f64a4706ae_dismissed","1","no");
INSERT INTO `wp_options` VALUES("779","rsssl_check_redirect_dismissed","1","no");
INSERT INTO `wp_options` VALUES("780","rsssl_email_verification_not_verified_dismissed","1","no");
INSERT INTO `wp_options` VALUES("781","rsssl_test_vulnerability_dashboard_a9c340f76e0a9a82f53f51f64a4706ae_dismissed","1","no");
INSERT INTO `wp_options` VALUES("876","rsssl_vulnerability_mail_sent_for","a:0:{}","off");
INSERT INTO `wp_options` VALUES("1154","dismissed_update_core","a:1:{s:11:\"6.4.3|en_GB\";b:1;}","no");
INSERT INTO `wp_options` VALUES("1284","_transient_timeout_dirsize_cache","2037455163","no");
INSERT INTO `wp_options` VALUES("1285","_transient_dirsize_cache","a:951:{s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/modern\";i:77989;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/ectoplasm\";i:77742;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/ocean\";i:75229;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/light\";i:78474;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/sunrise\";i:78407;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/midnight\";i:78486;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/coffee\";i:75892;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors/blue\";i:77778;s:63:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css/colors\";i:643556;s:56:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/css\";i:2517729;s:57:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/user\";i:3418;s:63:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/js/widgets\";i:139380;s:55:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/js\";i:1929744;s:60:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/network\";i:125258;s:58:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/maint\";i:7592;s:61:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/includes\";i:3033731;s:59:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin/images\";i:412436;s:52:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-admin\";i:8948239;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";i:503773;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/languages/themes\";i:383682;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/languages\";i:3607781;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/upgrade\";i:0;s:54:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content\";i:3607809;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/rest-api/search\";i:15908;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/rest-api/endpoints\";i:779742;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/rest-api/fields\";i:22340;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/rest-api\";i:906471;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/patterns\";i:5546;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/nux\";i:11478;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/reusable-blocks\";i:2076;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/block-library\";i:805004;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/components\";i:352551;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/format-library\";i:7080;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/customize-widgets\";i:27076;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/edit-post\";i:219684;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/editor\";i:74740;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/widgets\";i:23542;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/block-editor\";i:615433;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/list-reusable-blocks\";i:17714;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/commands\";i:12638;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/block-directory\";i:15034;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/edit-widgets\";i:117832;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist/edit-site\";i:404246;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css/dist\";i:2711674;s:59:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/css\";i:3357723;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/html-api\";i:154919;s:61:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/fonts\";i:305179;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/jcrop\";i:24976;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/swfupload\";i:8715;s:63:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/crop\";i:20004;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/mediaelement/renderers\";i:18880;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/mediaelement\";i:721307;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/codemirror\";i:1287141;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/dist/development\";i:174586;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/dist/vendor\";i:2976435;s:63:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/dist\";i:20609808;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/jquery/ui\";i:808535;s:65:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/jquery\";i:1326271;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/langs\";i:15529;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/media\";i:57914;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wplink\";i:26476;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wordpress\";i:50628;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpeditimage\";i:37711;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/lists\";i:97383;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/link\";i:32949;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/hr\";i:1347;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/paste\";i:113193;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins/image\";i:55874;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/plugins\";i:606961;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/utils\";i:18822;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/themes/modern\";i:446221;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/themes/inlite\";i:452642;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/themes\";i:898863;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins/wordpress/images\";i:14207;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins/wordpress\";i:22831;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce/skins\";i:233085;s:66:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/tinymce\";i:2853651;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/imgareaselect\";i:49553;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/plupload\";i:489844;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js/thickbox\";i:31233;s:58:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/js\";i:29839032;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/namespaced\";i:2698;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/lib\";i:87360;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core32\";i:437041;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/PHP52\";i:4116;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/Base64\";i:22135;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:7881;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/Curve25519\";i:121645;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src/Core\";i:452743;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat/src\";i:1207254;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sodium_compat\";i:1303525;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/HTTP\";i:11487;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Parse\";i:20551;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Net\";i:7493;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Content/Type\";i:8015;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Content\";i:8015;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/XML/Declaration\";i:7098;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/XML\";i:7098;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Decode/HTML\";i:17241;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Decode\";i:17241;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie/Cache\";i:39607;s:65:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/SimplePie\";i:458625;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Text/Diff/Renderer\";i:5528;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Text/Diff/Engine\";i:31802;s:65:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Text/Diff\";i:44136;s:60:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Text\";i:57048;s:60:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/pomo\";i:54208;s:66:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/php-compat\";i:1251;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/theme-compat\";i:15446;s:59:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/IXR\";i:33915;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/block-supports\";i:108965;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/certificates\";i:233231;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-title\";i:1824;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/paragraph\";i:6850;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-author-biography\";i:917;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-pagination\";i:9465;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/video\";i:11501;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-date\";i:1058;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/button\";i:25521;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-author-name\";i:1138;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/heading\";i:5721;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/embed\";i:11032;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/page-list\";i:7792;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/read-more\";i:2280;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-author-name\";i:1064;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-pagination-numbers\";i:1887;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments\";i:28882;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments-pagination-numbers\";i:1779;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/group\";i:13130;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/navigation\";i:133186;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/pattern\";i:336;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/social-links\";i:53196;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-edit-link\";i:1159;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/buttons\";i:11092;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/loginout\";i:828;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/term-description\";i:1697;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/footnotes\";i:2531;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/verse\";i:1844;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/social-link\";i:2290;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments-pagination-next\";i:957;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments-title\";i:1646;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/separator\";i:5308;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/table\";i:28464;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/site-logo\";i:16209;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/quote\";i:6270;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/column\";i:1525;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-author\";i:2841;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-comments-form\";i:9575;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/preformatted\";i:1652;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/archives\";i:1671;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/navigation-submenu\";i:5812;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/widget-group\";i:319;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/text-columns\";i:2980;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-pagination-previous\";i:997;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-reply-link\";i:1001;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-featured-image\";i:26362;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments-pagination-previous\";i:969;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/tag-cloud\";i:3446;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-template\";i:9000;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-title\";i:1393;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/nextpage\";i:2985;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-excerpt\";i:2871;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-no-results\";i:845;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/block\";i:5038;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/more\";i:3698;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/html\";i:3678;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/spacer\";i:4647;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/search\";i:17268;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/pullquote\";i:7773;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comments-pagination\";i:8439;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/home-link\";i:1076;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/cover\";i:85139;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-content\";i:1009;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/legacy-widget\";i:501;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/list\";i:2063;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/calendar\";i:3750;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/site-title\";i:2253;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/shortcode\";i:3216;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/latest-posts\";i:11200;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/missing\";i:564;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/navigation-link\";i:10951;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/media-text\";i:13734;s:66:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/rss\";i:5023;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-navigation-link\";i:3865;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/columns\";i:9084;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/details\";i:2005;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/freeform\";i:41936;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/page-list-item\";i:1055;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query-pagination-next\";i:985;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/file\";i:10458;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-content\";i:1369;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/avatar\";i:2156;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/categories\";i:2771;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/comment-template\";i:2856;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/latest-comments\";i:6603;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/code\";i:2576;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/gallery\";i:74915;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/template-part\";i:8427;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/site-tagline\";i:1516;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/image\";i:71443;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/audio\";i:3542;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-date\";i:1323;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/post-terms\";i:1661;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/list-item\";i:876;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks/query\";i:16382;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/blocks\";i:1463105;s:63:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/widgets\";i:158520;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/block-patterns\";i:8843;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/assets\";i:25344;s:65:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/customize\";i:175188;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/style-engine\";i:42972;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sitemaps/providers\";i:16754;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/sitemaps\";i:46652;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/images/media\";i:2419;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/images/smilies\";i:10082;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/images/crystal\";i:15541;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/images\";i:99334;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Exception/Transport\";i:1397;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Exception/Http\";i:16715;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Exception\";i:22464;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Transport\";i:35060;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Auth\";i:2541;s:74:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Proxy\";i:4217;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Cookie\";i:4363;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Utility\";i:7176;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src/Response\";i:3101;s:68:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/src\";i:214155;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests/library\";i:261;s:64:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/Requests\";i:214416;s:59:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/ID3\";i:1155209;s:65:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes/PHPMailer\";i:228579;s:55:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-includes\";i:47528059;s:43:\"/home/m7spi/public_html/southlancsarc.co.uk\";i:60269471;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/css\";i:7468;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/fonts/vendor\";i:84156;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/fonts\";i:84156;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/google-fonts\";i:918951;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/customizer\";i:3653288;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/admin\";i:10561;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/theme\";i:200261;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/videos\";i:506098;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/header-presets/previews\";i:110210;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/header-presets/images\";i:3058095;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/header-presets\";i:3168305;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/images/header-shapes\";i:1630832;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources/images\";i:4418282;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/resources\";i:12959902;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/inc\";i:294168;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/browser-detection\";i:86798;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components/InnerHeader\";i:2436;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components/Common\";i:38312;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components/FrontHeader\";i:14491;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components/MainContent\";i:2911;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components/Header\";i:3170;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src/Components\";i:69394;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase/src\";i:74753;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/kubio-themebase\";i:74753;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components/Footer\";i:2626;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components/InnerHeader\";i:2569;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components/FrontHeader\";i:37241;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components/MainContent\";i:2673;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components/Header\";i:62168;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Components\";i:139229;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Core\";i:21525;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Customizer/Sections\";i:2932;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Customizer/Panel\";i:1315;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Customizer/Controls\";i:30033;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src/Customizer\";i:47681;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp/src\";i:266037;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib/colibriwp\";i:266037;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/lib\";i:427588;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/admin\";i:2910;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/front-header/buttons\";i:1346;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/front-header/top-bar\";i:2528;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/front-header\";i:28225;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/content/index\";i:5193;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/content/search\";i:4318;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/content\";i:46219;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/404-header\";i:19089;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/footer\";i:1945;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/header/top-bar\";i:2474;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts/header\";i:23864;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/template-parts\";i:119342;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/vendor/composer\";i:49895;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice/vendor\";i:50073;s:69:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/vertice\";i:14521245;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/patterns\";i:155627;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/templates\";i:12593;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/css\";i:357;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/fonts/instrument-sans\";i:187522;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/fonts/jost\";i:116852;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/fonts/inter\";i:331004;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/fonts/cardo\";i:388180;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/fonts\";i:1023558;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets/images\";i:1152100;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/assets\";i:2176015;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/parts\";i:1322;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour/styles\";i:33892;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/twentytwentyfour\";i:3367970;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/lang\";i:3958448;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/rtl/fonts/fonts\";i:157736;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/rtl/fonts\";i:157736;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/rtl\";i:553300;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/fonts/fonts\";i:232484;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/fonts\";i:235537;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css/img\";i:21576;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/css\";i:1619197;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/js\";i:498512;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/less/bootstrap\";i:160832;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/less\";i:292286;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets/img\";i:28704;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/assets\";i:2438727;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/_dev/parts\";i:357471;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc/_dev\";i:578648;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/inc\";i:7568719;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/sidebars\";i:1690;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/singular/authors\";i:1802;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/singular/comments\";i:7069;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/singular/navigation\";i:3649;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/singular/headings\";i:9873;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/singular\";i:27909;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/item-parts/authors\";i:215;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/item-parts/contents\";i:683;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/item-parts/footers\";i:3505;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/item-parts/headings\";i:4230;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/item-parts\";i:8661;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/navigation\";i:2423;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists/headings\";i:4547;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/post-lists\";i:22260;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/common/media\";i:1650;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/common/text\";i:984;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/common\";i:3688;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content/no-results\";i:1351;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/content\";i:56926;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/featured-pages\";i:2583;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/grid\";i:4372;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/search\";i:1426;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/related-posts\";i:3177;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/common\";i:646;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules/slider\";i:3650;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/modules\";i:15882;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/footer\";i:4366;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/header/parts\";i:15566;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts/header\";i:19208;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates/parts\";i:101837;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/templates\";i:114286;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/template-tags\";i:9298;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/utils\";i:26427;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/controllers\";i:26834;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/sidebars\";i:1046;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-metas\";i:14240;s:114:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/singular/authors\";i:1009;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/singular/comments\";i:2965;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/singular\";i:10006;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-lists/item-parts/contents\";i:7414;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-lists/item-parts/headings\";i:1023;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-lists/item-parts\";i:8465;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-lists/headings\";i:4485;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/post-lists\";i:48602;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/common/media\";i:22694;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/common/text\";i:10261;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content/common\";i:47274;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/content\";i:121196;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules/featured-pages\";i:15188;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules/grid\";i:26776;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules/related-posts\";i:4614;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules/common\";i:44128;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules/slider\";i:50928;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/modules\";i:141662;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/footer\";i:1593;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/header/parts\";i:20840;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models/header\";i:22183;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front/models\";i:312438;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/front\";i:375025;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-modules/social-links/assets/js\";i:21033;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-modules/social-links/assets\";i:21033;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-modules/social-links\";i:38326;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-modules\";i:38326;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_framework\";i:58374;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_utils\";i:61318;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_czr/controls\";i:25327;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_czr/sections\";i:2528;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_czr/panels\";i:2269;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_czr\";i:64789;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev/_admin\";i:126520;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/_dev\";i:311001;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/css/lib\";i:34880;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/css/img\";i:15120;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/css\";i:172244;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/fonts/css\";i:142128;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/fonts/webfonts\";i:2955966;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/fonts\";i:3098094;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/js\";i:670416;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets/img\";i:1293;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk/assets\";i:3942047;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core/czr-base-fmk\";i:4049191;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/core\";i:5664772;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared/fonts/fa/css\";i:142128;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared/fonts/fa/webfonts\";i:2955966;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared/fonts/fa\";i:3098094;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared/fonts/customizr\";i:34203;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared/fonts\";i:3132297;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/shared\";i:3132297;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/czr/css/lib\";i:30;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/czr/css/img\";i:15150;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/czr/css\";i:20149;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/czr/js\";i:191162;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/czr\";i:211341;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/css/_dev/custom-bs\";i:91357;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/css/_dev\";i:839762;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/css\";i:1769123;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/libs/fancybox\";i:115926;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/libs/jquery-plugins\";i:48823;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/libs\";i:973842;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/_front_js_fmk\";i:43156;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/_parts/_parts_modern\";i:215694;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/_parts/_parts_classical\";i:110916;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js/_parts\";i:326610;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/js\";i:1921500;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_1_base\";i:39111;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_3_components\";i:52223;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_4_layout\";i:52547;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_2_header/skins\";i:5465;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_2_header\";i:37852;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_9_utils_calcs/modular-scale\";i:13572;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_9_utils_calcs\";i:14048;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_6_skin\";i:3388;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/1_0_ms_respond\";i:812;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss/0_5_footer\";i:5563;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/scss\";i:206511;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front/img\";i:487789;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/front\";i:4384951;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/back/css\";i:44913;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/back/js\";i:37457;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/back/img\";i:53134;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets/back\";i:135534;s:78:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr/assets\";i:7864151;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/customizr\";i:21622259;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/patterns\";i:91248;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/templates\";i:9774;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/assets/fonts\";i:39185;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/assets/images\";i:34716;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/assets\";i:73901;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode/parts\";i:170;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes/bright-mode\";i:290522;s:61:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/themes\";i:39802024;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/rest-api\";i:841;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/languages\";i:81614;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/templates/wizard\";i:5362;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/templates\";i:7988;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/gutenberg/src/utils\";i:416;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/gutenberg/src\";i:6982;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/gutenberg/build\";i:20919;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/gutenberg\";i:683085;s:114:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/css/admin/modules\";i:13692;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/css/admin\";i:22399;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/css\";i:282627;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/js\";i:20389;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/select2/css\";i:32707;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/select2/js/i18n\";i:50110;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/select2/js\";i:506702;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/select2\";i:539409;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/data/patterns\";i:487610;s:130:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/data/iccprofiles\";i:3052;s:123:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/data/font\";i:58910;s:129:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/data/collations\";i:210286;s:118:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/data\";i:2308101;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/ttfonts\";i:5942165;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Conversion\";i:7899;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Output\";i:148;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Gif\";i:14777;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Exception\";i:281;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Barcode\";i:65066;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Config\";i:34020;s:123:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Color\";i:23761;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Css\";i:4947;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Language\";i:18262;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Log\";i:298;s:123:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Image\";i:195993;s:132:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Pdf/Protection\";i:568;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Pdf\";i:7879;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/File\";i:1145;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Container\";i:757;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Shaper\";i:92702;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Writer\";i:101751;s:132:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Http/Exception\";i:388;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Http\";i:31643;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Tag\";i:270126;s:123:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Fonts\";i:5670;s:123:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src/Utils\";i:4651;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/src\";i:2867276;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf/tmp\";i:0;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/mpdf\";i:11186784;s:132:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/psr-log-aware-trait/src\";i:0;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf/psr-log-aware-trait\";i:0;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/mpdf\";i:11186784;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/log/Psr/Log/Test\";i:9427;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/log/Psr/Log\";i:20877;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/log/Psr\";i:20877;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/log\";i:23869;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/http-message/src\";i:46833;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/http-message/docs\";i:15040;s:120:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr/http-message\";i:64541;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/psr\";i:88410;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/bin\";i:0;s:150:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/TypeFilter/Date\";i:639;s:149:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/TypeFilter/Spl\";i:1936;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/TypeFilter\";i:3516;s:144:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Exception\";i:247;s:151:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Matcher/Doctrine\";i:367;s:142:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Matcher\";i:3091;s:150:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine\";i:1896;s:141:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Filter\";i:3901;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/Reflection\";i:2174;s:146:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy/TypeMatcher\";i:468;s:134:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src/DeepCopy\";i:21696;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy/src\";i:21696;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs/deep-copy\";i:33507;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/myclabs\";i:33507;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/composer\";i:59001;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/Tfpdf\";i:5304;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfParser/Filter\";i:13269;s:136:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfParser/Type\";i:34421;s:146:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfParser/CrossReference\";i:25159;s:131:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfParser\";i:100958;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/Tcpdf\";i:8708;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfReader/DataStructure\";i:3713;s:131:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src/PdfReader\";i:21172;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi/src\";i:176087;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign/fpdi\";i:183686;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/setasign\";i:183686;s:132:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/php-http/message-factory/src\";i:3469;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/php-http/message-factory\";i:8572;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/php-http\";i:8572;s:132:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/paragonie/random_compat/dist\";i:703;s:131:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/paragonie/random_compat/lib\";i:1327;s:133:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/paragonie/random_compat/other\";i:1633;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/paragonie/random_compat\";i:6592;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor/paragonie\";i:6592;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/vendor\";i:11567323;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets/images\";i:44303;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/assets\";i:12470524;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/config/documents\";i:41297;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions/config\";i:99844;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/complianz-terms-conditions\";i:13741665;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/security/server\";i:586;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/security/wordpress/vulnerabilities\";i:3012;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/security/wordpress\";i:85418;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/security/tests\";i:185;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/security\";i:149788;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/progress\";i:4487;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/languages\";i:139984;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/upgrade/img\";i:22085;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/upgrade\";i:75893;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/placeholders\";i:17765;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal/src/components/Modal\";i:6581;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal/src/components/DeactivationModal\";i:4866;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal/src/components\";i:11447;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal/src\";i:11924;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal/build\";i:81176;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/modal\";i:95111;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/onboarding\";i:16716;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/mailer/templates\";i:29516;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/mailer\";i:41344;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/rtl\";i:100688;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/admin/modules/wizard\";i:14979;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/admin/modules/toast/animations\";i:6835;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/admin/modules/toast\";i:14325;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/admin/modules\";i:72335;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css/admin\";i:84818;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/css\";i:418107;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/js\";i:0;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets/img\";i:55299;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/assets\";i:473441;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverhttpxproto\";i:303;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/envhttps\";i:299;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/cloudflare\";i:319;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverport443\";i:302;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverhttpxforwardedssl1\";i:310;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/cloudfront\";i:324;s:114:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverhttpxforwardedsslon\";i:310;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverhttpson\";i:301;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/loadbalancer\";i:315;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl/serverhttps1\";i:295;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/testssl\";i:3078;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations/cloudways\";i:10253;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations/plesk\";i:4333;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations/cpanel\";i:15320;s:118:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations/directadmin\";i:15488;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations/hostgator\";i:168;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/integrations\";i:46299;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/composer\";i:30253;s:144:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Request/Account\";i:8980;s:150:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Request/Authorization\";i:3030;s:142:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Request/Order\";i:8219;s:136:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Request\";i:22097;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Exception\";i:2915;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Connector\";i:4817;s:134:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Cache\";i:9465;s:139:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Authorizer\";i:12122;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Utilities\";i:11546;s:135:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Struct\";i:1620;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Response/Account\";i:1862;s:158:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Response/Authorization/Struct\";i:833;s:151:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Response/Authorization\";i:2917;s:143:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Response/Order\";i:4229;s:137:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2/Response\";i:12315;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2\";i:98556;s:144:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2Tests/Authorizer\";i:1076;s:133:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src/LE_ACME2Tests\";i:8104;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2/src\";i:106660;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett/le_acme2\";i:113409;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/fbett\";i:113444;s:135:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Operator\";i:20721;s:133:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Client\";i:193;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/Site\";i:1619;s:140:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/Locale\";i:495;s:143:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/SiteAlias\";i:909;s:142:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/EventLog\";i:1279;s:137:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/Dns\";i:726;s:144:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/PhpHandler\";i:988;s:141:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/Session\";i:680;s:143:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/SecretKey\";i:535;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct/Certificate\";i:456;s:133:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api/Struct\";i:7687;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src/Api\";i:48026;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib/src\";i:48026;s:118:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk/api-php-lib\";i:53731;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor/plesk\";i:53766;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/vendor\";i:197676;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt/config\";i:52636;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/lets-encrypt\";i:386493;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Placeholder\";i:3150;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Onboarding/Items\";i:3080;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Onboarding\";i:33129;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Modal\";i:4586;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard/OtherPlugins\";i:5276;s:114:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard/TipsTricks\";i:2551;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard/Vulnerabilities\";i:14498;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard/SslLabs\";i:20337;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard/Progress\";i:9875;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Dashboard\";i:59496;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/utils/Flag/Flags\";i:762097;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/utils/Flag\";i:762391;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/utils\";i:814925;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/LetsEncrypt\";i:33007;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Menu\";i:14727;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/TwoFA\";i:20168;s:120:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/RiskConfiguration\";i:31479;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/Host\";i:2649;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/LimitLoginAttempts\";i:84357;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/AutoComplete\";i:2767;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/LearningMode\";i:21107;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/EventLog\";i:11357;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/MixedContentScan\";i:13480;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/DynamicDataTable\";i:8849;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings/License\";i:3456;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src/Settings\";i:279470;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/src\";i:1251612;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/build\";i:1357906;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings/config\";i:97944;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl/settings\";i:4102104;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/really-simple-ssl\";i:5774095;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet/views\";i:40028;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet/_inc/rtl\";i:20221;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet/_inc/fonts\";i:2193;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet/_inc/img\";i:17892;s:75:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet/_inc\";i:85324;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/akismet\";i:326611;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/libs\";i:40295;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope/assets/czr/js/_dev\";i:25724;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope/assets/czr/js\";i:56917;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope/assets/czr\";i:56917;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope/assets\";i:56917;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope/_dev\";i:40519;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-skope\";i:137955;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/admin\";i:90511;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_customizer_dev_php\";i:251400;s:137:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/_constants_and_helper_functions\";i:275649;s:146:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/dyn_css_builder_and_google_fonts_printer\";i:127556;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/_simple_form_classes\";i:52049;s:131:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration/front\";i:381398;s:137:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration/ui/_1_level\";i:99072;s:137:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration/ui/_2_local\";i:27027;s:138:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration/ui/_3_global\";i:54192;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration/ui\";i:184768;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php/module_registration\";i:582569;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions/_front_dev_php\";i:1224487;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/sektions\";i:2961145;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/_dev_php\";i:107686;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/css/lib\";i:34880;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/css/img\";i:15120;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/css\";i:172244;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/fonts/css\";i:250487;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/fonts/webfonts\";i:3355314;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/fonts\";i:3605801;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/js\";i:670416;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets/img\";i:1293;s:101:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk/assets\";i:4449754;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc/czr-base-fmk\";i:4665126;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/inc\";i:7896304;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/admin/css\";i:14546;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/admin/js\";i:5968;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/admin/img\";i:22808;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/admin\";i:43322;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/css/lib\";i:34880;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/css/parts\";i:87859;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/css/img\";i:15120;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/css\";i:137889;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/____modules/pro\";i:13838;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/____modules/free\";i:51067;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/____modules\";i:68269;s:126:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/0_4_preview_listeners\";i:2423;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/lib\";i:266876;s:145:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_3_module\";i:85748;s:144:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_0_input\";i:43464;s:175:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_1_item_and_modopt/1_1_1_module_options\";i:13147;s:165:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_1_item_and_modopt/1_1_0_item\";i:43868;s:154:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_1_item_and_modopt\";i:57015;s:166:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_4_control/base_module_control\";i:38576;s:146:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control/1_4_control\";i:40163;s:134:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/1_0_input_item_module_control\";i:226390;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/0_2_api_override\";i:13091;s:120:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk/0_3_api_helpers\";i:48884;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/base-fmk\";i:582818;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js/themes\";i:50352;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk/js\";i:701439;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/fmk\";i:839328;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/css/_dev_control\";i:66895;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/css\";i:242684;s:113:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/fonts/material-icons\";i:373358;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/fonts\";i:373358;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_preview\";i:187495;s:134:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/front/simple_form\";i:21515;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/front\";i:227941;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/ui/_1_level\";i:62440;s:128:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/ui/_2_local\";i:14279;s:129:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/ui/_3_global\";i:27470;s:119:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules/ui\";i:124656;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/modules\";i:352597;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control/inputs\";i:208988;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js/_dev_control\";i:1398785;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/js\";i:3544542;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/icons/modules\";i:42696;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/icons\";i:42696;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek/img\";i:3384;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr/sek\";i:4206664;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/czr\";i:5045992;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/css/libs/swipebox-img\";i:4768;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/css/libs\";i:54105;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/css/modules\";i:145962;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/css\";i:888775;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/fonts/css\";i:250487;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/fonts/webfonts\";i:3355314;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/fonts/material-icons\";i:373358;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/fonts\";i:3979159;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/libs\";i:544488;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/__FRONT_JS_FMK_TO_BE_UPDATED/libs\";i:745941;s:129:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/__FRONT_JS_FMK_TO_BE_UPDATED/_parts\";i:15895;s:122:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/__FRONT_JS_FMK_TO_BE_UPDATED\";i:879306;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/partials\";i:108092;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/_dev_front_concat\";i:61587;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js/_dev_to_uglify_manually\";i:791;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/js\";i:1696297;s:105:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/scss/utilities\";i:5344;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/scss/modules\";i:87463;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/scss/mixins\";i:10327;s:125:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/scss/stand-alone-module-generators\";i:1837;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front/scss\";i:151484;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/front\";i:6715715;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/img/nimble\";i:42606;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/img/section_assets/thumbs\";i:303062;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/img/section_assets\";i:303062;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets/img\";i:354756;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/assets\";i:12825984;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/wp\";i:1172;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/modules\";i:111314;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/footer\";i:680;s:97:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/page-templates\";i:2380;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/header\";i:1961;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl/base-tmpl\";i:22186;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder/tmpl\";i:139693;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/nimble-builder\";i:20917131;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/remove-powered-by-wp/includes\";i:23633;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/remove-powered-by-wp\";i:54568;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/languages\";i:122;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/admin/css\";i:1310;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/admin/js\";i:205;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/admin/includes\";i:31537;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/admin\";i:55430;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo/includes\";i:29176;s:71:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/flamingo\";i:108256;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/languages\";i:128;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/admin/css\";i:9805;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/admin/js\";i:14466;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/admin/includes\";i:36929;s:83:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/admin\";i:88636;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules/stripe\";i:20566;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules/akismet\";i:8085;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules/recaptcha\";i:14799;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules/constant-contact\";i:31127;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules/sendinblue\";i:24243;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/modules\";i:209129;s:84:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/assets\";i:31340;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/css\";i:3046;s:124:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/images\";i:32598;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness\";i:118302;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes\";i:118302;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/js/jquery-ui\";i:118302;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/js\";i:132208;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/swv/js\";i:11198;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/swv/rules\";i:17237;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/swv\";i:36323;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/config-validator\";i:33424;s:99:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes/block-editor\";i:7909;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7/includes\";i:435046;s:77:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/contact-form-7\";i:797111;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/languages\";i:69262;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/upgrade/img\";i:22085;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/upgrade\";i:75426;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/integrations/plugins\";i:2794;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/integrations\";i:5679;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/automation\";i:8688;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/tracking\";i:25681;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/sessions\";i:1094;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/statistics\";i:64497;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/goals\";i:12116;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/rtl\";i:93004;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/wizard\";i:15179;s:121:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/toast/animations\";i:6835;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/toast\";i:14353;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/statistics\";i:12710;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/inputs\";i:5161;s:114:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules/dashboard\";i:176;s:104:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin/modules\";i:87972;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css/admin\";i:98349;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/css\";i:412451;s:108:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js/src/imprintjs/dist\";i:83951;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js/src/imprintjs/src\";i:51055;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js/src/imprintjs\";i:135006;s:93:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js/src\";i:151467;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js/build\";i:127991;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/js\";i:279486;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets/img\";i:27125;s:86:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/assets\";i:719090;s:127:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/dashboard-widget/src/components/DashboardWidget\";i:9271;s:111:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/dashboard-widget/src/components\";i:9271;s:100:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/dashboard-widget/src\";i:10323;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/dashboard-widget/build\";i:184739;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/dashboard-widget\";i:197688;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/helpers/timeme\";i:24919;s:106:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/helpers/referrer-spam-list\";i:36411;s:112:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/helpers/php-user-agent/UserAgent\";i:6125;s:102:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/helpers/php-user-agent\";i:13207;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/helpers\";i:76498;s:107:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/rest-api-optimizer\";i:1821;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/store\";i:35766;s:96:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/api\";i:14339;s:109:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/pages\";i:2822;s:116:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/blocks/Goals\";i:11284;s:115:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/blocks/Menu\";i:3990;s:117:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/blocks/Fields\";i:41266;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/blocks\";i:154317;s:110:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components/common\";i:12489;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/components\";i:178514;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/utils\";i:69606;s:98:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src/hooks\";i:339;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/src\";i:300122;s:94:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/build\";i:1019645;s:95:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings/config\";i:18270;s:88:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics/settings\";i:1378084;s:79:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/burst-statistics\";i:2788186;s:90:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/auto-upload-images/src/lang\";i:77299;s:85:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/auto-upload-images/src\";i:110522;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins/auto-upload-images\";i:420515;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/plugins\";i:44928166;s:70:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/2024/02\";i:104300592;s:67:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/2024\";i:104300592;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/wpcf7_uploads\";i:152;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-google-fonts-cache\";i:0;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/css\";i:0;s:82:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/snapshots\";i:0;s:89:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/withdrawal-forms\";i:43260;s:103:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245/mpdf/ttfontdata\";i:436885;s:92:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245/mpdf\";i:436885;s:87:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245\";i:436885;s:76:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp\";i:436885;s:72:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/complianz\";i:480145;s:80:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/really-simple-ssl\";i:308324;s:73:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/nimble_css\";i:28;s:91:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-site-backups/customizr\";i:80879;s:81:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-site-backups\";i:80893;s:62:\"/home/m7spi/public_html/southlancsarc.co.uk/wp-content/uploads\";i:105170236;s:75:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/db-backup/log\";i:384;s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/db-backup\";i:665;s:69:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/2024/07\";i:1131556;s:69:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/2024/02\";i:109733932;s:69:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/2024/05\";i:815033;s:69:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/2024/06\";i:0;s:66:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/2024\";i:111680521;s:70:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/burst/js\";i:7492;s:67:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/burst\";i:7492;s:75:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/wpcf7_uploads\";i:152;s:86:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-google-fonts-cache\";i:0;s:75:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/css\";i:0;s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/snapshots\";i:0;s:88:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/withdrawal-forms\";i:43260;s:102:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1714879293/mpdf/ttfontdata\";i:580918;s:91:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1714879293/mpdf\";i:580918;s:86:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1714879293\";i:580918;s:102:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245/mpdf/ttfontdata\";i:436885;s:91:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245/mpdf\";i:436885;s:86:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp/1707068245\";i:436885;s:75:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz/tmp\";i:1017803;s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/complianz\";i:1061063;s:112:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/really-simple-ssl/99c9733837e744414d29572b1f254cdc\";i:350576;s:79:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/really-simple-ssl\";i:350576;s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/nimble_css\";i:28;s:90:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-site-backups/customizr\";i:80879;s:80:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/kubio-site-backups\";i:80893;s:61:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads\";i:113181492;}","no");
INSERT INTO `wp_options` VALUES("1514","pagelayer_version","1.8.2","yes");
INSERT INTO `wp_options` VALUES("1515","pagelayer_options","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("1516","pagelayer_promo_time","1710051365","yes");
INSERT INTO `wp_options` VALUES("1517","pagelayer_icons_set","a:1:{i:0;s:13:\"font-awesome5\";}","yes");
INSERT INTO `wp_options` VALUES("1518","pagelayer_enable_giver","1","yes");
INSERT INTO `wp_options` VALUES("2011","rsssl_display_name_is_login_exists_dismissed","1","no");
INSERT INTO `wp_options` VALUES("2012","rsssl_block_display_is_login_enabled_dismissed","1","no");
INSERT INTO `wp_options` VALUES("2782","rsssl_previous_version","9.5.2.3","off");
INSERT INTO `wp_options` VALUES("4648","burst_goals_information_shown","1","yes");
INSERT INTO `wp_options` VALUES("4783","new_admin_email","cwoodalluk@yahoo.co.uk","yes");
INSERT INTO `wp_options` VALUES("4832","recovery_mode_email_last_sent","1708601856","yes");
INSERT INTO `wp_options` VALUES("4872","cmplz_tc_documents_update_date","1746120951","yes");
INSERT INTO `wp_options` VALUES("4873","complianz_tc_options_terms-conditions","a:32:{s:17:\"organisation_name\";s:30:\"South Lancs Amateur Radio Club\";s:15:\"address_company\";s:50:\"Vicarage Rd, Abram, Wigan, United Kingdom, WN2 5QX\";s:15:\"country_company\";s:2:\"GB\";s:15:\"contact_company\";s:7:\"webpage\";s:13:\"email_company\";s:0:\"\";s:12:\"page_company\";s:35:\"https://www.slarc.co.uk/contact-us/\";s:13:\"legal_mention\";s:3:\"yes\";s:13:\"cookie_policy\";s:0:\"\";s:14:\"privacy_policy\";s:0:\"\";s:18:\"disclosure_company\";s:0:\"\";s:15:\"webshop_content\";s:2:\"no\";s:15:\"account_content\";s:2:\"no\";s:17:\"affiliate_content\";s:2:\"no\";s:13:\"forum_content\";s:2:\"no\";s:21:\"accessibility_content\";s:2:\"no\";s:11:\"age_content\";s:2:\"no\";s:11:\"minimum_age\";i:12;s:24:\"electronic_communication\";s:3:\"yes\";s:24:\"newsletter_communication\";s:2:\"no\";s:21:\"majeure_communication\";s:2:\"no\";s:20:\"notice_communication\";s:2:\"no\";s:22:\"language_communication\";s:3:\"yes\";s:27:\"multilanguage_communication\";a:1:{s:2:\"en\";s:1:\"0\";}s:19:\"sensitive_liability\";s:2:\"no\";s:13:\"max_liability\";s:2:\"no\";s:15:\"about_liability\";s:0:\"\";s:15:\"about_copyright\";s:9:\"allrights\";s:10:\"if_returns\";s:2:\"no\";s:17:\"if_returns_custom\";s:2:\"no\";s:22:\"if_returns_custom_link\";s:69:\"https://www.slarc.co.uk/wp-content/uploads/custom-withdrawal-form.pdf\";s:13:\"refund_period\";i:14;s:19:\"max_amount_returned\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("4932","cmplz_documents_update_date","1708611302","no");
INSERT INTO `wp_options` VALUES("4935","cmplz_cookie_data_verified_date","1709128685","yes");
INSERT INTO `wp_options` VALUES("4936","cmplz_publish_date","1708611302","yes");
INSERT INTO `wp_options` VALUES("4937","complianz_active_policy_id","16","no");
INSERT INTO `wp_options` VALUES("4938","complianz_options_wizard","a:36:{s:7:\"regions\";s:2:\"uk\";s:18:\"eu_consent_regions\";s:2:\"no\";s:18:\"uk_consent_regions\";s:2:\"no\";s:9:\"us_states\";a:6:{s:3:\"cal\";s:1:\"0\";s:3:\"col\";s:1:\"0\";s:3:\"con\";s:1:\"0\";s:3:\"nev\";s:1:\"0\";s:3:\"uta\";s:1:\"0\";s:3:\"vir\";s:1:\"0\";}s:21:\"wp_admin_access_users\";s:2:\"no\";s:16:\"cookie-statement\";s:9:\"generated\";s:17:\"privacy-statement\";s:6:\"custom\";s:9:\"impressum\";s:4:\"none\";s:10:\"disclaimer\";s:4:\"none\";s:17:\"organisation_name\";s:30:\"South Lancs Amateur Radio Club\";s:15:\"address_company\";s:33:\"Vicarage Rd, Abram, Wigan WN2 5QX\";s:15:\"country_company\";s:2:\"GB\";s:13:\"email_company\";s:21:\"webmaster@slarc.co.uk\";s:17:\"telephone_company\";s:0:\"\";s:18:\"records_of_consent\";s:2:\"no\";s:11:\"datarequest\";s:2:\"no\";s:11:\"respect_dnt\";s:3:\"yes\";s:18:\"compile_statistics\";s:2:\"no\";s:28:\"compile_statistics_more_info\";a:3:{s:8:\"accepted\";s:1:\"0\";s:10:\"no-sharing\";s:1:\"0\";s:20:\"ip-addresses-blocked\";s:1:\"0\";}s:40:\"compile_statistics_more_info_tag_manager\";a:3:{s:8:\"accepted\";s:1:\"0\";s:10:\"no-sharing\";s:1:\"0\";s:20:\"ip-addresses-blocked\";s:1:\"0\";}s:17:\"matomo_anonymized\";s:0:\"\";s:15:\"region_redirect\";s:2:\"no\";s:24:\"uses_thirdparty_services\";s:3:\"yes\";s:27:\"thirdparty_services_on_site\";a:22:{s:14:\"activecampaign\";s:1:\"0\";s:11:\"adobe-fonts\";s:1:\"0\";s:12:\"google-fonts\";s:1:\"1\";s:16:\"google-recaptcha\";s:1:\"1\";s:11:\"google-maps\";s:1:\"1\";s:14:\"openstreetmaps\";s:1:\"0\";s:5:\"vimeo\";s:1:\"0\";s:7:\"youtube\";s:1:\"1\";s:10:\"videopress\";s:1:\"0\";s:11:\"dailymotion\";s:1:\"0\";s:10:\"soundcloud\";s:1:\"0\";s:6:\"twitch\";s:1:\"0\";s:6:\"paypal\";s:1:\"0\";s:7:\"spotify\";s:1:\"0\";s:6:\"hotjar\";s:1:\"0\";s:7:\"addthis\";s:1:\"0\";s:8:\"addtoany\";s:1:\"0\";s:9:\"sharethis\";s:1:\"1\";s:8:\"livechat\";s:1:\"0\";s:7:\"hubspot\";s:1:\"0\";s:8:\"calendly\";s:1:\"0\";s:12:\"microsoftads\";s:1:\"0\";}s:23:\"block_recaptcha_service\";s:2:\"no\";s:22:\"self_host_google_fonts\";s:9:\"self-host\";s:21:\"block_hubspot_service\";s:2:\"no\";s:17:\"uses_social_media\";s:3:\"yes\";s:19:\"socialmedia_on_site\";a:8:{s:8:\"facebook\";s:1:\"1\";s:7:\"twitter\";s:1:\"1\";s:8:\"linkedin\";s:1:\"0\";s:8:\"whatsapp\";s:1:\"0\";s:9:\"instagram\";s:1:\"0\";s:6:\"tiktok\";s:1:\"0\";s:6:\"disqus\";s:1:\"0\";s:9:\"pinterest\";s:1:\"0\";}s:33:\"uses_firstparty_marketing_cookies\";s:2:\"no\";s:15:\"uses_ad_cookies\";s:2:\"no\";s:28:\"uses_ad_cookies_personalized\";s:2:\"no\";s:23:\"uses_wordpress_comments\";s:3:\"yes\";s:31:\"block_wordpress_comment_cookies\";s:3:\"yes\";s:20:\"enable_cookie_banner\";s:3:\"yes\";s:21:\"enable_cookie_blocker\";s:2:\"no\";}","yes");
INSERT INTO `wp_options` VALUES("4949","cmplz_detected_forms","a:0:{}","no");
INSERT INTO `wp_options` VALUES("4950","cmplz_plugins_changed","-1","yes");
INSERT INTO `wp_options` VALUES("4951","cmplz_plugins_updated","-1","yes");
INSERT INTO `wp_options` VALUES("4954","cmplz_cookie-statement_custom_page","365","yes");
INSERT INTO `wp_options` VALUES("4955","cmplz_cookie-statement_custom_page_url","","yes");
INSERT INTO `wp_options` VALUES("4956","cmplz_privacy-statement_custom_page","365","yes");
INSERT INTO `wp_options` VALUES("4957","cmplz_privacy-statement_custom_page_url","","yes");
INSERT INTO `wp_options` VALUES("4958","cmplz_impressum_custom_page","0","yes");
INSERT INTO `wp_options` VALUES("4959","cmplz_impressum_custom_page_url","","yes");
INSERT INTO `wp_options` VALUES("4960","cmplz_disclaimer_custom_page","0","yes");
INSERT INTO `wp_options` VALUES("4961","cmplz_disclaimer_custom_page_url","","yes");
INSERT INTO `wp_options` VALUES("5076","cmplz_wizard_completed_once","1","no");
INSERT INTO `wp_options` VALUES("5162","cmplz_sync_cookies_complete","1","yes");
INSERT INTO `wp_options` VALUES("5165","cmplz_last_cookie_sync","1708611237","yes");
INSERT INTO `wp_options` VALUES("5166","cmplz_sync_services_complete","1","yes");
INSERT INTO `wp_options` VALUES("5171","cmplz_sync_cookies_after_services_complete","1","yes");
INSERT INTO `wp_options` VALUES("5206","complianz_options_settings","a:1:{s:9:\"safe_mode\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("5246","cmplz_dismissed_warnings","a:9:{i:0;s:14:\"contact-form-7\";i:1;s:6:\"no-dnt\";i:2;s:17:\"all-pages-created\";i:3;s:6:\"no-ssl\";i:4;s:21:\"cookie-banner-enabled\";i:5;s:18:\"custom-google-maps\";i:6;s:19:\"integration_enabled\";i:7;s:13:\"upgraded_to_6\";i:8;s:13:\"upgraded_to_7\";}","no");
INSERT INTO `wp_options` VALUES("5397","cmplz_excluded_posts_array","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("5889","mihdan_index_now_version","2.6.5","no");
INSERT INTO `wp_options` VALUES("5890","mihdan_index_now_general","a:9:{s:10:\"post_types\";a:3:{i:0;s:0:\"\";s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";}s:10:\"taxonomies\";a:2:{i:0;s:0:\"\";s:8:\"category\";s:8:\"category\";}s:12:\"ping_on_post\";s:2:\"on\";s:20:\"ping_on_post_updated\";s:2:\"on\";s:12:\"ping_on_term\";s:3:\"off\";s:15:\"ping_on_comment\";s:3:\"off\";s:21:\"disable_for_bulk_edit\";s:2:\"on\";s:23:\"show_last_update_column\";s:2:\"on\";s:10:\"ping_delay\";s:2:\"60\";}","no");
INSERT INTO `wp_options` VALUES("5891","mihdan_index_now_index_now","a:3:{s:6:\"enable\";s:2:\"on\";s:7:\"api_key\";s:32:\"99F21AC35FCD4ED81BDBF2056D4B7AE8\";s:13:\"search_engine\";s:14:\"bing-index-now\";}","no");
INSERT INTO `wp_options` VALUES("5892","mihdan_index_now_bing_webmaster","a:2:{s:6:\"enable\";s:2:\"on\";s:7:\"api_key\";s:32:\"99F21AC35FCD4ED81BDBF2056D4B7AE8\";}","no");
INSERT INTO `wp_options` VALUES("5893","mihdan_index_now_google_webmaster","","no");
INSERT INTO `wp_options` VALUES("5894","mihdan_index_now_yandex_webmaster","","no");
INSERT INTO `wp_options` VALUES("5895","mihdan_index_now_logs","","no");
INSERT INTO `wp_options` VALUES("5896","mihdan_index_now_plugins","","no");
INSERT INTO `wp_options` VALUES("5929","akismet_strictness","1","yes");
INSERT INTO `wp_options` VALUES("5930","akismet_show_user_comments_approved","0","yes");
INSERT INTO `wp_options` VALUES("5931","akismet_comment_form_privacy_notice","display","yes");
INSERT INTO `wp_options` VALUES("5932","wordpress_api_key","5fced871eedb","yes");
INSERT INTO `wp_options` VALUES("5935","akismet_spam_count","56","yes");
INSERT INTO `wp_options` VALUES("6304","flamingo_inbound_channel_children","a:1:{i:49;a:2:{i:0;i:50;i:1;i:52;}}","yes");
INSERT INTO `wp_options` VALUES("6798","jetpack_boost_ds_dismissed_alerts","a:3:{s:31:\"performance_history_fresh_start\";b:0;s:14:\"score_increase\";b:1;s:14:\"score_decrease\";b:0;}","no");
INSERT INTO `wp_options` VALUES("6800","_transient_jetpack_autoloader_plugin_paths","a:5:{i:0;s:25:\"{{WP_PLUGIN_DIR}}/jetpack\";i:1;s:31:\"{{WP_PLUGIN_DIR}}/jetpack-boost\";i:2;s:33:\"{{WP_PLUGIN_DIR}}/jetpack-protect\";i:3;s:32:\"{{WP_PLUGIN_DIR}}/jetpack-search\";i:4;s:32:\"{{WP_PLUGIN_DIR}}/jetpack-social\";}","yes");
INSERT INTO `wp_options` VALUES("6802","jetpack_sync_settings_disable","0","yes");
INSERT INTO `wp_options` VALUES("6803","jetpack_connection_active_plugins","a:5:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}s:13:\"jetpack-boost\";a:2:{s:4:\"name\";s:13:\"Jetpack Boost\";s:8:\"url_info\";s:0:\"\";}s:15:\"jetpack-protect\";a:2:{s:4:\"name\";s:15:\"Jetpack Protect\";s:8:\"url_info\";s:35:\"https://jetpack.com/jetpack-protect\";}s:14:\"jetpack-search\";a:2:{s:4:\"name\";s:14:\"Jetpack Search\";s:8:\"url_info\";s:35:\"https://jetpack.com/upgrade/search/\";}s:14:\"jetpack-social\";a:2:{s:4:\"name\";s:14:\"Jetpack Social\";s:8:\"url_info\";s:34:\"https://jetpack.com/jetpack-social\";}}","yes");
INSERT INTO `wp_options` VALUES("6805","jetpack_options","a:13:{s:14:\"last_heartbeat\";i:1762098388;s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:229837585;s:6:\"public\";i:1;s:11:\"master_user\";i:1;s:21:\"publicize_connections\";a:0:{}s:9:\"hide_jitm\";a:2:{s:14:\"protect_review\";a:2:{s:14:\"last_dismissal\";i:1715714135;s:6:\"number\";i:2;}s:6:\"social\";a:2:{s:14:\"last_dismissal\";i:1722098412;s:6:\"number\";i:1;}}s:27:\"historically_active_modules\";a:8:{i:0;s:9:\"anti-spam\";i:1;s:5:\"boost\";i:2;s:6:\"social\";i:3;s:7:\"protect\";i:4;s:7:\"creator\";i:5;s:6:\"extras\";i:6;s:10:\"jetpack-ai\";i:7;s:5:\"stats\";}s:7:\"version\";s:17:\"15.1.1:1760116125\";s:11:\"old_version\";s:15:\"15.1:1760044515\";s:16:\"first_admin_view\";b:1;s:27:\"recommendations_conditional\";a:1:{i:0;s:11:\"backup-plan\";}}","yes");
INSERT INTO `wp_options` VALUES("6807","jetpack_tos_agreed","1","yes");
INSERT INTO `wp_options` VALUES("6808","jetpack_secrets","a:0:{}","no");
INSERT INTO `wp_options` VALUES("6809","jetpack_sync_https_history_site_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","yes");
INSERT INTO `wp_options` VALUES("6810","jetpack_sync_https_history_home_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","yes");
INSERT INTO `wp_options` VALUES("6811","_transient_jetpack_assumed_site_creation_date","2024-02-02 21:13:49","yes");
INSERT INTO `wp_options` VALUES("6812","jetpack_package_versions","a:7:{s:16:\"transport-helper\";s:5:\"0.3.3\";s:6:\"backup\";s:6:\"4.2.25\";s:10:\"connection\";s:6:\"6.19.2\";s:4:\"sync\";s:6:\"4.22.2\";s:6:\"search\";s:7:\"0.52.21\";s:10:\"videopress\";s:6:\"0.32.9\";s:5:\"stats\";s:6:\"0.17.2\";}","yes");
INSERT INTO `wp_options` VALUES("6813","jetpack_private_options","a:2:{s:10:\"blog_token\";s:65:\"6g0!2G3xon^k812cLUS4uZiBDDj8*zzg.Wv9AtGhJuQ9R)P*PSIz*a6W^B^b0FoVI\";s:11:\"user_tokens\";a:2:{i:1;s:67:\"w0S5#i#5HXGHERT5zpuOX0!@AtglnoWD.Xhm{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}FyOAq*0*d1Og3kCuo^NMU3c1zjrZ.1\";i:2;s:67:\"#ZWVvB9Un0Q)r(C@o6P)eL79XKe1(kGd.#{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}h(8!#z@dsgCqRsyAO*WYe0qWL4GT{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}x.2\";}}","yes");
INSERT INTO `wp_options` VALUES("6814","jetpack_sync_settings_custom_queue_table_enabled","1","yes");
INSERT INTO `wp_options` VALUES("6815","jetpack_sync_settings_max_queue_size","5000","yes");
INSERT INTO `wp_options` VALUES("6816","jetpack_sync_settings_max_queue_lag","7200","yes");
INSERT INTO `wp_options` VALUES("6818","jetpack_sync_settings_dequeue_max_bytes","500000","yes");
INSERT INTO `wp_options` VALUES("6819","jetpack_sync_settings_upload_max_bytes","600000","yes");
INSERT INTO `wp_options` VALUES("6820","jetpack_sync_settings_upload_max_rows","500","yes");
INSERT INTO `wp_options` VALUES("6821","jetpack_sync_settings_sync_wait_time","10","yes");
INSERT INTO `wp_options` VALUES("6822","jetpack_sync_settings_sync_wait_threshold","10","yes");
INSERT INTO `wp_options` VALUES("6823","jetpack_sync_settings_enqueue_wait_time","1","yes");
INSERT INTO `wp_options` VALUES("6824","jetpack_sync_settings_queue_max_writes_sec","100","yes");
INSERT INTO `wp_options` VALUES("6825","jetpack_sync_settings_post_types_blacklist","a:39:{i:0;s:10:\"_term_meta\";i:1;s:11:\"ai1ec_event\";i:2;s:6:\"ai_log\";i:3;s:17:\"amp_validated_url\";i:4;s:9:\"bwg_album\";i:5;s:11:\"bwg_gallery\";i:6;s:19:\"customize_changeset\";i:7;s:12:\"dn_wp_yt_log\";i:8;s:16:\"flamingo_contact\";i:9;s:16:\"flamingo_inbound\";i:10;s:17:\"flamingo_outbound\";i:11;s:4:\"http\";i:12;s:8:\"idx_page\";i:13;s:19:\"jetpack_inspect_log\";i:14;s:17:\"jetpack_migration\";i:15;s:14:\"jp_img_sitemap\";i:16;s:20:\"jp_img_sitemap_index\";i:17;s:10:\"jp_sitemap\";i:18;s:16:\"jp_sitemap_index\";i:19;s:17:\"jp_sitemap_master\";i:20;s:14:\"jp_vid_sitemap\";i:21;s:20:\"jp_vid_sitemap_index\";i:22;s:11:\"msm_sitemap\";i:23;s:17:\"postman_sent_mail\";i:24;s:10:\"rssap-feed\";i:25;s:15:\"rssmi_feed_item\";i:26;s:16:\"scheduled-action\";i:27;s:20:\"secupress_log_action\";i:28;s:17:\"sg_optimizer_jobs\";i:29;s:14:\"sl-insta-media\";i:30;s:6:\"snitch\";i:31;s:19:\"vip-legacy-redirect\";i:32;s:15:\"wp-rest-api-log\";i:33;s:12:\"wp_automatic\";i:34;s:6:\"wp_log\";i:35;s:17:\"wpephpcompat_jobs\";i:36;s:15:\"wprss_feed_item\";i:74;s:18:\"memberships_coupon\";i:75;s:16:\"memberships_gift\";}","yes");
INSERT INTO `wp_options` VALUES("6829","jetpack_sync_settings_dedicated_sync_enabled","1","on");
INSERT INTO `wp_options` VALUES("6831","jetpack_sync_settings_taxonomies_blacklist","a:149:{i:0;s:9:\"ancestors\";i:1;s:13:\"archives_link\";i:2;s:13:\"attached_file\";i:3;s:14:\"attached_media\";i:4;s:19:\"attached_media_args\";i:5;s:10:\"attachment\";i:6;s:19:\"available_languages\";i:7;s:6:\"avatar\";i:8;s:20:\"avatar_comment_types\";i:9;s:11:\"avatar_data\";i:10;s:10:\"avatar_url\";i:11;s:12:\"bloginfo_rss\";i:12;s:13:\"blogs_of_user\";i:13;s:13:\"bookmark_link\";i:14;s:9:\"bookmarks\";i:15;s:8:\"calendar\";i:16;s:13:\"canonical_url\";i:17;s:19:\"categories_per_page\";i:18;s:19:\"categories_taxonomy\";i:19;s:13:\"category_form\";i:20;s:20:\"category_form_fields\";i:21;s:17:\"category_form_pre\";i:22;s:7:\"comment\";i:23;s:10:\"comment_ID\";i:24;s:14:\"comment_author\";i:25;s:17:\"comment_author_IP\";i:26;s:20:\"comment_author_email\";i:27;s:19:\"comment_author_link\";i:28;s:18:\"comment_author_url\";i:29;s:23:\"comment_author_url_link\";i:30;s:12:\"comment_date\";i:31;s:15:\"comment_excerpt\";i:32;s:12:\"comment_link\";i:33;s:20:\"comment_misc_actions\";i:34;s:12:\"comment_text\";i:35;s:12:\"comment_time\";i:36;s:12:\"comment_type\";i:37;s:13:\"comments_link\";i:38;s:15:\"comments_number\";i:39;s:21:\"comments_pagenum_link\";i:40;s:11:\"custom_logo\";i:41;s:8:\"date_sql\";i:42;s:22:\"default_comment_status\";i:43;s:16:\"delete_post_link\";i:44;s:18:\"edit_bookmark_link\";i:45;s:17:\"edit_comment_link\";i:46;s:14:\"edit_post_link\";i:47;s:13:\"edit_tag_link\";i:48;s:14:\"edit_term_link\";i:49;s:14:\"edit_user_link\";i:50;s:8:\"enclosed\";i:51;s:15:\"feed_build_date\";i:52;s:13:\"form_advanced\";i:53;s:17:\"form_after_editor\";i:54;s:16:\"form_after_title\";i:55;s:21:\"form_before_permalink\";i:56;s:8:\"form_top\";i:57;s:18:\"handle_product_cat\";i:58;s:16:\"header_image_tag\";i:59;s:16:\"header_video_url\";i:60;s:9:\"image_tag\";i:61;s:15:\"image_tag_class\";i:62;s:12:\"lastpostdate\";i:63;s:16:\"lastpostmodified\";i:64;s:4:\"link\";i:65;s:18:\"link_category_form\";i:66;s:25:\"link_category_form_fields\";i:67;s:22:\"link_category_form_pre\";i:68;s:15:\"main_network_id\";i:69;s:5:\"media\";i:70;s:15:\"media_item_args\";i:71;s:7:\"ms_user\";i:72;s:7:\"network\";i:73;s:12:\"object_terms\";i:74;s:6:\"option\";i:75;s:4:\"page\";i:76;s:9:\"page_form\";i:77;s:15:\"page_of_comment\";i:78;s:8:\"page_uri\";i:79;s:12:\"pagenum_link\";i:80;s:5:\"pages\";i:81;s:6:\"plugin\";i:82;s:4:\"post\";i:83;s:14:\"post_galleries\";i:84;s:12:\"post_gallery\";i:85;s:9:\"post_link\";i:86;s:18:\"post_modified_time\";i:87;s:11:\"post_status\";i:88;s:9:\"post_time\";i:89;s:8:\"postmeta\";i:90;s:14:\"posts_per_page\";i:91;s:19:\"product_search_form\";i:92;s:11:\"profile_url\";i:93;s:4:\"pung\";i:94;s:9:\"role_list\";i:95;s:16:\"sample_permalink\";i:96;s:21:\"sample_permalink_html\";i:97;s:8:\"schedule\";i:98;s:11:\"search_form\";i:99;s:12:\"search_query\";i:100;s:9:\"shortlink\";i:101;s:4:\"site\";i:102;s:18:\"site_email_content\";i:103;s:13:\"site_icon_url\";i:104;s:11:\"site_option\";i:105;s:13:\"space_allowed\";i:106;s:3:\"tag\";i:107;s:8:\"tag_form\";i:108;s:15:\"tag_form_fields\";i:109;s:12:\"tag_form_pre\";i:110;s:8:\"tag_link\";i:111;s:4:\"tags\";i:112;s:13:\"tags_per_page\";i:113;s:4:\"term\";i:114;s:9:\"term_link\";i:115;s:18:\"term_relationships\";i:116;s:15:\"term_taxonomies\";i:117;s:13:\"term_taxonomy\";i:118;s:5:\"terms\";i:119;s:10:\"terms_args\";i:120;s:14:\"terms_defaults\";i:121;s:12:\"terms_fields\";i:122;s:13:\"terms_orderby\";i:123;s:23:\"the_archive_description\";i:124;s:17:\"the_archive_title\";i:125;s:14:\"the_categories\";i:126;s:8:\"the_date\";i:127;s:11:\"the_excerpt\";i:128;s:8:\"the_guid\";i:129;s:17:\"the_modified_date\";i:130;s:17:\"the_modified_time\";i:131;s:25:\"the_post_type_description\";i:132;s:8:\"the_tags\";i:133;s:9:\"the_terms\";i:134;s:8:\"the_time\";i:135;s:21:\"theme_starter_content\";i:136;s:7:\"to_ping\";i:137;s:4:\"user\";i:138;s:17:\"user_created_user\";i:139;s:9:\"user_form\";i:140;s:12:\"user_profile\";i:141;s:19:\"user_profile_update\";i:142;s:8:\"usermeta\";i:143;s:12:\"usernumposts\";i:144;s:12:\"users_drafts\";i:145;s:7:\"webhook\";i:146;s:6:\"widget\";i:147;s:19:\"woocommerce_archive\";i:148;s:12:\"wp_title_rss\";}","yes");
INSERT INTO `wp_options` VALUES("6833","jetpack_sync_settings_render_filtered_content","0","yes");
INSERT INTO `wp_options` VALUES("6834","jetpack_sync_settings_post_meta_whitelist","a:41:{i:0;s:24:\"_feedback_akismet_values\";i:1;s:15:\"_feedback_email\";i:2;s:22:\"_feedback_extra_fields\";i:3;s:21:\"_g_feedback_shortcode\";i:4;s:23:\"_jetpack_post_thumbnail\";i:5;s:25:\"_last_editor_used_jetpack\";i:6;s:18:\"_menu_item_classes\";i:7;s:27:\"_menu_item_menu_item_parent\";i:8;s:17:\"_menu_item_object\";i:9;s:20:\"_menu_item_object_id\";i:10;s:19:\"_menu_item_orphaned\";i:11;s:15:\"_menu_item_type\";i:12;s:14:\"_menu_item_xfn\";i:13;s:24:\"_publicize_facebook_user\";i:14;s:23:\"_publicize_twitter_user\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:27:\"_wp_attachment_backup_sizes\";i:18;s:22:\"_wp_attachment_context\";i:19;s:24:\"_wp_attachment_image_alt\";i:20;s:35:\"_wp_attachment_is_custom_background\";i:21;s:31:\"_wp_attachment_is_custom_header\";i:22;s:23:\"_wp_attachment_metadata\";i:23;s:17:\"_wp_page_template\";i:24;s:30:\"_wp_trash_meta_comments_status\";i:25;s:21:\"_wpas_feature_enabled\";i:26;s:10:\"_wpas_mess\";i:27;s:13:\"_wpas_options\";i:28;s:24:\"advanced_seo_description\";i:29;s:13:\"content_width\";i:30;s:14:\"custom_css_add\";i:31;s:23:\"custom_css_preprocessor\";i:32;s:9:\"enclosure\";i:33;s:9:\"imagedata\";i:34;s:10:\"nova_price\";i:35;s:17:\"publicize_results\";i:36;s:16:\"sharing_disabled\";i:37;s:18:\"switch_like_status\";i:38;s:15:\"videopress_guid\";i:39;s:18:\"vimeo_poster_image\";i:40;s:28:\"_jetpack_blogging_prompt_key\";}","yes");
INSERT INTO `wp_options` VALUES("6836","jetpack_sync_settings_comment_meta_whitelist","a:4:{i:0;s:9:\"hc_avatar\";i:1;s:18:\"hc_foreign_user_id\";i:2;s:10:\"hc_post_as\";i:3;s:15:\"hc_wpcom_id_sig\";}","yes");
INSERT INTO `wp_options` VALUES("6838","jetpack_sync_settings_max_enqueue_full_sync","100","yes");
INSERT INTO `wp_options` VALUES("6839","jetpack_sync_settings_max_queue_size_full_sync","1000","yes");
INSERT INTO `wp_options` VALUES("6840","jetpack_sync_settings_sync_via_cron","1","yes");
INSERT INTO `wp_options` VALUES("6841","jetpack_sync_settings_cron_sync_time_limit","240","yes");
INSERT INTO `wp_options` VALUES("6842","jetpack_sync_settings_known_importers","a:6:{s:16:\"Blogger_Importer\";s:7:\"blogger\";s:13:\"LJ_API_Import\";s:11:\"livejournal\";s:9:\"MT_Import\";s:2:\"mt\";s:10:\"RSS_Import\";s:3:\"rss\";s:20:\"WC_Tax_Rate_Importer\";s:12:\"woo-tax-rate\";s:9:\"WP_Import\";s:9:\"wordpress\";}","yes");
INSERT INTO `wp_options` VALUES("6843","jetpack_sync_settings_term_relationships_full_sync_item_size","100","yes");
INSERT INTO `wp_options` VALUES("6844","jetpack_sync_settings_sync_sender_enabled","1","yes");
INSERT INTO `wp_options` VALUES("6845","jetpack_sync_settings_full_sync_sender_enabled","1","yes");
INSERT INTO `wp_options` VALUES("6846","jetpack_sync_settings_full_sync_send_duration","9","yes");
INSERT INTO `wp_options` VALUES("6847","jetpack_sync_settings_full_sync_limits","a:5:{s:8:\"comments\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:5:\"posts\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:1;}s:18:\"term_relationships\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"terms\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"users\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}}","yes");
INSERT INTO `wp_options` VALUES("6848","jetpack_sync_settings_checksum_disable","0","yes");
INSERT INTO `wp_options` VALUES("6851","jetpack_plugin_api_action_links","a:10:{s:36:\"indexnow/indexnow-url-submission.php\";a:1:{s:8:\"Settings\";s:74:\"https://www.southlancsarc.co.uk/wp-admin/options-general.php?page=indexnow\";}s:19:\"jetpack/jetpack.php\";a:1:{s:10:\"My Jetpack\";s:66:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=my-jetpack\";}s:31:\"jetpack-boost/jetpack-boost.php\";a:2:{s:10:\"My Jetpack\";s:66:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=my-jetpack\";s:8:\"Settings\";s:69:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=jetpack-boost\";}s:35:\"jetpack-protect/jetpack-protect.php\";a:2:{s:10:\"My Jetpack\";s:66:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=my-jetpack\";s:9:\"Dashboard\";s:71:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=jetpack-protect\";}s:33:\"jetpack-search/jetpack-search.php\";a:2:{s:10:\"My Jetpack\";s:66:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=my-jetpack\";s:8:\"Settings\";s:70:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=jetpack-search\";}s:33:\"jetpack-social/jetpack-social.php\";a:2:{s:10:\"My Jetpack\";s:66:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=my-jetpack\";s:8:\"Settings\";s:70:\"https://www.southlancsarc.co.uk/wp-admin/admin.php?page=jetpack-social\";}s:27:\"redis-cache/redis-cache.php\";a:1:{s:8:\"Settings\";s:77:\"https://www.southlancsarc.co.uk/wp-admin/options-general.php?page=redis-cache\";}s:45:\"simple-local-avatars/simple-local-avatars.php\";a:1:{s:10:\" Settings \";s:63:\"https://www.southlancsarc.co.uk/wp-admin/options-discussion.php\";}s:53:\"smart-auto-upload-images/smart-auto-upload-images.php\";a:1:{s:8:\"Settings\";s:90:\"https://www.southlancsarc.co.uk/wp-admin/options-general.php?page=smart-auto-upload-images\";}s:41:\"wp-database-backup/wp-database-backup.php\";a:1:{s:8:\"Settings\";s:84:\"https://www.southlancsarc.co.uk/wp-admin/options-general.php?page=wp-database-backup\";}}","yes");
INSERT INTO `wp_options` VALUES("6866","jp_sync_lock_full_sync","","off");
INSERT INTO `wp_options` VALUES("6869","jetpack_constants_sync_checksum","a:21:{s:7:\"ABSPATH\";i:3414855400;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:16:\"ATOMIC_CLIENT_ID\";i:634125391;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:4261170317;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:9:\"FS_METHOD\";i:634125391;s:12:\"IS_PRESSABLE\";i:634125391;s:16:\"JETPACK__VERSION\";i:2472190375;s:11:\"PHP_VERSION\";i:3940899010;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:14:\"WP_CONTENT_DIR\";i:610505275;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:8:\"WP_DEBUG\";i:734881840;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1517881590;s:15:\"WP_MEMORY_LIMIT\";i:3065409971;s:17:\"WP_POST_REVISIONS\";i:4261170317;}","yes");
INSERT INTO `wp_options` VALUES("6884","jetpack_callables_sync_checksum","a:48:{s:21:\"get_loaded_extensions\";i:778277327;s:11:\"get_plugins\";i:2026187131;s:10:\"get_themes\";i:834951792;s:24:\"get_plugins_action_links\";i:287814658;s:28:\"has_file_system_write_access\";i:4261170317;s:8:\"home_url\";i:3524416488;s:16:\"hosting_provider\";i:769900095;s:12:\"is_fse_theme\";i:734881840;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:21:\"is_version_controlled\";i:734881840;s:6:\"locale\";i:1256278236;s:17:\"main_network_site\";i:3524416488;s:26:\"main_network_site_wpcom_id\";i:470126678;s:14:\"paused_plugins\";i:223132457;s:13:\"paused_themes\";i:223132457;s:18:\"post_type_features\";i:794272936;s:10:\"post_types\";i:165115652;s:27:\"rest_api_allowed_post_types\";i:1765992367;s:32:\"rest_api_allowed_public_metadata\";i:3610467939;s:5:\"roles\";i:2975596121;s:10:\"shortcodes\";i:3425577302;s:13:\"site_icon_url\";i:4092112771;s:8:\"site_url\";i:3524416488;s:10:\"taxonomies\";i:2146887478;s:13:\"theme_support\";i:453506207;s:8:\"timezone\";i:2482825302;s:23:\"wp_get_environment_type\";i:1138987844;s:18:\"wp_max_upload_size\";i:1819132959;s:10:\"wp_version\";i:1339759982;s:14:\"active_modules\";i:3245590456;s:33:\"jetpack_connection_active_plugins\";i:2767569100;s:27:\"jetpack_sync_active_modules\";i:3829104773;s:13:\"boost_modules\";i:567921069;s:23:\"boost_sub_modules_state\";i:634125391;s:19:\"boost_latest_scores\";i:53103133;s:28:\"boost_latest_no_boost_scores\";i:4247465142;s:18:\"critical_css_state\";i:2569000963;s:16:\"single_user_site\";i:734881840;s:7:\"updates\";i:2903718415;s:24:\"available_jetpack_blocks\";i:1263601756;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:4261170317;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:734881840;s:24:\"jetpack_package_versions\";i:3561827623;s:9:\"lcp_state\";i:3262254420;}","no");
INSERT INTO `wp_options` VALUES("6885","jpsq_sync_checkout","0:0","no");
INSERT INTO `wp_options` VALUES("6891","jpsq_sync-1708789592.453810-57814-6","a:6:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:48:\"jetpack_sync_settings_custom_queue_table_enabled\";i:1;s:1:\"0\";i:2;i:1;}i:2;i:0;i:3;d:1708789592.4537;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:1;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:257:\"https://www.slarc.co.uk/?rest_route={3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2Fjetpack{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2Fv4{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2Fsync{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2Fsettings&_for=jetpack&token=6g0{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}212G3xon{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}5Ek812cLUS4uZiBDDj8{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2Azzg{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}3A1{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}3A0&timestamp=1708789590&nonce=xaVkvUvkra&body-hash=p03riSqJgAEbjpEe4NzGVpfkolQ{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}3D&signature=ToizvqQ{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}2B4V8wpKrx1wlnTh6EVnI{3f8946c6cd92674f41a5dea58c3b668bd8f8c9f35ea524e660ae76b7e64e8301}3D\";}}","no");
INSERT INTO `wp_options` VALUES("6892","jetpack_next_sync_time_sync","1761840945","on");
INSERT INTO `wp_options` VALUES("6893","jetpack_next_sync_time_full-sync-enqueue","1733902246","on");
INSERT INTO `wp_options` VALUES("6898","jp_sync_last_success_immediate-send","1733902244.5975","off");
INSERT INTO `wp_options` VALUES("6900","jp_sync_last_success_sync","1762098398.2672","off");
INSERT INTO `wp_options` VALUES("6932","jetpack_boost_status_critical-css","1","yes");
INSERT INTO `wp_options` VALUES("6937","jetpack_boost_ds_critical_css_state","a:4:{s:9:\"providers\";a:6:{i:0;a:5:{s:3:\"key\";s:20:\"cornerstone_d41d8cd9\";s:5:\"label\";s:16:\"Cornerstone page\";s:4:\"urls\";a:1:{i:0;s:32:\"https://www.southlancsarc.co.uk/\";}s:13:\"success_ratio\";d:1;s:6:\"status\";s:7:\"success\";}i:1;a:5:{s:3:\"key\";s:15:\"core_posts_page\";s:5:\"label\";s:10:\"Posts page\";s:4:\"urls\";a:1:{i:0;s:37:\"https://www.southlancsarc.co.uk/blog/\";}s:13:\"success_ratio\";d:1;s:6:\"status\";s:7:\"success\";}i:2;a:5:{s:3:\"key\";s:13:\"singular_post\";s:5:\"label\";s:16:\"Single post view\";s:4:\"urls\";a:18:{i:0;s:63:\"https://www.southlancsarc.co.uk/beacon-country-park-ardf-event/\";i:1;s:96:\"https://www.southlancsarc.co.uk/ardf-amateur-radio-direction-finding-event-sunday-7th-september/\";i:2;s:70:\"https://www.southlancsarc.co.uk/eastham-country-park-ardf-competition/\";i:3;s:106:\"https://www.southlancsarc.co.uk/club-members-pota-parks-on-the-air-activation-gb-1281-beacon-country-park/\";i:4;s:56:\"https://www.southlancsarc.co.uk/monday-night-net-nights/\";i:5;s:70:\"https://www.southlancsarc.co.uk/hubfest-2025-24th-may-untill-29th-may/\";i:6;s:54:\"https://www.southlancsarc.co.uk/145-alive-certificate/\";i:7;s:76:\"https://www.southlancsarc.co.uk/amateur-radio-direction-finding-event-wigan/\";i:8;s:56:\"https://www.southlancsarc.co.uk/narsa-rally-2025-photos/\";i:9;s:75:\"https://www.southlancsarc.co.uk/145-alive-event-april-12th-2025-narsa-2025/\";i:10;s:75:\"https://www.southlancsarc.co.uk/amateur-radio-direction-finding-north-west/\";i:11;s:67:\"https://www.southlancsarc.co.uk/south-lancs-radio-club-merchandise/\";i:12;s:67:\"https://www.southlancsarc.co.uk/sunday-13th-april-2025-narsa-rally/\";i:13;s:73:\"https://www.southlancsarc.co.uk/amateaur-radio-uk-band-plands-allocation/\";i:14;s:63:\"https://www.southlancsarc.co.uk/licence-changes-2024-explained/\";i:15;s:73:\"https://www.southlancsarc.co.uk/south-lancs-amateur-radio-club-net-night/\";i:16;s:56:\"https://www.southlancsarc.co.uk/planning-ashurst-beacon/\";i:17;s:69:\"https://www.southlancsarc.co.uk/ashurst-beacon-event-10th-april-2021/\";}s:13:\"success_ratio\";d:0.5;s:6:\"status\";s:7:\"success\";}i:3;a:5:{s:3:\"key\";s:13:\"singular_page\";s:5:\"label\";s:16:\"Single page view\";s:4:\"urls\";a:10:{i:0;s:49:\"https://www.southlancsarc.co.uk/cookie-policy-uk/\";i:1;s:53:\"https://www.southlancsarc.co.uk/terms-and-conditions/\";i:2;s:43:\"https://www.southlancsarc.co.uk/contact-us/\";i:3;s:40:\"https://www.southlancsarc.co.uk/welcome/\";i:4;s:43:\"https://www.southlancsarc.co.uk/club-media/\";i:5;s:38:\"https://www.southlancsarc.co.uk/links/\";i:6;s:46:\"https://www.southlancsarc.co.uk/meet-the-team/\";i:7;s:41:\"https://www.southlancsarc.co.uk/training/\";i:8;s:43:\"https://www.southlancsarc.co.uk/activities/\";i:9;s:38:\"https://www.southlancsarc.co.uk/about/\";}s:13:\"success_ratio\";d:0.5;s:6:\"status\";s:7:\"success\";}i:4;a:5:{s:3:\"key\";s:17:\"taxonomy_category\";s:5:\"label\";s:13:\"Category view\";s:4:\"urls\";a:10:{i:0;s:55:\"https://www.southlancsarc.co.uk/category/uncategorized/\";i:1;s:45:\"https://www.southlancsarc.co.uk/category/agm/\";i:2;s:53:\"https://www.southlancsarc.co.uk/category/club-events/\";i:3;s:47:\"https://www.southlancsarc.co.uk/category/narsa/\";i:4;s:49:\"https://www.southlancsarc.co.uk/category/meeting/\";i:5;s:46:\"https://www.southlancsarc.co.uk/category/jota/\";i:6;s:46:\"https://www.southlancsarc.co.uk/category/gota/\";i:7;s:46:\"https://www.southlancsarc.co.uk/category/yota/\";i:8;s:46:\"https://www.southlancsarc.co.uk/category/joti/\";i:9;s:47:\"https://www.southlancsarc.co.uk/category/morse/\";}s:13:\"success_ratio\";d:0.5;s:6:\"status\";s:7:\"success\";}i:5;a:5:{s:3:\"key\";s:17:\"taxonomy_post_tag\";s:5:\"label\";s:24:\"View for custom taxonomy\";s:4:\"urls\";a:10:{i:0;s:40:\"https://www.southlancsarc.co.uk/tag/agm/\";i:1;s:42:\"https://www.southlancsarc.co.uk/tag/slarc/\";i:2;s:59:\"https://www.southlancsarc.co.uk/tag/annual-general-meeting/\";i:3;s:51:\"https://www.southlancsarc.co.uk/tag/ashurst-beacon/\";i:4;s:43:\"https://www.southlancsarc.co.uk/tag/events/\";i:5;s:41:\"https://www.southlancsarc.co.uk/tag/iaru/\";i:6;s:42:\"https://www.southlancsarc.co.uk/tag/narsa/\";i:7;s:78:\"https://www.southlancsarc.co.uk/tag/nothern-amateur-radio-society-association/\";i:8;s:44:\"https://www.southlancsarc.co.uk/tag/meeting/\";i:9;s:46:\"https://www.southlancsarc.co.uk/tag/club-meet/\";}s:13:\"success_ratio\";d:0.5;s:6:\"status\";s:7:\"success\";}}s:6:\"status\";s:9:\"generated\";s:7:\"created\";d:1761841815.759998;s:7:\"updated\";d:1761843228.469826;}","off");
INSERT INTO `wp_options` VALUES("6947","jetpack_boost_speed_score_history_13a6ef7e8c30cc7f18285579ced858a7","a:5:{i:0;a:3:{s:9:\"timestamp\";i:1708789622;s:6:\"scores\";a:2:{s:6:\"mobile\";i:70;s:7:\"desktop\";i:75;}s:5:\"theme\";s:9:\"Customizr\";}i:1;a:3:{s:9:\"timestamp\";i:1708789881;s:6:\"scores\";a:2:{s:6:\"mobile\";i:59;s:7:\"desktop\";i:85;}s:5:\"theme\";s:9:\"Customizr\";}i:2;a:3:{s:9:\"timestamp\";i:1708789966;s:6:\"scores\";a:2:{s:6:\"mobile\";i:63;s:7:\"desktop\";i:74;}s:5:\"theme\";s:9:\"Customizr\";}i:3;a:3:{s:9:\"timestamp\";i:1708790027;s:6:\"scores\";a:2:{s:6:\"mobile\";i:74;s:7:\"desktop\";i:95;}s:5:\"theme\";s:9:\"Customizr\";}i:4;a:3:{s:9:\"timestamp\";i:1708790271;s:6:\"scores\";a:2:{s:6:\"mobile\";i:72;s:7:\"desktop\";i:96;}s:5:\"theme\";s:9:\"Customizr\";}}","no");
INSERT INTO `wp_options` VALUES("6949","jetpack_boost_speed_score_history_e87601946aac981dfc929e535202b6c3","a:1:{i:0;a:3:{s:9:\"timestamp\";i:1708789626;s:6:\"scores\";a:2:{s:6:\"mobile\";i:70;s:7:\"desktop\";i:84;}s:5:\"theme\";s:9:\"Customizr\";}}","no");
INSERT INTO `wp_options` VALUES("6983","jetpack_boost_status_image-cdn","1","auto");
INSERT INTO `wp_options` VALUES("6990","jetpack_active_plan","a:11:{s:10:\"product_id\";i:2002;s:12:\"product_slug\";s:12:\"jetpack_free\";s:12:\"product_name\";s:12:\"Jetpack Free\";s:18:\"product_name_short\";s:4:\"Free\";s:7:\"expired\";b:0;s:14:\"billing_period\";s:0:\"\";s:13:\"user_is_owner\";b:0;s:7:\"is_free\";b:1;s:11:\"license_key\";s:0:\"\";s:15:\"subscribed_date\";s:0:\"\";s:8:\"features\";a:2:{s:6:\"active\";a:20:{i:0;s:12:\"advanced-seo\";i:1;s:3:\"cdn\";i:2;s:9:\"donations\";i:3;s:14:\"multistep-form\";i:4;s:14:\"install-themes\";i:5;s:17:\"jetpack-dashboard\";i:6;s:18:\"recurring-payments\";i:7;s:11:\"republicize\";i:8;s:17:\"security-settings\";i:9;s:17:\"seo-preview-tools\";i:10;s:14:\"send-a-message\";i:11;s:18:\"social-shares-1000\";i:12;s:29:\"social-connections-management\";i:13;s:18:\"upload-audio-files\";i:14;s:18:\"upload-video-files\";i:15;s:15:\"whatsapp-button\";i:16;s:25:\"social-image-auto-convert\";i:17;s:17:\"social-admin-page\";i:18;s:19:\"social-share-status\";i:19;s:21:\"social-editor-preview\";}s:9:\"available\";a:49:{s:7:\"akismet\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:8:\"antispam\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:7:\"backups\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:13:\"backups-daily\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:8:\"calendly\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:20:\"cloudflare-analytics\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:14:\"cloudflare-cdn\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:10:\"core/audio\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:10:\"core/cover\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:10:\"core/video\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:17:\"full-activity-log\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:16:\"google-analytics\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:9:\"opentable\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:16:\"priority_support\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:4:\"scan\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:15:\"simple-payments\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:28:\"subscriber-unlimited-imports\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:7:\"support\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:29:\"vaultpress-automated-restores\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:25:\"vaultpress-backup-archive\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:18:\"vaultpress-backups\";a:17:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:22:\"jetpack_security_daily\";i:7;s:30:\"jetpack_security_daily_monthly\";i:8;s:25:\"jetpack_security_realtime\";i:9;s:33:\"jetpack_security_realtime_monthly\";i:10;s:16:\"jetpack_complete\";i:11;s:24:\"jetpack_complete_monthly\";i:12;s:29:\"jetpack_security_t1_bi_yearly\";i:13;s:26:\"jetpack_security_t1_yearly\";i:14;s:27:\"jetpack_security_t1_monthly\";i:15;s:26:\"jetpack_security_t2_yearly\";i:16;s:27:\"jetpack_security_t2_monthly\";}s:24:\"vaultpress-storage-space\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:13:\"video-hosting\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:10:\"videopress\";a:8:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:16:\"jetpack_personal\";i:3;s:23:\"jetpack_premium_monthly\";i:4;s:24:\"jetpack_business_monthly\";i:5;s:24:\"jetpack_personal_monthly\";i:6;s:16:\"jetpack_complete\";i:7;s:24:\"jetpack_complete_monthly\";}s:22:\"videopress-1tb-storage\";a:6:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:16:\"jetpack_complete\";i:5;s:24:\"jetpack_complete_monthly\";}s:16:\"videopress/video\";a:4:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";}s:7:\"wordads\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:15:\"wordads-jetpack\";a:15:{i:0;s:15:\"jetpack_premium\";i:1;s:16:\"jetpack_business\";i:2;s:23:\"jetpack_premium_monthly\";i:3;s:24:\"jetpack_business_monthly\";i:4;s:22:\"jetpack_security_daily\";i:5;s:30:\"jetpack_security_daily_monthly\";i:6;s:25:\"jetpack_security_realtime\";i:7;s:33:\"jetpack_security_realtime_monthly\";i:8;s:16:\"jetpack_complete\";i:9;s:24:\"jetpack_complete_monthly\";i:10;s:29:\"jetpack_security_t1_bi_yearly\";i:11;s:26:\"jetpack_security_t1_yearly\";i:12;s:27:\"jetpack_security_t1_monthly\";i:13;s:26:\"jetpack_security_t2_yearly\";i:14;s:27:\"jetpack_security_t2_monthly\";}s:6:\"search\";a:4:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";i:2;s:16:\"jetpack_complete\";i:3;s:24:\"jetpack_complete_monthly\";}s:18:\"google-my-business\";a:11:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";i:2;s:25:\"jetpack_security_realtime\";i:3;s:33:\"jetpack_security_realtime_monthly\";i:4;s:16:\"jetpack_complete\";i:5;s:24:\"jetpack_complete_monthly\";i:6;s:29:\"jetpack_security_t1_bi_yearly\";i:7;s:26:\"jetpack_security_t1_yearly\";i:8;s:27:\"jetpack_security_t1_monthly\";i:9;s:26:\"jetpack_security_t2_yearly\";i:10;s:27:\"jetpack_security_t2_monthly\";}s:9:\"polldaddy\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:15:\"personal-themes\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:14:\"premium-themes\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:17:\"real-time-backups\";a:11:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";i:2;s:25:\"jetpack_security_realtime\";i:3;s:33:\"jetpack_security_realtime_monthly\";i:4;s:16:\"jetpack_complete\";i:5;s:24:\"jetpack_complete_monthly\";i:6;s:29:\"jetpack_security_t1_bi_yearly\";i:7;s:26:\"jetpack_security_t1_yearly\";i:8;s:27:\"jetpack_security_t1_monthly\";i:9;s:26:\"jetpack_security_t2_yearly\";i:10;s:27:\"jetpack_security_t2_monthly\";}s:10:\"stats-paid\";a:4:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";i:2;s:16:\"jetpack_complete\";i:3;s:24:\"jetpack_complete_monthly\";}s:16:\"stats-commercial\";a:4:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";i:2;s:16:\"jetpack_complete\";i:3;s:24:\"jetpack_complete_monthly\";}s:28:\"vaultpress-security-scanning\";a:2:{i:0;s:16:\"jetpack_business\";i:1;s:24:\"jetpack_business_monthly\";}s:12:\"ai-assistant\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:15:\"ai-seo-enhancer\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:18:\"cloud-critical-css\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:20:\"cornerstone-10-pages\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:10:\"field-file\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:14:\"image-cdn-liar\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:17:\"image-cdn-quality\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:19:\"image-size-analysis\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:14:\"instant-search\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:19:\"performance-history\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:26:\"social-enhanced-publishing\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}s:22:\"social-image-generator\";a:2:{i:0;s:16:\"jetpack_complete\";i:1;s:24:\"jetpack_complete_monthly\";}}}}","on");
INSERT INTO `wp_options` VALUES("7003","jetpack_boost_status_minify-css","","yes");
INSERT INTO `wp_options` VALUES("7005","jetpack_boost_status_minify-js","1","yes");
INSERT INTO `wp_options` VALUES("7029","jp_sync_retry_after_immediate-send","","no");
INSERT INTO `wp_options` VALUES("7030","jp_sync_error_log_immediate-send","a:5:{s:15:\"1708799048.6738\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 24 Feb 2024 18:24:08 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.sea _bur BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:15:\"1708799048.9463\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 24 Feb 2024 18:24:08 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.sea _bur BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:15:\"1708799049.1848\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 24 Feb 2024 18:24:09 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.sea _bur BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:15:\"1708799049.4641\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 24 Feb 2024 18:24:09 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.sea _bur BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}s:14:\"1708799049.728\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;s:53:\"There is another request running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:24:\"concurrent_request_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 24 Feb 2024 18:24:09 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:11:\"retry-after\";s:1:\"5\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-ac\";s:17:\"4.sea _bur BYPASS\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}s:4:\"body\";s:461:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_request_error] There is another request running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:24:\"concurrent_request_error\";a:1:{i:0;i:400;}}}}","yes");
INSERT INTO `wp_options` VALUES("7041","jetpack_sync_health_status","a:2:{s:6:\"status\";s:7:\"in_sync\";s:9:\"timestamp\";d:1723996848.036864;}","yes");
INSERT INTO `wp_options` VALUES("7409","jetpack_updates_sync_checksum","a:3:{s:13:\"update_themes\";i:876468021;s:14:\"update_plugins\";i:4209677825;s:11:\"update_core\";i:3403900655;}","yes");
INSERT INTO `wp_options` VALUES("7743","jb_transient_speed_score_stale_marker","a:2:{s:6:\"expire\";i:1793535263;s:4:\"data\";i:1761999263;}","off");
INSERT INTO `wp_options` VALUES("7917","jetpack_sync_https_history_main_network_site_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","yes");
INSERT INTO `wp_options` VALUES("7924","jetpack_active_modules","a:18:{i:0;s:9:\"publicize\";i:1;s:3:\"waf\";i:2;s:7:\"protect\";i:3;s:5:\"stats\";i:4;s:5:\"blaze\";i:5;s:12:\"contact-form\";i:6;s:8:\"json-api\";i:7;s:5:\"notes\";i:8;s:18:\"verification-tools\";i:9;s:21:\"woocommerce-analytics\";i:10;s:7:\"monitor\";i:11;s:3:\"sso\";i:12;s:6:\"photon\";i:13;s:13:\"tiled-gallery\";i:14;s:10:\"photon-cdn\";i:15;s:10:\"sharedaddy\";i:16;s:6:\"blocks\";i:17;s:18:\"account-protection\";}","yes");
INSERT INTO `wp_options` VALUES("7941","jetpack-social_show_pricing_page","0","yes");
INSERT INTO `wp_options` VALUES("8343","jetpack_protect_status","s:2579:\"O:8:\"stdClass\":8:{s:12:\"last_checked\";s:19:\"2025-11-01 12:12:02\";s:19:\"num_vulnerabilities\";i:0;s:27:\"num_plugins_vulnerabilities\";i:0;s:26:\"num_themes_vulnerabilities\";i:0;s:6:\"status\";s:11:\"in_progress\";s:4:\"core\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"6.8.3\";s:15:\"vulnerabilities\";a:0:{}}s:6:\"themes\";O:8:\"stdClass\":2:{s:9:\"customizr\";O:8:\"stdClass\":2:{s:7:\"version\";s:6:\"4.4.24\";s:15:\"vulnerabilities\";a:0:{}}s:16:\"twentytwentyfour\";O:8:\"stdClass\":2:{s:7:\"version\";s:3:\"1.3\";s:15:\"vulnerabilities\";a:0:{}}}s:7:\"plugins\";O:8:\"stdClass\":17:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"3.1.7\";s:15:\"vulnerabilities\";a:0:{}}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:3:\"5.5\";s:15:\"vulnerabilities\";a:0:{}}s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"1.2.8\";s:15:\"vulnerabilities\";a:0:{}}s:36:\"indexnow/indexnow-url-submission.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"1.0.3\";s:15:\"vulnerabilities\";a:0:{}}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:6:\"15.1.1\";s:15:\"vulnerabilities\";a:0:{}}s:31:\"jetpack-boost/jetpack-boost.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"4.5.1\";s:15:\"vulnerabilities\";a:0:{}}s:35:\"jetpack-protect/jetpack-protect.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"4.4.0\";s:15:\"vulnerabilities\";a:0:{}}s:33:\"jetpack-search/jetpack-search.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"5.1.0\";s:15:\"vulnerabilities\";a:0:{}}s:33:\"jetpack-social/jetpack-social.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"7.2.0\";s:15:\"vulnerabilities\";a:0:{}}s:41:\"last-login-display/last-login-display.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"1.0.5\";s:15:\"vulnerabilities\";a:0:{}}s:33:\"nimble-builder/nimble-builder.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"3.3.8\";s:15:\"vulnerabilities\";a:0:{}}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"9.5.3\";s:15:\"vulnerabilities\";a:0:{}}s:27:\"redis-cache/redis-cache.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"2.7.0\";s:15:\"vulnerabilities\";a:0:{}}s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"1.6.1\";s:15:\"vulnerabilities\";a:0:{}}s:45:\"simple-local-avatars/simple-local-avatars.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"2.8.5\";s:15:\"vulnerabilities\";a:0:{}}s:53:\"smart-auto-upload-images/smart-auto-upload-images.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:5:\"1.2.0\";s:15:\"vulnerabilities\";a:0:{}}s:41:\"wp-database-backup/wp-database-backup.php\";O:8:\"stdClass\":2:{s:7:\"version\";s:3:\"7.7\";s:15:\"vulnerabilities\";a:0:{}}}}\";","yes");
INSERT INTO `wp_options` VALUES("8344","jetpack_protect_status_time","1762035583","yes");
INSERT INTO `wp_options` VALUES("8346","jetpack_waf_automatic_rules","","yes");
INSERT INTO `wp_options` VALUES("8348","jetpack_waf_share_data","1","yes");
INSERT INTO `wp_options` VALUES("8350","jetpack_protect_key","7bc0cb1f9a75a2206841b23af346400265d7a943","no");
INSERT INTO `wp_options` VALUES("8353","jetpack_waf_needs_update","1","auto");
INSERT INTO `wp_options` VALUES("8360","jetpack_waf_last_updated_timestamp","1762092841","yes");
INSERT INTO `wp_options` VALUES("8375","trusted_ip_header","O:8:\"stdClass\":3:{s:14:\"trusted_header\";s:11:\"REMOTE_ADDR\";s:8:\"segments\";i:1;s:7:\"reverse\";b:0;}","no");
INSERT INTO `wp_options` VALUES("8429","xyz_credit_link","0","yes");
INSERT INTO `wp_options` VALUES("8462","xyz_smap_tb_af","1","yes");
INSERT INTO `wp_options` VALUES("8541","xyz_smap_fb_token","","yes");
INSERT INTO `wp_options` VALUES("8614","xyz_fbap_premium_version_ads","1","yes");
INSERT INTO `wp_options` VALUES("8682","widget_heateor_sss_follow","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("8688","heateor_sss_gdpr_notification_read","1","yes");
INSERT INTO `wp_options` VALUES("8736","jetpack_protect_blocked_attempts","32941","off");
INSERT INTO `wp_options` VALUES("10732","cmplz_dnsmpd_db_version","7.0.5","no");
INSERT INTO `wp_options` VALUES("10733","cmplz_preloaded_privacy_info","a:5:{i:0;a:3:{s:11:\"plugin_name\";s:9:\"WordPress\";s:11:\"policy_text\";s:4475:\"<h2 class=\"wp-block-heading\">Who we are</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: https://www.southlancsarc.co.uk.</p><h2 class=\"wp-block-heading\">Comments</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><p>An anonymised string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service Privacy Policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><h2 class=\"wp-block-heading\">Media</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><h2 class=\"wp-block-heading\">Cookies</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><h2 class=\"wp-block-heading\">Embedded content from other websites</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><h2 class=\"wp-block-heading\">Who we share your data with</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><h2 class=\"wp-block-heading\">How long we retain your data</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognise and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><h2 class=\"wp-block-heading\">What rights you have over your data</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><h2 class=\"wp-block-heading\">Where your data is sent</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p>\";s:5:\"added\";i:1712383670;}i:1;a:3:{s:11:\"plugin_name\";s:16:\"Burst Statistics\";s:11:\"policy_text\";s:393:\"<p>This website uses Burst Statistics, a Privacy-Friendly Statistics Tool to analyse visitor behaviour. For this functionality we (this website) collect anonymised data, stored locally without sharing it with other parties. For more information, please read the <a href=\"https://burst-statistics.com/legal/privacy-statement/\" target=\"_blank\"> Privacy Statement </a> from Burst Statistics.</p>\n\";s:5:\"added\";i:1712383670;}i:2;a:3:{s:11:\"plugin_name\";s:17:\"Really Simple SSL\";s:11:\"policy_text\";s:339:\"<p>Really Simple SSL and Really Simple SSL add-ons do not process any personal identifiable information, so the GDPR does not apply to these plugins or usage of these plugins on your website. You can find our privacy policy <a href=\"https://really-simple-ssl.com/privacy-statement/\" rel=\"noopener noreferrer\" target=\"_blank\">here</a>.</p>\n\";s:5:\"added\";i:1712383670;}i:3;a:3:{s:11:\"plugin_name\";s:43:\"Complianz | The Privacy Suite for WordPress\";s:11:\"policy_text\";s:462:\"<p>This website uses the Privacy Suite for WordPress by Complianz to collect and record Browser and Device-based Consent. For this functionality, your IP address is anonymized and stored in our database.&nbsp;This service does not process any personally identifiable information and does not share any data with the service provider.&nbsp;For more information, see the Complianz <a href=\"https://complianz.io/legal/privacy-statement/\">Privacy Statement</a>.</p>\n\";s:5:\"added\";i:1712383670;}i:4;a:3:{s:11:\"plugin_name\";s:7:\"Akismet\";s:11:\"policy_text\";s:400:\"We collect information about visitors who comment on sites that use our Akismet Anti-spam service. The information we collect depends on how the user sets up Akismet for the site, but typically includes the commenter\'s IP address, user agent, referrer, and site URL (along with other information directly provided by the commenter such as their name, username, email address, and the comment itself).\";s:5:\"added\";i:1712383670;}}","no");
INSERT INTO `wp_options` VALUES("10737","cmplz_options","a:37:{s:9:\"safe_mode\";b:1;s:7:\"regions\";s:2:\"uk\";s:18:\"eu_consent_regions\";s:2:\"no\";s:18:\"uk_consent_regions\";s:2:\"no\";s:9:\"us_states\";a:0:{}s:21:\"wp_admin_access_users\";s:2:\"no\";s:16:\"cookie-statement\";s:9:\"generated\";s:17:\"privacy-statement\";s:6:\"custom\";s:9:\"impressum\";s:4:\"none\";s:10:\"disclaimer\";s:4:\"none\";s:17:\"organisation_name\";s:30:\"South Lancs Amateur Radio Club\";s:15:\"address_company\";s:33:\"Vicarage Rd, Abram, Wigan WN2 5QX\";s:15:\"country_company\";s:2:\"GB\";s:13:\"email_company\";s:21:\"webmaster@slarc.co.uk\";s:17:\"telephone_company\";s:0:\"\";s:18:\"records_of_consent\";s:2:\"no\";s:11:\"datarequest\";s:2:\"no\";s:11:\"respect_dnt\";s:3:\"yes\";s:18:\"compile_statistics\";s:2:\"no\";s:28:\"compile_statistics_more_info\";a:0:{}s:40:\"compile_statistics_more_info_tag_manager\";a:0:{}s:17:\"matomo_anonymized\";s:0:\"\";s:15:\"region_redirect\";s:2:\"no\";s:24:\"uses_thirdparty_services\";s:3:\"yes\";s:27:\"thirdparty_services_on_site\";a:5:{i:0;s:12:\"google-fonts\";i:1;s:16:\"google-recaptcha\";i:2;s:11:\"google-maps\";i:3;s:7:\"youtube\";i:4;s:9:\"sharethis\";}s:23:\"block_recaptcha_service\";s:2:\"no\";s:22:\"self_host_google_fonts\";s:9:\"self-host\";s:21:\"block_hubspot_service\";s:2:\"no\";s:17:\"uses_social_media\";s:3:\"yes\";s:19:\"socialmedia_on_site\";a:2:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";}s:33:\"uses_firstparty_marketing_cookies\";s:2:\"no\";s:15:\"uses_ad_cookies\";s:2:\"no\";s:28:\"uses_ad_cookies_personalized\";s:2:\"no\";s:23:\"uses_wordpress_comments\";s:3:\"yes\";s:31:\"block_wordpress_comment_cookies\";s:3:\"yes\";s:20:\"enable_cookie_banner\";s:3:\"yes\";s:21:\"enable_cookie_blocker\";s:2:\"no\";}","yes");
INSERT INTO `wp_options` VALUES("10745","cmplz_onboarding_dismissed","1","no");
INSERT INTO `wp_options` VALUES("10747","_transient_media_months","a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"year\";s:4:\"2024\";s:5:\"month\";s:1:\"2\";}}","yes");
INSERT INTO `wp_options` VALUES("10756","cmplz_first_sync_started","1","no");
INSERT INTO `wp_options` VALUES("10757","cmplz_purposes_stored","1","no");
INSERT INTO `wp_options` VALUES("10758","cmplz_purposes_en","a:5:{i:0;a:2:{s:5:\"value\";s:2:\"61\";s:5:\"label\";s:10:\"Functional\";}i:1;a:2:{s:5:\"value\";s:2:\"64\";s:5:\"label\";s:9:\"Marketing\";}i:2;a:2:{s:5:\"value\";s:4:\"1257\";s:5:\"label\";s:11:\"Preferences\";}i:3;a:2:{s:5:\"value\";s:2:\"63\";s:5:\"label\";s:10:\"Statistics\";}i:4;a:2:{s:5:\"value\";s:2:\"62\";s:5:\"label\";s:22:\"Statistics (anonymous)\";}}","no");
INSERT INTO `wp_options` VALUES("10759","cmplz_serviceTypes_stored","1","no");
INSERT INTO `wp_options` VALUES("10760","cmplz_serviceTypes_en","a:53:{i:0;a:2:{s:5:\"value\";s:3:\"422\";s:5:\"label\";s:11:\"advertising\";}i:1;a:2:{s:5:\"value\";s:3:\"402\";s:5:\"label\";s:19:\"affiliate marketing\";}i:2;a:2:{s:5:\"value\";s:3:\"429\";s:5:\"label\";s:15:\"audio streaming\";}i:3;a:2:{s:5:\"value\";s:3:\"418\";s:5:\"label\";s:16:\"buttons creation\";}i:4;a:2:{s:5:\"value\";s:3:\"396\";s:5:\"label\";s:13:\"call tracking\";}i:5;a:2:{s:5:\"value\";s:3:\"180\";s:5:\"label\";s:12:\"chat support\";}i:6;a:2:{s:5:\"value\";s:3:\"425\";s:5:\"label\";s:19:\"comments management\";}i:7;a:2:{s:5:\"value\";s:4:\"2443\";s:5:\"label\";s:13:\"Contact Forms\";}i:8;a:2:{s:5:\"value\";s:3:\"400\";s:5:\"label\";s:16:\"content creation\";}i:9;a:2:{s:5:\"value\";s:3:\"409\";s:5:\"label\";s:43:\"content distribution network (CDN) services\";}i:10;a:2:{s:5:\"value\";s:3:\"408\";s:5:\"label\";s:18:\"content management\";}i:11;a:2:{s:5:\"value\";s:2:\"67\";s:5:\"label\";s:25:\"cookie consent management\";}i:12;a:2:{s:5:\"value\";s:4:\"1336\";s:5:\"label\";s:22:\"creating online forums\";}i:13;a:2:{s:5:\"value\";s:3:\"412\";s:5:\"label\";s:14:\"creating polls\";}i:14;a:2:{s:5:\"value\";s:3:\"399\";s:5:\"label\";s:25:\"cross-channel advertising\";}i:15;a:2:{s:5:\"value\";s:3:\"413\";s:5:\"label\";s:28:\"customer identity management\";}i:16;a:2:{s:5:\"value\";s:4:\"1157\";s:5:\"label\";s:29:\"Customer Relations Management\";}i:17;a:2:{s:5:\"value\";s:3:\"405\";s:5:\"label\";s:27:\"customer support management\";}i:18;a:2:{s:5:\"value\";s:3:\"426\";s:5:\"label\";s:27:\"display of recent purchases\";}i:19;a:2:{s:5:\"value\";s:3:\"384\";s:5:\"label\";s:58:\"display of recent social posts and/or social share buttons\";}i:20;a:2:{s:5:\"value\";s:3:\"415\";s:5:\"label\";s:19:\"display of webfonts\";}i:21;a:2:{s:5:\"value\";s:3:\"410\";s:5:\"label\";s:31:\"heat maps and screen recordings\";}i:22;a:2:{s:5:\"value\";s:4:\"3410\";s:5:\"label\";s:38:\"learning management and course builder\";}i:23;a:2:{s:5:\"value\";s:3:\"401\";s:5:\"label\";s:17:\"locale management\";}i:24;a:2:{s:5:\"value\";s:3:\"387\";s:5:\"label\";s:26:\"mailing list subscriptions\";}i:25;a:2:{s:5:\"value\";s:3:\"385\";s:5:\"label\";s:12:\"maps display\";}i:26;a:2:{s:5:\"value\";s:3:\"395\";s:5:\"label\";s:48:\"marketing automation (automated email marketing)\";}i:27;a:2:{s:5:\"value\";s:4:\"1335\";s:5:\"label\";s:19:\"online appointments\";}i:28;a:2:{s:5:\"value\";s:3:\"407\";s:5:\"label\";s:12:\"page caching\";}i:29;a:2:{s:5:\"value\";s:3:\"163\";s:5:\"label\";s:30:\"page loading speed improvement\";}i:30;a:2:{s:5:\"value\";s:3:\"161\";s:5:\"label\";s:18:\"payment processing\";}i:31;a:2:{s:5:\"value\";s:3:\"419\";s:5:\"label\";s:14:\"popup creation\";}i:32;a:2:{s:5:\"value\";s:3:\"397\";s:5:\"label\";s:30:\"providing social share buttons\";}i:33;a:2:{s:5:\"value\";s:4:\"2016\";s:5:\"label\";s:18:\"push notifications\";}i:34;a:2:{s:5:\"value\";s:3:\"411\";s:5:\"label\";s:11:\"remarketing\";}i:35;a:2:{s:5:\"value\";s:3:\"423\";s:5:\"label\";s:26:\"Search Engine Optimization\";}i:36;a:2:{s:5:\"value\";s:3:\"404\";s:5:\"label\";s:16:\"search functions\";}i:37;a:2:{s:5:\"value\";s:3:\"416\";s:5:\"label\";s:29:\"security and fraud prevention\";}i:38;a:2:{s:5:\"value\";s:3:\"398\";s:5:\"label\";s:22:\"showing advertisements\";}i:39;a:2:{s:5:\"value\";s:3:\"386\";s:5:\"label\";s:15:\"spam prevention\";}i:40;a:2:{s:5:\"value\";s:3:\"388\";s:5:\"label\";s:27:\"Statistics and optimization\";}i:41;a:2:{s:5:\"value\";s:3:\"178\";s:5:\"label\";s:13:\"video display\";}i:42;a:2:{s:5:\"value\";s:3:\"406\";s:5:\"label\";s:16:\"visitor tracking\";}i:43;a:2:{s:5:\"value\";s:4:\"1131\";s:5:\"label\";s:16:\"weather forecast\";}i:44;a:2:{s:5:\"value\";s:3:\"427\";s:5:\"label\";s:8:\"webforms\";}i:45;a:2:{s:5:\"value\";s:3:\"420\";s:5:\"label\";s:18:\"webshop management\";}i:46;a:2:{s:5:\"value\";s:3:\"421\";s:5:\"label\";s:23:\"website admin functions\";}i:47;a:2:{s:5:\"value\";s:3:\"403\";s:5:\"label\";s:14:\"website design\";}i:48;a:2:{s:5:\"value\";s:3:\"424\";s:5:\"label\";s:19:\"website development\";}i:49;a:2:{s:5:\"value\";s:3:\"414\";s:5:\"label\";s:15:\"website hosting\";}i:50;a:2:{s:5:\"value\";s:3:\"417\";s:5:\"label\";s:13:\"website menus\";}i:51;a:2:{s:5:\"value\";s:3:\"164\";s:5:\"label\";s:32:\"website performance optimization\";}i:52;a:2:{s:5:\"value\";s:3:\"162\";s:5:\"label\";s:18:\"website statistics\";}}","no");
INSERT INTO `wp_options` VALUES("11353","_wp_suggested_policy_text_has_changed","changed","off");
INSERT INTO `wp_options` VALUES("12236","jetpack_boost_speed_score_history_18872809a3a9dd11e7f7d7da5fdd5cac","a:20:{i:0;a:3:{s:9:\"timestamp\";i:1732132044;s:6:\"scores\";a:2:{s:6:\"mobile\";i:77;s:7:\"desktop\";i:76;}s:5:\"theme\";s:9:\"Customizr\";}i:1;a:3:{s:9:\"timestamp\";i:1732137850;s:6:\"scores\";a:2:{s:6:\"mobile\";i:60;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:2;a:3:{s:9:\"timestamp\";i:1733858957;s:6:\"scores\";a:2:{s:6:\"mobile\";i:57;s:7:\"desktop\";i:88;}s:5:\"theme\";s:9:\"Customizr\";}i:3;a:3:{s:9:\"timestamp\";i:1735387844;s:6:\"scores\";a:2:{s:6:\"mobile\";i:70;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:4;a:3:{s:9:\"timestamp\";i:1736193431;s:6:\"scores\";a:2:{s:6:\"mobile\";i:63;s:7:\"desktop\";i:84;}s:5:\"theme\";s:9:\"Customizr\";}i:5;a:3:{s:9:\"timestamp\";i:1737468180;s:6:\"scores\";a:2:{s:6:\"mobile\";i:66;s:7:\"desktop\";i:90;}s:5:\"theme\";s:9:\"Customizr\";}i:6;a:3:{s:9:\"timestamp\";i:1737806609;s:6:\"scores\";a:2:{s:6:\"mobile\";i:64;s:7:\"desktop\";i:85;}s:5:\"theme\";s:9:\"Customizr\";}i:7;a:3:{s:9:\"timestamp\";i:1737978701;s:6:\"scores\";a:2:{s:6:\"mobile\";i:65;s:7:\"desktop\";i:82;}s:5:\"theme\";s:9:\"Customizr\";}i:8;a:3:{s:9:\"timestamp\";i:1738181778;s:6:\"scores\";a:2:{s:6:\"mobile\";i:66;s:7:\"desktop\";i:68;}s:5:\"theme\";s:9:\"Customizr\";}i:9;a:3:{s:9:\"timestamp\";i:1739618591;s:6:\"scores\";a:2:{s:6:\"mobile\";i:57;s:7:\"desktop\";i:91;}s:5:\"theme\";s:9:\"Customizr\";}i:10;a:3:{s:9:\"timestamp\";i:1742133620;s:6:\"scores\";a:2:{s:6:\"mobile\";i:64;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}i:11;a:3:{s:9:\"timestamp\";i:1742138768;s:6:\"scores\";a:2:{s:6:\"mobile\";i:62;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:12;a:3:{s:9:\"timestamp\";i:1742138793;s:6:\"scores\";a:2:{s:6:\"mobile\";i:50;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}i:13;a:3:{s:9:\"timestamp\";i:1744319530;s:6:\"scores\";a:2:{s:6:\"mobile\";i:58;s:7:\"desktop\";i:80;}s:5:\"theme\";s:9:\"Customizr\";}i:14;a:3:{s:9:\"timestamp\";i:1744652013;s:6:\"scores\";a:2:{s:6:\"mobile\";i:56;s:7:\"desktop\";i:83;}s:5:\"theme\";s:9:\"Customizr\";}i:15;a:3:{s:9:\"timestamp\";i:1746122822;s:6:\"scores\";a:2:{s:6:\"mobile\";i:59;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:16;a:3:{s:9:\"timestamp\";i:1746560602;s:6:\"scores\";a:2:{s:6:\"mobile\";i:53;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:17;a:3:{s:9:\"timestamp\";i:1750441968;s:6:\"scores\";a:2:{s:6:\"mobile\";i:58;s:7:\"desktop\";i:85;}s:5:\"theme\";s:9:\"Customizr\";}i:18;a:3:{s:9:\"timestamp\";i:1750441993;s:6:\"scores\";a:2:{s:6:\"mobile\";i:60;s:7:\"desktop\";i:77;}s:5:\"theme\";s:9:\"Customizr\";}i:19;a:3:{s:9:\"timestamp\";i:1752605171;s:6:\"scores\";a:2:{s:6:\"mobile\";i:53;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}}","off");
INSERT INTO `wp_options` VALUES("12237","jetpack_boost_speed_score_history_431e66c259d1cfcfd06e7ad00a84bc04","a:20:{i:0;a:3:{s:9:\"timestamp\";i:1735387839;s:6:\"scores\";a:2:{s:6:\"mobile\";i:68;s:7:\"desktop\";i:93;}s:5:\"theme\";s:9:\"Customizr\";}i:1;a:3:{s:9:\"timestamp\";i:1735387902;s:6:\"scores\";a:2:{s:6:\"mobile\";i:64;s:7:\"desktop\";i:93;}s:5:\"theme\";s:9:\"Customizr\";}i:2;a:3:{s:9:\"timestamp\";i:1736193432;s:6:\"scores\";a:2:{s:6:\"mobile\";i:69;s:7:\"desktop\";i:95;}s:5:\"theme\";s:9:\"Customizr\";}i:3;a:3:{s:9:\"timestamp\";i:1737468176;s:6:\"scores\";a:2:{s:6:\"mobile\";i:69;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}i:4;a:3:{s:9:\"timestamp\";i:1737806609;s:6:\"scores\";a:2:{s:6:\"mobile\";i:67;s:7:\"desktop\";i:93;}s:5:\"theme\";s:9:\"Customizr\";}i:5;a:3:{s:9:\"timestamp\";i:1737978701;s:6:\"scores\";a:2:{s:6:\"mobile\";i:62;s:7:\"desktop\";i:83;}s:5:\"theme\";s:9:\"Customizr\";}i:6;a:3:{s:9:\"timestamp\";i:1738181778;s:6:\"scores\";a:2:{s:6:\"mobile\";i:49;s:7:\"desktop\";i:72;}s:5:\"theme\";s:9:\"Customizr\";}i:7;a:3:{s:9:\"timestamp\";i:1739618582;s:6:\"scores\";a:2:{s:6:\"mobile\";i:62;s:7:\"desktop\";i:95;}s:5:\"theme\";s:9:\"Customizr\";}i:8;a:3:{s:9:\"timestamp\";i:1742133620;s:6:\"scores\";a:2:{s:6:\"mobile\";i:63;s:7:\"desktop\";i:90;}s:5:\"theme\";s:9:\"Customizr\";}i:9;a:3:{s:9:\"timestamp\";i:1742138788;s:6:\"scores\";a:2:{s:6:\"mobile\";i:54;s:7:\"desktop\";i:83;}s:5:\"theme\";s:9:\"Customizr\";}i:10;a:3:{s:9:\"timestamp\";i:1742138821;s:6:\"scores\";a:2:{s:6:\"mobile\";i:67;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}i:11;a:3:{s:9:\"timestamp\";i:1744319520;s:6:\"scores\";a:2:{s:6:\"mobile\";i:40;s:7:\"desktop\";i:88;}s:5:\"theme\";s:9:\"Customizr\";}i:12;a:3:{s:9:\"timestamp\";i:1744319597;s:6:\"scores\";a:2:{s:6:\"mobile\";i:42;s:7:\"desktop\";i:85;}s:5:\"theme\";s:9:\"Customizr\";}i:13;a:3:{s:9:\"timestamp\";i:1744320238;s:6:\"scores\";a:2:{s:6:\"mobile\";i:45;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}i:14;a:3:{s:9:\"timestamp\";i:1744652008;s:6:\"scores\";a:2:{s:6:\"mobile\";i:45;s:7:\"desktop\";i:84;}s:5:\"theme\";s:9:\"Customizr\";}i:15;a:3:{s:9:\"timestamp\";i:1746122811;s:6:\"scores\";a:2:{s:6:\"mobile\";i:62;s:7:\"desktop\";i:90;}s:5:\"theme\";s:9:\"Customizr\";}i:16;a:3:{s:9:\"timestamp\";i:1746560597;s:6:\"scores\";a:2:{s:6:\"mobile\";i:59;s:7:\"desktop\";i:95;}s:5:\"theme\";s:9:\"Customizr\";}i:17;a:3:{s:9:\"timestamp\";i:1750441964;s:6:\"scores\";a:2:{s:6:\"mobile\";i:55;s:7:\"desktop\";i:92;}s:5:\"theme\";s:9:\"Customizr\";}i:18;a:3:{s:9:\"timestamp\";i:1750441988;s:6:\"scores\";a:2:{s:6:\"mobile\";i:66;s:7:\"desktop\";i:93;}s:5:\"theme\";s:9:\"Customizr\";}i:19;a:3:{s:9:\"timestamp\";i:1752605166;s:6:\"scores\";a:2:{s:6:\"mobile\";i:54;s:7:\"desktop\";i:89;}s:5:\"theme\";s:9:\"Customizr\";}}","off");
INSERT INTO `wp_options` VALUES("14308","cmplz_tc_review_notice_shown","1","yes");
INSERT INTO `wp_options` VALUES("16361","jetpack_sync_settings_wpcom_rest_api_enabled","1","yes");
INSERT INTO `wp_options` VALUES("25604","cmplz_review_notice_shown","1","no");
INSERT INTO `wp_options` VALUES("33003","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"cwoodalluk@yahoo.co.uk\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759266963;}","off");
INSERT INTO `wp_options` VALUES("35049","db_upgraded","","on");
INSERT INTO `wp_options` VALUES("35246","jetpack_boost_status_page-cache","1","auto");
INSERT INTO `wp_options` VALUES("35248","jetpack_boost_ds_page_cache_error","","off");
INSERT INTO `wp_options` VALUES("53763","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","no");
INSERT INTO `wp_options` VALUES("55462","rpbw_donated","1","yes");
INSERT INTO `wp_options` VALUES("66615","cmplz_pdf_dir_token","1714879293","yes");
INSERT INTO `wp_options` VALUES("67887","jetpack_boost_status_image-guide","","yes");
INSERT INTO `wp_options` VALUES("68236","cmplz_transients","a:5:{s:35:\"cmplz_shortcode_cookie-statement-uk\";a:2:{s:5:\"value\";i:369;s:7:\"expires\";i:1715603432;}s:45:\"cmplz_shortcode_privacy-statement-children-uk\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1715217034;}s:18:\"page_links_1_en_GB\";a:2:{s:5:\"value\";a:1:{s:2:\"uk\";a:2:{s:16:\"cookie-statement\";a:2:{s:5:\"title\";s:14:\"Cookie Policy \";s:3:\"url\";s:49:\"https://www.southlancsarc.co.uk/cookie-policy-uk/\";}s:17:\"privacy-statement\";a:2:{s:5:\"title\";s:20:\"Terms and Conditions\";s:3:\"url\";s:53:\"https://www.southlancsarc.co.uk/terms-and-conditions/\";}}}s:7:\"expires\";i:1715280016;}s:23:\"cmplz_default_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1715283452;}s:19:\"cmplz_min_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1715283452;}}","yes");
INSERT INTO `wp_options` VALUES("71182","burst_summary_table_upgrade_days_offset","120","no");
INSERT INTO `wp_options` VALUES("105388","wp_db_backup_destination_SFTP","0","yes");
INSERT INTO `wp_options` VALUES("105389","wp_db_backup_destination_FTP","1","off");
INSERT INTO `wp_options` VALUES("105390","wp_db_backup_destination_Email","0","yes");
INSERT INTO `wp_options` VALUES("105391","wp_db_backup_destination_s3","0","yes");
INSERT INTO `wp_options` VALUES("105392","wp_db_remove_local_backup","0","off");
INSERT INTO `wp_options` VALUES("105393","wp_db_remove_on_uninstall","0","off");
INSERT INTO `wp_options` VALUES("105394","wp_db_backup_backup_type","complete","yes");
INSERT INTO `wp_options` VALUES("105395","wp_db_backup_exclude_dir","wp-content/backupwordpress-728d36f682-backups|.git|db-backup","yes");
INSERT INTO `wp_options` VALUES("105396","wp_db_backup_backups_dir","db-backup","yes");
INSERT INTO `wp_options` VALUES("105397","bb_last_backup_timestamp","0","yes");
INSERT INTO `wp_options` VALUES("105398","wp_db_backup_sftp_details","","yes");
INSERT INTO `wp_options` VALUES("105425","wpdbbkp_backupcron_status","active","off");
INSERT INTO `wp_options` VALUES("105426","wpdbbkp_backupcron_step","Fetching Tables","off");
INSERT INTO `wp_options` VALUES("105427","wpdbbkp_backupcron_current","wp_options","off");
INSERT INTO `wp_options` VALUES("105428","wpdbbkp_backupcron_progress","24","off");
INSERT INTO `wp_options` VALUES("105440","wpdbbkp_total_chunk_cnt","10","off");
INSERT INTO `wp_options` VALUES("105441","wpdbbkp_current_chunk_cnt","10","off");
INSERT INTO `wp_options` VALUES("105442","wpdbbkp_current_chunk_args","a:9:{s:11:\"files_added\";i:0;s:8:\"siteName\";s:30:\"South_Lancs_Amateur_Radio_Club\";s:8:\"FileName\";s:68:\"South_Lancs_Amateur_Radio_Club_2025_10_26_1761519636_fe1ac382e_wpall\";s:7:\"logFile\";s:148:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/uploads/db-backup/log/South_Lancs_Amateur_Radio_Club_2025_10_26_1761519636_fe1ac382e_wpall.txt\";s:10:\"logFileUrl\";s:137:\"https://www.southlancsarc.co.uk/wp-content/uploads/db-backup/log/South_Lancs_Amateur_Radio_Club_2025_10_26_1761519636_fe1ac382e_wpall.txt\";s:10:\"logMessage\";s:492:\"\n#--------------------------------------------------------\nNOTICE: Do NOT post to public sites or forums\n#--------------------------------------------------------\n Backup File Name : South_Lancs_Amateur_Radio_Club_2025_10_26_1761519636_fe1ac382e_wpall.zip\n Backup File Path : https://www.southlancsarc.co.uk/wp-content/uploads/db-backup/South_Lancs_Amateur_Radio_Club_2025_10_26_1761519636_fe1ac382e_wpall.zip\n Backup Type : complete\n#--------------------------------------------------------\n\";s:9:\"tableName\";s:26:\"wp_wpdbbkp_processed_files\";s:15:\"total_chunk_cnt\";i:10;s:11:\"chunk_count\";i:10;}","off");
INSERT INTO `wp_options` VALUES("105445","wpdbbkp_last_update","1761519731","off");
INSERT INTO `wp_options` VALUES("105537","wp_db_local_backup_path","/home/carl/backupcwp","yes");
INSERT INTO `wp_options` VALUES("105538","wp_db_local_backup","1","no");
INSERT INTO `wp_options` VALUES("105649","wp_local_db_backup_count","2","off");
INSERT INTO `wp_options` VALUES("105650","wp_db_log","0","off");
INSERT INTO `wp_options` VALUES("105651","wp_db_backup_enable_auto_upgrade","0","off");
INSERT INTO `wp_options` VALUES("105652","wp_db_backup_enable_htaccess","0","no");
INSERT INTO `wp_options` VALUES("105653","wp_db_exclude_table","","no");
INSERT INTO `wp_options` VALUES("106298","wpdbbkp_backup_status","inactive","no");
INSERT INTO `wp_options` VALUES("139518","wpdbbkp_unsubscribe_token","784de5196d48d07801c0a2ed095bf4a103042b9f3ee521539f0c3adddcdc5f1e","off");
INSERT INTO `wp_options` VALUES("139519","wpdbbkp_dashboard_notify","create","off");
INSERT INTO `wp_options` VALUES("139833","jetpack_search_plan_info","a:3:{s:23:\"supports_instant_search\";b:0;s:28:\"supports_only_classic_search\";b:0;s:15:\"supports_search\";b:0;}","auto");
INSERT INTO `wp_options` VALUES("139992","jetpack_boost_ds_performance_history_toggle","1","off");
INSERT INTO `wp_options` VALUES("140104","jetpack_activated","1","auto");
INSERT INTO `wp_options` VALUES("140109","jetpack_activation_source","a:2:{i:0;s:7:\"unknown\";i:1;N;}","auto");
INSERT INTO `wp_options` VALUES("140112","jetpack_available_modules","a:1:{s:6:\"15.1.1\";a:43:{s:18:\"account-protection\";s:4:\"14.5\";s:5:\"blaze\";s:4:\"12.3\";s:6:\"blocks\";s:8:\"13.9-a.8\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:12:\"google-fonts\";s:6:\"10.8.0\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"post-list\";s:4:\"11.3\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:3:\"waf\";s:4:\"10.9\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}","auto");
INSERT INTO `wp_options` VALUES("140113","jetpack_active_modules_initialized","1","auto");
INSERT INTO `wp_options` VALUES("140114","jetpack_waf_mode","normal","auto");
INSERT INTO `wp_options` VALUES("140115","jetpack_waf_rules_version","1.0.0","auto");
INSERT INTO `wp_options` VALUES("140116","jetpack_protect_activating","activating","off");
INSERT INTO `wp_options` VALUES("140121","jetpack_testimonial","0","auto");
INSERT INTO `wp_options` VALUES("140137","do_activate","0","auto");
INSERT INTO `wp_options` VALUES("140167","sharing-options","a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:4:\"icon\";s:13:\"sharing_label\";b:0;s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";}s:6:\"custom\";a:0:{}}}","auto");
INSERT INTO `wp_options` VALUES("140168","post_by_email_address1","NULL","auto");
INSERT INTO `wp_options` VALUES("140169","monitor_receive_notifications","1","auto");
INSERT INTO `wp_options` VALUES("140202","tiled_galleries","1","auto");
INSERT INTO `wp_options` VALUES("140227","sharedaddy_disable_resources","0","auto");
INSERT INTO `wp_options` VALUES("140267","sharing-services","a:2:{s:7:\"visible\";a:13:{i:0;s:8:\"facebook\";i:1;s:1:\"x\";i:2;s:8:\"telegram\";i:3;s:7:\"threads\";i:4;s:16:\"jetpack-whatsapp\";i:5;s:6:\"reddit\";i:6;s:6:\"tumblr\";i:7;s:7:\"twitter\";i:8;s:9:\"pinterest\";i:9;s:6:\"pocket\";i:10;s:8:\"mastodon\";i:11;s:8:\"nextdoor\";i:12;s:7:\"bluesky\";}s:6:\"hidden\";a:0:{}}","auto");
INSERT INTO `wp_options` VALUES("140292","verification_services_codes","0","auto");
INSERT INTO `wp_options` VALUES("140295","open_graph_protocol_site_type","","auto");
INSERT INTO `wp_options` VALUES("140296","facebook_admins","a:0:{}","auto");
INSERT INTO `wp_options` VALUES("140297","jetpack-twitter-cards-site-tag","","auto");
INSERT INTO `wp_options` VALUES("140885","jetpack_log","a:25:{i:0;a:5:{s:4:\"time\";i:1722273420;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"8.1.6\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.8.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.6.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"8.1.5\";}s:6:\"result\";b:1;s:4:\"name\";s:17:\"Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:34:\"Updating plugin: Really Simple SSL\";i:1;s:97:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.8.1.6.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"8.1.6\";s:7:\"updated\";s:19:\"2024-07-29 12:52:23\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.1.6/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-8.1.6-en_gb/\";s:12:\"source_files\";a:13:{i:0;s:61:\"really-simple-ssl-en_GB-0b4bb6c641e5d439dfc95999bd9232ae.json\";i:1;s:61:\"really-simple-ssl-en_GB-1c216eb5d099cac6b1a2f9cc53f4cb9b.json\";i:2;s:61:\"really-simple-ssl-en_GB-9fe60b9f3db35b66e01e6a16d56b9b33.json\";i:3;s:61:\"really-simple-ssl-en_GB-b9552aaaefa0f9a844590ffcc51524c5.json\";i:4;s:61:\"really-simple-ssl-en_GB-0095b576f64c1698d1d23c725d2da1ad.json\";i:5;s:26:\"really-simple-ssl-en_GB.po\";i:6;s:61:\"really-simple-ssl-en_GB-3c58b6e7c8b62fd3599df0641e21c59c.json\";i:7;s:61:\"really-simple-ssl-en_GB-073065ad071f470ef419934d8cbb0426.json\";i:8;s:61:\"really-simple-ssl-en_GB-372680c0a7defe787573862720114f8c.json\";i:9;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:10;s:61:\"really-simple-ssl-en_GB-bf650d751228aee72abb21a7d075cf38.json\";i:11;s:26:\"really-simple-ssl-en_GB.mo\";i:12;s:61:\"really-simple-ssl-en_GB-ddd1902b465940be916d5efa8947f128.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:34:\"Translations for Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:58:\"Updating translations for Really Simple SSL (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.1.6/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:1;a:5:{s:4:\"time\";i:1722450958;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"8.1.6\";s:7:\"updated\";s:19:\"2024-07-30 08:03:37\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.1.6/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-8.1.6-en_gb/\";s:12:\"source_files\";a:13:{i:0;s:61:\"really-simple-ssl-en_GB-0b4bb6c641e5d439dfc95999bd9232ae.json\";i:1;s:61:\"really-simple-ssl-en_GB-1c216eb5d099cac6b1a2f9cc53f4cb9b.json\";i:2;s:61:\"really-simple-ssl-en_GB-9fe60b9f3db35b66e01e6a16d56b9b33.json\";i:3;s:61:\"really-simple-ssl-en_GB-b9552aaaefa0f9a844590ffcc51524c5.json\";i:4;s:61:\"really-simple-ssl-en_GB-0095b576f64c1698d1d23c725d2da1ad.json\";i:5;s:26:\"really-simple-ssl-en_GB.po\";i:6;s:61:\"really-simple-ssl-en_GB-3c58b6e7c8b62fd3599df0641e21c59c.json\";i:7;s:61:\"really-simple-ssl-en_GB-073065ad071f470ef419934d8cbb0426.json\";i:8;s:61:\"really-simple-ssl-en_GB-372680c0a7defe787573862720114f8c.json\";i:9;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:10;s:61:\"really-simple-ssl-en_GB-bf650d751228aee72abb21a7d075cf38.json\";i:11;s:26:\"really-simple-ssl-en_GB.mo\";i:12;s:61:\"really-simple-ssl-en_GB-ddd1902b465940be916d5efa8947f128.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:34:\"Translations for Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:58:\"Updating translations for Really Simple SSL (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.1.6/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:2;a:5:{s:4:\"time\";i:1722546967;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:30:\"w.org/plugins/burst-statistics\";s:4:\"slug\";s:16:\"burst-statistics\";s:6:\"plugin\";s:26:\"burst-statistics/burst.php\";s:11:\"new_version\";s:5:\"1.7.0\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/burst-statistics/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/burst-statistics.1.7.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/burst-statistics/assets/icon-256x256.png?rev=2672964\";s:2:\"1x\";s:69:\"https://ps.w.org/burst-statistics/assets/icon-128x128.png?rev=2672964\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/burst-statistics/assets/banner-1544x500.png?rev=2672964\";s:2:\"1x\";s:71:\"https://ps.w.org/burst-statistics/assets/banner-772x250.png?rev=2672964\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.6.1\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"1.6.1\";}s:6:\"result\";b:1;s:4:\"name\";s:59:\"Burst Statistics - Privacy-Friendly Analytics for WordPress\";s:8:\"messages\";a:6:{i:0;s:76:\"Updating plugin: Burst Statistics - Privacy-Friendly Analytics for WordPress\";i:1;s:96:\"Downloading update from https://downloads.wordpress.org/plugin/burst-statistics.1.7.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:28:\"w.org/plugins/jetpack-social\";s:4:\"slug\";s:14:\"jetpack-social\";s:6:\"plugin\";s:33:\"jetpack-social/jetpack-social.php\";s:11:\"new_version\";s:5:\"5.0.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/jetpack-social/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/jetpack-social.5.0.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";s:3:\"svg\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/jetpack-social/assets/banner-1544x500.png?rev=2778707\";s:2:\"1x\";s:69:\"https://ps.w.org/jetpack-social/assets/banner-772x250.png?rev=2778707\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.6.1\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"4.5.2\";}s:6:\"result\";b:1;s:4:\"name\";s:14:\"Jetpack Social\";s:8:\"messages\";a:6:{i:0;s:31:\"Updating plugin: Jetpack Social\";i:1;s:94:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack-social.5.0.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:16:\"burst-statistics\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:19:\"2024-08-01 13:40:39\";s:7:\"package\";s:83:\"https://downloads.wordpress.org/translation/plugin/burst-statistics/1.7.0/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:91:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/burst-statistics-1.7.0-en_gb/\";s:12:\"source_files\";a:9:{i:0;s:60:\"burst-statistics-en_GB-377936d6a6158a1981bfce3963e913c7.json\";i:1;s:60:\"burst-statistics-en_GB-a0567252995d8c31742aaf19ef7b759c.json\";i:2;s:25:\"burst-statistics-en_GB.mo\";i:3;s:60:\"burst-statistics-en_GB-89970e46103f90ae380f6b336f2a1093.json\";i:4;s:31:\"burst-statistics-en_GB.l10n.php\";i:5;s:25:\"burst-statistics-en_GB.po\";i:6;s:60:\"burst-statistics-en_GB-1868439152d8046cfcee9710f4e9e3d3.json\";i:7;s:60:\"burst-statistics-en_GB-1b39609b8e7e1e08f68b261d8252f7ba.json\";i:8;s:60:\"burst-statistics-en_GB-934c17cb20dd15c6ac9b9a625b2fe492.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:76:\"Translations for Burst Statistics - Privacy-Friendly Analytics for WordPress\";s:8:\"messages\";a:6:{i:0;s:100:\"Updating translations for Burst Statistics - Privacy-Friendly Analytics for WordPress (en_GB)&#8230;\";i:1;s:119:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/burst-statistics/1.7.0/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:23:\"plugin:burst-statistics\";}}}}i:3;a:5:{s:4:\"time\";i:1722978969;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"13.7\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.13.7.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.6.1\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"13.6\";}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Jetpack\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Jetpack\";i:1;s:86:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.13.7.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"13.7\";s:7:\"updated\";s:19:\"2024-08-06 17:53:08\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/13.7/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-13.7-en_gb/\";s:12:\"source_files\";a:29:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:14;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:15;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:16;s:16:\"jetpack-en_GB.po\";i:17;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:18;s:22:\"jetpack-en_GB.l10n.php\";i:19;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:20;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:21;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:22;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:23;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:24;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:25;s:51:\"jetpack-en_GB-d22c30dba935395cccce55a08f020343.json\";i:26;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:27;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:28;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/13.7/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:4;a:5:{s:4:\"time\";i:1723540562;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:16:\"burst-statistics\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.1\";s:7:\"updated\";s:19:\"2024-08-13 06:17:20\";s:7:\"package\";s:83:\"https://downloads.wordpress.org/translation/plugin/burst-statistics/1.7.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:91:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/burst-statistics-1.7.1-en_gb/\";s:12:\"source_files\";a:10:{i:0;s:60:\"burst-statistics-en_GB-377936d6a6158a1981bfce3963e913c7.json\";i:1;s:60:\"burst-statistics-en_GB-a0567252995d8c31742aaf19ef7b759c.json\";i:2;s:25:\"burst-statistics-en_GB.mo\";i:3;s:60:\"burst-statistics-en_GB-89970e46103f90ae380f6b336f2a1093.json\";i:4;s:31:\"burst-statistics-en_GB.l10n.php\";i:5;s:25:\"burst-statistics-en_GB.po\";i:6;s:60:\"burst-statistics-en_GB-1868439152d8046cfcee9710f4e9e3d3.json\";i:7;s:60:\"burst-statistics-en_GB-1b39609b8e7e1e08f68b261d8252f7ba.json\";i:8;s:60:\"burst-statistics-en_GB-934c17cb20dd15c6ac9b9a625b2fe492.json\";i:9;s:60:\"burst-statistics-en_GB-6231805d66220c50c039fdfb343a2dd9.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:76:\"Translations for Burst Statistics - Privacy-Friendly Analytics for WordPress\";s:8:\"messages\";a:6:{i:0;s:100:\"Updating translations for Burst Statistics - Privacy-Friendly Analytics for WordPress (en_GB)&#8230;\";i:1;s:119:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/burst-statistics/1.7.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:23:\"plugin:burst-statistics\";}}}}i:5;a:5:{s:4:\"time\";i:1724706927;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:7:\"8.3.0.1\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/really-simple-ssl.8.3.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.5.5\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"8.1.6\";}s:6:\"result\";b:1;s:4:\"name\";s:17:\"Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:34:\"Updating plugin: Really Simple SSL\";i:1;s:99:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.8.3.0.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:7:\"8.3.0.1\";s:7:\"updated\";s:19:\"2024-08-26 13:21:25\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.3.0.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:94:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-8.3.0.1-en_gb/\";s:12:\"source_files\";a:13:{i:0;s:61:\"really-simple-ssl-en_GB-0b4bb6c641e5d439dfc95999bd9232ae.json\";i:1;s:61:\"really-simple-ssl-en_GB-fddd49076f9fe8d84dcebe2fffbee173.json\";i:2;s:61:\"really-simple-ssl-en_GB-674c83d81a7b6ea6bdef4cc2caf638c5.json\";i:3;s:61:\"really-simple-ssl-en_GB-0095b576f64c1698d1d23c725d2da1ad.json\";i:4;s:61:\"really-simple-ssl-en_GB-aa48e3a9322e5983a272cc780a628b94.json\";i:5;s:26:\"really-simple-ssl-en_GB.po\";i:6;s:61:\"really-simple-ssl-en_GB-3c58b6e7c8b62fd3599df0641e21c59c.json\";i:7;s:61:\"really-simple-ssl-en_GB-b146092a9318516ca05e01363050ef72.json\";i:8;s:61:\"really-simple-ssl-en_GB-ab4407349f28e6406e58d38d73fc68aa.json\";i:9;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:10;s:61:\"really-simple-ssl-en_GB-bf650d751228aee72abb21a7d075cf38.json\";i:11;s:26:\"really-simple-ssl-en_GB.mo\";i:12;s:61:\"really-simple-ssl-en_GB-7ffe7f3ac111abecaf93f3a95151bb1c.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:34:\"Translations for Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:58:\"Updating translations for Really Simple SSL (en_GB)&#8230;\";i:1;s:122:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.3.0.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:6;a:5:{s:4:\"time\";i:1725484529;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"13.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.13.8.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.6.1\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"13.7\";}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Jetpack\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Jetpack\";i:1;s:86:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.13.8.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"13.8\";s:7:\"updated\";s:19:\"2024-09-04 19:06:41\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/13.8/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-13.8-en_gb/\";s:12:\"source_files\";a:29:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:14;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:15;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:16;s:16:\"jetpack-en_GB.po\";i:17;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:18;s:22:\"jetpack-en_GB.l10n.php\";i:19;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:20;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:21;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:22;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:23;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:24;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:25;s:51:\"jetpack-en_GB-d22c30dba935395cccce55a08f020343.json\";i:26;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:27;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:28;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/13.8/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:7;a:5:{s:4:\"time\";i:1726521337;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:7:\"8.3.0.1\";s:7:\"updated\";s:19:\"2024-09-16 11:10:06\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.3.0.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:94:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-8.3.0.1-en_gb/\";s:12:\"source_files\";a:13:{i:0;s:61:\"really-simple-ssl-en_GB-0b4bb6c641e5d439dfc95999bd9232ae.json\";i:1;s:61:\"really-simple-ssl-en_GB-fddd49076f9fe8d84dcebe2fffbee173.json\";i:2;s:61:\"really-simple-ssl-en_GB-674c83d81a7b6ea6bdef4cc2caf638c5.json\";i:3;s:61:\"really-simple-ssl-en_GB-0095b576f64c1698d1d23c725d2da1ad.json\";i:4;s:61:\"really-simple-ssl-en_GB-aa48e3a9322e5983a272cc780a628b94.json\";i:5;s:26:\"really-simple-ssl-en_GB.po\";i:6;s:61:\"really-simple-ssl-en_GB-3c58b6e7c8b62fd3599df0641e21c59c.json\";i:7;s:61:\"really-simple-ssl-en_GB-b146092a9318516ca05e01363050ef72.json\";i:8;s:61:\"really-simple-ssl-en_GB-ab4407349f28e6406e58d38d73fc68aa.json\";i:9;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:10;s:61:\"really-simple-ssl-en_GB-bf650d751228aee72abb21a7d075cf38.json\";i:11;s:26:\"really-simple-ssl-en_GB.mo\";i:12;s:61:\"really-simple-ssl-en_GB-7ffe7f3ac111abecaf93f3a95151bb1c.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:34:\"Translations for Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:58:\"Updating translations for Really Simple SSL (en_GB)&#8230;\";i:1;s:122:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/8.3.0.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:8;a:5:{s:4:\"time\";i:1726564480;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.0.0\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.0.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:7:\"8.3.0.1\";}s:6:\"result\";b:1;s:4:\"name\";s:17:\"Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:34:\"Updating plugin: Really Simple SSL\";i:1;s:97:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.9.0.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.0.0\";s:7:\"updated\";s:19:\"2024-09-17 07:31:29\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.0.0/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.0.0-en_gb/\";s:12:\"source_files\";a:17:{i:0;s:61:\"really-simple-ssl-en_GB-0b4bb6c641e5d439dfc95999bd9232ae.json\";i:1;s:61:\"really-simple-ssl-en_GB-ef9f07b3b54711801a34147958e12504.json\";i:2;s:61:\"really-simple-ssl-en_GB-674c83d81a7b6ea6bdef4cc2caf638c5.json\";i:3;s:61:\"really-simple-ssl-en_GB-0095b576f64c1698d1d23c725d2da1ad.json\";i:4;s:26:\"really-simple-ssl-en_GB.po\";i:5;s:61:\"really-simple-ssl-en_GB-3894b089cd82666e9a4e77535094da45.json\";i:6;s:61:\"really-simple-ssl-en_GB-3c58b6e7c8b62fd3599df0641e21c59c.json\";i:7;s:61:\"really-simple-ssl-en_GB-15f6778886f6647b0040e73346153a73.json\";i:8;s:61:\"really-simple-ssl-en_GB-84af82b5ae42fa9ccd14a0bc0c1cbfaf.json\";i:9;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:10;s:61:\"really-simple-ssl-en_GB-bf650d751228aee72abb21a7d075cf38.json\";i:11;s:61:\"really-simple-ssl-en_GB-b79855382f99d4660356e1a4e4947d6d.json\";i:12;s:26:\"really-simple-ssl-en_GB.mo\";i:13;s:61:\"really-simple-ssl-en_GB-2c14c1c7d5701789f05ed9f25401ff0b.json\";i:14;s:61:\"really-simple-ssl-en_GB-fa4f7a887e789803d5ccfcbce66aa812.json\";i:15;s:61:\"really-simple-ssl-en_GB-5a61f05e4931284797a13bb6216a5f0a.json\";i:16;s:61:\"really-simple-ssl-en_GB-df279e5f0e6d1ac85a692e21470ce62f.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:34:\"Translations for Really Simple SSL\";s:8:\"messages\";a:6:{i:0;s:58:\"Updating translations for Really Simple SSL (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.0.0/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:9;a:5:{s:4:\"time\";i:1726694146;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"jetpack-boost\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.4.9\";s:7:\"updated\";s:19:\"2024-09-18 13:48:01\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.4.9/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:88:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-boost-3.4.9-en_gb/\";s:12:\"source_files\";a:6:{i:0;s:22:\"jetpack-boost-en_GB.po\";i:1;s:57:\"jetpack-boost-en_GB-ebf07196b96d7e69ef7b14042e01c8c3.json\";i:2;s:28:\"jetpack-boost-en_GB.l10n.php\";i:3;s:57:\"jetpack-boost-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:4;s:57:\"jetpack-boost-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:5;s:22:\"jetpack-boost-en_GB.mo\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:30:\"Translations for Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:54:\"Updating translations for Jetpack Boost (en_GB)&#8230;\";i:1;s:116:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.4.9/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:jetpack-boost\";}}}}i:10;a:5:{s:4:\"time\";i:1727817365;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"13.9\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.13.9.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"13.8.1\";}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Jetpack\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Jetpack\";i:1;s:86:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.13.9.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"13.9\";s:7:\"updated\";s:19:\"2024-10-01 18:52:49\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/13.9/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-13.9-en_gb/\";s:12:\"source_files\";a:30:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:14;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:15;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:16;s:16:\"jetpack-en_GB.po\";i:17;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:18;s:22:\"jetpack-en_GB.l10n.php\";i:19;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:20;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:21;s:51:\"jetpack-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:22;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:23;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:24;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:25;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:26;s:51:\"jetpack-en_GB-d22c30dba935395cccce55a08f020343.json\";i:27;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:28;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:29;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/13.9/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:11;a:5:{s:4:\"time\";i:1727903638;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"13.9\";s:7:\"updated\";s:19:\"2024-10-02 16:20:13\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/13.9/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-13.9-en_gb/\";s:12:\"source_files\";a:30:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:14;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:15;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:16;s:16:\"jetpack-en_GB.po\";i:17;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:18;s:22:\"jetpack-en_GB.l10n.php\";i:19;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:20;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:21;s:51:\"jetpack-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:22;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:23;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:24;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:25;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:26;s:51:\"jetpack-en_GB-d22c30dba935395cccce55a08f020343.json\";i:27;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:28;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:29;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/13.9/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:12;a:5:{s:4:\"time\";i:1729026979;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/jetpack-boost\";s:4:\"slug\";s:13:\"jetpack-boost\";s:6:\"plugin\";s:31:\"jetpack-boost/jetpack-boost.php\";s:11:\"new_version\";s:5:\"3.5.2\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/jetpack-boost/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/jetpack-boost.3.5.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";s:3:\"svg\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/jetpack-boost/assets/banner-1544x500.png?rev=2653958\";s:2:\"1x\";s:68:\"https://ps.w.org/jetpack-boost/assets/banner-772x250.png?rev=2653958\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"3.5.1\";}s:6:\"result\";b:1;s:4:\"name\";s:13:\"Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:30:\"Updating plugin: Jetpack Boost\";i:1;s:93:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack-boost.3.5.2.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"jetpack-boost\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.5.2\";s:7:\"updated\";s:19:\"2024-10-15 12:18:31\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.5.2/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:88:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-boost-3.5.2-en_gb/\";s:12:\"source_files\";a:7:{i:0;s:57:\"jetpack-boost-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:1;s:22:\"jetpack-boost-en_GB.po\";i:2;s:57:\"jetpack-boost-en_GB-ebf07196b96d7e69ef7b14042e01c8c3.json\";i:3;s:28:\"jetpack-boost-en_GB.l10n.php\";i:4;s:57:\"jetpack-boost-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:5;s:57:\"jetpack-boost-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:6;s:22:\"jetpack-boost-en_GB.mo\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:30:\"Translations for Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:54:\"Updating translations for Jetpack Boost (en_GB)&#8230;\";i:1;s:116:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.5.2/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:jetpack-boost\";}}}}i:13;a:5:{s:4:\"time\";i:1733394082;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"14.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.14.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"14.0\";}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Jetpack\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Jetpack\";i:1;s:86:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.14.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:28:\"w.org/plugins/nimble-builder\";s:4:\"slug\";s:14:\"nimble-builder\";s:6:\"plugin\";s:33:\"nimble-builder/nimble-builder.php\";s:11:\"new_version\";s:5:\"3.3.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/nimble-builder/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/nimble-builder.3.3.6.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/nimble-builder/assets/icon.svg?rev=1986014\";s:3:\"svg\";s:59:\"https://ps.w.org/nimble-builder/assets/icon.svg?rev=1986014\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/nimble-builder/assets/banner-1544x500.jpg?rev=1986014\";s:2:\"1x\";s:69:\"https://ps.w.org/nimble-builder/assets/banner-772x250.jpg?rev=1986014\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"3.3.5\";}s:6:\"result\";b:1;s:4:\"name\";s:19:\"Nimble Page Builder\";s:8:\"messages\";a:6:{i:0;s:36:\"Updating plugin: Nimble Page Builder\";i:1;s:94:\"Downloading update from https://downloads.wordpress.org/plugin/nimble-builder.3.3.6.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"14.1\";s:7:\"updated\";s:19:\"2024-12-03 23:12:34\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/14.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-14.1-en_gb/\";s:12:\"source_files\";a:29:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:14;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:15;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:16;s:16:\"jetpack-en_GB.po\";i:17;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:18;s:22:\"jetpack-en_GB.l10n.php\";i:19;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:20;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:21;s:51:\"jetpack-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:22;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:23;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:24;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:25;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:26;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:27;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:28;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/14.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:14;a:5:{s:4:\"time\";i:1740086125;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:4:\"14.3\";s:7:\"updated\";s:19:\"2025-02-20 19:47:04\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/plugin/jetpack/14.3/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:81:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-14.3-en_gb/\";s:12:\"source_files\";a:31:{i:0;s:51:\"jetpack-en_GB-27f144e22b9d44c9b4e55a0d29e11244.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-69677086a93fca1f16db30b2da0d6c44.json\";i:13;s:51:\"jetpack-en_GB-75205eaf16548b329c0a828163f3900b.json\";i:14;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:15;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:16;s:51:\"jetpack-en_GB-0167f266e4b6ce6543049f3e9896a693.json\";i:17;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:18;s:16:\"jetpack-en_GB.po\";i:19;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:20;s:22:\"jetpack-en_GB.l10n.php\";i:21;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:22;s:51:\"jetpack-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:23;s:51:\"jetpack-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:24;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:25;s:51:\"jetpack-en_GB-f2fec8be18a8ebb735f851bee375cb5f.json\";i:26;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:27;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:28;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:29;s:51:\"jetpack-en_GB-1bac79e646a8bf4081a5011ab72d5807.json\";i:30;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:109:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/14.3/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:14:\"plugin:jetpack\";}}}}i:15;a:5:{s:4:\"time\";i:1740604525;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"jetpack-boost\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.9.0\";s:7:\"updated\";s:19:\"2025-02-26 13:48:02\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.9.0/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:88:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-boost-3.9.0-en_gb/\";s:12:\"source_files\";a:7:{i:0;s:57:\"jetpack-boost-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:1;s:22:\"jetpack-boost-en_GB.po\";i:2;s:57:\"jetpack-boost-en_GB-ebf07196b96d7e69ef7b14042e01c8c3.json\";i:3;s:28:\"jetpack-boost-en_GB.l10n.php\";i:4;s:57:\"jetpack-boost-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:5;s:57:\"jetpack-boost-en_GB-8d7cc819888d3ac362c235ff94809c9a.json\";i:6;s:22:\"jetpack-boost-en_GB.mo\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:30:\"Translations for Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:54:\"Updating translations for Jetpack Boost (en_GB)&#8230;\";i:1;s:116:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack-boost/3.9.0/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:jetpack-boost\";}}}}i:16;a:5:{s:4:\"time\";i:1748466963;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.3.5\";s:7:\"updated\";s:19:\"2025-05-28 12:17:44\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.3.5/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.3.5-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-f903632dc12fbaa3f179fb893d1690f7.json\";i:1;s:61:\"really-simple-ssl-en_GB-41bd23a5a07cfdcee0fe318f819a6eed.json\";i:2;s:61:\"really-simple-ssl-en_GB-38e562ee038bfb8031a370e0f01f2b39.json\";i:3;s:26:\"really-simple-ssl-en_GB.po\";i:4;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:5;s:61:\"really-simple-ssl-en_GB-203d99aa0e2973fb2d8b5fc6e2b5539f.json\";i:6;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:7;s:26:\"really-simple-ssl-en_GB.mo\";i:8;s:61:\"really-simple-ssl-en_GB-360ee2df23d5eaf2621ba1031406d1a1.json\";i:9;s:61:\"really-simple-ssl-en_GB-5bfce13e2f10879923047fc30a41a341.json\";i:10;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:11;s:61:\"really-simple-ssl-en_GB-d193f0cc5373f0a49e5ddca05f9f5867.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.3.5/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:17;a:5:{s:4:\"time\";i:1749762931;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.4.0\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.4.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"9.3.5\";}s:6:\"result\";b:1;s:4:\"name\";s:22:\"Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:39:\"Updating plugin: Really Simple Security\";i:1;s:97:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.9.4.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.4.0\";s:7:\"updated\";s:19:\"2025-06-12 12:32:11\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.0/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.4.0-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:1;s:26:\"really-simple-ssl-en_GB.po\";i:2;s:61:\"really-simple-ssl-en_GB-7e9334822d11312e41826d63577f541a.json\";i:3;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:4;s:61:\"really-simple-ssl-en_GB-6bf567f0ae100d411bde92087b8f0bbd.json\";i:5;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:6;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:7;s:26:\"really-simple-ssl-en_GB.mo\";i:8;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:9;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:10;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";i:11;s:61:\"really-simple-ssl-en_GB-2b26b46e405bda898dd726408205fab0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.0/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:18;a:5:{s:4:\"time\";i:1750756538;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.4.1\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"9.4.0\";}s:6:\"result\";b:1;s:4:\"name\";s:22:\"Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:39:\"Updating plugin: Really Simple Security\";i:1;s:97:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.9.4.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.4.1\";s:7:\"updated\";s:19:\"2025-06-24 07:48:54\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.4.1-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:1;s:26:\"really-simple-ssl-en_GB.po\";i:2;s:61:\"really-simple-ssl-en_GB-7e9334822d11312e41826d63577f541a.json\";i:3;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:4;s:61:\"really-simple-ssl-en_GB-6bf567f0ae100d411bde92087b8f0bbd.json\";i:5;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:6;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:7;s:26:\"really-simple-ssl-en_GB.mo\";i:8;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:9;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:10;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";i:11;s:61:\"really-simple-ssl-en_GB-2b26b46e405bda898dd726408205fab0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:19;a:5:{s:4:\"time\";i:1754428521;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"14.9\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.14.9.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"14.8\";}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Jetpack\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Jetpack\";i:1;s:86:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.14.9.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:28:\"w.org/plugins/jetpack-social\";s:4:\"slug\";s:14:\"jetpack-social\";s:6:\"plugin\";s:33:\"jetpack-social/jetpack-social.php\";s:11:\"new_version\";s:5:\"7.1.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/jetpack-social/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/jetpack-social.7.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";s:3:\"svg\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/jetpack-social/assets/banner-1544x500.png?rev=2778707\";s:2:\"1x\";s:69:\"https://ps.w.org/jetpack-social/assets/banner-772x250.png?rev=2778707\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"7.0.0\";}s:6:\"result\";b:1;s:4:\"name\";s:14:\"Jetpack Social\";s:8:\"messages\";a:6:{i:0;s:31:\"Updating plugin: Jetpack Social\";i:1;s:94:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack-social.7.1.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.4.3\";s:7:\"updated\";s:19:\"2025-08-05 13:39:11\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.3/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:75:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/en_GB-QXkxUc/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:1;s:26:\"really-simple-ssl-en_GB.po\";i:2;s:61:\"really-simple-ssl-en_GB-7e9334822d11312e41826d63577f541a.json\";i:3;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:4;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:5;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:6;s:26:\"really-simple-ssl-en_GB.mo\";i:7;s:61:\"really-simple-ssl-en_GB-7784ddbe33ba820b8a52d0f6aa287cf8.json\";i:8;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:9;s:61:\"really-simple-ssl-en_GB-b501f82ba7331371dd34b566c9c89860.json\";i:10;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:11;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.4.3/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:20;a:5:{s:4:\"time\";i:1758705302;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.5.1\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:7:\"9.5.0.2\";}s:6:\"result\";b:1;s:4:\"name\";s:22:\"Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:39:\"Updating plugin: Really Simple Security\";i:1;s:97:\"Downloading update from https://downloads.wordpress.org/plugin/really-simple-ssl.9.5.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.5.1\";s:7:\"updated\";s:19:\"2025-09-23 08:32:19\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.5.1-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-2fe5998d9410c6bf9c7a773ff9ffee8d.json\";i:1;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:2;s:26:\"really-simple-ssl-en_GB.po\";i:3;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:4;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:5;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:6;s:61:\"really-simple-ssl-en_GB-05fb6fac90c05a83b2068fd63a3ac669.json\";i:7;s:26:\"really-simple-ssl-en_GB.mo\";i:8;s:61:\"really-simple-ssl-en_GB-7784ddbe33ba820b8a52d0f6aa287cf8.json\";i:9;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:10;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:11;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:21;a:5:{s:4:\"time\";i:1759914914;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:7:\"9.5.2.2\";s:7:\"updated\";s:19:\"2025-10-08 08:12:43\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.2.2/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:94:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.5.2.2-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:1;s:26:\"really-simple-ssl-en_GB.po\";i:2;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:3;s:61:\"really-simple-ssl-en_GB-ceada65f7358637df205b2e904555292.json\";i:4;s:61:\"really-simple-ssl-en_GB-3c73aad6aa7598ec29f11c7a36da3e91.json\";i:5;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:6;s:26:\"really-simple-ssl-en_GB.mo\";i:7;s:61:\"really-simple-ssl-en_GB-efbda1adf0da11cd15fcf712312be23a.json\";i:8;s:61:\"really-simple-ssl-en_GB-7784ddbe33ba820b8a52d0f6aa287cf8.json\";i:9;s:61:\"really-simple-ssl-en_GB-294561b840091d10d2897b8a56d1f5c1.json\";i:10;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:11;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:122:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.2.2/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}i:22;a:5:{s:4:\"time\";i:1760390120;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"akismet\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"5.5\";s:7:\"updated\";s:19:\"2025-10-13 12:03:08\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/plugin/akismet/5.5/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:80:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/akismet-5.5-en_gb/\";s:12:\"source_files\";a:3:{i:0;s:16:\"akismet-en_GB.po\";i:1;s:16:\"akismet-en_GB.mo\";i:2;s:22:\"akismet-en_GB.l10n.php\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:51:\"Translations for Akismet Anti-spam: Spam Protection\";s:8:\"messages\";a:6:{i:0;s:75:\"Updating translations for Akismet Anti-spam: Spam Protection (en_GB)&#8230;\";i:1;s:108:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/akismet/5.5/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"jetpack\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"15.1.1\";s:7:\"updated\";s:19:\"2025-10-13 12:13:28\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/translation/plugin/jetpack/15.1.1/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:83:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-15.1.1-en_gb/\";s:12:\"source_files\";a:33:{i:0;s:51:\"jetpack-en_GB-66db072beeffdbc9f16406be03975055.json\";i:1;s:51:\"jetpack-en_GB-f2b234a1eb36d7500074cd58bfbd9b1c.json\";i:2;s:51:\"jetpack-en_GB-f6670db2c5ad7c2c86f45179f56a7ca9.json\";i:3;s:51:\"jetpack-en_GB-554ecab996622b1334be87a17ae022de.json\";i:4;s:51:\"jetpack-en_GB-62e43f7d6792ea2be029a71950464bf3.json\";i:5;s:51:\"jetpack-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:6;s:51:\"jetpack-en_GB-c6f94343b6379d3dda4a697514e96d02.json\";i:7;s:51:\"jetpack-en_GB-bf3e383be435d83a2459a4462233b979.json\";i:8;s:51:\"jetpack-en_GB-c5dc571685340e9b475a95252117d2c7.json\";i:9;s:51:\"jetpack-en_GB-7dae60c198ed9f69d176dfd7ea217d88.json\";i:10;s:16:\"jetpack-en_GB.mo\";i:11;s:51:\"jetpack-en_GB-4ecdb48266dceea37c977503447f349c.json\";i:12;s:51:\"jetpack-en_GB-bf6a5f88e58a208ae4807d76acb5bbac.json\";i:13;s:51:\"jetpack-en_GB-35af72e2b94b0e96cd38139871d6af9d.json\";i:14;s:51:\"jetpack-en_GB-75205eaf16548b329c0a828163f3900b.json\";i:15;s:51:\"jetpack-en_GB-95040824fe31ba694278a70050adaa46.json\";i:16;s:51:\"jetpack-en_GB-2830d0baff716a2e4109fd6df428a8a8.json\";i:17;s:51:\"jetpack-en_GB-0167f266e4b6ce6543049f3e9896a693.json\";i:18;s:51:\"jetpack-en_GB-a10b91e0b186c0a8ec1f9c913319c624.json\";i:19;s:16:\"jetpack-en_GB.po\";i:20;s:51:\"jetpack-en_GB-e48297939dadcf2a16dec6bb472204f5.json\";i:21;s:51:\"jetpack-en_GB-a9db040a8837f9367b1f92a70f3d51e0.json\";i:22;s:22:\"jetpack-en_GB.l10n.php\";i:23;s:51:\"jetpack-en_GB-08a44c15ee3a7292b50075342bd24e4d.json\";i:24;s:51:\"jetpack-en_GB-0964953ddc4d31526b971bae5fc59f60.json\";i:25;s:51:\"jetpack-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:26;s:51:\"jetpack-en_GB-5526f2d846aa8a4c9e44813ad8e94bbb.json\";i:27;s:51:\"jetpack-en_GB-db7f39b584eeeb1e17097396bd63d618.json\";i:28;s:51:\"jetpack-en_GB-d1114d13658cd1116d9e4f79f56ea595.json\";i:29;s:51:\"jetpack-en_GB-1c7420c5c99c6ed7a03f7b6f7fe38302.json\";i:30;s:51:\"jetpack-en_GB-ba4064db8ab113111b65050d6a9cdd2c.json\";i:31;s:51:\"jetpack-en_GB-94768ea01bd74c6cbddeacb66a15e82d.json\";i:32;s:51:\"jetpack-en_GB-a92df450dcecb4ab69728221dfbe2cc1.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:24:\"Translations for Jetpack\";s:8:\"messages\";a:6:{i:0;s:48:\"Updating translations for Jetpack (en_GB)&#8230;\";i:1;s:111:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack/15.1.1/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:2:{i:0;s:14:\"plugin:akismet\";i:1;s:14:\"plugin:jetpack\";}}}}i:23;a:5:{s:4:\"time\";i:1760562902;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/jetpack-boost\";s:4:\"slug\";s:13:\"jetpack-boost\";s:6:\"plugin\";s:31:\"jetpack-boost/jetpack-boost.php\";s:11:\"new_version\";s:5:\"4.5.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/jetpack-boost/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/jetpack-boost.4.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";s:3:\"svg\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/jetpack-boost/assets/banner-1544x500.png?rev=2653958\";s:2:\"1x\";s:68:\"https://ps.w.org/jetpack-boost/assets/banner-772x250.png?rev=2653958\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"4.4.0\";}s:6:\"result\";b:1;s:4:\"name\";s:13:\"Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:30:\"Updating plugin: Jetpack Boost\";i:1;s:93:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack-boost.4.5.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"jetpack-boost\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:19:\"2025-10-15 13:48:18\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/jetpack-boost/4.5.0/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:88:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/jetpack-boost-4.5.0-en_gb/\";s:12:\"source_files\";a:5:{i:0;s:57:\"jetpack-boost-en_GB-7221b325c2a766b72f33c74092369ea7.json\";i:1;s:22:\"jetpack-boost-en_GB.po\";i:2;s:28:\"jetpack-boost-en_GB.l10n.php\";i:3;s:57:\"jetpack-boost-en_GB-582bb18aafa8130caa006d1e3420849c.json\";i:4;s:22:\"jetpack-boost-en_GB.mo\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:30:\"Translations for Jetpack Boost\";s:8:\"messages\";a:6:{i:0;s:54:\"Updating translations for Jetpack Boost (en_GB)&#8230;\";i:1;s:116:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/jetpack-boost/4.5.0/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:jetpack-boost\";}}}}i:24;a:5:{s:4:\"time\";i:1761686096;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:229837585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"9.5.3\";s:7:\"updated\";s:19:\"2025-10-28 10:00:41\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.3/en_GB.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:92:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/upgrade/really-simple-ssl-9.5.3-en_gb/\";s:12:\"source_files\";a:12:{i:0;s:61:\"really-simple-ssl-en_GB-a8958ff5e6fcbf1f2312c11f460e5ae6.json\";i:1;s:61:\"really-simple-ssl-en_GB-c1cce18b4b17339c1a2facaea4d84ede.json\";i:2;s:61:\"really-simple-ssl-en_GB-4bec6e7cfcb9b70a03d67091c8bd433b.json\";i:3;s:61:\"really-simple-ssl-en_GB-4e0c363fd793b724b46cee1c465b5cc5.json\";i:4;s:26:\"really-simple-ssl-en_GB.po\";i:5;s:61:\"really-simple-ssl-en_GB-66e3147c7aa63f4ed21f5f99320ef72b.json\";i:6;s:61:\"really-simple-ssl-en_GB-54b76e75e7275fc70e7abbae27f55e10.json\";i:7;s:32:\"really-simple-ssl-en_GB.l10n.php\";i:8;s:61:\"really-simple-ssl-en_GB-ec141d2db92202e08336653186484176.json\";i:9;s:26:\"really-simple-ssl-en_GB.mo\";i:10;s:61:\"really-simple-ssl-en_GB-5aae9e26053e5b6278c2ed1dd2fb1b59.json\";i:11;s:61:\"really-simple-ssl-en_GB-95c64faa005d698e43c0ea68942aafc0.json\";}s:11:\"destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:71:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins\";s:18:\"remote_destination\";s:72:\"/home/carl/public_html/southlancsarc.co.uk/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:39:\"Translations for Really Simple Security\";s:8:\"messages\";a:6:{i:0;s:63:\"Updating translations for Really Simple Security (en_GB)&#8230;\";i:1;s:120:\"Downloading translation from https://downloads.wordpress.org/translation/plugin/really-simple-ssl/9.5.3/en_GB.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:50:\"Removing the old version of the translation&#8230;\";i:5;s:33:\"Translation updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:24:\"plugin:really-simple-ssl\";}}}}}","off");
INSERT INTO `wp_options` VALUES("141019","rsssl_404_cache","a:40:{s:13:\"45.227.254.34\";a:2:{i:2;i:1722907176;i:3;i:1722907176;}s:12:\"140.82.50.67\";a:5:{i:4;i:1722458017;i:5;i:1722458018;i:6;i:1722458019;i:7;i:1722458020;i:8;i:1722458021;}s:14:\"195.234.109.82\";a:1:{i:5;i:1722948230;}s:14:\"195.234.109.10\";a:1:{i:10;i:1722948313;}s:13:\"195.234.109.8\";a:1:{i:11;i:1722948367;}s:11:\"66.249.70.7\";a:1:{i:0;i:1722484684;}s:14:\"104.28.152.168\";a:1:{i:0;i:1722508564;}s:13:\"46.183.184.61\";a:1:{i:0;i:1722508641;}s:14:\"23.106.216.201\";a:1:{i:0;i:1722517100;}s:13:\"159.223.46.93\";a:2:{i:4;i:1722821892;i:5;i:1722821893;}s:15:\"181.177.102.105\";a:1:{i:0;i:1722537050;}s:14:\"186.179.22.206\";a:1:{i:0;i:1722539637;}s:11:\"192.0.99.83\";a:1:{i:1;i:1722825969;}s:11:\"66.249.70.8\";a:1:{i:0;i:1722545775;}s:12:\"66.42.113.59\";a:5:{i:4;i:1722547188;i:5;i:1722547189;i:6;i:1722547190;i:7;i:1722547191;i:8;i:1722547192;}s:13:\"188.166.54.99\";a:2:{i:0;i:1722561868;i:1;i:1722561868;}s:13:\"192.0.102.116\";a:1:{i:0;i:1722584812;}s:13:\"45.237.168.80\";a:1:{i:0;i:1722613956;}s:13:\"192.0.112.147\";a:1:{i:0;i:1722627222;}s:15:\"104.156.230.168\";a:5:{i:4;i:1722629612;i:5;i:1722629613;i:6;i:1722629614;i:7;i:1722629615;i:8;i:1722629616;}s:11:\"66.249.70.1\";a:1:{i:1;i:1722728991;}s:13:\"192.0.114.113\";a:1:{i:0;i:1722672789;}s:12:\"5.255.231.54\";a:1:{i:0;i:1722692891;}s:14:\"213.180.203.71\";a:1:{i:0;i:1722692891;}s:13:\"173.252.107.7\";a:1:{i:0;i:1722712826;}s:15:\"138.186.137.124\";a:1:{i:0;i:1722765216;}s:13:\"173.44.152.79\";a:1:{i:0;i:1722776194;}s:13:\"85.25.185.238\";a:1:{i:0;i:1722784764;}s:13:\"64.237.48.188\";a:4:{i:5;i:1722799750;i:6;i:1722799751;i:7;i:1722799752;i:8;i:1722799754;}s:11:\"34.17.70.72\";a:2:{i:8;i:1722870476;i:9;i:1722870479;}s:13:\"152.32.234.39\";a:2:{i:1;i:1722891419;i:2;i:1722891422;}s:14:\"82.132.239.156\";a:10:{i:10;i:1722952835;i:11;i:1722952835;i:12;i:1722952836;i:13;i:1722952836;i:14;i:1722952836;i:15;i:1722952836;i:16;i:1722952837;i:17;i:1722952837;i:18;i:1722952837;i:19;i:1722952838;}s:14:\"195.234.109.70\";a:1:{i:11;i:1722948406;}s:15:\"195.234.109.120\";a:1:{i:3;i:1722948305;}s:15:\"195.234.109.186\";a:1:{i:3;i:1722948313;}s:15:\"195.234.109.190\";a:1:{i:3;i:1722948313;}s:13:\"66.249.81.104\";a:1:{i:0;i:1722947573;}s:14:\"195.234.109.74\";a:1:{i:0;i:1722947700;}s:15:\"195.234.109.134\";a:1:{i:0;i:1722947703;}s:15:\"195.234.109.138\";a:1:{i:0;i:1722947703;}}","off");
INSERT INTO `wp_options` VALUES("143221","burst_ran_test","1732130667","auto");
INSERT INTO `wp_options` VALUES("143234","burst_last_cron_hit","1732130665","off");
INSERT INTO `wp_options` VALUES("149696","burst_new_email_reporting_dismissed","1","off");
INSERT INTO `wp_options` VALUES("149985","rsssl_404_notice_shown","1","off");
INSERT INTO `wp_options` VALUES("150427","wpcom_publish_posts_with_markdown","1","auto");
INSERT INTO `wp_options` VALUES("166216","rsssl_404_detection_warning_dismissed","1","off");
INSERT INTO `wp_options` VALUES("166222","stats_options","a:10:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:12:\"do_not_track\";b:1;s:7:\"blog_id\";i:229837585;s:7:\"version\";s:1:\"9\";s:20:\"enable_odyssey_stats\";b:1;s:24:\"odyssey_stats_changed_at\";i:0;s:7:\"notices\";a:0:{}s:5:\"views\";i:3;}","auto");
INSERT INTO `wp_options` VALUES("179707","rsssl_encryption_keys_set","1","off");
INSERT INTO `wp_options` VALUES("179716","rsssl_upgrade_le_key","1","off");
INSERT INTO `wp_options` VALUES("179783","rsssl_folder_name","really-simple-ssl/50fa9325c1e9ff1f0c3764268e93b080","auto");
INSERT INTO `wp_options` VALUES("211638","burst_last_report_sent","1731312629","off");
INSERT INTO `wp_options` VALUES("220333","rsssl_upgraded_to_nine_dismissed","1","off");
INSERT INTO `wp_options` VALUES("237373","nimble_version_upgraded_from","3.3.7","off");
INSERT INTO `wp_options` VALUES("269194","feedback_unread_count","0","auto");
INSERT INTO `wp_options` VALUES("277668","rsssl_reset_fix","1","off");
INSERT INTO `wp_options` VALUES("288122","odyssey_stats_admin_asset_cache_buster","{\"cache_buster\":\"52a4d0abefa\",\"cached_at\":1761999126703}","off");
INSERT INTO `wp_options` VALUES("288178","jetpack_protect_global_stats","s:60:\"O:8:\"stdClass\":1:{s:21:\"total_vulnerabilities\";s:5:\"65303\";}\";","auto");
INSERT INTO `wp_options` VALUES("288179","jetpack_protect_global_stats_timestamp","1757572719","auto");
INSERT INTO `wp_options` VALUES("288236","rsssl_count_open_hardening_features_dismissed","1","off");
INSERT INTO `wp_options` VALUES("288305","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"8c7d46a72d7d4591fc1dd9485bedb304\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on");
INSERT INTO `wp_options` VALUES("292029","jetpack_boost_ds_cornerstone_pages_list","a:0:{}","auto");
INSERT INTO `wp_options` VALUES("300739","jb_transient_concat_paths_c1342baf7b","a:2:{s:6:\"expire\";i:1765393032;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:66:\"/wp-content/themes/customizr/assets/front/js/libs/modernizr.min.js\";}s:5:\"mtime\";i:1715504231;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("300740","jb_transient_concat_paths_f86d09744a","a:2:{s:6:\"expire\";i:1776287680;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:36:\"/wp-includes/js/comment-reply.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:5:\"mtime\";i:1732130692;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("300833","jb_transient_concat_paths_e3865dcd44","a:2:{s:6:\"expire\";i:1764702568;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:35:\"/wp-includes/js/zxcvbn-async.min.js\";i:2;s:33:\"/wp-includes/js/dist/hooks.min.js\";}s:5:\"mtime\";i:1732130692;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("300834","jb_transient_concat_paths_95809a599e","a:2:{s:6:\"expire\";i:1764702568;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:30:\"/wp-includes/js/wp-util.min.js\";i:1;s:37:\"/wp-includes/js/dist/dom-ready.min.js\";}s:5:\"mtime\";i:1715504127;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("301956","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"en_GB\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1738180765;s:15:\"version_checked\";s:5:\"6.7.1\";s:12:\"translations\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("309702","jb_transient_concat_paths_e0646a74dd","a:2:{s:6:\"expire\";i:1765565517;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:78:\"/wp-content/plugins/christmasify/public/js/cf-christmasification-public.min.js\";i:2;s:66:\"/wp-content/themes/customizr/assets/front/js/libs/modernizr.min.js\";}s:5:\"mtime\";i:1733856759;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("309706","jb_transient_concat_paths_a6b18ca771","a:2:{s:6:\"expire\";i:1765564577;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:1;s:75:\"/wp-content/themes/customizr/assets/front/js/libs/customizr-placeholders.js\";}s:5:\"mtime\";i:1721164700;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("309709","cf_christmasify_snowflakes","25","auto");
INSERT INTO `wp_options` VALUES("309710","cf_christmasify_classy_snow","0","auto");
INSERT INTO `wp_options` VALUES("309711","cf_christmasify_snow_speed","slow","auto");
INSERT INTO `wp_options` VALUES("309712","cf_christmasify_santa","1","auto");
INSERT INTO `wp_options` VALUES("309713","cf_christmasify_music","0","auto");
INSERT INTO `wp_options` VALUES("309714","cf_christmasify_image_frame","1","auto");
INSERT INTO `wp_options` VALUES("309715","cf_christmasify_font","0","auto");
INSERT INTO `wp_options` VALUES("309716","cf_christmasify_homepage_only","0","auto");
INSERT INTO `wp_options` VALUES("309717","cf_christmasify_date_from","2024-12-10","auto");
INSERT INTO `wp_options` VALUES("309718","cf_christmasify_date_to","2024-12-26","auto");
INSERT INTO `wp_options` VALUES("309721","jb_transient_concat_paths_f677534244","a:2:{s:6:\"expire\";i:1765564463;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:36:\"/wp-includes/js/comment-reply.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:2;s:75:\"/wp-content/themes/customizr/assets/front/js/libs/customizr-placeholders.js\";}s:5:\"mtime\";i:1732130692;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("310992","jetpack_sync_full_status","a:4:{s:7:\"started\";i:1733902192;s:8:\"finished\";i:1733902246;s:8:\"progress\";a:10:{s:8:\"comments\";a:4:{s:5:\"total\";i:0;s:4:\"sent\";i:0;s:8:\"finished\";b:1;s:9:\"last_sent\";s:2:\"~0\";}s:9:\"constants\";a:1:{s:8:\"finished\";b:1;}s:9:\"functions\";a:1:{s:8:\"finished\";b:1;}s:7:\"options\";a:1:{s:8:\"finished\";b:1;}s:5:\"posts\";a:4:{s:5:\"total\";i:355;s:4:\"sent\";i:355;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"1\";}s:18:\"term_relationships\";a:4:{s:5:\"total\";i:153;s:4:\"sent\";i:153;s:8:\"finished\";b:1;s:9:\"last_sent\";a:2:{s:9:\"object_id\";s:1:\"1\";s:16:\"term_taxonomy_id\";s:1:\"0\";}}s:5:\"terms\";a:4:{s:5:\"total\";i:65;s:4:\"sent\";i:65;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"1\";}s:6:\"themes\";a:1:{s:8:\"finished\";b:1;}s:7:\"updates\";a:1:{s:8:\"finished\";b:1;}s:5:\"users\";a:4:{s:5:\"total\";i:2;s:4:\"sent\";i:2;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"1\";}}s:6:\"config\";a:12:{s:8:\"comments\";b:1;s:9:\"constants\";b:1;s:9:\"functions\";b:1;s:7:\"options\";b:1;s:5:\"posts\";b:1;s:18:\"term_relationships\";b:1;s:5:\"terms\";b:1;s:6:\"themes\";b:1;s:7:\"updates\";b:1;s:5:\"users\";b:1;s:11:\"woocommerce\";b:1;s:23:\"woocommerce_hpos_orders\";b:1;}}","no");
INSERT INTO `wp_options` VALUES("313454","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1738180765;s:7:\"checked\";a:2:{s:9:\"customizr\";s:6:\"4.4.24\";s:16:\"twentytwentyfour\";s:3:\"1.3\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:2:{s:9:\"customizr\";a:6:{s:5:\"theme\";s:9:\"customizr\";s:11:\"new_version\";s:6:\"4.4.24\";s:3:\"url\";s:39:\"https://wordpress.org/themes/customizr/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/customizr.4.4.24.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.3\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("313473","jb_transient_concat_paths_edcdcc7ca5","a:2:{s:6:\"expire\";i:1766703972;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:78:\"/wp-content/plugins/christmasify/public/js/cf-christmasification-public.min.js\";i:2;s:66:\"/wp-content/themes/customizr/assets/front/js/libs/modernizr.min.js\";}s:5:\"mtime\";i:1734029617;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("324313","wpdbbkp_htaccess_fix","1734641072","off");
INSERT INTO `wp_options` VALUES("324445","jb_transient_concat_paths_709eaa6ff5","a:2:{s:6:\"expire\";i:1776191066;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:36:\"/wp-includes/js/comment-reply.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:2;s:75:\"/wp-content/themes/customizr/assets/front/js/libs/customizr-placeholders.js\";}s:5:\"mtime\";i:1734029617;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("334298","jb_transient_concat_paths_c5b3700998","a:2:{s:6:\"expire\";i:1764716645;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:66:\"/wp-content/themes/customizr/assets/front/js/libs/modernizr.min.js\";}s:5:\"mtime\";i:1734029617;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("338278","jb_transient_concat_paths_b7ddeb6ec4","a:2:{s:6:\"expire\";i:1776186991;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:1;s:75:\"/wp-content/themes/customizr/assets/front/js/libs/customizr-placeholders.js\";}s:5:\"mtime\";i:1734029617;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("338321","weather_effect_settings","a:105:{s:21:\"enable_weather_effect\";s:1:\"1\";s:16:\"weather_occasion\";s:14:\"new_year_check\";s:15:\"christmas_types\";s:11:\"snow_effect\";s:4:\"ball\";s:0:\"\";s:14:\"christmas_ball\";s:5:\"ball3\";s:4:\"bell\";s:0:\"\";s:14:\"christmas_bell\";s:5:\"bell3\";s:5:\"candy\";s:0:\"\";s:15:\"christmas_candy\";s:6:\"candy3\";s:4:\"gift\";s:0:\"\";s:14:\"christmas_gift\";s:5:\"gift3\";s:7:\"snowman\";s:0:\"\";s:17:\"christmas_snowman\";s:8:\"snowman3\";s:10:\"snow_flake\";s:0:\"\";s:20:\"christmas_snow_flake\";s:6:\"flack2\";s:23:\"christmas_min_size_leaf\";s:2:\"20\";s:23:\"christmas_max_size_leaf\";s:2:\"50\";s:21:\"christmas_flakes_leaf\";s:1:\"5\";s:15:\"christmas_speed\";s:1:\"5\";s:12:\"master_round\";s:5:\"false\";s:10:\"round_type\";s:4:\"true\";s:14:\"min_size_round\";s:1:\"4\";s:14:\"max_size_round\";s:2:\"20\";s:14:\"master_shadows\";s:5:\"false\";s:11:\"shadow_type\";s:4:\"true\";s:13:\"flakes_shadow\";s:2:\"50\";s:10:\"snow_types\";s:11:\"winter_snow\";s:8:\"ice_cube\";s:4:\"true\";s:18:\"min_size_christmas\";s:1:\"1\";s:18:\"max_size_christmas\";s:2:\"10\";s:15:\"flake_christmas\";s:1:\"5\";s:16:\"min_size_falling\";s:1:\"3\";s:16:\"max_size_falling\";s:2:\"30\";s:17:\"snow_falling_time\";s:3:\"500\";s:18:\"snow_falling_color\";s:6:\"FFFFFF\";s:4:\"leaf\";s:0:\"\";s:11:\"autumn_leaf\";s:12:\"autumn-leaf2\";s:20:\"autumn_min_size_leaf\";s:2:\"20\";s:20:\"autumn_max_size_leaf\";s:2:\"50\";s:18:\"autumn_flakes_leaf\";s:1:\"5\";s:12:\"autumn_speed\";s:1:\"5\";s:11:\"leaf_spring\";s:0:\"\";s:11:\"spring_leaf\";s:12:\"spring-leaf1\";s:20:\"spring_min_size_leaf\";s:2:\"20\";s:20:\"spring_max_size_leaf\";s:2:\"30\";s:18:\"spring_flakes_leaf\";s:1:\"5\";s:12:\"spring_speed\";s:1:\"5\";s:5:\"drink\";s:0:\"\";s:12:\"summer_drink\";s:6:\"drink1\";s:3:\"sun\";s:0:\"\";s:10:\"summer_sun\";s:4:\"sun1\";s:20:\"summer_min_size_leaf\";s:2:\"20\";s:20:\"summer_max_size_leaf\";s:2:\"50\";s:18:\"summer_flakes_leaf\";s:1:\"5\";s:12:\"summer_speed\";s:1:\"5\";s:8:\"umbrella\";s:0:\"\";s:13:\"rain_umbrella\";s:9:\"umbrella1\";s:4:\"drop\";s:0:\"\";s:10:\"rain_drops\";s:6:\"drops1\";s:5:\"cloud\";s:0:\"\";s:10:\"rain_cloud\";s:6:\"cloud1\";s:18:\"rain_min_size_leaf\";s:2:\"20\";s:18:\"rain_max_size_leaf\";s:2:\"50\";s:16:\"rain_flakes_leaf\";s:1:\"5\";s:10:\"rain_speed\";s:1:\"5\";s:5:\"ghost\";s:0:\"\";s:15:\"halloween_ghost\";s:6:\"ghost1\";s:4:\"bats\";s:0:\"\";s:14:\"halloween_bats\";s:5:\"bats1\";s:4:\"moon\";s:0:\"\";s:14:\"halloween_moon\";s:5:\"moon1\";s:7:\"pumpkin\";s:0:\"\";s:17:\"halloween_pumpkin\";s:8:\"pumpkin1\";s:3:\"web\";s:0:\"\";s:13:\"halloween_web\";s:4:\"web1\";s:5:\"witch\";s:0:\"\";s:15:\"halloween_witch\";s:6:\"witch1\";s:23:\"halloween_min_size_leaf\";s:2:\"20\";s:23:\"halloween_max_size_leaf\";s:2:\"50\";s:21:\"halloween_flakes_leaf\";s:1:\"5\";s:15:\"halloween_speed\";s:1:\"5\";s:6:\"turkey\";s:0:\"\";s:19:\"thanksgiving_turkey\";s:7:\"turkey1\";s:26:\"thanksgiving_min_size_leaf\";s:2:\"20\";s:26:\"thanksgiving_max_size_leaf\";s:2:\"50\";s:24:\"thanksgiving_flakes_leaf\";s:1:\"5\";s:18:\"thanksgiving_speed\";s:1:\"5\";s:4:\"rose\";s:0:\"\";s:14:\"valentine_rose\";s:5:\"rose1\";s:7:\"balloon\";s:0:\"\";s:17:\"valentine_balloon\";s:18:\"valentine_balloon1\";s:5:\"heart\";s:0:\"\";s:15:\"valentine_heart\";s:16:\"valentine_heart2\";s:23:\"valentine_min_size_leaf\";s:2:\"20\";s:23:\"valentine_max_size_leaf\";s:2:\"50\";s:21:\"valentine_flakes_leaf\";s:1:\"5\";s:15:\"valentine_speed\";s:1:\"5\";s:11:\"balloon_new\";s:11:\"balloon_new\";s:15:\"newyear_balloon\";s:16:\"newyear_balloon3\";s:7:\"sticker\";s:7:\"sticker\";s:16:\"new_year_sticker\";s:16:\"newyear_sticker1\";s:21:\"newyear_min_size_leaf\";s:2:\"20\";s:21:\"newyear_max_size_leaf\";s:3:\"145\";s:19:\"newyear_flakes_leaf\";s:2:\"13\";s:13:\"newyear_speed\";s:1:\"1\";}","auto");
INSERT INTO `wp_options` VALUES("338331","jb_transient_concat_paths_52da3a418f","a:2:{s:6:\"expire\";i:1767728927;s:4:\"data\";a:3:{s:5:\"paths\";a:3:{i:0;s:77:\"/wp-content/plugins/weather-effect/assets/js/christmas-snow/christmas-snow.js\";i:1;s:73:\"/wp-content/plugins/weather-effect/assets/js/snow-falling/snow-falling.js\";i:2;s:83:\"/wp-content/plugins/weather-effect/assets/js/snowfall-master/snowfall-master.min.js\";}s:5:\"mtime\";i:1735388102;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("343037","jb_transient_concat_paths_4c19e9b392","a:2:{s:6:\"expire\";i:1767673053;s:4:\"data\";a:3:{s:5:\"paths\";a:4:{i:0;s:77:\"/wp-content/plugins/weather-effect/assets/js/christmas-snow/christmas-snow.js\";i:1;s:73:\"/wp-content/plugins/weather-effect/assets/js/snow-falling/snow-falling.js\";i:2;s:83:\"/wp-content/plugins/weather-effect/assets/js/snowfall-master/snowfall-master.min.js\";i:3;s:31:\"/wp-includes/js/wp-embed.min.js\";}s:5:\"mtime\";i:1735388102;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("351679","aDBc_settings","a:6:{s:9:\"left_menu\";s:1:\"1\";s:16:\"menu_under_tools\";s:1:\"1\";s:14:\"plugin_version\";s:5:\"3.1.7\";s:12:\"installed_on\";s:10:\"2025/01/06\";s:9:\"keep_last\";a:1:{s:8:\"revision\";i:0;}s:13:\"ignore_rating\";s:3:\"yes\";}","off");
INSERT INTO `wp_options` VALUES("351695","aDBc_clean_schedule","a:1:{s:6:\"weekly\";a:5:{s:17:\"elements_to_clean\";a:14:{i:0;s:8:\"revision\";i:1;s:10:\"auto-draft\";i:2;s:11:\"trash-posts\";i:3;s:18:\"moderated-comments\";i:4;s:13:\"spam-comments\";i:5;s:14:\"trash-comments\";i:6;s:9:\"pingbacks\";i:7;s:10:\"trackbacks\";i:8;s:15:\"orphan-postmeta\";i:9;s:18:\"orphan-commentmeta\";i:10;s:15:\"orphan-usermeta\";i:11;s:15:\"orphan-termmeta\";i:12;s:20:\"orphan-relationships\";i:13;s:18:\"expired-transients\";}s:6:\"repeat\";s:6:\"weekly\";s:10:\"start_date\";s:10:\"2025-01-06\";s:10:\"start_time\";s:5:\"19:50\";s:6:\"active\";s:1:\"1\";}}","off");
INSERT INTO `wp_options` VALUES("372050","post_by_email_address2","NULL","auto");
INSERT INTO `wp_options` VALUES("383211","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1738180771;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:19:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"w.org/plugins/advanced-database-cleaner\";s:4:\"slug\";s:25:\"advanced-database-cleaner\";s:6:\"plugin\";s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";s:11:\"new_version\";s:5:\"3.1.5\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/advanced-database-cleaner/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/advanced-database-cleaner.3.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-database-cleaner/assets/icon-256x256.png?rev=1306117\";s:2:\"1x\";s:78:\"https://ps.w.org/advanced-database-cleaner/assets/icon-128x128.png?rev=1306117\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:80:\"https://ps.w.org/advanced-database-cleaner/assets/banner-772x250.png?rev=1630620\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.1.0\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:28:\"auto-upload-images/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/auto-upload-images\";s:4:\"slug\";s:18:\"auto-upload-images\";s:6:\"plugin\";s:28:\"auto-upload-images/index.php\";s:11:\"new_version\";s:5:\"3.3.2\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/auto-upload-images/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/auto-upload-images.3.3.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/auto-upload-images/assets/icon-256x256.png?rev=1617356\";s:2:\"1x\";s:71:\"https://ps.w.org/auto-upload-images/assets/icon-128x128.jpg?rev=1617356\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/auto-upload-images/assets/banner-1544x500.jpg?rev=1617356\";s:2:\"1x\";s:72:\"https://ps.w.org/auto-upload-images/assets/banner-772x250.jpg?rev=624464\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"2.7\";}s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:40:\"w.org/plugins/complianz-terms-conditions\";s:4:\"slug\";s:26:\"complianz-terms-conditions\";s:6:\"plugin\";s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";s:11:\"new_version\";s:5:\"1.2.8\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/complianz-terms-conditions/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/complianz-terms-conditions.1.2.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/complianz-terms-conditions/assets/icon-256x256.png?rev=2900489\";s:2:\"1x\";s:79:\"https://ps.w.org/complianz-terms-conditions/assets/icon-128x128.png?rev=2900489\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/complianz-terms-conditions/assets/banner-1544x500.png?rev=2881007\";s:2:\"1x\";s:81:\"https://ps.w.org/complianz-terms-conditions/assets/banner-772x250.png?rev=2881007\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.0.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:21:\"flamingo/flamingo.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/flamingo\";s:4:\"slug\";s:8:\"flamingo\";s:6:\"plugin\";s:21:\"flamingo/flamingo.php\";s:11:\"new_version\";s:3:\"2.5\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/flamingo/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/flamingo.2.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/flamingo/assets/icon-128x128.png?rev=1540977\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:62:\"https://ps.w.org/flamingo/assets/banner-772x250.png?rev=544829\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.4\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:6:\"14.2.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/jetpack.14.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:31:\"jetpack-boost/jetpack-boost.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/jetpack-boost\";s:4:\"slug\";s:13:\"jetpack-boost\";s:6:\"plugin\";s:31:\"jetpack-boost/jetpack-boost.php\";s:11:\"new_version\";s:5:\"3.8.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/jetpack-boost/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/jetpack-boost.3.8.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";s:3:\"svg\";s:58:\"https://ps.w.org/jetpack-boost/assets/icon.svg?rev=2818794\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/jetpack-boost/assets/banner-1544x500.png?rev=2653958\";s:2:\"1x\";s:68:\"https://ps.w.org/jetpack-boost/assets/banner-772x250.png?rev=2653958\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:35:\"jetpack-protect/jetpack-protect.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/jetpack-protect\";s:4:\"slug\";s:15:\"jetpack-protect\";s:6:\"plugin\";s:35:\"jetpack-protect/jetpack-protect.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/jetpack-protect/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/jetpack-protect.3.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/jetpack-protect/assets/icon-256x256.png?rev=2820708\";s:2:\"1x\";s:68:\"https://ps.w.org/jetpack-protect/assets/icon-128x128.png?rev=2820708\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/jetpack-protect/assets/banner-1544x500.png?rev=2735068\";s:2:\"1x\";s:70:\"https://ps.w.org/jetpack-protect/assets/banner-772x250.png?rev=2735068\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:33:\"jetpack-search/jetpack-search.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/jetpack-search\";s:4:\"slug\";s:14:\"jetpack-search\";s:6:\"plugin\";s:33:\"jetpack-search/jetpack-search.php\";s:11:\"new_version\";s:5:\"4.0.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/jetpack-search/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/jetpack-search.4.0.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/jetpack-search/assets/icon.svg?rev=2821772\";s:3:\"svg\";s:59:\"https://ps.w.org/jetpack-search/assets/icon.svg?rev=2821772\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/jetpack-search/assets/banner-1544x500.png?rev=2734348\";s:2:\"1x\";s:69:\"https://ps.w.org/jetpack-search/assets/banner-772x250.png?rev=2734348\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:33:\"jetpack-social/jetpack-social.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/jetpack-social\";s:4:\"slug\";s:14:\"jetpack-social\";s:6:\"plugin\";s:33:\"jetpack-social/jetpack-social.php\";s:11:\"new_version\";s:5:\"6.1.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/jetpack-social/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/jetpack-social.6.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";s:3:\"svg\";s:59:\"https://ps.w.org/jetpack-social/assets/icon.svg?rev=2822276\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/jetpack-social/assets/banner-1544x500.png?rev=2778707\";s:2:\"1x\";s:69:\"https://ps.w.org/jetpack-social/assets/banner-772x250.png?rev=2778707\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:41:\"last-login-display/last-login-display.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/last-login-display\";s:4:\"slug\";s:18:\"last-login-display\";s:6:\"plugin\";s:41:\"last-login-display/last-login-display.php\";s:11:\"new_version\";s:5:\"1.0.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/last-login-display/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/last-login-display.1.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/last-login-display/assets/icon-256x256.png?rev=3175354\";s:2:\"1x\";s:71:\"https://ps.w.org/last-login-display/assets/icon-256x256.png?rev=3175354\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/last-login-display/assets/banner-1544x500.png?rev=3175354\";s:2:\"1x\";s:73:\"https://ps.w.org/last-login-display/assets/banner-772x250.png?rev=3175354\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:33:\"nimble-builder/nimble-builder.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/nimble-builder\";s:4:\"slug\";s:14:\"nimble-builder\";s:6:\"plugin\";s:33:\"nimble-builder/nimble-builder.php\";s:11:\"new_version\";s:5:\"3.3.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/nimble-builder/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/nimble-builder.3.3.7.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/nimble-builder/assets/icon.svg?rev=1986014\";s:3:\"svg\";s:59:\"https://ps.w.org/nimble-builder/assets/icon.svg?rev=1986014\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/nimble-builder/assets/banner-1544x500.jpg?rev=1986014\";s:2:\"1x\";s:69:\"https://ps.w.org/nimble-builder/assets/banner-772x250.jpg?rev=1986014\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.2.0\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.2.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}s:27:\"redis-cache/redis-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/redis-cache\";s:4:\"slug\";s:11:\"redis-cache\";s:6:\"plugin\";s:27:\"redis-cache/redis-cache.php\";s:11:\"new_version\";s:5:\"2.5.4\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/redis-cache/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/redis-cache.2.5.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/redis-cache/assets/icon-256x256.gif?rev=2568513\";s:2:\"1x\";s:64:\"https://ps.w.org/redis-cache/assets/icon-128x128.gif?rev=2568513\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/redis-cache/assets/banner-1544x500.png?rev=2315420\";s:2:\"1x\";s:66:\"https://ps.w.org/redis-cache/assets/banner-772x250.png?rev=2315420\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/remove-powered-by-wp\";s:4:\"slug\";s:20:\"remove-powered-by-wp\";s:6:\"plugin\";s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";s:11:\"new_version\";s:5:\"1.6.1\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/remove-powered-by-wp/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/remove-powered-by-wp.1.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/remove-powered-by-wp/assets/icon-256x256.jpg?rev=1830045\";s:2:\"1x\";s:73:\"https://ps.w.org/remove-powered-by-wp/assets/icon-128x128.jpg?rev=1830045\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:41:\"sassy-social-share/sassy-social-share.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/sassy-social-share\";s:4:\"slug\";s:18:\"sassy-social-share\";s:6:\"plugin\";s:41:\"sassy-social-share/sassy-social-share.php\";s:11:\"new_version\";s:6:\"3.3.70\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/sassy-social-share/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/sassy-social-share.3.3.70.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/sassy-social-share/assets/icon-128x128.png?rev=1300723\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/sassy-social-share/assets/banner-772x250.png?rev=2489986\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"2.5.0\";}s:45:\"simple-local-avatars/simple-local-avatars.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/simple-local-avatars\";s:4:\"slug\";s:20:\"simple-local-avatars\";s:6:\"plugin\";s:45:\"simple-local-avatars/simple-local-avatars.php\";s:11:\"new_version\";s:5:\"2.8.3\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/simple-local-avatars/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/simple-local-avatars.2.8.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:65:\"https://ps.w.org/simple-local-avatars/assets/icon.svg?rev=2783752\";s:3:\"svg\";s:65:\"https://ps.w.org/simple-local-avatars/assets/icon.svg?rev=2783752\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/simple-local-avatars/assets/banner-1544x500.jpg?rev=2406995\";s:2:\"1x\";s:75:\"https://ps.w.org/simple-local-avatars/assets/banner-772x250.jpg?rev=2406995\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:41:\"wp-database-backup/wp-database-backup.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/wp-database-backup\";s:4:\"slug\";s:18:\"wp-database-backup\";s:6:\"plugin\";s:41:\"wp-database-backup/wp-database-backup.php\";s:11:\"new_version\";s:3:\"7.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wp-database-backup/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/wp-database-backup.7.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/wp-database-backup/assets/icon-256x256.png?rev=2838048\";s:2:\"1x\";s:71:\"https://ps.w.org/wp-database-backup/assets/icon-256x256.png?rev=2838048\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/wp-database-backup/assets/banner-1544x500.png?rev=2838048\";s:2:\"1x\";s:73:\"https://ps.w.org/wp-database-backup/assets/banner-772x250.png?rev=2838048\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.1\";}}s:7:\"checked\";a:19:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";s:5:\"3.1.5\";s:19:\"akismet/akismet.php\";s:5:\"5.3.5\";s:28:\"auto-upload-images/index.php\";s:5:\"3.3.2\";s:57:\"complianz-terms-conditions/complianz-terms-conditions.php\";s:5:\"1.2.8\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.0.3\";s:21:\"flamingo/flamingo.php\";s:3:\"2.5\";s:19:\"jetpack/jetpack.php\";s:6:\"14.2.1\";s:31:\"jetpack-boost/jetpack-boost.php\";s:5:\"3.8.0\";s:35:\"jetpack-protect/jetpack-protect.php\";s:5:\"3.1.1\";s:33:\"jetpack-search/jetpack-search.php\";s:5:\"4.0.0\";s:33:\"jetpack-social/jetpack-social.php\";s:5:\"6.1.0\";s:41:\"last-login-display/last-login-display.php\";s:5:\"1.0.4\";s:33:\"nimble-builder/nimble-builder.php\";s:5:\"3.3.7\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:5:\"9.2.0\";s:27:\"redis-cache/redis-cache.php\";s:5:\"2.5.4\";s:45:\"remove-powered-by-wp/remove-powered-by-wp.php\";s:5:\"1.6.1\";s:41:\"sassy-social-share/sassy-social-share.php\";s:6:\"3.3.70\";s:45:\"simple-local-avatars/simple-local-avatars.php\";s:5:\"2.8.3\";s:41:\"wp-database-backup/wp-database-backup.php\";s:3:\"7.4\";}}","off");
INSERT INTO `wp_options` VALUES("383305","backupbreeze_ftp_host","cwoodalluk.co.uk","off");
INSERT INTO `wp_options` VALUES("383306","backupbreeze_ftp_user","carl@cwoodalluk.co.uk","off");
INSERT INTO `wp_options` VALUES("383307","backupbreeze_ftp_pass","cw73rys25K","off");
INSERT INTO `wp_options` VALUES("383308","backupbreeze_ftp_subdir","","off");
INSERT INTO `wp_options` VALUES("383309","backupbreeze_ftp_port","21","off");
INSERT INTO `wp_options` VALUES("383601","jetpack_boost_version","4.5.1","auto");
INSERT INTO `wp_options` VALUES("384376","jetpack_boost_minify_cron_cache_cleanup_last_run","1762082093","off");
INSERT INTO `wp_options` VALUES("384435","jetpack_boost_404_tester_last_run","1762082092","off");
INSERT INTO `wp_options` VALUES("384482","wpdbbkp_export_notify","create","off");
INSERT INTO `wp_options` VALUES("384833","jetpack_boost_status_minify-common","1","auto");
INSERT INTO `wp_options` VALUES("384834","jetpack_boost_status_cache-preload","1","auto");
INSERT INTO `wp_options` VALUES("385047","jb_transient_concat_paths_3986839d01","a:2:{s:6:\"expire\";i:1764716647;s:4:\"data\";a:3:{s:5:\"paths\";a:2:{i:0;s:36:\"/wp-includes/js/comment-reply.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:5:\"mtime\";i:1744751680;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("385612","indexnow-is_valid_api_key","1","auto");
INSERT INTO `wp_options` VALUES("385613","indexnow-admin_api_key","OTNlOWQ0MDQ3N2VkNDc0Mzg3YmM0YTA1NzU0OGJlMWQ=","auto");
INSERT INTO `wp_options` VALUES("386133","jetpack_boost_status_lcp","1","auto");
INSERT INTO `wp_options` VALUES("386143","wp_db_save_settings_in_backup","1","off");
INSERT INTO `wp_options` VALUES("386485","can_compress_scripts","0","on");
INSERT INTO `wp_options` VALUES("386487","rsssl_pro_trial_dismissed","1","off");
INSERT INTO `wp_options` VALUES("386516","jb_transient_jetpack_boost_speed_scores_431e66c259d1cfcfd06e7ad00a84bc04","a:2:{s:6:\"expire\";i:1752605466;s:4:\"data\";a:8:{s:2:\"id\";s:32:\"431e66c259d1cfcfd06e7ad00a84bc04\";s:3:\"url\";s:31:\"https://www.southlancsarc.co.uk\";s:14:\"active_modules\";a:6:{i:0;s:12:\"critical_css\";i:1;s:3:\"lcp\";i:2;s:9:\"minify_js\";i:3;s:9:\"image_cdn\";i:4;s:10:\"page_cache\";i:5;s:13:\"minify_common\";}s:7:\"created\";d:1752605139.308929;s:6:\"status\";s:7:\"success\";s:5:\"error\";N;s:6:\"client\";s:12:\"boost-plugin\";s:11:\"retry_count\";i:0;}}","off");
INSERT INTO `wp_options` VALUES("386517","jb_transient_jetpack_boost_speed_scores_18872809a3a9dd11e7f7d7da5fdd5cac","a:2:{s:6:\"expire\";i:1752605471;s:4:\"data\";a:8:{s:2:\"id\";s:32:\"18872809a3a9dd11e7f7d7da5fdd5cac\";s:3:\"url\";s:54:\"https://www.southlancsarc.co.uk?jb-disable-modules=all\";s:14:\"active_modules\";a:0:{}s:7:\"created\";d:1752605141.825983;s:6:\"status\";s:7:\"success\";s:5:\"error\";N;s:6:\"client\";s:12:\"boost-plugin\";s:11:\"retry_count\";i:0;}}","off");
INSERT INTO `wp_options` VALUES("386746","jetpack_boost_ds_lcp_state","a:4:{s:5:\"pages\";a:1:{i:0;a:3:{s:3:\"key\";s:20:\"cornerstone_d41d8cd9\";s:3:\"url\";s:31:\"https://www.southlancsarc.co.uk\";s:6:\"status\";s:7:\"success\";}}s:6:\"status\";s:8:\"analyzed\";s:7:\"created\";d:1753846389.839039;s:7:\"updated\";d:1753846452.701795;}","off");
INSERT INTO `wp_options` VALUES("387072","category_children","a:0:{}","auto");
INSERT INTO `wp_options` VALUES("387250","rsssl_htaccess_should_wrap","1","off");
INSERT INTO `wp_options` VALUES("387532","jetpack_boost_speed_score_history_bf1e62ade416587c606482940ee5f244","a:7:{i:0;a:3:{s:9:\"timestamp\";i:1757484076;s:6:\"scores\";a:2:{s:6:\"mobile\";i:78;s:7:\"desktop\";i:91;}s:5:\"theme\";s:9:\"Customizr\";}i:1;a:3:{s:9:\"timestamp\";i:1757484878;s:6:\"scores\";a:2:{s:6:\"mobile\";i:46;s:7:\"desktop\";i:92;}s:5:\"theme\";s:9:\"Customizr\";}i:2;a:3:{s:9:\"timestamp\";i:1757525196;s:6:\"scores\";a:2:{s:6:\"mobile\";i:55;s:7:\"desktop\";i:91;}s:5:\"theme\";s:9:\"Customizr\";}i:3;a:3:{s:9:\"timestamp\";i:1758361864;s:6:\"scores\";a:2:{s:6:\"mobile\";i:51;s:7:\"desktop\";i:87;}s:5:\"theme\";s:9:\"Customizr\";}i:4;a:3:{s:9:\"timestamp\";i:1758461414;s:6:\"scores\";a:2:{s:6:\"mobile\";i:46;s:7:\"desktop\";i:92;}s:5:\"theme\";s:9:\"Customizr\";}i:5;a:3:{s:9:\"timestamp\";i:1761824226;s:6:\"scores\";a:2:{s:6:\"mobile\";i:39;s:7:\"desktop\";i:93;}s:5:\"theme\";s:9:\"Customizr\";}i:6;a:3:{s:9:\"timestamp\";i:1761843293;s:6:\"scores\";a:2:{s:6:\"mobile\";i:38;s:7:\"desktop\";i:64;}s:5:\"theme\";s:9:\"Customizr\";}}","off");
INSERT INTO `wp_options` VALUES("387533","jetpack_boost_speed_score_history_6a5dbe9ed5a230d5869b9f470cba90aa","a:6:{i:0;a:3:{s:9:\"timestamp\";i:1757484086;s:6:\"scores\";a:2:{s:6:\"mobile\";i:50;s:7:\"desktop\";i:73;}s:5:\"theme\";s:9:\"Customizr\";}i:1;a:3:{s:9:\"timestamp\";i:1757525200;s:6:\"scores\";a:2:{s:6:\"mobile\";i:60;s:7:\"desktop\";i:90;}s:5:\"theme\";s:9:\"Customizr\";}i:2;a:3:{s:9:\"timestamp\";i:1758361864;s:6:\"scores\";a:2:{s:6:\"mobile\";i:39;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}i:3;a:3:{s:9:\"timestamp\";i:1758461418;s:6:\"scores\";a:2:{s:6:\"mobile\";i:41;s:7:\"desktop\";i:80;}s:5:\"theme\";s:9:\"Customizr\";}i:4;a:3:{s:9:\"timestamp\";i:1761824235;s:6:\"scores\";a:2:{s:6:\"mobile\";i:40;s:7:\"desktop\";i:58;}s:5:\"theme\";s:9:\"Customizr\";}i:5;a:3:{s:9:\"timestamp\";i:1761843303;s:6:\"scores\";a:2:{s:6:\"mobile\";i:42;s:7:\"desktop\";i:86;}s:5:\"theme\";s:9:\"Customizr\";}}","off");
INSERT INTO `wp_options` VALUES("387543","indexnow-auto_submission_enabled","1","auto");
INSERT INTO `wp_options` VALUES("387544","indexnow-failed_count","O:23:\"IndexNowSubmissionCount\":3:{s:12:\"hourly_count\";a:48:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:0;i:6;i:0;i:7;i:0;i:8;i:0;i:9;i:0;i:10;i:0;i:11;i:0;i:12;i:0;i:13;i:0;i:14;i:0;i:15;i:0;i:16;i:0;i:17;i:0;i:18;i:0;i:19;i:0;i:20;i:0;i:21;i:0;i:22;i:0;i:23;i:0;i:24;i:0;i:25;i:0;i:26;i:0;i:27;i:0;i:28;i:0;i:29;i:0;i:30;i:0;i:31;i:0;i:32;i:0;i:33;i:0;i:34;i:0;i:35;i:0;i:36;i:0;i:37;i:0;i:38;i:0;i:39;i:0;i:40;i:0;i:41;i:0;i:42;i:0;i:43;i:0;i:44;i:0;i:45;i:0;i:46;i:0;i:47;i:0;}s:15:\"last_count_date\";i:1757855453;s:5:\"index\";i:37;}","auto");
INSERT INTO `wp_options` VALUES("387545","indexnow-passed_count","O:23:\"IndexNowSubmissionCount\":3:{s:12:\"hourly_count\";a:48:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:0;i:6;i:0;i:7;i:0;i:8;i:0;i:9;i:0;i:10;i:0;i:11;i:0;i:12;i:1;i:13;i:0;i:14;i:0;i:15;i:3;i:16;i:8;i:17;i:0;i:18;i:0;i:19;i:0;i:20;i:0;i:21;i:0;i:22;i:0;i:23;i:0;i:24;i:0;i:25;i:0;i:26;i:0;i:27;i:0;i:28;i:0;i:29;i:0;i:30;i:0;i:31;i:0;i:32;i:0;i:33;i:0;i:34;i:0;i:35;i:0;i:36;i:0;i:37;i:0;i:38;i:0;i:39;i:0;i:40;i:0;i:41;i:0;i:42;i:0;i:43;i:0;i:44;i:0;i:45;i:0;i:46;i:0;i:47;i:0;}s:15:\"last_count_date\";i:1761999256;s:5:\"index\";i:12;}","auto");
INSERT INTO `wp_options` VALUES("387546","indexnow-admin_bwt_site_auth_key","baa297c5-9c51-43d3-baf2-55d704e422d8","auto");
INSERT INTO `wp_options` VALUES("387547","indexnow-admin_bwt_site_auth_timestamp","1757855490","auto");
INSERT INTO `wp_options` VALUES("387958","jb_transient_concat_paths_96b7107381","a:2:{s:6:\"expire\";i:1764591278;s:4:\"data\";a:3:{s:5:\"paths\";a:5:{i:0;s:37:\"/wp-includes/js/hoverintent-js.min.js\";i:1;s:32:\"/wp-includes/js/admin-bar.min.js\";i:2;s:36:\"/wp-includes/js/comment-reply.min.js\";i:3;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:4;s:75:\"/wp-content/themes/customizr/assets/front/js/libs/customizr-placeholders.js\";}s:5:\"mtime\";i:1744751680;s:12:\"cache_buster\";i:1;}}","off");
INSERT INTO `wp_options` VALUES("388634","jetpack_boost_static_minification","1","off");
INSERT INTO `wp_options` VALUES("388801","jetpack_boost_ds_critical_css_suggest_regenerate","page_saved","off");
INSERT INTO `wp_options` VALUES("388808","jb_transient_jetpack_boost_speed_scores_bf1e62ade416587c606482940ee5f244","a:2:{s:6:\"expire\";i:1761843593;s:4:\"data\";a:8:{s:2:\"id\";s:32:\"bf1e62ade416587c606482940ee5f244\";s:3:\"url\";s:32:\"https://www.southlancsarc.co.uk/\";s:14:\"active_modules\";a:6:{i:0;s:12:\"critical_css\";i:1;s:3:\"lcp\";i:2;s:9:\"minify_js\";i:3;s:9:\"image_cdn\";i:4;s:10:\"page_cache\";i:5;s:13:\"minify_common\";}s:7:\"created\";d:1761843251.109639;s:6:\"status\";s:7:\"success\";s:5:\"error\";N;s:6:\"client\";s:12:\"boost-plugin\";s:11:\"retry_count\";i:0;}}","off");
INSERT INTO `wp_options` VALUES("388809","jb_transient_jetpack_boost_speed_scores_6a5dbe9ed5a230d5869b9f470cba90aa","a:2:{s:6:\"expire\";i:1761843603;s:4:\"data\";a:8:{s:2:\"id\";s:32:\"6a5dbe9ed5a230d5869b9f470cba90aa\";s:3:\"url\";s:55:\"https://www.southlancsarc.co.uk/?jb-disable-modules=all\";s:14:\"active_modules\";a:0:{}s:7:\"created\";d:1761843253.858491;s:6:\"status\";s:7:\"success\";s:5:\"error\";N;s:6:\"client\";s:12:\"boost-plugin\";s:11:\"retry_count\";i:0;}}","off");
INSERT INTO `wp_options` VALUES("388846","jetpack_boost_cleanup_concat_paths_last_processed_option_id","387958","off");
INSERT INTO `wp_options` VALUES("388848","jetpack_site_products","a:0:{}","on");
INSERT INTO `wp_options` VALUES("388850","jb_transient_premium_features","a:2:{s:6:\"expire\";i:1762360214;s:4:\"data\";a:0:{}}","off");


CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25033 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_postmeta` VALUES("5","12","_kubio_created_at_activation","1");
INSERT INTO `wp_postmeta` VALUES("6","12","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("7","13","_kubio_created_at_activation","1");
INSERT INTO `wp_postmeta` VALUES("8","13","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("25","16","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("26","17","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("27","18","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("28","19","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("29","20","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("30","21","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("31","22","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("32","23","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("33","24","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("34","25","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("35","26","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("36","27","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("37","28","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("38","29","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("39","30","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("40","31","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("41","32","_kubio_template_source","kubio");
INSERT INTO `wp_postmeta` VALUES("56","10","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("57","12","_edit_lock","1758976611:1");
INSERT INTO `wp_postmeta` VALUES("58","41","_wp_attached_file","2024/02/Ashurst_Beacon.png");
INSERT INTO `wp_postmeta` VALUES("59","41","_wp_attachment_metadata","a:6:{s:5:\"width\";i:205;s:6:\"height\";i:141;s:4:\"file\";s:26:\"2024/02/Ashurst_Beacon.png\";s:8:\"filesize\";i:69879;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Ashurst_Beacon-150x141.png\";s:5:\"width\";i:150;s:6:\"height\";i:141;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54687;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("60","42","_wp_attached_file","2024/02/ashurst001.jpg");
INSERT INTO `wp_postmeta` VALUES("61","42","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1599;s:6:\"height\";i:1200;s:4:\"file\";s:22:\"2024/02/ashurst001.jpg\";s:8:\"filesize\";i:504327;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"ashurst001-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23312;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"ashurst001-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:263249;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"ashurst001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8754;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"ashurst001-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:154411;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"ashurst001-1536x1153.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:517856;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"ashurst001-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:136204;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"ashurst001-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68801;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst001-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24323;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"ashurst001-1599x500.jpg\";s:5:\"width\";i:1599;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:194044;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"ashurst001-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:158628;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst001-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95232;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"ashurst001-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:210616;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst001-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53474;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"ashurst001-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40395;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("62","43","_wp_attached_file","2024/02/PIC004-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("63","43","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC004-scaled.jpg\";s:8:\"filesize\";i:763583;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC004-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20413;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC004-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:172974;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC004-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7356;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC004-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105306;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC004-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:339040;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC004-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:537678;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC004-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88765;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC004-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50081;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC004-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19368;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC004-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144372;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC004-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105515;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC004-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61712;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC004-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140912;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC004-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39200;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC004-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29075;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104539939\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"21.6\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC004.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("64","44","_wp_attached_file","2024/02/PIC006-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("65","44","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC006-scaled.jpg\";s:8:\"filesize\";i:382893;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC006-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11316;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC006-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73269;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC006-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5444;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC006-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45871;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC006-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147477;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC006-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:251792;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC006-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49844;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC006-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24536;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC006-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11433;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC006-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144632;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC006-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54293;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC006-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31813;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC006-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65568;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC006-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20181;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC006-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16025;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540062\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0035714285714286\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC006.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("66","45","_wp_attached_file","2024/02/PIC007-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("67","45","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC007-scaled.jpg\";s:8:\"filesize\";i:423543;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC007-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11684;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC007-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76712;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC007-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5162;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC007-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47813;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC007-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157216;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC007-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:274102;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC007-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48737;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC007-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24418;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC007-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11188;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC007-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127193;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC007-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54142;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC007-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30913;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC007-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65413;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC007-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19818;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC007-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16012;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540073\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0035714285714286\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC007.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("68","46","_wp_attached_file","2024/02/PIC009-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("69","46","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC009-scaled.jpg\";s:8:\"filesize\";i:416467;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC009-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15322;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC009-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88912;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC009-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6629;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC009-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58140;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC009-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:167840;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC009-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:277112;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC009-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65618;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC009-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33861;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC009-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14334;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC009-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:139003;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC009-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72499;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC009-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37024;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC009-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:84445;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC009-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28793;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC009-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24346;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540229\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"44.9\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC009.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("70","47","_wp_attached_file","2024/02/PIC010-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("71","47","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC010-scaled.jpg\";s:8:\"filesize\";i:763792;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC010-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16901;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC010-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157030;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC010-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6402;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC010-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91480;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC010-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:327299;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC010-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:533578;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC010-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94065;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC010-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39936;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC010-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16107;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC010-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:241978;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC010-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104992;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC010-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52500;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC010-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:129093;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC010-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31437;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC010-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24656;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540336\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"6.3\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC010.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("72","48","_wp_attached_file","2024/02/PIC016-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("73","48","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC016-scaled.jpg\";s:8:\"filesize\";i:425922;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC016-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16986;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC016-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109184;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC016-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6586;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC016-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71141;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC016-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:198239;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC016-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:304027;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC016-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76610;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC016-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40508;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC016-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15385;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC016-4288x500.jpg\";s:5:\"width\";i:4288;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162170;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC016-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86439;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC016-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40798;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC016-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103583;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC016-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34096;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC016-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27947;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S3380\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1110736089\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"9.1\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC016.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("76","12","post_slider_check_key","1");
INSERT INTO `wp_postmeta` VALUES("77","12","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("78","12","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("79","12","layout_key","");
INSERT INTO `wp_postmeta` VALUES("80","52","_wp_attached_file","2024/02/Untitled.jpeg");
INSERT INTO `wp_postmeta` VALUES("81","52","_wp_attachment_metadata","a:6:{s:5:\"width\";i:225;s:6:\"height\";i:225;s:4:\"file\";s:21:\"2024/02/Untitled.jpeg\";s:8:\"filesize\";i:12057;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"Untitled-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8890;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("82","53","_wp_attached_file","2024/02/cropped-Untitled.jpeg");
INSERT INTO `wp_postmeta` VALUES("83","53","_wp_attachment_context","custom-logo");
INSERT INTO `wp_postmeta` VALUES("84","53","_wp_attachment_metadata","a:6:{s:5:\"width\";i:225;s:6:\"height\";i:225;s:4:\"file\";s:29:\"2024/02/cropped-Untitled.jpeg\";s:8:\"filesize\";i:15477;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"cropped-Untitled-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8629;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("89","58","_edit_lock","1761999274:1");
INSERT INTO `wp_postmeta` VALUES("90","58","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("91","58","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:2253;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("92","58","layout_key","");
INSERT INTO `wp_postmeta` VALUES("93","58","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("112","67","_edit_lock","1761841702:1");
INSERT INTO `wp_postmeta` VALUES("113","67","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("114","67","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:2238;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("115","67","layout_key","");
INSERT INTO `wp_postmeta` VALUES("116","67","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("118","1","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:41;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("121","71","_wp_attached_file","2024/02/cropped-cropped-Untitled.jpeg");
INSERT INTO `wp_postmeta` VALUES("122","71","_wp_attachment_context","site-icon");
INSERT INTO `wp_postmeta` VALUES("123","71","_wp_attachment_metadata","a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:37:\"2024/02/cropped-cropped-Untitled.jpeg\";s:8:\"filesize\";i:45836;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-300x300.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19760;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8415;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x444.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39723;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x350.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30052;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-270x250.jpeg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16542;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x500.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44524;}s:6:\"slider\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x500.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44524;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-510x510.jpeg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42278;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x297.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25396;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-512x235.jpeg\";s:5:\"width\";i:512;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22487;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-270x270.jpeg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17364;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-192x192.jpeg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11381;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-Untitled-180x180.jpeg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10636;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:35:\"cropped-cropped-Untitled-32x32.jpeg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1379;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("142","79","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("143","79","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("144","79","_menu_item_object_id","67");
INSERT INTO `wp_postmeta` VALUES("145","79","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("146","79","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("147","79","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("148","79","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("149","79","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("150","80","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("151","80","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("152","80","_menu_item_object_id","58");
INSERT INTO `wp_postmeta` VALUES("153","80","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("154","80","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("155","80","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("156","80","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("157","80","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("162","82","_edit_lock","1716238556:2");
INSERT INTO `wp_postmeta` VALUES("163","82","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("164","82","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:330;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("165","82","layout_key","");
INSERT INTO `wp_postmeta` VALUES("166","82","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("167","86","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("168","86","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("169","86","_menu_item_object_id","13");
INSERT INTO `wp_postmeta` VALUES("170","86","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("171","86","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("172","86","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("173","86","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("174","86","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("201","13","_edit_lock","1737808071:1");
INSERT INTO `wp_postmeta` VALUES("202","102","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("203","102","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("204","102","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("205","102","_menu_item_object_id","12");
INSERT INTO `wp_postmeta` VALUES("206","102","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("207","102","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("208","102","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("209","102","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("210","102","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("212","80","_wp_old_date","2024-02-02");
INSERT INTO `wp_postmeta` VALUES("213","80","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("214","79","_wp_old_date","2024-02-02");
INSERT INTO `wp_postmeta` VALUES("215","79","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("216","86","_wp_old_date","2024-02-02");
INSERT INTO `wp_postmeta` VALUES("217","86","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("218","103","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("219","103","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("220","103","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("221","103","_menu_item_object_id","82");
INSERT INTO `wp_postmeta` VALUES("222","103","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("223","103","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("224","103","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("225","103","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("226","103","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("228","104","_edit_lock","1757962751:1");
INSERT INTO `wp_postmeta` VALUES("229","105","_wp_attached_file","2024/02/team_dh.jpg");
INSERT INTO `wp_postmeta` VALUES("230","105","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:19:\"2024/02/team_dh.jpg\";s:8:\"filesize\";i:6924;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("231","106","_wp_attached_file","2024/02/team_sh.jpg");
INSERT INTO `wp_postmeta` VALUES("232","106","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:19:\"2024/02/team_sh.jpg\";s:8:\"filesize\";i:5153;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("233","107","_wp_attached_file","2024/02/team_rh.jpg");
INSERT INTO `wp_postmeta` VALUES("234","107","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:19:\"2024/02/team_rh.jpg\";s:8:\"filesize\";i:6782;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("235","108","_wp_attached_file","2024/02/team_sc.jpg");
INSERT INTO `wp_postmeta` VALUES("236","108","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:19:\"2024/02/team_sc.jpg\";s:8:\"filesize\";i:12077;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("237","109","_wp_attached_file","2024/02/team_cw.jpg");
INSERT INTO `wp_postmeta` VALUES("238","109","_wp_attachment_metadata","a:6:{s:5:\"width\";i:110;s:6:\"height\";i:134;s:4:\"file\";s:19:\"2024/02/team_cw.jpg\";s:8:\"filesize\";i:3784;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("239","110","_wp_attached_file","2024/02/team_ml.jpg");
INSERT INTO `wp_postmeta` VALUES("240","110","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:19:\"2024/02/team_ml.jpg\";s:8:\"filesize\";i:7095;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("241","111","_wp_attached_file","2024/02/team_who.png");
INSERT INTO `wp_postmeta` VALUES("242","111","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:20:\"2024/02/team_who.png\";s:8:\"filesize\";i:2371;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("243","104","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("244","104","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1194;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("245","104","layout_key","");
INSERT INTO `wp_postmeta` VALUES("246","104","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("247","114","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("248","114","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("249","114","_menu_item_object_id","104");
INSERT INTO `wp_postmeta` VALUES("250","114","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("251","114","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("252","114","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("253","114","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("254","114","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("257","115","_wp_attached_file","2024/02/banner.png");
INSERT INTO `wp_postmeta` VALUES("258","115","_wp_attachment_metadata","a:6:{s:5:\"width\";i:650;s:6:\"height\";i:145;s:4:\"file\";s:18:\"2024/02/banner.png\";s:8:\"filesize\";i:164464;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"banner-300x67.png\";s:5:\"width\";i:300;s:6:\"height\";i:67;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42928;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"banner-150x145.png\";s:5:\"width\";i:150;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38709;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"banner-570x145.png\";s:5:\"width\";i:570;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:145143;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"banner-270x145.png\";s:5:\"width\";i:270;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:69422;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"banner-510x145.png\";s:5:\"width\";i:510;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:132249;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"banner-528x145.png\";s:5:\"width\";i:528;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:136365;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"banner-517x145.png\";s:5:\"width\";i:517;s:6:\"height\";i:145;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:133778;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("268","117","_edit_lock","1713937625:2");
INSERT INTO `wp_postmeta` VALUES("269","118","_wp_attached_file","2024/02/link_rsgb.png");
INSERT INTO `wp_postmeta` VALUES("270","118","_wp_attachment_metadata","a:6:{s:5:\"width\";i:63;s:6:\"height\";i:124;s:4:\"file\";s:21:\"2024/02/link_rsgb.png\";s:8:\"filesize\";i:10298;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("271","119","_wp_attached_file","2024/02/link_raynet.png");
INSERT INTO `wp_postmeta` VALUES("272","119","_wp_attachment_metadata","a:6:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"file\";s:23:\"2024/02/link_raynet.png\";s:8:\"filesize\";i:10128;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("273","120","_wp_attached_file","2024/02/link_wab.gif");
INSERT INTO `wp_postmeta` VALUES("274","120","_wp_attachment_metadata","a:6:{s:5:\"width\";i:77;s:6:\"height\";i:75;s:4:\"file\";s:20:\"2024/02/link_wab.gif\";s:8:\"filesize\";i:1570;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("275","121","_wp_attached_file","2024/02/link_narsa.jpg");
INSERT INTO `wp_postmeta` VALUES("276","121","_wp_attachment_metadata","a:6:{s:5:\"width\";i:150;s:6:\"height\";i:94;s:4:\"file\";s:22:\"2024/02/link_narsa.jpg\";s:8:\"filesize\";i:10064;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("277","122","_wp_attached_file","2024/02/link_raibc.png");
INSERT INTO `wp_postmeta` VALUES("278","122","_wp_attachment_metadata","a:6:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"file\";s:22:\"2024/02/link_raibc.png\";s:8:\"filesize\";i:20367;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("279","123","_wp_attached_file","2024/02/link_bartg.png");
INSERT INTO `wp_postmeta` VALUES("280","123","_wp_attachment_metadata","a:6:{s:5:\"width\";i:65;s:6:\"height\";i:131;s:4:\"file\";s:22:\"2024/02/link_bartg.png\";s:8:\"filesize\";i:8132;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("281","124","_wp_attached_file","2024/02/link_qrp.png");
INSERT INTO `wp_postmeta` VALUES("282","124","_wp_attachment_metadata","a:6:{s:5:\"width\";i:75;s:6:\"height\";i:146;s:4:\"file\";s:20:\"2024/02/link_qrp.png\";s:8:\"filesize\";i:4835;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("283","125","_wp_attached_file","2024/02/link_wspr.png");
INSERT INTO `wp_postmeta` VALUES("284","125","_wp_attachment_metadata","a:6:{s:5:\"width\";i:150;s:6:\"height\";i:32;s:4:\"file\";s:21:\"2024/02/link_wspr.png\";s:8:\"filesize\";i:12231;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("285","126","_wp_attached_file","2024/02/link_scan.jpg");
INSERT INTO `wp_postmeta` VALUES("286","126","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:83;s:4:\"file\";s:21:\"2024/02/link_scan.jpg\";s:8:\"filesize\";i:6769;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("287","127","_wp_attached_file","2024/02/link_fists.png");
INSERT INTO `wp_postmeta` VALUES("288","127","_wp_attachment_metadata","a:6:{s:5:\"width\";i:100;s:6:\"height\";i:97;s:4:\"file\";s:22:\"2024/02/link_fists.png\";s:8:\"filesize\";i:12618;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("289","128","_wp_attached_file","2024/02/link_echo.gif");
INSERT INTO `wp_postmeta` VALUES("290","128","_wp_attachment_metadata","a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:21:\"2024/02/link_echo.gif\";s:8:\"filesize\";i:589;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("291","129","_wp_attached_file","2024/02/link_epc.png");
INSERT INTO `wp_postmeta` VALUES("292","129","_wp_attachment_metadata","a:6:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"file\";s:20:\"2024/02/link_epc.png\";s:8:\"filesize\";i:15258;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("293","130","_wp_attached_file","2024/02/link_vmars.jpg");
INSERT INTO `wp_postmeta` VALUES("294","130","_wp_attachment_metadata","a:6:{s:5:\"width\";i:67;s:6:\"height\";i:130;s:4:\"file\";s:22:\"2024/02/link_vmars.jpg\";s:8:\"filesize\";i:3980;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("295","131","_wp_attached_file","2024/02/link_bylara.jpg");
INSERT INTO `wp_postmeta` VALUES("296","131","_wp_attachment_metadata","a:6:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"file\";s:23:\"2024/02/link_bylara.jpg\";s:8:\"filesize\";i:6200;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("297","132","_wp_attached_file","2024/02/raota.png");
INSERT INTO `wp_postmeta` VALUES("298","132","_wp_attachment_metadata","a:6:{s:5:\"width\";i:94;s:6:\"height\";i:130;s:4:\"file\";s:17:\"2024/02/raota.png\";s:8:\"filesize\";i:11237;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("299","117","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("300","117","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:132;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("301","117","layout_key","");
INSERT INTO `wp_postmeta` VALUES("302","117","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("303","135","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("304","135","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("305","135","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("306","135","_menu_item_object_id","117");
INSERT INTO `wp_postmeta` VALUES("307","135","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("308","135","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("309","135","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("310","135","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("311","135","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("313","114","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("314","136","_wp_attached_file","2024/02/logo-e1708789305733.gif");
INSERT INTO `wp_postmeta` VALUES("315","136","_wp_attachment_metadata","a:6:{s:5:\"width\";i:240;s:6:\"height\";i:407;s:4:\"file\";s:31:\"2024/02/logo-e1708789305733.gif\";s:8:\"filesize\";i:468280;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"logo-177x300.gif\";s:5:\"width\";i:177;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:10962;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"logo-150x150.gif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:5567;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:16:\"logo-294x444.gif\";s:5:\"width\";i:294;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:14704;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:16:\"logo-294x350.gif\";s:5:\"width\";i:294;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:12644;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:16:\"logo-270x250.gif\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:10330;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:16:\"logo-294x297.gif\";s:5:\"width\";i:294;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:10547;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:16:\"logo-294x235.gif\";s:5:\"width\";i:294;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/gif\";s:8:\"filesize\";i:8589;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("316","136","_wp_attachment_image_alt","slarc");
INSERT INTO `wp_postmeta` VALUES("321","139","_edit_lock","1708633401:2");
INSERT INTO `wp_postmeta` VALUES("322","139","_oembed_6627a041b0443acfd26a079c1cffb13d","<iframe title=\"SLARC Channel Intro\" width=\"1140\" height=\"641\" src=\"https://www.youtube.com/embed/8v7L8x7LegY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("323","139","_oembed_time_6627a041b0443acfd26a079c1cffb13d","1706967516");
INSERT INTO `wp_postmeta` VALUES("324","139","_oembed_345f56ca9b306bb0d0c803fcaff9ba6e","<iframe title=\"Morse Key Makeover\" width=\"1140\" height=\"641\" src=\"https://www.youtube.com/embed/XLwWxc8jK1c?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("325","139","_oembed_time_345f56ca9b306bb0d0c803fcaff9ba6e","1706967576");
INSERT INTO `wp_postmeta` VALUES("326","139","_oembed_c18a42edd3db4351c062bf1ba41882bd","<iframe title=\"Toroid Winding with a Crochet Hook!\" width=\"1140\" height=\"641\" src=\"https://www.youtube.com/embed/F5wRoLYjrG4?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("327","139","_oembed_time_c18a42edd3db4351c062bf1ba41882bd","1706967637");
INSERT INTO `wp_postmeta` VALUES("328","139","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("329","139","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("330","139","layout_key","");
INSERT INTO `wp_postmeta` VALUES("331","139","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("332","142","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("333","142","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("334","142","_menu_item_object_id","139");
INSERT INTO `wp_postmeta` VALUES("335","142","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("336","142","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("337","142","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("338","142","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("339","142","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("342","143","_wp_attached_file","2024/02/unnamed.jpg");
INSERT INTO `wp_postmeta` VALUES("343","143","_wp_attachment_metadata","a:6:{s:5:\"width\";i:176;s:6:\"height\";i:176;s:4:\"file\";s:19:\"2024/02/unnamed.jpg\";s:8:\"filesize\";i:12518;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"unnamed-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5732;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("346","145","_wp_attached_file","2024/02/training05.jpg");
INSERT INTO `wp_postmeta` VALUES("347","145","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:164;s:4:\"file\";s:22:\"2024/02/training05.jpg\";s:8:\"filesize\";i:6937;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"training05-120x150.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5010;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("348","1","_edit_lock","1707042901:1");
INSERT INTO `wp_postmeta` VALUES("351","1","_thumbnail_id","41");
INSERT INTO `wp_postmeta` VALUES("352","1","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("355","1","layout_key","");
INSERT INTO `wp_postmeta` VALUES("356","1","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("360","149","_wp_attached_file","2024/02/about_image.jpg");
INSERT INTO `wp_postmeta` VALUES("361","149","_wp_attachment_metadata","a:6:{s:5:\"width\";i:300;s:6:\"height\";i:171;s:4:\"file\";s:23:\"2024/02/about_image.jpg\";s:8:\"filesize\";i:20646;s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"about_image-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7200;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:23:\"about_image-270x171.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:171;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12779;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("371","156","_edit_lock","1706972097:1");
INSERT INTO `wp_postmeta` VALUES("372","157","_wp_attached_file","2024/02/iaru.png");
INSERT INTO `wp_postmeta` VALUES("373","157","_wp_attachment_metadata","a:6:{s:5:\"width\";i:95;s:6:\"height\";i:121;s:4:\"file\";s:16:\"2024/02/iaru.png\";s:8:\"filesize\";i:12089;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("374","158","_wp_attached_file","2024/02/ethics-and-operational-procedures-for-the-radio-amateur.pdf");
INSERT INTO `wp_postmeta` VALUES("375","158","_wp_attachment_metadata","a:1:{s:8:\"filesize\";i:3595753;}");
INSERT INTO `wp_postmeta` VALUES("378","156","_thumbnail_id","157");
INSERT INTO `wp_postmeta` VALUES("379","156","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("382","156","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:157;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("383","156","layout_key","");
INSERT INTO `wp_postmeta` VALUES("384","156","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("385","160","_edit_lock","1706971870:1");
INSERT INTO `wp_postmeta` VALUES("386","161","_wp_attached_file","2024/02/Abram-Community-Centre-Logo.jpg");
INSERT INTO `wp_postmeta` VALUES("387","161","_wp_attachment_metadata","a:6:{s:5:\"width\";i:500;s:6:\"height\";i:160;s:4:\"file\";s:39:\"2024/02/Abram-Community-Centre-Logo.jpg\";s:8:\"filesize\";i:23697;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"Abram-Community-Centre-Logo-300x96.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6732;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:39:\"Abram-Community-Centre-Logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5767;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:39:\"Abram-Community-Centre-Logo-270x160.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:160;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10041;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("390","160","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("391","160","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("394","160","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("395","160","layout_key","");
INSERT INTO `wp_postmeta` VALUES("396","160","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("419","166","_edit_lock","1706972244:1");
INSERT INTO `wp_postmeta` VALUES("422","166","_thumbnail_id","136");
INSERT INTO `wp_postmeta` VALUES("423","166","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("425","166","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:136;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("426","166","layout_key","");
INSERT INTO `wp_postmeta` VALUES("427","166","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("428","168","_edit_lock","1706972582:1");
INSERT INTO `wp_postmeta` VALUES("431","168","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("433","168","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("434","168","layout_key","");
INSERT INTO `wp_postmeta` VALUES("435","168","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("437","168","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("440","170","_edit_lock","1706972744:1");
INSERT INTO `wp_postmeta` VALUES("443","170","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("444","170","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("447","170","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("448","170","layout_key","");
INSERT INTO `wp_postmeta` VALUES("449","170","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("450","172","_edit_lock","1706972840:1");
INSERT INTO `wp_postmeta` VALUES("453","172","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("454","172","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("457","172","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("458","172","layout_key","");
INSERT INTO `wp_postmeta` VALUES("459","172","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("460","174","_edit_lock","1706973068:1");
INSERT INTO `wp_postmeta` VALUES("463","174","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("465","174","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:176;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("466","174","layout_key","");
INSERT INTO `wp_postmeta` VALUES("467","174","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("468","176","_wp_attached_file","2024/02/GB1GMW.jpg");
INSERT INTO `wp_postmeta` VALUES("469","176","_wp_attachment_metadata","a:6:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:18:\"2024/02/GB1GMW.jpg\";s:8:\"filesize\";i:57602;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"GB1GMW-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17270;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"GB1GMW-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7344;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:18:\"GB1GMW-600x444.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51514;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"GB1GMW-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36095;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"GB1GMW-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16336;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"GB1GMW-510x450.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45951;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"GB1GMW-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29890;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"GB1GMW-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24876;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("471","174","_thumbnail_id","176");
INSERT INTO `wp_postmeta` VALUES("473","177","_edit_lock","1706973434:1");
INSERT INTO `wp_postmeta` VALUES("476","177","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("478","177","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("479","177","layout_key","");
INSERT INTO `wp_postmeta` VALUES("480","177","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("481","179","_edit_lock","1706973375:1");
INSERT INTO `wp_postmeta` VALUES("482","180","_wp_attached_file","2024/02/GOTA.png");
INSERT INTO `wp_postmeta` VALUES("483","180","_wp_attachment_metadata","a:6:{s:5:\"width\";i:725;s:6:\"height\";i:689;s:4:\"file\";s:16:\"2024/02/GOTA.png\";s:8:\"filesize\";i:135610;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"GOTA-300x285.png\";s:5:\"width\";i:300;s:6:\"height\";i:285;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44369;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"GOTA-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18212;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:16:\"GOTA-725x444.png\";s:5:\"width\";i:725;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:86330;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:16:\"GOTA-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:81982;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:16:\"GOTA-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38514;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:16:\"GOTA-725x500.png\";s:5:\"width\";i:725;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:99997;}s:6:\"slider\";a:5:{s:4:\"file\";s:16:\"GOTA-725x500.png\";s:5:\"width\";i:725;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:99997;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:16:\"GOTA-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:99587;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:16:\"GOTA-725x624.png\";s:5:\"width\";i:725;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:117177;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:16:\"GOTA-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:66445;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:16:\"GOTA-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:52906;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("486","179","_thumbnail_id","180");
INSERT INTO `wp_postmeta` VALUES("487","179","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("490","179","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:180;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("491","179","layout_key","");
INSERT INTO `wp_postmeta` VALUES("492","179","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("495","177","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("500","183","_edit_lock","1706973595:1");
INSERT INTO `wp_postmeta` VALUES("503","183","_thumbnail_id","41");
INSERT INTO `wp_postmeta` VALUES("504","183","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("507","183","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:41;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("508","183","layout_key","");
INSERT INTO `wp_postmeta` VALUES("509","183","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("510","185","_edit_lock","1706973817:1");
INSERT INTO `wp_postmeta` VALUES("513","185","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("514","185","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("517","185","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("518","185","layout_key","");
INSERT INTO `wp_postmeta` VALUES("519","185","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("520","187","_edit_lock","1707039757:2");
INSERT INTO `wp_postmeta` VALUES("521","188","_wp_attached_file","2024/02/Sticker-2024-555x96-1.jpg");
INSERT INTO `wp_postmeta` VALUES("522","188","_wp_attachment_metadata","a:6:{s:5:\"width\";i:555;s:6:\"height\";i:96;s:4:\"file\";s:33:\"2024/02/Sticker-2024-555x96-1.jpg\";s:8:\"filesize\";i:24119;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-300x52.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:52;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9433;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-150x96.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7343;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-270x96.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11499;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-510x96.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21788;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-528x96.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22268;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:32:\"Sticker-2024-555x96-1-517x96.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:96;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22079;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("525","187","_thumbnail_id","188");
INSERT INTO `wp_postmeta` VALUES("526","187","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("529","187","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:188;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("530","187","layout_key","");
INSERT INTO `wp_postmeta` VALUES("531","187","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("532","190","_edit_lock","1706974254:1");
INSERT INTO `wp_postmeta` VALUES("533","191","_wp_attached_file","2024/02/YOTA.jpg");
INSERT INTO `wp_postmeta` VALUES("534","191","_wp_attachment_metadata","a:6:{s:5:\"width\";i:720;s:6:\"height\";i:656;s:4:\"file\";s:16:\"2024/02/YOTA.jpg\";s:8:\"filesize\";i:49729;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"YOTA-300x273.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23907;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"YOTA-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9615;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:16:\"YOTA-720x444.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53724;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:16:\"YOTA-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37842;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:16:\"YOTA-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20427;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:16:\"YOTA-720x500.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61339;}s:6:\"slider\";a:5:{s:4:\"file\";s:16:\"YOTA-720x500.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61339;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:16:\"YOTA-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51183;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:16:\"YOTA-720x624.jpg\";s:5:\"width\";i:720;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65902;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:16:\"YOTA-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31145;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:16:\"YOTA-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24110;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("537","190","_thumbnail_id","191");
INSERT INTO `wp_postmeta` VALUES("538","190","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("540","190","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:191;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("541","190","layout_key","");
INSERT INTO `wp_postmeta` VALUES("542","190","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("552","195","_edit_lock","1706974723:1");
INSERT INTO `wp_postmeta` VALUES("555","195","_thumbnail_id","136");
INSERT INTO `wp_postmeta` VALUES("556","195","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("557","195","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:136;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("558","195","layout_key","");
INSERT INTO `wp_postmeta` VALUES("559","195","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("560","197","_edit_lock","1706974978:1");
INSERT INTO `wp_postmeta` VALUES("561","198","_wp_attached_file","2024/02/GB1FAS.png");
INSERT INTO `wp_postmeta` VALUES("562","198","_wp_attachment_metadata","a:6:{s:5:\"width\";i:768;s:6:\"height\";i:577;s:4:\"file\";s:18:\"2024/02/GB1FAS.png\";s:8:\"filesize\";i:19372;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"GB1FAS-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15227;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"GB1FAS-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7588;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:18:\"GB1FAS-768x444.png\";s:5:\"width\";i:768;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:32126;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"GB1FAS-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29686;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"GB1FAS-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15241;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:18:\"GB1FAS-768x500.png\";s:5:\"width\";i:768;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39309;}s:6:\"slider\";a:5:{s:4:\"file\";s:18:\"GB1FAS-768x500.png\";s:5:\"width\";i:768;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39309;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"GB1FAS-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38174;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"GB1FAS-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22665;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"GB1FAS-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17265;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("565","197","_thumbnail_id","198");
INSERT INTO `wp_postmeta` VALUES("566","197","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("569","197","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:198;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("570","197","layout_key","");
INSERT INTO `wp_postmeta` VALUES("571","197","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("572","197","_oembed_9df2ca9ed93292f65d2a45042aefe3dd","<blockquote class=\"wp-embedded-content\" data-secret=\"FpiIgPWHPP\"><a href=\"https://1stabram.org.uk/gb1fas/\">GB1FAS &#8211; 1st Abram Cubs on JOTA with SLARC</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" title=\"&#8220;GB1FAS &#8211; 1st Abram Cubs on JOTA with SLARC&#8221; &#8212; 1st Abram Scout Group\" src=\"https://1stabram.org.uk/gb1fas/embed/#?secret=o1wZyYWOGo#?secret=FpiIgPWHPP\" data-secret=\"FpiIgPWHPP\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>");
INSERT INTO `wp_postmeta` VALUES("573","197","_oembed_time_9df2ca9ed93292f65d2a45042aefe3dd","1706974970");
INSERT INTO `wp_postmeta` VALUES("577","201","_edit_lock","1742138032:1");
INSERT INTO `wp_postmeta` VALUES("578","202","_wp_attached_file","2024/02/ashurst001-1.jpg");
INSERT INTO `wp_postmeta` VALUES("579","202","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1599;s:6:\"height\";i:1200;s:4:\"file\";s:24:\"2024/02/ashurst001-1.jpg\";s:8:\"filesize\";i:504327;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23312;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"ashurst001-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:263249;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8754;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:154411;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:26:\"ashurst001-1-1536x1153.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:517856;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:25:\"ashurst001-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:136204;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68801;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24323;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:25:\"ashurst001-1-1599x500.jpg\";s:5:\"width\";i:1599;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:194044;}s:6:\"slider\";a:5:{s:4:\"file\";s:25:\"ashurst001-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:158628;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95232;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:25:\"ashurst001-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:210616;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53474;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:24:\"ashurst001-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40395;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("580","203","_wp_attached_file","2024/02/ashurst003.jpg");
INSERT INTO `wp_postmeta` VALUES("581","203","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1599;s:6:\"height\";i:1200;s:4:\"file\";s:22:\"2024/02/ashurst003.jpg\";s:8:\"filesize\";i:271710;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"ashurst003-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18075;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"ashurst003-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:153632;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"ashurst003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7010;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"ashurst003-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94881;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"ashurst003-1536x1153.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:290000;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"ashurst003-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:107791;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"ashurst003-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47303;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst003-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17841;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"ashurst003-1599x500.jpg\";s:5:\"width\";i:1599;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:173502;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"ashurst003-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116970;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst003-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58628;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"ashurst003-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:135437;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst003-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38819;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"ashurst003-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32326;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("582","204","_wp_attached_file","2024/02/ashurst002.jpg");
INSERT INTO `wp_postmeta` VALUES("583","204","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1599;s:4:\"file\";s:22:\"2024/02/ashurst002.jpg\";s:8:\"filesize\";i:503475;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"ashurst002-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28288;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"ashurst002-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:276895;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"ashurst002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10041;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"ashurst002-768x1023.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1023;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:276995;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"ashurst002-1153x1536.jpg\";s:5:\"width\";i:1153;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:525142;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"ashurst002-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:156088;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"ashurst002-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79970;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst002-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28784;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"ashurst002-1200x500.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:199952;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"ashurst002-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:176032;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst002-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104075;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"ashurst002-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:215796;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst002-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63545;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"ashurst002-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50496;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("584","205","_wp_attached_file","2024/02/ashurst005.jpg");
INSERT INTO `wp_postmeta` VALUES("585","205","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1599;s:6:\"height\";i:1200;s:4:\"file\";s:22:\"2024/02/ashurst005.jpg\";s:8:\"filesize\";i:184910;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"ashurst005-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15184;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"ashurst005-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:114911;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"ashurst005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6108;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"ashurst005-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72677;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"ashurst005-1536x1153.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:211770;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"ashurst005-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41083;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"ashurst005-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32358;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst005-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15388;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"ashurst005-1599x500.jpg\";s:5:\"width\";i:1599;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50036;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"ashurst005-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51876;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst005-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47001;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"ashurst005-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79206;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst005-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24422;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"ashurst005-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16273;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("586","206","_wp_attached_file","2024/02/PIC001-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("587","206","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC001-scaled.jpg\";s:8:\"filesize\";i:318290;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC001-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11056;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC001-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73830;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4267;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC001-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47502;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC001-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:138775;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC001-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:221189;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC001-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40781;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC001-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23550;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC001-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9994;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC001-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66197;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC001-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46288;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC001-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26825;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC001-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58727;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC001-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18721;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC001-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14385;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1161948436\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"21.6\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC001.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("588","207","_wp_attached_file","2024/02/PIC002-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("589","207","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC002-scaled.jpg\";s:8:\"filesize\";i:676749;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC002-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18693;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC002-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:152754;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6940;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC002-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93685;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC002-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:297835;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC002-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:475097;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC002-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86930;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC002-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45564;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC002-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17145;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC002-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:193638;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC002-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:98305;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC002-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54227;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC002-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125840;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC002-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35752;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC002-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27137;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104537667\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"13.3\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC002.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("590","208","_wp_attached_file","2024/02/ashurst004.jpg");
INSERT INTO `wp_postmeta` VALUES("591","208","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1599;s:4:\"file\";s:22:\"2024/02/ashurst004.jpg\";s:8:\"filesize\";i:296073;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"ashurst004-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17499;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"ashurst004-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:163306;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"ashurst004-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6870;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"ashurst004-768x1023.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1023;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:163260;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"ashurst004-1153x1536.jpg\";s:5:\"width\";i:1153;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:319983;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"ashurst004-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93481;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"ashurst004-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46757;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst004-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18248;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"ashurst004-1200x500.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:122487;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"ashurst004-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105646;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst004-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62111;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"ashurst004-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:130776;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"ashurst004-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37242;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"ashurst004-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29232;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("592","209","_wp_attached_file","2024/02/PIC005-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("593","209","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC005-scaled.jpg\";s:8:\"filesize\";i:858825;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC005-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19836;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC005-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:184986;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7322;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC005-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109588;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC005-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:375650;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC005-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:602741;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC005-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:131067;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC005-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54061;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC005-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18848;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC005-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:298309;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC005-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144425;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC005-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62225;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC005-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:171576;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC005-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43677;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC005-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35742;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540027\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"10.8\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC005.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("594","210","_wp_attached_file","2024/02/PIC003-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("595","211","_wp_attached_file","2024/02/PIC008-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("596","212","_wp_attached_file","2024/02/PIC007-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("597","210","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC003-scaled.jpg\";s:8:\"filesize\";i:422898;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC003-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11695;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC003-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85613;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5166;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC003-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52312;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC003-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:172470;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC003-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:285891;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC003-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64589;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC003-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28222;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC003-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11353;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC003-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:163513;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC003-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71371;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC003-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33166;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC003-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83043;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC003-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23793;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC003-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20020;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104539882\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"14.8\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:8:\"0.003125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC003.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("598","211","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC008-scaled.jpg\";s:8:\"filesize\";i:556035;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC008-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16012;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC008-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:114122;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC008-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7109;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC008-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70611;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC008-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:227666;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC008-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:376549;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC008-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78487;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC008-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36452;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC008-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16087;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC008-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:180800;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC008-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:87081;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC008-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47434;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC008-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103063;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC008-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30178;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC008-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24898;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540126\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0045454545454545\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC008.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("599","213","_wp_attached_file","2024/02/PIC004-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("600","212","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC007-1-scaled.jpg\";s:8:\"filesize\";i:423543;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC007-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11684;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC007-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76712;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC007-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5162;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC007-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47813;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC007-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157216;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC007-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:274102;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC007-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48737;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC007-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24418;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC007-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11188;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC007-1-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127193;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC007-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54142;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC007-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30913;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC007-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65413;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC007-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19818;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC007-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16012;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540073\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0035714285714286\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC007-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("601","213","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC004-1-scaled.jpg\";s:8:\"filesize\";i:763583;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC004-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20413;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC004-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:172974;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC004-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7356;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC004-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105306;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC004-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:339040;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC004-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:537678;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC004-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88765;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC004-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50081;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC004-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19368;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC004-1-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144372;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC004-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105515;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC004-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61712;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC004-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140912;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC004-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39200;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC004-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29075;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104539939\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"21.6\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC004-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("602","214","_wp_attached_file","2024/02/PIC009-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("603","215","_wp_attached_file","2024/02/PIC006-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("604","214","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC009-1-scaled.jpg\";s:8:\"filesize\";i:416467;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC009-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15322;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC009-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:88912;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC009-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6629;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC009-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58140;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC009-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:167840;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC009-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:277112;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC009-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65618;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC009-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33861;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC009-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14334;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC009-1-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:139003;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC009-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72499;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC009-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37024;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC009-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:84445;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC009-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28793;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC009-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24346;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540229\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"44.9\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC009-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("605","215","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC006-1-scaled.jpg\";s:8:\"filesize\";i:382893;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC006-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11316;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC006-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73269;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC006-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5444;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC006-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45871;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC006-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147477;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC006-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:251792;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC006-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49844;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC006-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24536;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC006-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11433;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC006-1-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144632;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC006-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54293;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC006-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31813;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC006-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65568;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC006-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20181;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC006-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16025;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540062\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0035714285714286\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC006-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("606","216","_wp_attached_file","2024/02/PIC010-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("607","216","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC010-1-scaled.jpg\";s:8:\"filesize\";i:763792;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC010-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16901;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC010-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:157030;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC010-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6402;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC010-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91480;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC010-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:327299;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC010-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:533578;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC010-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94065;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC010-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39936;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC010-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16107;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC010-1-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:241978;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC010-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104992;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC010-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52500;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC010-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:129093;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC010-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31437;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC010-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24656;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104540336\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"6.3\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC010-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("608","217","_wp_attached_file","2024/02/PIC012-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("609","217","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC012-scaled.jpg\";s:8:\"filesize\";i:344647;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC012-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9336;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC012-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68301;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC012-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4153;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC012-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42302;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC012-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:135733;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC012-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:227416;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC012-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49998;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC012-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23021;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC012-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9456;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC012-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125992;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC012-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55327;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC012-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28378;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC012-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64583;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC012-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19323;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC012-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16231;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104543478\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0023809523809524\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC012.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("610","218","_wp_attached_file","2024/02/PIC013-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("611","218","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC013-scaled.jpg\";s:8:\"filesize\";i:291865;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC013-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6785;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC013-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49289;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC013-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2930;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC013-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29995;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC013-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103956;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC013-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:184572;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC013-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34636;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC013-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16269;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC013-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6526;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC013-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86432;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC013-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38859;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC013-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18710;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC013-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46299;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC013-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13649;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC013-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11303;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104543482\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:5:\"0.002\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC013.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("612","219","_wp_attached_file","2024/02/PIC014-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("613","219","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC014-scaled.jpg\";s:8:\"filesize\";i:443789;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC014-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12840;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC014-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95219;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC014-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5219;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC014-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59800;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC014-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:183346;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC014-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:299469;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC014-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66719;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC014-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33189;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC014-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12486;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC014-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:147867;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC014-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75339;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC014-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37623;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC014-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91027;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC014-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27747;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC014-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22247;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104543497\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"63\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC014.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("614","220","_wp_attached_file","2024/02/PIC015-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("615","220","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC015-scaled.jpg\";s:8:\"filesize\";i:1039196;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC015-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22891;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC015-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:224593;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC015-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8412;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC015-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:131970;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC015-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:456771;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC015-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:731986;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC015-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:143090;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC015-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62861;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC015-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22487;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC015-2592x500.jpg\";s:5:\"width\";i:2592;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:312653;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC015-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:160708;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC015-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78956;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC015-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:197783;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC015-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49781;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC015-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39824;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S5600\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1104543512\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"16.7\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:18:\"0.0066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC015.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("616","221","_wp_attached_file","2024/02/PIC017-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("617","221","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC017-scaled.jpg\";s:8:\"filesize\";i:516868;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC017-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14579;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC017-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109051;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC017-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5820;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC017-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67267;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC017-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:214979;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC017-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:350070;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC017-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78391;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC017-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35843;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC017-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13931;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC017-4000x500.jpg\";s:5:\"width\";i:4000;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:282633;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC017-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86629;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC017-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41793;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC017-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103204;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC017-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29492;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC017-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24069;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"MAR-LX1A\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1618059161\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.75\";s:3:\"iso\";s:2:\"50\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC017.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("618","222","_wp_attached_file","2024/02/PIC016-1-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("619","222","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:27:\"2024/02/PIC016-1-scaled.jpg\";s:8:\"filesize\";i:425922;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"PIC016-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16986;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"PIC016-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109184;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"PIC016-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6586;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"PIC016-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71141;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"PIC016-1-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:198239;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:22:\"PIC016-1-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:304027;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"PIC016-1-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76610;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"PIC016-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40508;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"PIC016-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15385;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"PIC016-1-4288x500.jpg\";s:5:\"width\";i:4288;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162170;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"PIC016-1-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86439;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"PIC016-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40798;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"PIC016-1-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103583;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"PIC016-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34096;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"PIC016-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27947;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"FinePix S3380\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1110736089\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"9.1\";s:3:\"iso\";s:2:\"64\";s:13:\"shutter_speed\";s:18:\"0.0066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:12:\"PIC016-1.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("620","223","_wp_attached_file","2024/02/PIC018-scaled.jpg");
INSERT INTO `wp_postmeta` VALUES("621","223","_wp_attachment_metadata","a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:25:\"2024/02/PIC018-scaled.jpg\";s:8:\"filesize\";i:966287;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"PIC018-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18649;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"PIC018-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:186132;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"PIC018-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6550;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"PIC018-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:107608;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:20:\"PIC018-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:395527;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:20:\"PIC018-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:660640;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:19:\"PIC018-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:132193;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:18:\"PIC018-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52600;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:18:\"PIC018-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18054;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:19:\"PIC018-4000x500.jpg\";s:5:\"width\";i:4000;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:457817;}s:6:\"slider\";a:5:{s:4:\"file\";s:19:\"PIC018-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:145304;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:18:\"PIC018-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63482;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:19:\"PIC018-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:173083;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:18:\"PIC018-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42087;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:18:\"PIC018-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34615;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"MAR-LX1A\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1618059171\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.75\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:8:\"0.003024\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:10:\"PIC018.jpg\";}");
INSERT INTO `wp_postmeta` VALUES("624","201","_thumbnail_id","1270");
INSERT INTO `wp_postmeta` VALUES("625","201","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("627","201","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1270;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("628","201","layout_key","");
INSERT INTO `wp_postmeta` VALUES("629","201","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("630","225","_edit_lock","1706975870:1");
INSERT INTO `wp_postmeta` VALUES("633","225","_thumbnail_id","205");
INSERT INTO `wp_postmeta` VALUES("634","225","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("637","225","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:205;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("638","225","layout_key","");
INSERT INTO `wp_postmeta` VALUES("639","225","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("640","227","_edit_lock","1706976017:1");
INSERT INTO `wp_postmeta` VALUES("641","228","_wp_attached_file","2024/02/2020.png");
INSERT INTO `wp_postmeta` VALUES("642","228","_wp_attachment_metadata","a:6:{s:5:\"width\";i:363;s:6:\"height\";i:244;s:4:\"file\";s:16:\"2024/02/2020.png\";s:8:\"filesize\";i:107128;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"2020-300x202.png\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:72114;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"2020-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27772;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:16:\"2020-270x244.png\";s:5:\"width\";i:270;s:6:\"height\";i:244;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:67693;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:16:\"2020-363x235.png\";s:5:\"width\";i:363;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:94509;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("645","227","_thumbnail_id","228");
INSERT INTO `wp_postmeta` VALUES("646","227","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("649","227","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:228;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("650","227","layout_key","");
INSERT INTO `wp_postmeta` VALUES("651","227","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("652","230","_edit_lock","1706976393:1");
INSERT INTO `wp_postmeta` VALUES("653","231","_wp_attached_file","2024/02/feed_2019_08_25.jpg");
INSERT INTO `wp_postmeta` VALUES("654","231","_wp_attachment_metadata","a:6:{s:5:\"width\";i:152;s:6:\"height\";i:200;s:4:\"file\";s:27:\"2024/02/feed_2019_08_25.jpg\";s:8:\"filesize\";i:11119;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"feed_2019_08_25-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5748;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("655","232","_wp_attached_file","2024/02/feed_2019_08_25a.jpg");
INSERT INTO `wp_postmeta` VALUES("656","232","_wp_attachment_metadata","a:6:{s:5:\"width\";i:150;s:6:\"height\";i:126;s:4:\"file\";s:28:\"2024/02/feed_2019_08_25a.jpg\";s:8:\"filesize\";i:12148;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("659","230","_thumbnail_id","231");
INSERT INTO `wp_postmeta` VALUES("660","230","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("663","230","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:231;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("664","230","layout_key","");
INSERT INTO `wp_postmeta` VALUES("665","230","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("666","234","_edit_lock","1707044522:2");
INSERT INTO `wp_postmeta` VALUES("667","235","_wp_attached_file","2024/02/feed_2019_04_28.jpg");
INSERT INTO `wp_postmeta` VALUES("668","235","_wp_attachment_metadata","a:6:{s:5:\"width\";i:300;s:6:\"height\";i:169;s:4:\"file\";s:27:\"2024/02/feed_2019_04_28.jpg\";s:8:\"filesize\";i:27920;s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"feed_2019_04_28-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9608;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:27:\"feed_2019_04_28-270x169.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19114;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("671","234","_thumbnail_id","235");
INSERT INTO `wp_postmeta` VALUES("672","234","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("675","234","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:235;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("676","234","layout_key","");
INSERT INTO `wp_postmeta` VALUES("677","234","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("678","237","_edit_lock","1707068868:2");
INSERT INTO `wp_postmeta` VALUES("679","238","_wp_attached_file","2024/02/feed_2019_04_02_002.jpg");
INSERT INTO `wp_postmeta` VALUES("680","238","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:31:\"2024/02/feed_2019_04_02_002.jpg\";s:8:\"filesize\";i:13077;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"feed_2019_04_02_002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6017;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("681","239","_wp_attached_file","2024/02/feed_2019_04_02_001.jpg");
INSERT INTO `wp_postmeta` VALUES("682","239","_wp_attachment_metadata","a:6:{s:5:\"width\";i:126;s:6:\"height\";i:200;s:4:\"file\";s:31:\"2024/02/feed_2019_04_02_001.jpg\";s:8:\"filesize\";i:10541;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"feed_2019_04_02_001-126x150.jpg\";s:5:\"width\";i:126;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6617;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("685","237","_thumbnail_id","238");
INSERT INTO `wp_postmeta` VALUES("686","237","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("689","237","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:238;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("690","237","layout_key","");
INSERT INTO `wp_postmeta` VALUES("691","237","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("692","241","_edit_lock","1707068709:2");
INSERT INTO `wp_postmeta` VALUES("693","242","_wp_attached_file","2024/02/feed_2019_03_05.jpg");
INSERT INTO `wp_postmeta` VALUES("694","242","_wp_attachment_metadata","a:6:{s:5:\"width\";i:98;s:6:\"height\";i:100;s:4:\"file\";s:27:\"2024/02/feed_2019_03_05.jpg\";s:8:\"filesize\";i:5651;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("697","241","_thumbnail_id","242");
INSERT INTO `wp_postmeta` VALUES("698","241","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("701","241","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:242;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("702","241","layout_key","");
INSERT INTO `wp_postmeta` VALUES("703","241","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("706","245","_edit_lock","1707043374:2");
INSERT INTO `wp_postmeta` VALUES("707","246","_wp_attached_file","2024/02/feed_2019_02_24.jpg");
INSERT INTO `wp_postmeta` VALUES("708","246","_wp_attachment_metadata","a:6:{s:5:\"width\";i:220;s:6:\"height\";i:110;s:4:\"file\";s:27:\"2024/02/feed_2019_02_24.jpg\";s:8:\"filesize\";i:14313;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"feed_2019_02_24-150x110.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7661;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("711","245","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("714","245","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:246;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("715","245","layout_key","");
INSERT INTO `wp_postmeta` VALUES("716","245","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("717","249","_edit_lock","1709373540:2");
INSERT INTO `wp_postmeta` VALUES("718","249","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("721","249","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("724","249","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:161;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("725","249","layout_key","");
INSERT INTO `wp_postmeta` VALUES("727","249","_thumbnail_id","161");
INSERT INTO `wp_postmeta` VALUES("730","253","_edit_lock","1738388914:2");
INSERT INTO `wp_postmeta` VALUES("733","253","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("736","253","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:235;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("737","253","layout_key","");
INSERT INTO `wp_postmeta` VALUES("738","253","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("739","253","_thumbnail_id","235");
INSERT INTO `wp_postmeta` VALUES("748","259","_edit_lock","1738533201:2");
INSERT INTO `wp_postmeta` VALUES("749","259","_thumbnail_id","143");
INSERT INTO `wp_postmeta` VALUES("750","259","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("751","259","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:143;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("752","259","layout_key","");
INSERT INTO `wp_postmeta` VALUES("753","259","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("754","261","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("755","261","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("756","261","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("757","261","_menu_item_object_id","259");
INSERT INTO `wp_postmeta` VALUES("758","261","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("759","261","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("760","261","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("761","261","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("762","261","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("764","102","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("765","80","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("766","114","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("767","79","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("768","86","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("769","103","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("770","142","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("771","142","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("772","135","_wp_old_date","2024-02-03");
INSERT INTO `wp_postmeta` VALUES("775","246","_edit_lock","1707042838:1");
INSERT INTO `wp_postmeta` VALUES("795","267","_edit_lock","1761823262:1");
INSERT INTO `wp_postmeta` VALUES("800","267","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("801","267","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("802","267","layout_key","");
INSERT INTO `wp_postmeta` VALUES("803","267","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("804","271","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("805","271","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("806","271","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("807","271","_menu_item_object_id","267");
INSERT INTO `wp_postmeta` VALUES("808","271","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("809","271","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("810","271","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("811","271","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("812","271","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("816","277","_edit_lock","1742136956:1");
INSERT INTO `wp_postmeta` VALUES("819","277","_thumbnail_id","1264");
INSERT INTO `wp_postmeta` VALUES("820","277","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("823","277","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1264;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("824","277","layout_key","");
INSERT INTO `wp_postmeta` VALUES("825","277","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("828","71","_oembed_31978c36af55da7dfa1987d96a7ffc4d","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("829","53","_oembed_a6f0559d6f86e588fb43e4a4d0cab6ec","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("833","253","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("834","249","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("835","245","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("836","241","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("837","237","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("838","259","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("839","139","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("840","117","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("841","104","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("842","82","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("843","277","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("844","267","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("999","267","pagelayer-data","1707334552");
INSERT INTO `wp_postmeta` VALUES("1017","271","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1020","313","_wp_attached_file","2024/02/slarclogo.png");
INSERT INTO `wp_postmeta` VALUES("1021","313","_wp_attachment_metadata","a:6:{s:5:\"width\";i:162;s:6:\"height\";i:162;s:4:\"file\";s:21:\"2024/02/slarclogo.png\";s:8:\"filesize\";i:27819;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"slarclogo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:20921;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1024","86","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1029","317","_wp_attached_file","2024/02/abrhamcommunitycentre.jpg");
INSERT INTO `wp_postmeta` VALUES("1030","317","_wp_attachment_metadata","a:6:{s:5:\"width\";i:960;s:6:\"height\";i:720;s:4:\"file\";s:33:\"2024/02/abrhamcommunitycentre.jpg\";s:8:\"filesize\";i:172203;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19960;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7477;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:111835;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-960x444.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:126106;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55006;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19246;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-960x500.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140886;}s:6:\"slider\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-960x500.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140886;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65383;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-960x624.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162662;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44170;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:33:\"abrhamcommunitycentre-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36001;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1032","320","_wp_attached_file","2024/02/abrhamcommunitycentre-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1033","320","_wp_attachment_metadata","a:6:{s:5:\"width\";i:960;s:6:\"height\";i:720;s:4:\"file\";s:35:\"2024/02/abrhamcommunitycentre-1.jpg\";s:8:\"filesize\";i:172203;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19960;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7477;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:111835;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-960x444.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:126106;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55006;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19246;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-960x500.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140886;}s:6:\"slider\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-960x500.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140886;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65383;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-960x624.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:162662;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44170;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:35:\"abrhamcommunitycentre-1-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36001;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1034","322","_wp_attached_file","2024/02/gb7hn.png");
INSERT INTO `wp_postmeta` VALUES("1035","322","_wp_attachment_metadata","a:6:{s:5:\"width\";i:498;s:6:\"height\";i:801;s:4:\"file\";s:17:\"2024/02/gb7hn.png\";s:8:\"filesize\";i:31333;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"gb7hn-187x300.png\";s:5:\"width\";i:187;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17714;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"gb7hn-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7699;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x444.png\";s:5:\"width\";i:498;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16140;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x350.png\";s:5:\"width\";i:498;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12580;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:17:\"gb7hn-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17589;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x500.png\";s:5:\"width\";i:498;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17569;}s:6:\"slider\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x500.png\";s:5:\"width\";i:498;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17569;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x510.png\";s:5:\"width\";i:498;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17991;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x624.png\";s:5:\"width\";i:498;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21514;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x297.png\";s:5:\"width\";i:498;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10907;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:17:\"gb7hn-498x235.png\";s:5:\"width\";i:498;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8315;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1047","327","_wp_attached_file","2024/02/training01.jpg");
INSERT INTO `wp_postmeta` VALUES("1048","327","_wp_attachment_metadata","a:6:{s:5:\"width\";i:121;s:6:\"height\";i:171;s:4:\"file\";s:22:\"2024/02/training01.jpg\";s:8:\"filesize\";i:9508;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"training01-121x150.jpg\";s:5:\"width\";i:121;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6606;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1049","328","_wp_attached_file","2024/02/training02.jpg");
INSERT INTO `wp_postmeta` VALUES("1050","328","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:170;s:4:\"file\";s:22:\"2024/02/training02.jpg\";s:8:\"filesize\";i:9656;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"training02-120x150.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6733;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1051","329","_wp_attached_file","2024/02/training03.jpg");
INSERT INTO `wp_postmeta` VALUES("1052","329","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:170;s:4:\"file\";s:22:\"2024/02/training03.jpg\";s:8:\"filesize\";i:9906;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"training03-120x150.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6824;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1053","330","_wp_attached_file","2024/02/training04.jpg");
INSERT INTO `wp_postmeta` VALUES("1054","330","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:166;s:4:\"file\";s:22:\"2024/02/training04.jpg\";s:8:\"filesize\";i:10155;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"training04-120x150.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7099;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1055","332","_wp_attached_file","2024/02/00slide03.jpg");
INSERT INTO `wp_postmeta` VALUES("1056","332","_wp_attachment_metadata","a:6:{s:5:\"width\";i:250;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2024/02/00slide03.jpg\";s:8:\"filesize\";i:12157;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"00slide03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5249;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1058","333","_wp_attached_file","2024/02/feed_2019_04_02_001-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1059","333","_wp_attachment_metadata","a:6:{s:5:\"width\";i:126;s:6:\"height\";i:200;s:4:\"file\";s:33:\"2024/02/feed_2019_04_02_001-1.jpg\";s:8:\"filesize\";i:10541;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"feed_2019_04_02_001-1-126x150.jpg\";s:5:\"width\";i:126;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6617;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1060","334","_wp_attached_file","2024/02/00slide04.jpg");
INSERT INTO `wp_postmeta` VALUES("1061","334","_wp_attachment_metadata","a:6:{s:5:\"width\";i:250;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2024/02/00slide04.jpg\";s:8:\"filesize\";i:30549;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"00slide04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11648;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1062","335","_wp_attached_file","2024/02/00slide01.jpg");
INSERT INTO `wp_postmeta` VALUES("1063","335","_wp_attachment_metadata","a:6:{s:5:\"width\";i:250;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2024/02/00slide01.jpg\";s:8:\"filesize\";i:13110;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"00slide01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5334;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1064","336","_wp_attached_file","2024/02/00slide02.jpg");
INSERT INTO `wp_postmeta` VALUES("1065","336","_wp_attachment_metadata","a:6:{s:5:\"width\";i:250;s:6:\"height\";i:172;s:4:\"file\";s:21:\"2024/02/00slide02.jpg\";s:8:\"filesize\";i:22659;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"00slide02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9269;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1066","337","_wp_attached_file","2024/02/activities_club.jpg");
INSERT INTO `wp_postmeta` VALUES("1067","337","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:138;s:4:\"file\";s:27:\"2024/02/activities_club.jpg\";s:8:\"filesize\";i:14221;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"activities_club-150x138.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8626;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1068","338","_wp_attached_file","2024/02/activities_fielddays.jpg");
INSERT INTO `wp_postmeta` VALUES("1069","338","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:164;s:4:\"file\";s:32:\"2024/02/activities_fielddays.jpg\";s:8:\"filesize\";i:15004;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"activities_fielddays-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7418;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1070","339","_wp_attached_file","2024/02/activities_net.jpg");
INSERT INTO `wp_postmeta` VALUES("1071","339","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:164;s:4:\"file\";s:26:\"2024/02/activities_net.jpg\";s:8:\"filesize\";i:20390;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"activities_net-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9702;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1072","340","_wp_attached_file","2024/02/Ashurst_Beacon-1.png");
INSERT INTO `wp_postmeta` VALUES("1073","340","_wp_attachment_metadata","a:6:{s:5:\"width\";i:205;s:6:\"height\";i:141;s:4:\"file\";s:28:\"2024/02/Ashurst_Beacon-1.png\";s:8:\"filesize\";i:69879;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"Ashurst_Beacon-1-150x141.png\";s:5:\"width\";i:150;s:6:\"height\";i:141;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54687;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1075","342","_wp_attached_file","2024/02/1000006514.jpg");
INSERT INTO `wp_postmeta` VALUES("1076","342","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:22:\"2024/02/1000006514.jpg\";s:8:\"filesize\";i:352281;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"1000006514-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8048;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"1000006514-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48706;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"1000006514-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4724;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"1000006514-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:97421;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"1000006514-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86360;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:23:\"1000006514-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:126174;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"1000006514-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42503;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"1000006514-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23881;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"1000006514-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11079;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"1000006514-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42524;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"1000006514-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42524;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"1000006514-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28389;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"1000006514-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55857;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"1000006514-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19248;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"1000006514-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15125;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1138","355","_edit_lock","1711085783:2");
INSERT INTO `wp_postmeta` VALUES("1141","355","_thumbnail_id","421");
INSERT INTO `wp_postmeta` VALUES("1142","355","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1143","355","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:421;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("1144","355","layout_key","");
INSERT INTO `wp_postmeta` VALUES("1145","355","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("1152","360","_wp_attached_file","2024/02/Screenshot_20240217_154305_Chrome.jpg");
INSERT INTO `wp_postmeta` VALUES("1153","360","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:45:\"2024/02/Screenshot_20240217_154305_Chrome.jpg\";s:8:\"filesize\";i:384061;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8733;}s:5:\"large\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56132;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5664;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112672;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96203;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140960;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50978;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26823;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12944;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64468;}s:6:\"slider\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64468;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33665;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240217_154305_Chrome-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70168;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24194;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240217_154305_Chrome-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21326;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1165","365","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("1175","102","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1176","261","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1177","80","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1178","114","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1179","79","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1180","86","_wp_old_date","2024-02-09");
INSERT INTO `wp_postmeta` VALUES("1181","103","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1182","142","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1183","135","_wp_old_date","2024-02-04");
INSERT INTO `wp_postmeta` VALUES("1184","271","_wp_old_date","2024-02-09");
INSERT INTO `wp_postmeta` VALUES("1186","369","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("1199","82","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1200","67","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1202","379","_wp_attached_file","2024/02/team_dh-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1203","379","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:21:\"2024/02/team_dh-1.jpg\";s:8:\"filesize\";i:6924;s:5:\"sizes\";a:1:{s:18:\"cmplz_banner_image\";a:5:{s:4:\"file\";s:21:\"team_dh-1-120x100.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4627;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1204","380","_wp_attached_file","2024/02/team_sh-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1205","380","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:21:\"2024/02/team_sh-1.jpg\";s:8:\"filesize\";i:5153;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1206","381","_wp_attached_file","2024/02/team_rh-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1207","381","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:21:\"2024/02/team_rh-1.jpg\";s:8:\"filesize\";i:6782;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1208","382","_wp_attached_file","2024/02/team_sc-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1209","382","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:21:\"2024/02/team_sc-1.jpg\";s:8:\"filesize\";i:12077;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1210","383","_wp_attached_file","2024/02/team_cw-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1211","383","_wp_attachment_metadata","a:6:{s:5:\"width\";i:110;s:6:\"height\";i:134;s:4:\"file\";s:21:\"2024/02/team_cw-1.jpg\";s:8:\"filesize\";i:3784;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1212","384","_wp_attached_file","2024/02/team_ml-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1213","384","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:21:\"2024/02/team_ml-1.jpg\";s:8:\"filesize\";i:7095;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1214","385","_wp_attached_file","2024/02/team_who-1.png");
INSERT INTO `wp_postmeta` VALUES("1215","385","_wp_attachment_metadata","a:6:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"file\";s:22:\"2024/02/team_who-1.png\";s:8:\"filesize\";i:2371;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1216","104","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1219","58","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1227","7","_edit_lock","1758459798:1");
INSERT INTO `wp_postmeta` VALUES("1263","355","mihdan_index_now_last_update","1711085783");
INSERT INTO `wp_postmeta` VALUES("1266","355","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1268","399","_wp_attached_file","2024/02/1000006518.jpg");
INSERT INTO `wp_postmeta` VALUES("1269","399","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:22:\"2024/02/1000006518.jpg\";s:8:\"filesize\";i:282568;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"1000006518-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6332;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"1000006518-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39241;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"1000006518-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4118;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"1000006518-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:81947;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"1000006518-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70494;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:23:\"1000006518-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104144;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"1000006518-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37495;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"1000006518-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23575;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"1000006518-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10076;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"1000006518-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45487;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"1000006518-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45487;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"1000006518-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25890;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"1000006518-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54321;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"1000006518-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18533;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"1000006518-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14300;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1273","402","_wp_attached_file","2024/02/feed_2019_04_28-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1274","402","_wp_attachment_metadata","a:6:{s:5:\"width\";i:300;s:6:\"height\";i:169;s:4:\"file\";s:29:\"2024/02/feed_2019_04_28-1.jpg\";s:8:\"filesize\";i:27920;s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"feed_2019_04_28-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9608;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:29:\"feed_2019_04_28-1-270x169.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19114;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1275","253","mihdan_index_now_last_update","1713937758");
INSERT INTO `wp_postmeta` VALUES("1280","253","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1282","136","_wp_attachment_backup_sizes","a:1:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:294;s:6:\"height\";i:498;s:4:\"file\";s:8:\"logo.gif\";}}");
INSERT INTO `wp_postmeta` VALUES("1289","421","_wp_attached_file","2024/02/Screenshot_20240225_060227_Chrome.jpg");
INSERT INTO `wp_postmeta` VALUES("1290","421","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:45:\"2024/02/Screenshot_20240225_060227_Chrome.jpg\";s:8:\"filesize\";i:313053;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7385;}s:5:\"large\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45944;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4174;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93871;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79562;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:117360;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35772;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23021;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10258;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43643;}s:6:\"slider\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43643;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25602;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:46:\"Screenshot_20240225_060227_Chrome-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55153;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20379;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:45:\"Screenshot_20240225_060227_Chrome-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15207;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1313","267","mihdan_index_now_last_update","1712951375");
INSERT INTO `wp_postmeta` VALUES("1314","267","footnotes","");
INSERT INTO `wp_postmeta` VALUES("1317","267","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1318","267","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("1341","104","mihdan_index_now_last_update","1713092668");
INSERT INTO `wp_postmeta` VALUES("1342","104","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("1405","441","_wp_attached_file","2024/02/newslarc_png.jpg");
INSERT INTO `wp_postmeta` VALUES("1406","441","_wp_attachment_metadata","a:6:{s:5:\"width\";i:745;s:6:\"height\";i:1199;s:4:\"file\";s:24:\"2024/02/newslarc_png.jpg\";s:8:\"filesize\";i:72336;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"newslarc_png-186x300.jpg\";s:5:\"width\";i:186;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16150;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"newslarc_png-636x1024.jpg\";s:5:\"width\";i:636;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76484;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"newslarc_png-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7955;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:24:\"newslarc_png-745x444.jpg\";s:5:\"width\";i:745;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40193;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:24:\"newslarc_png-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29392;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:24:\"newslarc_png-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16554;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:24:\"newslarc_png-745x500.jpg\";s:5:\"width\";i:745;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44481;}s:6:\"slider\";a:5:{s:4:\"file\";s:24:\"newslarc_png-745x500.jpg\";s:5:\"width\";i:745;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44481;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:24:\"newslarc_png-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39979;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:24:\"newslarc_png-745x624.jpg\";s:5:\"width\";i:745;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52351;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:24:\"newslarc_png-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25640;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:24:\"newslarc_png-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21763;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1408","443","_wp_attached_file","2024/02/newslarc_png-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1409","443","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2024/02/newslarc_png-1.jpg\";s:8:\"filesize\";i:20506;s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"newslarc_png-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7509;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:26:\"newslarc_png-1-200x250.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13736;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:26:\"newslarc_png-1-200x297.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15450;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:26:\"newslarc_png-1-200x235.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13237;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1421","446","_edit_lock","1715524518:2");
INSERT INTO `wp_postmeta` VALUES("1422","447","_wp_attached_file","2024/02/341013634_1893320937716132_5653939237683159664_n.jpg");
INSERT INTO `wp_postmeta` VALUES("1423","447","_wp_attachment_metadata","a:6:{s:5:\"width\";i:720;s:6:\"height\";i:402;s:4:\"file\";s:60:\"2024/02/341013634_1893320937716132_5653939237683159664_n.jpg\";s:8:\"filesize\";i:38161;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10794;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5788;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28765;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12440;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-510x402.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:402;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28069;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24318;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:60:\"341013634_1893320937716132_5653939237683159664_n-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20062;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1424","446","mihdan_index_now_last_update","1709299717");
INSERT INTO `wp_postmeta` VALUES("1428","446","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("1429","446","_thumbnail_id","589");
INSERT INTO `wp_postmeta` VALUES("1430","446","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1433","446","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1434","446","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:589;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("1435","446","layout_key","");
INSERT INTO `wp_postmeta` VALUES("1436","446","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("1437","446","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("1462","249","mihdan_index_now_last_update","1709373540");
INSERT INTO `wp_postmeta` VALUES("1482","446","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1483","227","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1484","225","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1507","469","_edit_lock","1712403241:2");
INSERT INTO `wp_postmeta` VALUES("1508","470","_wp_attached_file","2024/03/1000006730.jpg");
INSERT INTO `wp_postmeta` VALUES("1509","470","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:22:\"2024/03/1000006730.jpg\";s:8:\"filesize\";i:275834;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"1000006730-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6174;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"1000006730-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38653;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"1000006730-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4478;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"1000006730-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:76557;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"1000006730-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69154;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:23:\"1000006730-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:102535;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"1000006730-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41920;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"1000006730-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21375;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"1000006730-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10713;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"1000006730-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47404;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"1000006730-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47404;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"1000006730-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27083;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"1000006730-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52121;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"1000006730-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18045;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"1000006730-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14885;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1510","471","_wp_attached_file","2024/03/1000006729.jpg");
INSERT INTO `wp_postmeta` VALUES("1511","471","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:2400;s:4:\"file\";s:22:\"2024/03/1000006729.jpg\";s:8:\"filesize\";i:410229;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"1000006729-135x300.jpg\";s:5:\"width\";i:135;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9939;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"1000006729-461x1024.jpg\";s:5:\"width\";i:461;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60033;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"1000006729-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5770;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"1000006729-768x1707.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:118274;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"1000006729-691x1536.jpg\";s:5:\"width\";i:691;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103568;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:23:\"1000006729-922x2048.jpg\";s:5:\"width\";i:922;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:152013;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"1000006729-1080x444.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36625;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"1000006729-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19965;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"1000006729-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11817;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:23:\"1000006729-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42726;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"1000006729-1080x500.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42726;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"1000006729-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27936;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"1000006729-1080x624.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47797;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"1000006729-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17434;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"1000006729-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14442;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1512","469","mihdan_index_now_last_update","1712403241");
INSERT INTO `wp_postmeta` VALUES("1516","469","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("1517","469","_thumbnail_id","443");
INSERT INTO `wp_postmeta` VALUES("1518","469","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1521","469","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("1522","469","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:443;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("1523","469","layout_key","");
INSERT INTO `wp_postmeta` VALUES("1524","469","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("1525","469","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("1902","469","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1903","201","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1904","197","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("1905","365","_wp_suggested_privacy_policy_content","a:3:{s:11:\"plugin_name\";s:9:\"WordPress\";s:11:\"policy_text\";s:4475:\"<h2 class=\"wp-block-heading\">Who we are</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: https://www.southlancsarc.co.uk.</p><h2 class=\"wp-block-heading\">Comments</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><p>An anonymised string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service Privacy Policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><h2 class=\"wp-block-heading\">Media</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><h2 class=\"wp-block-heading\">Cookies</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><h2 class=\"wp-block-heading\">Embedded content from other websites</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><h2 class=\"wp-block-heading\">Who we share your data with</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><h2 class=\"wp-block-heading\">How long we retain your data</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognise and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><h2 class=\"wp-block-heading\">What rights you have over your data</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><h2 class=\"wp-block-heading\">Where your data is sent</h2><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p>\";s:5:\"added\";i:1712383670;}");
INSERT INTO `wp_postmeta` VALUES("1906","365","_wp_suggested_privacy_policy_content","a:3:{s:11:\"plugin_name\";s:16:\"Burst Statistics\";s:11:\"policy_text\";s:393:\"<p>This website uses Burst Statistics, a Privacy-Friendly Statistics Tool to analyse visitor behaviour. For this functionality we (this website) collect anonymised data, stored locally without sharing it with other parties. For more information, please read the <a href=\"https://burst-statistics.com/legal/privacy-statement/\" target=\"_blank\"> Privacy Statement </a> from Burst Statistics.</p>\n\";s:5:\"added\";i:1712383670;}");
INSERT INTO `wp_postmeta` VALUES("1907","365","_wp_suggested_privacy_policy_content","a:3:{s:11:\"plugin_name\";s:17:\"Really Simple SSL\";s:11:\"policy_text\";s:339:\"<p>Really Simple SSL and Really Simple SSL add-ons do not process any personal identifiable information, so the GDPR does not apply to these plugins or usage of these plugins on your website. You can find our privacy policy <a href=\"https://really-simple-ssl.com/privacy-statement/\" rel=\"noopener noreferrer\" target=\"_blank\">here</a>.</p>\n\";s:5:\"added\";i:1712383670;}");
INSERT INTO `wp_postmeta` VALUES("1908","365","_wp_suggested_privacy_policy_content","a:3:{s:11:\"plugin_name\";s:43:\"Complianz | The Privacy Suite for WordPress\";s:11:\"policy_text\";s:462:\"<p>This website uses the Privacy Suite for WordPress by Complianz to collect and record Browser and Device-based Consent. For this functionality, your IP address is anonymized and stored in our database.&nbsp;This service does not process any personally identifiable information and does not share any data with the service provider.&nbsp;For more information, see the Complianz <a href=\"https://complianz.io/legal/privacy-statement/\">Privacy Statement</a>.</p>\n\";s:5:\"added\";i:1712383670;}");
INSERT INTO `wp_postmeta` VALUES("1909","365","_wp_suggested_privacy_policy_content","a:3:{s:11:\"plugin_name\";s:7:\"Akismet\";s:11:\"policy_text\";s:400:\"We collect information about visitors who comment on sites that use our Akismet Anti-spam service. The information we collect depends on how the user sets up Akismet for the site, but typically includes the commenter\'s IP address, user agent, referrer, and site URL (along with other information directly provided by the commenter such as their name, username, email address, and the comment itself).\";s:5:\"added\";i:1712383670;}");
INSERT INTO `wp_postmeta` VALUES("2134","253","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2311","117","mihdan_index_now_last_update","1713934106");
INSERT INTO `wp_postmeta` VALUES("2312","117","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("2313","117","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2368","540","_edit_lock","1717064483:2");
INSERT INTO `wp_postmeta` VALUES("2369","541","_wp_attached_file","2024/04/link_rsgb.png");
INSERT INTO `wp_postmeta` VALUES("2370","541","_wp_attachment_metadata","a:6:{s:5:\"width\";i:63;s:6:\"height\";i:124;s:4:\"file\";s:21:\"2024/04/link_rsgb.png\";s:8:\"filesize\";i:10298;s:5:\"sizes\";a:1:{s:18:\"cmplz_banner_image\";a:5:{s:4:\"file\";s:20:\"link_rsgb-63x100.png\";s:5:\"width\";i:63;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9699;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2371","541","_wp_attachment_image_alt","Guest Speaker David Crowe");
INSERT INTO `wp_postmeta` VALUES("2372","540","mihdan_index_now_last_update","1714456947");
INSERT INTO `wp_postmeta` VALUES("2376","540","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("2377","540","_thumbnail_id","320");
INSERT INTO `wp_postmeta` VALUES("2378","540","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("2381","540","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("2382","540","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:320;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("2383","540","layout_key","");
INSERT INTO `wp_postmeta` VALUES("2384","540","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("2385","540","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2410","555","_wp_attached_file","2024/04/link_echo.gif");
INSERT INTO `wp_postmeta` VALUES("2411","555","_wp_attachment_metadata","a:6:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:21:\"2024/04/link_echo.gif\";s:8:\"filesize\";i:589;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2580","13","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:758;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("2581","540","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("2582","195","_cmplz_scanned_post","1");
INSERT INTO `wp_postmeta` VALUES("2584","575","_edit_lock","1720814539:2");
INSERT INTO `wp_postmeta` VALUES("2585","576","_wp_attached_file","2024/05/440802866_804178661770154_8697788213306598660_n.jpg");
INSERT INTO `wp_postmeta` VALUES("2586","576","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1434;s:6:\"height\";i:809;s:4:\"file\";s:59:\"2024/05/440802866_804178661770154_8697788213306598660_n.jpg\";s:8:\"filesize\";i:211900;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18928;}s:5:\"large\";a:5:{s:4:\"file\";s:60:\"440802866_804178661770154_8697788213306598660_n-1024x578.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:578;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:135649;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9820;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-768x433.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:87397;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:60:\"440802866_804178661770154_8697788213306598660_n-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:102922;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59179;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23751;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:60:\"440802866_804178661770154_8697788213306598660_n-1434x500.jpg\";s:5:\"width\";i:1434;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:136381;}s:6:\"slider\";a:5:{s:4:\"file\";s:60:\"440802866_804178661770154_8697788213306598660_n-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:118679;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67049;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:60:\"440802866_804178661770154_8697788213306598660_n-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:151366;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47798;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:59:\"440802866_804178661770154_8697788213306598660_n-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37347;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2587","577","_wp_attached_file","2024/05/Final-Net-List-for-145-Alive-PDF.pdf");
INSERT INTO `wp_postmeta` VALUES("2588","577","_wp_attachment_metadata","a:1:{s:8:\"filesize\";i:226363;}");
INSERT INTO `wp_postmeta` VALUES("2589","578","_wp_attached_file","2024/05/439218176_803457138508973_4368234651293654798_n.jpg");
INSERT INTO `wp_postmeta` VALUES("2590","578","_wp_attachment_metadata","a:6:{s:5:\"width\";i:881;s:6:\"height\";i:679;s:4:\"file\";s:59:\"2024/05/439218176_803457138508973_4368234651293654798_n.jpg\";s:8:\"filesize\";i:219209;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21933;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6789;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-768x592.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:592;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:128351;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-881x444.jpg\";s:5:\"width\";i:881;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125184;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60649;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18551;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-881x500.jpg\";s:5:\"width\";i:881;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:138947;}s:6:\"slider\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-881x500.jpg\";s:5:\"width\";i:881;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:138947;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62717;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-881x624.jpg\";s:5:\"width\";i:881;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:166587;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48870;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:59:\"439218176_803457138508973_4368234651293654798_n-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40107;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2591","575","mihdan_index_now_last_update","1714998520");
INSERT INTO `wp_postmeta` VALUES("2595","575","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("2596","575","_thumbnail_id","576");
INSERT INTO `wp_postmeta` VALUES("2597","575","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("2600","575","cmplz_hide_cookiebanner","");
INSERT INTO `wp_postmeta` VALUES("2601","575","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:576;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("2602","575","layout_key","");
INSERT INTO `wp_postmeta` VALUES("2603","575","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("2604","575","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2643","589","_wp_attached_file","2024/05/341013634_1893320937716132_5653939237683159664_n.webp");
INSERT INTO `wp_postmeta` VALUES("2644","589","_wp_attachment_metadata","a:6:{s:5:\"width\";i:720;s:6:\"height\";i:402;s:4:\"file\";s:61:\"2024/05/341013634_1893320937716132_5653939237683159664_n.webp\";s:8:\"filesize\";i:21756;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-300x168.webp\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7758;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4228;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-570x350.webp\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:18752;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-270x250.webp\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8530;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-510x402.webp\";s:5:\"width\";i:510;s:6:\"height\";i:402;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:19920;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-528x297.webp\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16266;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:61:\"341013634_1893320937716132_5653939237683159664_n-517x235.webp\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:13266;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2647","590","_email","cwoodalluk@yahoo.co.uk");
INSERT INTO `wp_postmeta` VALUES("2648","590","_name","Admin.Carl");
INSERT INTO `wp_postmeta` VALUES("2649","590","_props","a:2:{s:10:\"first_name\";s:10:\"Admin.Carl\";s:9:\"last_name\";s:7:\"woodall\";}");
INSERT INTO `wp_postmeta` VALUES("2650","590","_last_contacted","2025-02-01 05:50:49");
INSERT INTO `wp_postmeta` VALUES("2653","591","_wp_attached_file","2024/05/newslarc_png-1.webp");
INSERT INTO `wp_postmeta` VALUES("2654","591","_wp_attachment_metadata","a:6:{s:5:\"width\";i:200;s:6:\"height\";i:300;s:4:\"file\";s:27:\"2024/05/newslarc_png-1.webp\";s:8:\"filesize\";i:7396;s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"newslarc_png-1-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4508;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:27:\"newslarc_png-1-200x250.webp\";s:5:\"width\";i:200;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7740;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:27:\"newslarc_png-1-200x297.webp\";s:5:\"width\";i:200;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:8144;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:27:\"newslarc_png-1-200x235.webp\";s:5:\"width\";i:200;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7132;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2664","109","_wp_attachment_image_alt","carl");
INSERT INTO `wp_postmeta` VALUES("2666","246","_wp_attachment_image_alt","training");
INSERT INTO `wp_postmeta` VALUES("2763","590","_wp_old_date","2024-05-12");
INSERT INTO `wp_postmeta` VALUES("2783","616","_email","willburkemma@gmail.com");
INSERT INTO `wp_postmeta` VALUES("2784","616","_name","Will Burke");
INSERT INTO `wp_postmeta` VALUES("2785","616","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("2786","616","_last_contacted","2024-06-04 14:55:50");
INSERT INTO `wp_postmeta` VALUES("2839","58","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2841","67","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("2843","82","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("3164","661","_email","stuart@m7spi.co.uk");
INSERT INTO `wp_postmeta` VALUES("3165","661","_name","stuart");
INSERT INTO `wp_postmeta` VALUES("3166","661","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("3167","661","_last_contacted","2025-03-16 15:29:38");
INSERT INTO `wp_postmeta` VALUES("3184","616","_wp_old_date","2024-05-15");
INSERT INTO `wp_postmeta` VALUES("3218","665","_email","pat@aneesho.com");
INSERT INTO `wp_postmeta` VALUES("3219","665","_name","Charles S.");
INSERT INTO `wp_postmeta` VALUES("3220","665","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("3221","665","_last_contacted","2024-06-07 06:49:45");
INSERT INTO `wp_postmeta` VALUES("3407","683","_email","davehine48@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3408","683","_name","David Hine");
INSERT INTO `wp_postmeta` VALUES("3409","683","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("3410","683","_last_contacted","2024-07-02 17:11:30");
INSERT INTO `wp_postmeta` VALUES("3497","691","_edit_lock","1720814208:2");
INSERT INTO `wp_postmeta` VALUES("3498","692","_wp_attached_file","2024/07/amateur_radio_licence_guidance_for_licensees.pdf");
INSERT INTO `wp_postmeta` VALUES("3499","692","_wp_attachment_metadata","a:1:{s:8:\"filesize\";i:378746;}");
INSERT INTO `wp_postmeta` VALUES("3500","661","_wp_old_date","2024-06-03");
INSERT INTO `wp_postmeta` VALUES("3501","693","_wp_attached_file","2024/07/callsign.png");
INSERT INTO `wp_postmeta` VALUES("3502","693","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1144;s:6:\"height\";i:508;s:4:\"file\";s:20:\"2024/07/callsign.png\";s:8:\"filesize\";i:41517;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"callsign-300x133.png\";s:5:\"width\";i:300;s:6:\"height\";i:133;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11914;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"callsign-1024x455.png\";s:5:\"width\";i:1024;s:6:\"height\";i:455;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:71274;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"callsign-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9469;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"callsign-768x341.png\";s:5:\"width\";i:768;s:6:\"height\";i:341;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:48384;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"callsign-1110x444.png\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62104;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:20:\"callsign-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:43742;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:20:\"callsign-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22549;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"callsign-1144x500.png\";s:5:\"width\";i:1144;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38528;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"callsign-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:80799;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:20:\"callsign-510x508.png\";s:5:\"width\";i:510;s:6:\"height\";i:508;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27119;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"callsign-1110x508.png\";s:5:\"width\";i:1110;s:6:\"height\";i:508;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38937;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:20:\"callsign-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:37133;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:20:\"callsign-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27887;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3503","694","_wp_attached_file","2024/07/UK_amateur_radio_regional_locators.svg.png");
INSERT INTO `wp_postmeta` VALUES("3504","694","_wp_attachment_metadata","a:6:{s:5:\"width\";i:220;s:6:\"height\";i:359;s:4:\"file\";s:50:\"2024/07/UK_amateur_radio_regional_locators.svg.png\";s:8:\"filesize\";i:11224;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-184x300.png\";s:5:\"width\";i:184;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:34230;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19957;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-220x350.png\";s:5:\"width\";i:220;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35041;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-220x250.png\";s:5:\"width\";i:220;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30040;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-220x297.png\";s:5:\"width\";i:220;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:32084;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:50:\"UK_amateur_radio_regional_locators.svg-220x235.png\";s:5:\"width\";i:220;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28878;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3508","691","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("3509","691","_thumbnail_id","693");
INSERT INTO `wp_postmeta` VALUES("3510","691","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("3513","691","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:693;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("3514","691","layout_key","");
INSERT INTO `wp_postmeta` VALUES("3515","691","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("3516","691","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("3517","590","_wp_old_date","2024-05-14");
INSERT INTO `wp_postmeta` VALUES("3521","707","_wp_attached_file","2024/05/342393918_1408399239997233_5132571030679724801_n.jpg");
INSERT INTO `wp_postmeta` VALUES("3522","707","_wp_attachment_metadata","a:6:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"file\";s:60:\"2024/05/342393918_1408399239997233_5132571030679724801_n.jpg\";s:8:\"filesize\";i:142740;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14396;}s:5:\"large\";a:5:{s:4:\"file\";s:62:\"342393918_1408399239997233_5132571030679724801_n-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67990;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5549;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47463;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:62:\"342393918_1408399239997233_5132571030679724801_n-1536x1536.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115156;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:61:\"342393918_1408399239997233_5132571030679724801_n-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36121;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24845;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12227;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:61:\"342393918_1408399239997233_5132571030679724801_n-2048x500.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45083;}s:6:\"slider\";a:5:{s:4:\"file\";s:61:\"342393918_1408399239997233_5132571030679724801_n-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40771;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28840;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:61:\"342393918_1408399239997233_5132571030679724801_n-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50305;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21212;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:60:\"342393918_1408399239997233_5132571030679724801_n-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16939;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3596","713","_email","stebridge16@gmail.com");
INSERT INTO `wp_postmeta` VALUES("3597","713","_name","Ste bridge");
INSERT INTO `wp_postmeta` VALUES("3598","713","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("3599","713","_last_contacted","2024-07-17 16:02:40");
INSERT INTO `wp_postmeta` VALUES("3906","757","_wp_attached_file","2024/08/slarclogo.webp");
INSERT INTO `wp_postmeta` VALUES("3907","757","_wp_attachment_metadata","a:6:{s:5:\"width\";i:162;s:6:\"height\";i:162;s:4:\"file\";s:22:\"2024/08/slarclogo.webp\";s:8:\"filesize\";i:16624;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"slarclogo-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6310;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3908","758","_wp_attached_file","2024/08/cropped-slarclogo.webp");
INSERT INTO `wp_postmeta` VALUES("3909","758","_wp_attachment_context","control-id");
INSERT INTO `wp_postmeta` VALUES("3910","758","_wp_attachment_metadata","a:6:{s:5:\"width\";i:162;s:6:\"height\";i:162;s:4:\"file\";s:30:\"2024/08/cropped-slarclogo.webp\";s:8:\"filesize\";i:6626;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-slarclogo-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6058;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("3911","661","_wp_old_date","2024-07-12");
INSERT INTO `wp_postmeta` VALUES("3912","661","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";b:0;s:11:\"_thumb_type\";s:10:\"attachment\";}");
INSERT INTO `wp_postmeta` VALUES("4649","793","_edit_lock","1742137572:1");
INSERT INTO `wp_postmeta` VALUES("4650","793","_oembed_815af3f290eded49510c3db0dcf5c6cb","<iframe title=\"Licence Changes 2024 - Guidance for Students\" width=\"1140\" height=\"641\" src=\"https://www.youtube.com/embed/E0hVGXC4SXg?start=7&feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("4651","793","_oembed_time_815af3f290eded49510c3db0dcf5c6cb","1725207904");
INSERT INTO `wp_postmeta` VALUES("4652","794","_wp_attached_file","2024/09/Ofcom-Amateur-Licence-Conditions-233x300-1.png");
INSERT INTO `wp_postmeta` VALUES("4653","794","_wp_attachment_metadata","a:6:{s:5:\"width\";i:233;s:6:\"height\";i:300;s:4:\"file\";s:54:\"2024/09/Ofcom-Amateur-Licence-Conditions-233x300-1.png\";s:8:\"filesize\";i:16760;s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:54:\"Ofcom-Amateur-Licence-Conditions-233x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8936;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:54:\"Ofcom-Amateur-Licence-Conditions-233x300-1-233x250.png\";s:5:\"width\";i:233;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17259;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:54:\"Ofcom-Amateur-Licence-Conditions-233x300-1-233x297.png\";s:5:\"width\";i:233;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19091;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:54:\"Ofcom-Amateur-Licence-Conditions-233x300-1-233x235.png\";s:5:\"width\";i:233;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16663;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4657","793","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("4658","793","_thumbnail_id","1268");
INSERT INTO `wp_postmeta` VALUES("4659","793","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("4661","793","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1268;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("4662","793","layout_key","");
INSERT INTO `wp_postmeta` VALUES("4663","793","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("4664","793","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("5673","853","_email","vhf-dx@radiouk.com");
INSERT INTO `wp_postmeta` VALUES("5674","853","_name","John");
INSERT INTO `wp_postmeta` VALUES("5675","853","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("5676","853","_last_contacted","2024-10-20 17:12:16");
INSERT INTO `wp_postmeta` VALUES("5797","861","_email","craig@craigpowers.co.uk");
INSERT INTO `wp_postmeta` VALUES("5798","861","_name","Craig Powers");
INSERT INTO `wp_postmeta` VALUES("5799","861","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("5800","861","_last_contacted","2024-10-23 15:46:59");
INSERT INTO `wp_postmeta` VALUES("5955","871","_email","graham.s.gee@hotmail.co.uk");
INSERT INTO `wp_postmeta` VALUES("5956","871","_name","Graham");
INSERT INTO `wp_postmeta` VALUES("5957","871","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("5958","871","_last_contacted","2024-10-29 20:20:20");
INSERT INTO `wp_postmeta` VALUES("6450","901","_edit_lock","1737466504:2");
INSERT INTO `wp_postmeta` VALUES("6451","758","_oembed_64c22ba3d08317f356cd500e8254158a","{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("6452","902","_wp_attached_file","2024/11/slarcannounce.jpg");
INSERT INTO `wp_postmeta` VALUES("6453","902","_wp_attachment_metadata","a:6:{s:5:\"width\";i:625;s:6:\"height\";i:250;s:4:\"file\";s:25:\"2024/11/slarcannounce.jpg\";s:8:\"filesize\";i:65535;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"slarcannounce-300x120.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10392;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"slarcannounce-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8378;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:25:\"slarcannounce-570x250.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32478;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:25:\"slarcannounce-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19954;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:25:\"slarcannounce-510x250.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31042;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:25:\"slarcannounce-528x250.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33638;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:25:\"slarcannounce-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26778;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6457","901","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("6458","901","_thumbnail_id","902");
INSERT INTO `wp_postmeta` VALUES("6459","901","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("6462","901","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:902;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("6463","901","layout_key","");
INSERT INTO `wp_postmeta` VALUES("6464","901","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("6465","901","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("6471","661","_wp_old_date","2024-08-06");
INSERT INTO `wp_postmeta` VALUES("6910","661","_wp_old_date","2024-11-20");
INSERT INTO `wp_postmeta` VALUES("7134","953","_email","turtonm@gmail.com");
INSERT INTO `wp_postmeta` VALUES("7135","953","_name","Martin Turton");
INSERT INTO `wp_postmeta` VALUES("7136","953","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("7137","953","_last_contacted","2024-12-21 20:57:34");
INSERT INTO `wp_postmeta` VALUES("7344","953","_wp_old_date","2024-12-14");
INSERT INTO `wp_postmeta` VALUES("8252","590","_wp_old_date","2024-07-12");
INSERT INTO `wp_postmeta` VALUES("8259","1024","_edit_lock","1740378229:2");
INSERT INTO `wp_postmeta` VALUES("8263","1024","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("8264","1024","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("8267","1024","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:320;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("8268","1024","layout_key","");
INSERT INTO `wp_postmeta` VALUES("8269","1024","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("8270","1024","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("8277","1024","_thumbnail_id","320");
INSERT INTO `wp_postmeta` VALUES("8297","1030","_edit_lock","1737913418:1");
INSERT INTO `wp_postmeta` VALUES("8298","1031","_wp_attached_file","2025/01/m7spi145alive.png");
INSERT INTO `wp_postmeta` VALUES("8299","1031","_wp_attachment_metadata","a:6:{s:5:\"width\";i:997;s:6:\"height\";i:941;s:4:\"file\";s:25:\"2025/01/m7spi145alive.png\";s:8:\"filesize\";i:1232350;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-300x283.png\";s:5:\"width\";i:300;s:6:\"height\";i:283;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:164203;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:51801;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-768x725.png\";s:5:\"width\";i:768;s:6:\"height\";i:725;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:753399;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-997x444.png\";s:5:\"width\";i:997;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:500342;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:290242;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:135077;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-997x500.png\";s:5:\"width\";i:997;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:559204;}s:6:\"slider\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-997x500.png\";s:5:\"width\";i:997;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:559204;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:405435;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-997x624.png\";s:5:\"width\";i:997;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:702426;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:234480;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:25:\"m7spi145alive-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:181681;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("8300","1032","_wp_attached_file","2025/01/1_m7spi145alive.png");
INSERT INTO `wp_postmeta` VALUES("8301","1032","_wp_attachment_metadata","a:6:{s:5:\"width\";i:300;s:6:\"height\";i:283;s:4:\"file\";s:27:\"2025/01/1_m7spi145alive.png\";s:8:\"filesize\";i:48439;s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"1_m7spi145alive-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:50263;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:27:\"1_m7spi145alive-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:132093;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:27:\"1_m7spi145alive-300x235.png\";s:5:\"width\";i:300;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:101803;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("8305","1030","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("8306","1030","_thumbnail_id","1031");
INSERT INTO `wp_postmeta` VALUES("8307","1030","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("8310","1030","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1031;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("8311","1030","layout_key","");
INSERT INTO `wp_postmeta` VALUES("8312","1030","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("8313","1030","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("8487","1045","_edit_lock","1742137321:1");
INSERT INTO `wp_postmeta` VALUES("8488","1046","_wp_attached_file","2025/01/240205_rsgb_band_plan_2024.pdf");
INSERT INTO `wp_postmeta` VALUES("8489","1046","_wp_attachment_metadata","a:1:{s:8:\"filesize\";i:240737;}");
INSERT INTO `wp_postmeta` VALUES("8490","1047","_wp_attached_file","2025/01/rsgb-band.png");
INSERT INTO `wp_postmeta` VALUES("8491","1047","_wp_attachment_metadata","a:6:{s:5:\"width\";i:721;s:6:\"height\";i:101;s:4:\"file\";s:21:\"2025/01/rsgb-band.png\";s:8:\"filesize\";i:29615;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"rsgb-band-300x42.png\";s:5:\"width\";i:300;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9577;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"rsgb-band-150x101.png\";s:5:\"width\";i:150;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7345;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:21:\"rsgb-band-570x101.png\";s:5:\"width\";i:570;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24241;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:21:\"rsgb-band-270x101.png\";s:5:\"width\";i:270;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10351;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:21:\"rsgb-band-510x101.png\";s:5:\"width\";i:510;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21557;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:21:\"rsgb-band-528x101.png\";s:5:\"width\";i:528;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22556;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:21:\"rsgb-band-517x101.png\";s:5:\"width\";i:517;s:6:\"height\";i:101;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21788;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("8495","1045","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("8496","1045","_thumbnail_id","1266");
INSERT INTO `wp_postmeta` VALUES("8497","1045","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("8499","1045","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1266;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("8500","1045","layout_key","");
INSERT INTO `wp_postmeta` VALUES("8501","1045","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("8502","1045","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("8513","13","_thumbnail_id","758");
INSERT INTO `wp_postmeta` VALUES("8514","13","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("8515","13","layout_key","");
INSERT INTO `wp_postmeta` VALUES("8516","13","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("8517","13","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("8716","1067","_email","safetystevebem@gmail.com");
INSERT INTO `wp_postmeta` VALUES("8717","1067","_name","Stephen Christie");
INSERT INTO `wp_postmeta` VALUES("8718","1067","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("8719","1067","_last_contacted","2025-01-28 20:17:59");
INSERT INTO `wp_postmeta` VALUES("8909","590","_wp_old_date","2025-01-21");
INSERT INTO `wp_postmeta` VALUES("8910","1089","_edit_lock","1743864780:1");
INSERT INTO `wp_postmeta` VALUES("8911","1089","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("8912","1089","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1369;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("8913","1089","layout_key","");
INSERT INTO `wp_postmeta` VALUES("8914","1089","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("8915","1089","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("8919","1089","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("8927","1089","_thumbnail_id","1369");
INSERT INTO `wp_postmeta` VALUES("8963","1096","_email","nigel_roberts@btinternet.com");
INSERT INTO `wp_postmeta` VALUES("8964","1096","_name","Nigel Roberts");
INSERT INTO `wp_postmeta` VALUES("8965","1096","_props","a:0:{}");
INSERT INTO `wp_postmeta` VALUES("8966","1096","_last_contacted","2025-02-04 18:22:20");
INSERT INTO `wp_postmeta` VALUES("8985","259","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("9038","1096","_wp_old_date","2025-02-02");
INSERT INTO `wp_postmeta` VALUES("9055","267","_g_feedback_shortcode_b09c54ec625ca10f7bd4b3baf9f8f17bec5672fa","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("9056","267","_g_feedback_shortcode_atts_b09c54ec625ca10f7bd4b3baf9f8f17bec5672fa","a:17:{s:2:\"to\";s:22:\"cwoodalluk@yahoo.co.uk\";s:7:\"subject\";s:43:\"[South Lancs Amateur Radio Club] CONTACT US\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:267;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("9666","1144","_edit_lock","1758976665:1");
INSERT INTO `wp_postmeta` VALUES("9667","1144","_g_feedback_shortcode_f6a465f16f93c9737051329a764777a90d26c623","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("9668","1144","_g_feedback_shortcode_atts_f6a465f16f93c9737051329a764777a90d26c623","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:110:\"[South Lancs Amateur Radio Club] Proud supporters of Fat Monkey Amateur Rugby League & Wigan and Leigh Hospice\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1144;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("9669","1145","_wp_attached_file","2025/02/477236570_1668745214015320_739811136916796207_n.jpg");
INSERT INTO `wp_postmeta` VALUES("9670","1145","_wp_attachment_metadata","a:6:{s:5:\"width\";i:757;s:6:\"height\";i:884;s:4:\"file\";s:59:\"2025/02/477236570_1668745214015320_739811136916796207_n.jpg\";s:8:\"filesize\";i:112260;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-257x300.jpg\";s:5:\"width\";i:257;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24866;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9566;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-757x444.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58390;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39494;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21313;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-757x500.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63376;}s:6:\"slider\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-757x500.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63376;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56149;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-757x624.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83101;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32817;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:59:\"477236570_1668745214015320_739811136916796207_n-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25637;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9671","1146","_wp_attached_file","2025/02/Firefox_Screenshot_2025-01-04T15-31-35.228Z.png");
INSERT INTO `wp_postmeta` VALUES("9672","1146","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1583;s:6:\"height\";i:747;s:4:\"file\";s:55:\"2025/02/Firefox_Screenshot_2025-01-04T15-31-35.228Z.png\";s:8:\"filesize\";i:596856;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-300x142.png\";s:5:\"width\";i:300;s:6:\"height\";i:142;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41136;}s:5:\"large\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1024x483.png\";s:5:\"width\";i:1024;s:6:\"height\";i:483;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:267202;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23585;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-768x362.png\";s:5:\"width\";i:768;s:6:\"height\";i:362;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:175709;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1536x725.png\";s:5:\"width\";i:1536;s:6:\"height\";i:725;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:463633;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1110x444.png\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:260657;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:127643;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54369;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1583x500.png\";s:5:\"width\";i:1583;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:329405;}s:6:\"slider\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:289716;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:142047;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:56:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-1110x624.png\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:319328;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:109577;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:55:\"Firefox_Screenshot_2025-01-04T15-31-35.228Z-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:94059;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9673","1147","_wp_attached_file","2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd.jpg");
INSERT INTO `wp_postmeta` VALUES("9674","1147","_wp_attachment_metadata","a:6:{s:5:\"width\";i:2040;s:6:\"height\";i:918;s:4:\"file\";s:58:\"2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd.jpg\";s:8:\"filesize\";i:286753;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-300x135.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9938;}s:5:\"large\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-1024x461.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:461;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:100995;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6007;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-768x346.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:346;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60174;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-1536x691.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:202666;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103596;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45699;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16298;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-2040x500.jpg\";s:5:\"width\";i:2040;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:182561;}s:6:\"slider\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116819;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56870;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:59:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:137074;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36510;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_0c5c18cd-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28156;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9675","1148","_wp_attached_file","2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7.jpg");
INSERT INTO `wp_postmeta` VALUES("9676","1148","_wp_attachment_metadata","a:6:{s:5:\"width\";i:757;s:6:\"height\";i:884;s:4:\"file\";s:58:\"2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7.jpg\";s:8:\"filesize\";i:94409;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-257x300.jpg\";s:5:\"width\";i:257;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24799;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9557;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-757x444.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:56910;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38940;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21294;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-757x500.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57919;}s:6:\"slider\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-757x500.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57919;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55430;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-757x624.jpg\";s:5:\"width\";i:757;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79719;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32411;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_d8b0b0c7-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25367;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9677","1149","_wp_attached_file","2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4.jpg");
INSERT INTO `wp_postmeta` VALUES("9678","1149","_wp_attachment_metadata","a:6:{s:5:\"width\";i:720;s:6:\"height\";i:398;s:4:\"file\";s:58:\"2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4.jpg\";s:8:\"filesize\";i:47055;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-300x166.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17960;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9283;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51180;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21888;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-510x398.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:398;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52385;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42956;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:58:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37913;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("9682","1144","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("9683","1144","_thumbnail_id","1260");
INSERT INTO `wp_postmeta` VALUES("9684","1144","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("9686","1144","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1260;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("9687","1144","layout_key","");
INSERT INTO `wp_postmeta` VALUES("9688","1144","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("9689","1144","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("9908","1171","_edit_lock","1740567947:2");
INSERT INTO `wp_postmeta` VALUES("9909","1171","_g_feedback_shortcode_b3d484e4014d4bda9b64ef5256378144634f2fb0","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("9910","1171","_g_feedback_shortcode_atts_b3d484e4014d4bda9b64ef5256378144634f2fb0","a:17:{s:2:\"to\";s:22:\"cwoodalluk@yahoo.co.uk\";s:7:\"subject\";s:51:\"[South Lancs Amateur Radio Club] MEETING at the ACC\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1171;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("9911","1171","_thumbnail_id","320");
INSERT INTO `wp_postmeta` VALUES("9912","1171","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("9913","1171","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:320;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("9914","1171","layout_key","");
INSERT INTO `wp_postmeta` VALUES("9915","1171","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("9916","1171","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("9920","1171","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("10062","104","_g_feedback_shortcode_b66d82d931f8950f90832e89b5afaf514ae36820","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("10063","104","_g_feedback_shortcode_atts_b66d82d931f8950f90832e89b5afaf514ae36820","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:46:\"[South Lancs Amateur Radio Club] Meet The Team\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:104;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("10067","1191","_wp_attached_file","2025/02/Untitled12.jpeg");
INSERT INTO `wp_postmeta` VALUES("10068","1191","_wp_attachment_metadata","a:6:{s:5:\"width\";i:225;s:6:\"height\";i:225;s:4:\"file\";s:23:\"2025/02/Untitled12.jpeg\";s:8:\"filesize\";i:5633;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"Untitled12-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3466;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10070","1194","_wp_attached_file","2025/02/1597390904798.png");
INSERT INTO `wp_postmeta` VALUES("10071","1194","_wp_attachment_metadata","a:6:{s:5:\"width\";i:873;s:6:\"height\";i:349;s:4:\"file\";s:25:\"2025/02/1597390904798.png\";s:8:\"filesize\";i:261755;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"1597390904798-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42534;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"1597390904798-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25957;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"1597390904798-768x307.png\";s:5:\"width\";i:768;s:6:\"height\";i:307;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:205512;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:25:\"1597390904798-570x349.png\";s:5:\"width\";i:570;s:6:\"height\";i:349;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:165880;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:25:\"1597390904798-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:63240;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:25:\"1597390904798-510x349.png\";s:5:\"width\";i:510;s:6:\"height\";i:349;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:151154;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:25:\"1597390904798-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:129661;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:25:\"1597390904798-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:110582;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10072","104","_thumbnail_id","1194");
INSERT INTO `wp_postmeta` VALUES("10073","661","_wp_old_date","2024-12-10");
INSERT INTO `wp_postmeta` VALUES("10476","1225","_edit_lock","1742146998:1");
INSERT INTO `wp_postmeta` VALUES("10477","1225","_g_feedback_shortcode_2b36a9f4b0f22f6e971fe9c94cc07fe11304bb9b","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("10478","1225","_g_feedback_shortcode_atts_2b36a9f4b0f22f6e971fe9c94cc07fe11304bb9b","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:75:\"[South Lancs Amateur Radio Club] South Lancs Amateur Radio Club Merchandise\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1225;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("10479","1225","_oembed_d5406f96af165449f8282510b216f7ba","<a href=\"https://www.customisedstuff.co.uk/products/slarc-deal\">SLARC Deal</a>");
INSERT INTO `wp_postmeta` VALUES("10480","1225","_oembed_time_d5406f96af165449f8282510b216f7ba","1741292923");
INSERT INTO `wp_postmeta` VALUES("10481","1226","_wp_attached_file","2025/03/slarc.jpg");
INSERT INTO `wp_postmeta` VALUES("10482","1226","_wp_attachment_metadata","a:6:{s:5:\"width\";i:698;s:6:\"height\";i:698;s:4:\"file\";s:17:\"2025/03/slarc.jpg\";s:8:\"filesize\";i:173569;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"slarc-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22341;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"slarc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9205;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:17:\"slarc-698x444.jpg\";s:5:\"width\";i:698;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34797;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:17:\"slarc-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26709;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:17:\"slarc-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18291;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:17:\"slarc-698x500.jpg\";s:5:\"width\";i:698;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40620;}s:6:\"slider\";a:5:{s:4:\"file\";s:17:\"slarc-698x500.jpg\";s:5:\"width\";i:698;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40620;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:17:\"slarc-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42061;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:17:\"slarc-698x624.jpg\";s:5:\"width\";i:698;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55861;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:17:\"slarc-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23046;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:17:\"slarc-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20745;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10483","1227","_wp_attached_file","2025/03/s-l1600.png");
INSERT INTO `wp_postmeta` VALUES("10484","1227","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:19:\"2025/03/s-l1600.png\";s:8:\"filesize\";i:552838;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"s-l1600-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:64286;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"s-l1600-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:19382;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"s-l1600-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:325130;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:20:\"s-l1600-1000x444.png\";s:5:\"width\";i:1000;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:171778;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:19:\"s-l1600-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:128414;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:19:\"s-l1600-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:52713;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:20:\"s-l1600-1000x500.png\";s:5:\"width\";i:1000;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:214430;}s:6:\"slider\";a:5:{s:4:\"file\";s:20:\"s-l1600-1000x500.png\";s:5:\"width\";i:1000;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:214430;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:19:\"s-l1600-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:161615;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:20:\"s-l1600-1000x624.png\";s:5:\"width\";i:1000;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321837;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:19:\"s-l1600-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:96428;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:19:\"s-l1600-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:63424;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10485","661","_wp_old_date","2025-02-27");
INSERT INTO `wp_postmeta` VALUES("10489","1225","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("10490","1225","_thumbnail_id","1258");
INSERT INTO `wp_postmeta` VALUES("10491","1225","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("10494","1225","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1258;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("10495","1225","layout_key","");
INSERT INTO `wp_postmeta` VALUES("10496","1225","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("10497","1225","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("10976","1258","_wp_attached_file","2025/03/s-l1600-Custom.png");
INSERT INTO `wp_postmeta` VALUES("10977","1258","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:26:\"2025/03/s-l1600-Custom.png\";s:8:\"filesize\";i:308339;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-300x128.png\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:31144;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"s-l1600-Custom-1024x438.png\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:251260;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18834;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-768x328.png\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:156147;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:27:\"s-l1600-Custom-1110x444.png\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:282353;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:147560;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:49913;}s:6:\"slider\";a:5:{s:4:\"file\";s:27:\"s-l1600-Custom-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:316320;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-510x500.png\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:152686;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:27:\"s-l1600-Custom-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:316320;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:119580;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:26:\"s-l1600-Custom-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:87940;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10982","1260","_wp_attached_file","2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("10983","1260","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:65:\"2025/02/WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom.jpg\";s:8:\"filesize\";i:150615;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14187;}s:5:\"large\";a:5:{s:4:\"file\";s:66:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-1024x438.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:86778;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8727;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57842;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:66:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94558;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47405;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20580;}s:6:\"slider\";a:5:{s:4:\"file\";s:66:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109124;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53807;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:66:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109124;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40609;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:65:\"WhatsApp-Image-2025-02-18-at-20.17.01_06ba99f4-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34503;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10987","1089","_g_feedback_shortcode_654620f244dd42baf693b76735f1812e987e0777","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("10988","1089","_g_feedback_shortcode_atts_654620f244dd42baf693b76735f1812e987e0777","a:17:{s:2:\"to\";s:22:\"cwoodalluk@yahoo.co.uk\";s:7:\"subject\";s:69:\"[South Lancs Amateur Radio Club] Sunday 13th April - 2025 Narsa Rally\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1089;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("10989","1262","_wp_attached_file","2025/02/feed_2019_04_28-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("10990","1262","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:34:\"2025/02/feed_2019_04_28-Custom.jpg\";s:8:\"filesize\";i:128063;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13570;}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"feed_2019_04_28-Custom-1024x438.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77010;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8585;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51965;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:35:\"feed_2019_04_28-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80615;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41176;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18718;}s:6:\"slider\";a:5:{s:4:\"file\";s:35:\"feed_2019_04_28-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92929;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46349;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:35:\"feed_2019_04_28-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:92929;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35845;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:34:\"feed_2019_04_28-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31623;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("10995","277","_g_feedback_shortcode_ae4c02a7f87fda4346d482ea962ea16eff738c39","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("10996","277","_g_feedback_shortcode_atts_ae4c02a7f87fda4346d482ea962ea16eff738c39","a:17:{s:2:\"to\";s:22:\"cwoodalluk@yahoo.co.uk\";s:7:\"subject\";s:56:\"[South Lancs Amateur Radio Club] Planning Ashurst Beacon\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:277;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("10997","1264","_wp_attached_file","2024/02/ashurst005-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("10998","1264","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:29:\"2024/02/ashurst005-Custom.jpg\";s:8:\"filesize\";i:127246;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9361;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"ashurst005-Custom-1024x438.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68955;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5803;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43570;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:30:\"ashurst005-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70196;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35566;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14690;}s:6:\"slider\";a:5:{s:4:\"file\";s:30:\"ashurst005-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91540;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43526;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:30:\"ashurst005-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:91540;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29639;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:29:\"ashurst005-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24505;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11003","277","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("11004","1045","_g_feedback_shortcode_3c71a32966291f88460371fb1da8f451819ede91","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11005","1045","_g_feedback_shortcode_atts_3c71a32966291f88460371fb1da8f451819ede91","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:73:\"[South Lancs Amateur Radio Club] Amateaur Radio UK Band Plands Allocation\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1045;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11006","1266","_wp_attached_file","2025/01/rsgb-band-Custom.png");
INSERT INTO `wp_postmeta` VALUES("11007","1266","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:28:\"2025/01/rsgb-band-Custom.png\";s:8:\"filesize\";i:174212;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-300x128.png\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22642;}s:5:\"large\";a:5:{s:4:\"file\";s:29:\"rsgb-band-Custom-1024x438.png\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:147122;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11785;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-768x328.png\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:95543;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:29:\"rsgb-band-Custom-1110x444.png\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:164680;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:75079;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26492;}s:6:\"slider\";a:5:{s:4:\"file\";s:29:\"rsgb-band-Custom-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:168463;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-510x500.png\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:68813;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:29:\"rsgb-band-Custom-1110x500.png\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:168463;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:65529;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:28:\"rsgb-band-Custom-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:57205;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11012","793","_g_feedback_shortcode_3bd0bdfb7bf9cc0d114ae6b97fb3de21bca108d7","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11013","793","_g_feedback_shortcode_atts_3bd0bdfb7bf9cc0d114ae6b97fb3de21bca108d7","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:63:\"[South Lancs Amateur Radio Club] Licence changes 2024 explained\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:793;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11014","1268","_wp_attached_file","2024/09/480850354_958332699733709_1200255464019356982_n-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("11015","1268","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:66:\"2024/09/480850354_958332699733709_1200255464019356982_n-Custom.jpg\";s:8:\"filesize\";i:115130;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10677;}s:5:\"large\";a:5:{s:4:\"file\";s:67:\"480850354_958332699733709_1200255464019356982_n-Custom-1024x438.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63958;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5605;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42412;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:67:\"480850354_958332699733709_1200255464019356982_n-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:69109;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32345;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12777;}s:6:\"slider\";a:5:{s:4:\"file\";s:67:\"480850354_958332699733709_1200255464019356982_n-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83171;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35401;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:67:\"480850354_958332699733709_1200255464019356982_n-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83171;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28590;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:66:\"480850354_958332699733709_1200255464019356982_n-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25383;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11020","201","_g_feedback_shortcode_0d1ad06c47f1553bffc6994247bc2cc85639d3dc","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11021","201","_g_feedback_shortcode_atts_0d1ad06c47f1553bffc6994247bc2cc85639d3dc","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:69:\"[South Lancs Amateur Radio Club] Ashurst Beacon Event 10th April 2021\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:201;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11022","1270","_wp_attached_file","2024/02/ashurst001-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("11023","1270","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:500;s:4:\"file\";s:29:\"2024/02/ashurst001-Custom.jpg\";s:8:\"filesize\";i:281186;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-300x128.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:128;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13267;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"ashurst001-Custom-1024x438.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:438;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:135025;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8472;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-768x328.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:328;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79631;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:30:\"ashurst001-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144380;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65780;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25209;}s:6:\"slider\";a:5:{s:4:\"file\";s:30:\"ashurst001-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:193830;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93618;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:30:\"ashurst001-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:193830;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52505;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:29:\"ashurst001-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40952;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11029","201","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("11030","661","_wp_old_date","2025-03-06");
INSERT INTO `wp_postmeta` VALUES("11032","1280","_wp_attached_file","2025/03/slarccs.jpg");
INSERT INTO `wp_postmeta` VALUES("11033","1280","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1556;s:6:\"height\";i:2048;s:4:\"file\";s:19:\"2025/03/slarccs.jpg\";s:8:\"filesize\";i:231729;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"slarccs-228x300.jpg\";s:5:\"width\";i:228;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14938;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"slarccs-778x1024.jpg\";s:5:\"width\";i:778;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94040;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"slarccs-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6558;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"slarccs-768x1011.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1011;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:87462;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:21:\"slarccs-1167x1536.jpg\";s:5:\"width\";i:1167;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:174557;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:20:\"slarccs-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44635;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:19:\"slarccs-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30459;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:19:\"slarccs-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14370;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:20:\"slarccs-1556x500.jpg\";s:5:\"width\";i:1556;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57681;}s:6:\"slider\";a:5:{s:4:\"file\";s:20:\"slarccs-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55714;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:19:\"slarccs-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38696;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:20:\"slarccs-1110x624.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72671;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:19:\"slarccs-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24999;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:19:\"slarccs-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18389;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11231","12","_g_feedback_shortcode_474be41c49bd8632334007820712df4fb31bfee4","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11232","12","_g_feedback_shortcode_atts_474be41c49bd8632334007820712df4fb31bfee4","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:63:\"[South Lancs Amateur Radio Club] South Lancs Amateur Radio Club\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:12;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11235","1297","_edit_lock","1755539673:1");
INSERT INTO `wp_postmeta` VALUES("11236","1297","_g_feedback_shortcode_fc3953b82f21f4270443eaadfab0111dca7337b2","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11237","1297","_g_feedback_shortcode_atts_fc3953b82f21f4270443eaadfab0111dca7337b2","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:75:\"[South Lancs Amateur Radio Club] Amateur Radio Direction Finding North West\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1297;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11238","1298","_wp_attached_file","2025/03/484813090_662771616249881_6845412770474558826_n.jpg");
INSERT INTO `wp_postmeta` VALUES("11239","1298","_wp_attachment_metadata","a:6:{s:5:\"width\";i:350;s:6:\"height\";i:411;s:4:\"file\";s:59:\"2025/03/484813090_662771616249881_6845412770474558826_n.jpg\";s:8:\"filesize\";i:54072;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-255x300.jpg\";s:5:\"width\";i:255;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23154;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9296;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-350x350.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37694;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21563;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-350x297.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32937;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:59:\"484813090_662771616249881_6845412770474558826_n-350x235.jpg\";s:5:\"width\";i:350;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27726;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11240","1299","_wp_attached_file","2025/03/484813090_662771616249881_6845412770474558826_n-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("11241","1299","_wp_attachment_metadata","a:6:{s:5:\"width\";i:400;s:6:\"height\";i:1700;s:4:\"file\";s:66:\"2025/03/484813090_662771616249881_6845412770474558826_n-Custom.jpg\";s:8:\"filesize\";i:145359;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:65:\"484813090_662771616249881_6845412770474558826_n-Custom-71x300.jpg\";s:5:\"width\";i:71;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8247;}s:5:\"large\";a:5:{s:4:\"file\";s:67:\"484813090_662771616249881_6845412770474558826_n-Custom-241x1024.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50618;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6801;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:67:\"484813090_662771616249881_6845412770474558826_n-Custom-361x1536.jpg\";s:5:\"width\";i:361;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:89006;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x444.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29584;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x350.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23874;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14080;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x500.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35507;}s:6:\"slider\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x500.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35507;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x510.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33191;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x624.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39753;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x297.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21113;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:66:\"484813090_662771616249881_6845412770474558826_n-Custom-400x235.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16972;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11242","1300","_wp_attached_file","2025/03/484813090_662771616249881_6845412770474558826_n-Custom-1.jpg");
INSERT INTO `wp_postmeta` VALUES("11243","1300","_wp_attachment_metadata","a:6:{s:5:\"width\";i:500;s:6:\"height\";i:1700;s:4:\"file\";s:68:\"2025/03/484813090_662771616249881_6845412770474558826_n-Custom-1.jpg\";s:8:\"filesize\";i:170919;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:67:\"484813090_662771616249881_6845412770474558826_n-Custom-1-88x300.jpg\";s:5:\"width\";i:88;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9769;}s:5:\"large\";a:5:{s:4:\"file\";s:69:\"484813090_662771616249881_6845412770474558826_n-Custom-1-301x1024.jpg\";s:5:\"width\";i:301;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59037;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7082;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:69:\"484813090_662771616249881_6845412770474558826_n-Custom-1-452x1536.jpg\";s:5:\"width\";i:452;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:104575;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x444.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34369;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x350.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27689;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14653;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41488;}s:6:\"slider\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41488;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x510.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38553;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x624.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46137;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x297.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24560;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-1-500x235.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19623;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11247","1297","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("11248","1297","_thumbnail_id","1304");
INSERT INTO `wp_postmeta` VALUES("11249","1297","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("11251","1297","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1304;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("11252","1297","layout_key","");
INSERT INTO `wp_postmeta` VALUES("11253","1297","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("11254","1297","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("11257","1302","_wp_attached_file","2025/03/resize-to-fit.png");
INSERT INTO `wp_postmeta` VALUES("11258","1302","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:768;s:4:\"file\";s:25:\"2025/03/resize-to-fit.png\";s:8:\"filesize\";i:1982999;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-300x225.png\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:187220;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:63693;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-768x576.png\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1196654;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:26:\"resize-to-fit-1024x444.png\";s:5:\"width\";i:1024;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1263216;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-570x350.png\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:539821;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:186949;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:26:\"resize-to-fit-1024x500.png\";s:5:\"width\";i:1024;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1423215;}s:6:\"slider\";a:5:{s:4:\"file\";s:26:\"resize-to-fit-1024x500.png\";s:5:\"width\";i:1024;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1423215;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-510x510.png\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:713994;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:26:\"resize-to-fit-1024x624.png\";s:5:\"width\";i:1024;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1779313;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-528x297.png\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:425065;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:25:\"resize-to-fit-517x235.png\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:329625;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11260","1304","_wp_attached_file","2025/03/484813090_662771616249881_6845412770474558826_n-Custom-2-e1742419076716.jpg");
INSERT INTO `wp_postmeta` VALUES("11261","1304","_wp_attachment_metadata","a:6:{s:5:\"width\";i:426;s:6:\"height\";i:500;s:4:\"file\";s:83:\"2025/03/484813090_662771616249881_6845412770474558826_n-Custom-2-e1742419076716.jpg\";s:8:\"filesize\";i:45746;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-256x300.jpg\";s:5:\"width\";i:256;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22187;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9045;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x444.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51104;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x350.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40765;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20420;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57074;}s:6:\"slider\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57074;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x510.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58102;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x297.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34870;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:68:\"484813090_662771616249881_6845412770474558826_n-Custom-2-500x235.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27749;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11262","1304","_wp_attachment_backup_sizes","a:1:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:500;s:6:\"height\";i:587;s:8:\"filesize\";i:84443;s:4:\"file\";s:60:\"484813090_662771616249881_6845412770474558826_n-Custom-2.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("11789","1332","_edit_lock","1744394184:1");
INSERT INTO `wp_postmeta` VALUES("11790","1332","_g_feedback_shortcode_94ca593d30e086883c50e2c75ba44f3765b8f61d","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("11791","1332","_g_feedback_shortcode_atts_94ca593d30e086883c50e2c75ba44f3765b8f61d","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:83:\"[South Lancs Amateur Radio Club] 145 Alive Event – April 12th 2025 – NARSA 2025\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1332;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("11792","1333","_wp_attached_file","2025/03/145slarcwdrgpromo-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("11793","1333","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1429;s:6:\"height\";i:500;s:4:\"file\";s:36:\"2025/03/145slarcwdrgpromo-Custom.jpg\";s:8:\"filesize\";i:174048;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-300x105.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:105;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13224;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"145slarcwdrgpromo-Custom-1024x358.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:358;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75939;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9131;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-768x269.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:269;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51628;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:37:\"145slarcwdrgpromo-Custom-1110x444.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95143;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46419;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20562;}s:6:\"slider\";a:5:{s:4:\"file\";s:37:\"145slarcwdrgpromo-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:110036;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-510x500.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53235;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:37:\"145slarcwdrgpromo-Custom-1110x500.jpg\";s:5:\"width\";i:1110;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:110036;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39772;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:36:\"145slarcwdrgpromo-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34777;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11794","1334","_wp_attached_file","2025/03/1_145slarcwdrgpromo-Custom.jpg");
INSERT INTO `wp_postmeta` VALUES("11795","1334","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:358;s:4:\"file\";s:38:\"2025/03/1_145slarcwdrgpromo-Custom.jpg\";s:8:\"filesize\";i:87473;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-300x105.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:105;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13049;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8913;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-768x269.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:269;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49687;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43965;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19310;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-510x358.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:358;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43130;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37834;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:38:\"1_145slarcwdrgpromo-Custom-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33456;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11796","1335","_wp_attached_file","2025/03/logo.jpg");
INSERT INTO `wp_postmeta` VALUES("11797","1335","_wp_attachment_metadata","a:6:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:16:\"2025/03/logo.jpg\";s:8:\"filesize\";i:15356;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"logo-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13658;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5408;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:16:\"logo-400x350.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19680;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:16:\"logo-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11495;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:16:\"logo-400x297.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18147;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:16:\"logo-400x235.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15458;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11798","1336","_wp_attached_file","2025/03/145acceptance.jpg");
INSERT INTO `wp_postmeta` VALUES("11799","1336","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:76;s:4:\"file\";s:25:\"2025/03/145acceptance.jpg\";s:8:\"filesize\";i:9897;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"145acceptance-300x22.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:22;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3505;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"145acceptance-150x76.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4338;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:24:\"145acceptance-768x57.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:57;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13479;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:24:\"145acceptance-570x76.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12972;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:24:\"145acceptance-270x76.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6429;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:24:\"145acceptance-510x76.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11342;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:24:\"145acceptance-528x76.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10913;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:24:\"145acceptance-517x76.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11897;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11800","1337","_wp_attached_file","2025/03/Sticker-2025-1024x180-1.jpg");
INSERT INTO `wp_postmeta` VALUES("11801","1337","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:180;s:4:\"file\";s:35:\"2025/03/Sticker-2025-1024x180-1.jpg\";s:8:\"filesize\";i:51197;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"Sticker-2025-1024x180-1-300x53.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:53;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9732;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8483;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-768x135.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36649;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-570x180.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30272;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-270x180.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15440;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-510x180.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26535;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-528x180.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27277;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:35:\"Sticker-2025-1024x180-1-517x180.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27193;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11805","1332","_wpas_done_all","1");
INSERT INTO `wp_postmeta` VALUES("11806","1332","_thumbnail_id","1333");
INSERT INTO `wp_postmeta` VALUES("11807","1332","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("11809","1332","tc-thumb-fld","a:2:{s:9:\"_thumb_id\";i:1333;s:11:\"_thumb_type\";s:5:\"thumb\";}");
INSERT INTO `wp_postmeta` VALUES("11810","1332","layout_key","");
INSERT INTO `wp_postmeta` VALUES("11811","1332","post_slider_check_key","0");
INSERT INTO `wp_postmeta` VALUES("11812","1332","_heateor_sss_meta","a:2:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("12231","1369","_wp_attached_file","2025/02/narsaslarc.png");
INSERT INTO `wp_postmeta` VALUES("12232","1369","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1170;s:6:\"height\";i:206;s:4:\"file\";s:22:\"2025/02/narsaslarc.png\";s:8:\"filesize\";i:334684;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"narsaslarc-300x53.png\";s:5:\"width\";i:300;s:6:\"height\";i:53;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33175;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"narsaslarc-1024x180.png\";s:5:\"width\";i:1024;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:262042;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"narsaslarc-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:36624;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"narsaslarc-768x135.png\";s:5:\"width\";i:768;s:6:\"height\";i:135;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:162390;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:23:\"narsaslarc-1110x206.png\";s:5:\"width\";i:1110;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321794;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"narsaslarc-570x206.png\";s:5:\"width\";i:570;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:158804;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"narsaslarc-270x206.png\";s:5:\"width\";i:270;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:80696;}s:6:\"slider\";a:5:{s:4:\"file\";s:23:\"narsaslarc-1110x206.png\";s:5:\"width\";i:1110;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321794;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"narsaslarc-510x206.png\";s:5:\"width\";i:510;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:144317;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:23:\"narsaslarc-1110x206.png\";s:5:\"width\";i:1110;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:321794;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"narsaslarc-528x206.png\";s:5:\"width\";i:528;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:148144;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"narsaslarc-517x206.png\";s:5:\"width\";i:517;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:145888;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("12667","1402","_wp_attached_file","2025/03/netcontrol.jpg");
INSERT INTO `wp_postmeta` VALUES("12668","1402","_wp_attachment_metadata","a:6:{s:5:\"width\";i:882;s:6:\"height\";i:715;s:4:\"file\";s:22:\"2025/03/netcontrol.jpg\";s:8:\"filesize\";i:179054;s:5:\"sizes\";a:12:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"netcontrol-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25140;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"netcontrol-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7958;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"netcontrol-768x623.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:623;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:142410;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:22:\"netcontrol-882x444.jpg\";s:5:\"width\";i:882;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:126255;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:22:\"netcontrol-570x350.jpg\";s:5:\"width\";i:570;s:6:\"height\";i:350;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65674;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:22:\"netcontrol-270x250.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22808;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:22:\"netcontrol-882x500.jpg\";s:5:\"width\";i:882;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140653;}s:6:\"slider\";a:5:{s:4:\"file\";s:22:\"netcontrol-882x500.jpg\";s:5:\"width\";i:882;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:140653;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:22:\"netcontrol-510x510.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78212;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:22:\"netcontrol-882x624.jpg\";s:5:\"width\";i:882;s:6:\"height\";i:624;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:177956;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";s:22:\"netcontrol-528x297.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:297;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52651;}s:15:\"tc-slider-small\";a:5:{s:4:\"file\";s:22:\"netcontrol-517x235.jpg\";s:5:\"width\";i:517;s:6:\"height\";i:235;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41400;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("12761","1408","_edit_lock","1744648218:1");
INSERT INTO `wp_postmeta` VALUES("12762","1408","_g_feedback_shortcode_08a5dbe7011d1a17e5ba1c2c02ac6fd98cc6db91","\n				[contact-field label=\"Name\" type=\"name\"  required=\"true\" /]\n				[contact-field label=\"Email\" type=\"email\" required=\"true\" /]\n				[contact-field label=\"Website\" type=\"url\" /]\n				[contact-field label=\"Message\" type=\"textarea\" /]");
INSERT INTO `wp_postmeta` VALUES("12763","1408","_g_feedback_shortcode_atts_08a5dbe7011d1a17e5ba1c2c02ac6fd98cc6db91","a:17:{s:2:\"to\";s:18:\"stuart@m7spi.co.uk\";s:7:\"subject\";s:56:\"[South Lancs Amateur Radio Club] Narsa Rally 2025 Photos\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:14:\"block_template\";N;s:19:\"block_template_part\";N;s:2:\"id\";i:1408;s:18:\"submit_button_text\";s:6:\"Submit\";s:14:\"customThankyou\";s:0:\"\";s:21:\"customThankyouHeading\";s:26:\"Your message has been sent\";s:21:\"customThankyouMessage\";s:30:\"Thank you for your submission!\";s:22:\"customThankyouRedirect\";s:0:\"\";s:10:\"jetpackCRM\";b:1;s:9:\"className\";N;s:9:\"postToUrl\";N;s:14:\"salesforceData\";N;s:12:\"hiddenFields\";N;}");
INSERT INTO `wp_postmeta` VALUES("12764","1409","_wp_attached_file","2025/04/Untitled3.png");
INSERT INTO `wp_postmeta` VALUES("12765","1409","_wp_attachment_metadata","a:6:{s:5:\"width\";i:404;s:6:\"height\";i:666;s:4:\"file\";s:21:\"2025/04/Untitled3.png\";s:8:\"filesize\";i:422564;s:5:\"sizes\";a:11:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"Untitled3-182x300.png\";s:5:\"width\";i:182;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:88713;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"Untitled3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41941;}s:12:\"tc-grid-full\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x444.png\";s:5:\"width\";i:404;s:6:\"height\";i:444;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:232294;}s:7:\"tc-grid\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x350.png\";s:5:\"width\";i:404;s:6:\"height\";i:350;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:180301;}s:8:\"tc-thumb\";a:5:{s:4:\"file\";s:21:\"Untitled3-270x250.png\";s:5:\"width\";i:270;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:102864;}s:11:\"slider-full\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x500.png\";s:5:\"width\";i:404;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:256129;}s:6:\"slider\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x500.png\";s:5:\"width\";i:404;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:256129;}s:11:\"tc-sq-thumb\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x510.png\";s:5:\"width\";i:404;s:6:\"height\";i:510;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:259947;}s:11:\"tc-ws-thumb\";a:5:{s:4:\"file\";s:21:\"Untitled3-404x624.png\";s:5:\"width\";i:404;s:6:\"height\";i:624;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:307247;}s:17:\"tc-ws-small-thumb\";a:5:{s:4:\"file\";